"use strict";
(self["webpackChunkcdt_cloud_blueprint_app"] = self["webpackChunkcdt_cloud_blueprint_app"] || []).push([["vendors-node_modules_theia_bulk-edit_lib_browser_bulk-edit-frontend-module_js"],{

/***/ "../../node_modules/@theia/bulk-edit/lib/browser/bulk-edit-commands.js":
/*!*****************************************************************************!*\
  !*** ../../node_modules/@theia/bulk-edit/lib/browser/bulk-edit-commands.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2021 SAP SE or an SAP affiliate company and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BulkEditCommands = void 0;
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
var BulkEditCommands;
(function (BulkEditCommands) {
    BulkEditCommands.TOGGLE_VIEW = {
        id: 'bulk-edit:toggleView'
    };
    BulkEditCommands.APPLY = {
        id: 'bulk-edit:apply',
        iconClass: (0, browser_1.codicon)('check')
    };
    BulkEditCommands.DISCARD = {
        id: 'bulk-edit:discard',
        iconClass: (0, browser_1.codicon)('clear-all')
    };
})(BulkEditCommands || (exports.BulkEditCommands = BulkEditCommands = {}));


/***/ }),

/***/ "../../node_modules/@theia/bulk-edit/lib/browser/bulk-edit-contribution.js":
/*!*********************************************************************************!*\
  !*** ../../node_modules/@theia/bulk-edit/lib/browser/bulk-edit-contribution.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2021 SAP SE or an SAP affiliate company and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BulkEditContribution = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const view_contribution_1 = __webpack_require__(/*! @theia/core/lib/browser/shell/view-contribution */ "../../node_modules/@theia/core/lib/browser/shell/view-contribution.js");
const bulk_edit_commands_1 = __webpack_require__(/*! ./bulk-edit-commands */ "../../node_modules/@theia/bulk-edit/lib/browser/bulk-edit-commands.js");
const monaco_bulk_edit_service_1 = __webpack_require__(/*! @theia/monaco/lib/browser/monaco-bulk-edit-service */ "../../node_modules/@theia/monaco/lib/browser/monaco-bulk-edit-service.js");
const bulk_edit_tree_1 = __webpack_require__(/*! ./bulk-edit-tree */ "../../node_modules/@theia/bulk-edit/lib/browser/bulk-edit-tree/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
let BulkEditContribution = class BulkEditContribution extends view_contribution_1.AbstractViewContribution {
    constructor() {
        super({
            widgetId: bulk_edit_tree_1.BULK_EDIT_TREE_WIDGET_ID,
            widgetName: bulk_edit_tree_1.BULK_EDIT_WIDGET_NAME,
            defaultWidgetOptions: {
                area: 'bottom'
            }
        });
    }
    init() {
        this.bulkEditService.setPreviewHandler((edits) => this.previewEdit(edits));
    }
    registerCommands(registry) {
        var _a;
        super.registerCommands(registry);
        (_a = this.quickView) === null || _a === void 0 ? void 0 : _a.hideItem(bulk_edit_tree_1.BULK_EDIT_WIDGET_NAME);
        registry.registerCommand(bulk_edit_commands_1.BulkEditCommands.APPLY, {
            isEnabled: widget => this.withWidget(widget, () => true),
            isVisible: widget => this.withWidget(widget, () => true),
            execute: widget => this.withWidget(widget, () => this.apply())
        });
        registry.registerCommand(bulk_edit_commands_1.BulkEditCommands.DISCARD, {
            isEnabled: widget => this.withWidget(widget, () => true),
            isVisible: widget => this.withWidget(widget, () => true),
            execute: widget => this.withWidget(widget, () => this.discard())
        });
    }
    async registerToolbarItems(toolbarRegistry) {
        toolbarRegistry.registerItem({
            id: bulk_edit_commands_1.BulkEditCommands.APPLY.id,
            command: bulk_edit_commands_1.BulkEditCommands.APPLY.id,
            tooltip: nls_1.nls.localizeByDefault('Apply Refactoring'),
            priority: 0,
        });
        toolbarRegistry.registerItem({
            id: bulk_edit_commands_1.BulkEditCommands.DISCARD.id,
            command: bulk_edit_commands_1.BulkEditCommands.DISCARD.id,
            tooltip: nls_1.nls.localizeByDefault('Discard Refactoring'),
            priority: 1,
        });
    }
    withWidget(widget = this.tryGetWidget(), cb) {
        if (widget instanceof bulk_edit_tree_1.BulkEditTreeWidget) {
            return cb(widget);
        }
        return false;
    }
    async previewEdit(edits) {
        const widget = await this.openView({ activate: true });
        if (widget) {
            this.edits = edits;
            await widget.initModel(edits);
        }
        return edits;
    }
    apply() {
        if (this.edits) {
            this.edits.forEach(edit => {
                if (edit.metadata) {
                    edit.metadata.needsConfirmation = false;
                }
            });
            this.bulkEditService.apply(this.edits);
        }
        this.closeView();
    }
    discard() {
        this.edits = [];
        this.closeView();
    }
};
exports.BulkEditContribution = BulkEditContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.QuickViewService),
    (0, inversify_1.optional)(),
    tslib_1.__metadata("design:type", browser_1.QuickViewService)
], BulkEditContribution.prototype, "quickView", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(monaco_bulk_edit_service_1.MonacoBulkEditService),
    tslib_1.__metadata("design:type", monaco_bulk_edit_service_1.MonacoBulkEditService)
], BulkEditContribution.prototype, "bulkEditService", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], BulkEditContribution.prototype, "init", null);
exports.BulkEditContribution = BulkEditContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)(),
    tslib_1.__metadata("design:paramtypes", [])
], BulkEditContribution);


/***/ }),

/***/ "../../node_modules/@theia/bulk-edit/lib/browser/bulk-edit-frontend-module.js":
/*!************************************************************************************!*\
  !*** ../../node_modules/@theia/bulk-edit/lib/browser/bulk-edit-frontend-module.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
// *****************************************************************************
// Copyright (C) 2021 SAP SE or an SAP affiliate company and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const widget_manager_1 = __webpack_require__(/*! @theia/core/lib/browser/widget-manager */ "../../node_modules/@theia/core/lib/browser/widget-manager.js");
const bulk_edit_tree_1 = __webpack_require__(/*! ./bulk-edit-tree */ "../../node_modules/@theia/bulk-edit/lib/browser/bulk-edit-tree/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const bulk_edit_contribution_1 = __webpack_require__(/*! ./bulk-edit-contribution */ "../../node_modules/@theia/bulk-edit/lib/browser/bulk-edit-contribution.js");
const tab_bar_toolbar_1 = __webpack_require__(/*! @theia/core/lib/browser/shell/tab-bar-toolbar */ "../../node_modules/@theia/core/lib/browser/shell/tab-bar-toolbar/index.js");
const bulk_edit_tree_label_provider_1 = __webpack_require__(/*! ./bulk-edit-tree-label-provider */ "../../node_modules/@theia/bulk-edit/lib/browser/bulk-edit-tree-label-provider.js");
__webpack_require__(/*! ../../src/browser/style/bulk-edit.css */ "../../node_modules/@theia/bulk-edit/src/browser/style/bulk-edit.css");
exports["default"] = new inversify_1.ContainerModule(bind => {
    bind(bulk_edit_tree_1.BulkEditTreeWidget).toDynamicValue(ctx => (0, bulk_edit_tree_1.createBulkEditTreeWidget)(ctx.container));
    bind(widget_manager_1.WidgetFactory).toDynamicValue(context => ({
        id: bulk_edit_tree_1.BULK_EDIT_TREE_WIDGET_ID,
        createWidget: () => context.container.get(bulk_edit_tree_1.BulkEditTreeWidget)
    }));
    (0, browser_1.bindViewContribution)(bind, bulk_edit_contribution_1.BulkEditContribution);
    bind(browser_1.FrontendApplicationContribution).toService(bulk_edit_contribution_1.BulkEditContribution);
    bind(tab_bar_toolbar_1.TabBarToolbarContribution).toService(bulk_edit_contribution_1.BulkEditContribution);
    bind(bulk_edit_tree_label_provider_1.BulkEditTreeLabelProvider).toSelf().inSingletonScope();
    bind(browser_1.LabelProviderContribution).toService(bulk_edit_tree_label_provider_1.BulkEditTreeLabelProvider);
});


/***/ }),

/***/ "../../node_modules/@theia/bulk-edit/lib/browser/bulk-edit-tree-label-provider.js":
/*!****************************************************************************************!*\
  !*** ../../node_modules/@theia/bulk-edit/lib/browser/bulk-edit-tree-label-provider.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2021 SAP SE or an SAP affiliate company and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BulkEditTreeLabelProvider = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const label_provider_1 = __webpack_require__(/*! @theia/core/lib/browser/label-provider */ "../../node_modules/@theia/core/lib/browser/label-provider.js");
const bulk_edit_tree_1 = __webpack_require__(/*! ./bulk-edit-tree */ "../../node_modules/@theia/bulk-edit/lib/browser/bulk-edit-tree/index.js");
const tree_label_provider_1 = __webpack_require__(/*! @theia/core/lib/browser/tree/tree-label-provider */ "../../node_modules/@theia/core/lib/browser/tree/tree-label-provider.js");
const browser_1 = __webpack_require__(/*! @theia/workspace/lib/browser */ "../../node_modules/@theia/workspace/lib/browser/index.js");
let BulkEditTreeLabelProvider = class BulkEditTreeLabelProvider {
    canHandle(element) {
        return bulk_edit_tree_1.BulkEditInfoNode.is(element) ?
            this.treeLabelProvider.canHandle(element) + 1 :
            0;
    }
    getIcon(node) {
        return this.labelProvider.getIcon(node.uri);
    }
    getName(node) {
        return this.labelProvider.getName(node.uri);
    }
    getLongName(node) {
        const description = [];
        const rootUri = this.workspaceService.getWorkspaceRootUri(node.uri);
        // In a multiple-root workspace include the root name to the label before the parent directory.
        if (this.workspaceService.isMultiRootWorkspaceOpened && rootUri) {
            description.push(this.labelProvider.getName(rootUri));
        }
        // If the given resource is not at the workspace root, include the parent directory to the label.
        if ((rootUri === null || rootUri === void 0 ? void 0 : rootUri.toString()) !== node.uri.parent.toString()) {
            description.push(this.labelProvider.getLongName(node.uri.parent));
        }
        return description.join(' ● ');
    }
    getDescription(node) {
        return this.labelProvider.getLongName(node.uri.parent);
    }
    affects(node, event) {
        return event.affects(node.uri) || event.affects(node.uri.parent);
    }
};
exports.BulkEditTreeLabelProvider = BulkEditTreeLabelProvider;
tslib_1.__decorate([
    (0, inversify_1.inject)(label_provider_1.LabelProvider),
    tslib_1.__metadata("design:type", label_provider_1.LabelProvider)
], BulkEditTreeLabelProvider.prototype, "labelProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(tree_label_provider_1.TreeLabelProvider),
    tslib_1.__metadata("design:type", tree_label_provider_1.TreeLabelProvider)
], BulkEditTreeLabelProvider.prototype, "treeLabelProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.WorkspaceService),
    tslib_1.__metadata("design:type", browser_1.WorkspaceService)
], BulkEditTreeLabelProvider.prototype, "workspaceService", void 0);
exports.BulkEditTreeLabelProvider = BulkEditTreeLabelProvider = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], BulkEditTreeLabelProvider);


/***/ }),

/***/ "../../node_modules/@theia/bulk-edit/lib/browser/bulk-edit-tree/bulk-edit-node-selection.js":
/*!**************************************************************************************************!*\
  !*** ../../node_modules/@theia/bulk-edit/lib/browser/bulk-edit-tree/bulk-edit-node-selection.js ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2021 SAP SE or an SAP affiliate company and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BulkEditNodeSelection = void 0;
const selection_command_handler_1 = __webpack_require__(/*! @theia/core/lib/common/selection-command-handler */ "../../node_modules/@theia/core/lib/common/selection-command-handler.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "../../node_modules/@theia/core/lib/common/index.js");
var BulkEditNodeSelection;
(function (BulkEditNodeSelection) {
    function is(arg) {
        return (0, common_1.isObject)(arg) && 'bulkEdit' in arg;
    }
    BulkEditNodeSelection.is = is;
    class CommandHandler extends selection_command_handler_1.SelectionCommandHandler {
        constructor(selectionService, options) {
            super(selectionService, arg => BulkEditNodeSelection.is(arg) ? arg : undefined, options);
            this.selectionService = selectionService;
            this.options = options;
        }
    }
    BulkEditNodeSelection.CommandHandler = CommandHandler;
})(BulkEditNodeSelection || (exports.BulkEditNodeSelection = BulkEditNodeSelection = {}));


/***/ }),

/***/ "../../node_modules/@theia/bulk-edit/lib/browser/bulk-edit-tree/bulk-edit-tree-container.js":
/*!**************************************************************************************************!*\
  !*** ../../node_modules/@theia/bulk-edit/lib/browser/bulk-edit-tree/bulk-edit-tree-container.js ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2021 SAP SE or an SAP affiliate company and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.createBulkEditTreeWidget = exports.createBulkEditContainer = void 0;
const bulk_edit_tree_widget_1 = __webpack_require__(/*! ./bulk-edit-tree-widget */ "../../node_modules/@theia/bulk-edit/lib/browser/bulk-edit-tree/bulk-edit-tree-widget.js");
const bulk_edit_tree_1 = __webpack_require__(/*! ./bulk-edit-tree */ "../../node_modules/@theia/bulk-edit/lib/browser/bulk-edit-tree/bulk-edit-tree.js");
const bulk_edit_tree_model_1 = __webpack_require__(/*! ./bulk-edit-tree-model */ "../../node_modules/@theia/bulk-edit/lib/browser/bulk-edit-tree/bulk-edit-tree-model.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
function createBulkEditContainer(parent) {
    const child = (0, browser_1.createTreeContainer)(parent, {
        tree: bulk_edit_tree_1.BulkEditTree,
        widget: bulk_edit_tree_widget_1.BulkEditTreeWidget,
        model: bulk_edit_tree_model_1.BulkEditTreeModel,
    });
    return child;
}
exports.createBulkEditContainer = createBulkEditContainer;
function createBulkEditTreeWidget(parent) {
    return createBulkEditContainer(parent).get(bulk_edit_tree_widget_1.BulkEditTreeWidget);
}
exports.createBulkEditTreeWidget = createBulkEditTreeWidget;


/***/ }),

/***/ "../../node_modules/@theia/bulk-edit/lib/browser/bulk-edit-tree/bulk-edit-tree-model.js":
/*!**********************************************************************************************!*\
  !*** ../../node_modules/@theia/bulk-edit/lib/browser/bulk-edit-tree/bulk-edit-tree-model.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2021 SAP SE or an SAP affiliate company and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BulkEditTreeModel = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const bulk_edit_tree_1 = __webpack_require__(/*! ./bulk-edit-tree */ "../../node_modules/@theia/bulk-edit/lib/browser/bulk-edit-tree/bulk-edit-tree.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
let BulkEditTreeModel = class BulkEditTreeModel extends browser_1.TreeModelImpl {
    doOpenNode(node) {
        if (bulk_edit_tree_1.BulkEditNode.is(node)) {
            (0, browser_1.open)(this.openerService, node.uri, undefined);
        }
        else {
            super.doOpenNode(node);
        }
    }
    revealNode(node) {
        this.doOpenNode(node);
    }
    async initModel(edits, fileContents) {
        this.tree.initTree(edits, fileContents);
    }
};
exports.BulkEditTreeModel = BulkEditTreeModel;
tslib_1.__decorate([
    (0, inversify_1.inject)(bulk_edit_tree_1.BulkEditTree),
    tslib_1.__metadata("design:type", bulk_edit_tree_1.BulkEditTree)
], BulkEditTreeModel.prototype, "tree", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.OpenerService),
    tslib_1.__metadata("design:type", Object)
], BulkEditTreeModel.prototype, "openerService", void 0);
exports.BulkEditTreeModel = BulkEditTreeModel = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], BulkEditTreeModel);


/***/ }),

/***/ "../../node_modules/@theia/bulk-edit/lib/browser/bulk-edit-tree/bulk-edit-tree-widget.js":
/*!***********************************************************************************************!*\
  !*** ../../node_modules/@theia/bulk-edit/lib/browser/bulk-edit-tree/bulk-edit-tree-widget.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2021 SAP SE or an SAP affiliate company and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BulkEditTreeWidget = exports.BULK_EDIT_WIDGET_NAME = exports.BULK_EDIT_TREE_WIDGET_ID = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const bulk_edit_tree_1 = __webpack_require__(/*! ./bulk-edit-tree */ "../../node_modules/@theia/bulk-edit/lib/browser/bulk-edit-tree/bulk-edit-tree.js");
const bulk_edit_tree_model_1 = __webpack_require__(/*! ./bulk-edit-tree-model */ "../../node_modules/@theia/bulk-edit/lib/browser/bulk-edit-tree/bulk-edit-tree-model.js");
const browser_2 = __webpack_require__(/*! @theia/filesystem/lib/browser */ "../../node_modules/@theia/filesystem/lib/browser/index.js");
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "../../node_modules/@theia/core/lib/common/uri.js");
const browser_3 = __webpack_require__(/*! @theia/editor/lib/browser */ "../../node_modules/@theia/editor/lib/browser/index.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "../../node_modules/@theia/core/lib/common/index.js");
const disposable_1 = __webpack_require__(/*! @theia/core/lib/common/disposable */ "../../node_modules/@theia/core/lib/common/disposable.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
exports.BULK_EDIT_TREE_WIDGET_ID = 'bulkedit';
exports.BULK_EDIT_WIDGET_NAME = nls_1.nls.localizeByDefault('Refactor Preview');
let BulkEditTreeWidget = class BulkEditTreeWidget extends browser_1.TreeWidget {
    constructor(treeProps, model, contextMenuRenderer) {
        super(treeProps, model, contextMenuRenderer);
        this.treeProps = treeProps;
        this.model = model;
        this.contextMenuRenderer = contextMenuRenderer;
        this.editorWidgets = [];
        this.id = exports.BULK_EDIT_TREE_WIDGET_ID;
        this.title.label = exports.BULK_EDIT_WIDGET_NAME;
        this.title.caption = exports.BULK_EDIT_WIDGET_NAME;
        this.title.closable = true;
        this.addClass('theia-bulk-edit-container');
        this.toDispose.push(disposable_1.Disposable.create(() => {
            this.disposeEditors();
        }));
    }
    async initModel(edits) {
        var _a;
        await this.model.initModel(edits, await this.getFileContentsMap(edits));
        (_a = this.quickView) === null || _a === void 0 ? void 0 : _a.showItem(exports.BULK_EDIT_WIDGET_NAME);
    }
    tapNode(node) {
        super.tapNode(node);
        if (bulk_edit_tree_1.BulkEditNode.is(node)) {
            this.doOpen(node);
        }
    }
    handleDown(event) {
        const node = this.model.getNextSelectableNode();
        super.handleDown(event);
        if (bulk_edit_tree_1.BulkEditNode.is(node)) {
            this.doOpen(node);
        }
    }
    handleUp(event) {
        const node = this.model.getPrevSelectableNode();
        super.handleUp(event);
        if (bulk_edit_tree_1.BulkEditNode.is(node)) {
            this.doOpen(node);
        }
    }
    renderTree(model) {
        if (browser_1.CompositeTreeNode.is(model.root) && model.root.children.length > 0) {
            return super.renderTree(model);
        }
        return React.createElement("div", { className: 'theia-widget-noInfo noEdits' }, nls_1.nls.localizeByDefault('Made no edits'));
    }
    renderCaption(node, props) {
        if (bulk_edit_tree_1.BulkEditInfoNode.is(node)) {
            return this.decorateBulkEditInfoNode(node);
        }
        else if (bulk_edit_tree_1.BulkEditNode.is(node)) {
            return this.decorateBulkEditNode(node);
        }
        return 'caption';
    }
    decorateBulkEditNode(node) {
        var _a, _b;
        if ((node === null || node === void 0 ? void 0 : node.parent) && (node === null || node === void 0 ? void 0 : node.bulkEdit) && ('textEdit' in (node === null || node === void 0 ? void 0 : node.bulkEdit))) {
            const bulkEdit = node.bulkEdit;
            const parent = node.parent;
            if (parent === null || parent === void 0 ? void 0 : parent.fileContents) {
                const lines = parent.fileContents.split('\n');
                const startLineNum = +((_b = (_a = bulkEdit.textEdit) === null || _a === void 0 ? void 0 : _a.range) === null || _b === void 0 ? void 0 : _b.startLineNumber);
                if (lines.length > startLineNum) {
                    const startColumn = +bulkEdit.textEdit.range.startColumn;
                    const endColumn = +bulkEdit.textEdit.range.endColumn;
                    const lineText = lines[startLineNum - 1];
                    const beforeMatch = (startColumn > 26 ? '... ' : '') + lineText.substring(0, startColumn - 1).slice(-25);
                    const replacedText = lineText.substring(startColumn - 1, endColumn - 1);
                    const afterMatch = lineText.substring(startColumn - 1 + replacedText.length, startColumn - 1 + replacedText.length + 75);
                    return React.createElement("div", { className: 'bulkEditNode' },
                        React.createElement("div", { className: 'message' },
                            beforeMatch,
                            React.createElement("span", { className: "replaced-text" }, replacedText),
                            React.createElement("span", { className: "inserted-text" }, bulkEdit.textEdit.text),
                            afterMatch));
                }
            }
        }
    }
    decorateBulkEditInfoNode(node) {
        const icon = this.toNodeIcon(node);
        const name = this.toNodeName(node);
        const description = this.toNodeDescription(node);
        const path = this.labelProvider.getLongName(node.uri.withScheme('bulkedit'));
        return React.createElement("div", { title: path, className: 'bulkEditInfoNode' },
            icon && React.createElement("div", { className: icon + ' file-icon' }),
            React.createElement("div", { className: 'name' }, name),
            React.createElement("div", { className: 'path' }, description));
    }
    async getFileContentsMap(edits) {
        var _a;
        const fileContentMap = new Map();
        if (edits) {
            for (const element of edits) {
                if (element) {
                    const filePath = (('newResource' in element) && ((_a = element.newResource) === null || _a === void 0 ? void 0 : _a.path)) ||
                        (('resource' in element) && element.resource.path);
                    if (filePath && !fileContentMap.has(filePath)) {
                        const fileUri = new uri_1.default(filePath).withScheme('file');
                        const resource = await this.fileResourceResolver.resolve(fileUri);
                        fileContentMap.set(filePath, await resource.readContents());
                    }
                }
            }
        }
        return fileContentMap;
    }
    async doOpen(node) {
        if (node && node.parent && node.bulkEdit && ('edit' in node.bulkEdit)) {
            const resultNode = node.parent;
            const leftUri = node.uri;
            const rightUri = await this.createReplacePreview(resultNode);
            const diffUri = browser_1.DiffUris.encode(leftUri, rightUri);
            const editorWidget = await this.editorManager.open(diffUri, this.getEditorOptions(node));
            this.editorWidgets.push(editorWidget);
        }
    }
    async createReplacePreview(bulkEditInfoNode) {
        const fileUri = bulkEditInfoNode.uri;
        let lines = [];
        if (bulkEditInfoNode === null || bulkEditInfoNode === void 0 ? void 0 : bulkEditInfoNode.fileContents) {
            lines = bulkEditInfoNode.fileContents.split('\n');
            bulkEditInfoNode.children.map((node) => {
                if (node.bulkEdit && ('textEdit' in node.bulkEdit)) {
                    const startLineNum = node.bulkEdit.textEdit.range.startLineNumber;
                    if (lines.length > startLineNum) {
                        const startColumn = node.bulkEdit.textEdit.range.startColumn;
                        const endColumn = node.bulkEdit.textEdit.range.endColumn;
                        const lineText = lines[startLineNum - 1];
                        const beforeMatch = lineText.substring(0, startColumn - 1);
                        const replacedText = lineText.substring(startColumn - 1, endColumn - 1);
                        const afterMatch = lineText.substring(startColumn - 1 + replacedText.length);
                        lines[startLineNum - 1] = beforeMatch + node.bulkEdit.textEdit.text + afterMatch;
                    }
                }
            });
        }
        return fileUri.withScheme(common_1.MEMORY_TEXT).withQuery(lines.join('\n'));
    }
    getEditorOptions(node) {
        var _a, _b;
        let options = {};
        if (('textEdit' in node.bulkEdit) && ((_b = (_a = node === null || node === void 0 ? void 0 : node.bulkEdit) === null || _a === void 0 ? void 0 : _a.textEdit) === null || _b === void 0 ? void 0 : _b.range)) {
            options = {
                selection: {
                    start: {
                        line: node.bulkEdit.textEdit.range.startLineNumber - 1,
                        character: node.bulkEdit.textEdit.range.startColumn - 1
                    },
                    end: {
                        line: node.bulkEdit.textEdit.range.endLineNumber - 1,
                        character: node.bulkEdit.textEdit.range.endColumn - 1
                    }
                }
            };
        }
        return options;
    }
    disposeEditors() {
        var _a;
        this.editorWidgets.forEach(w => w.dispose());
        (_a = this.quickView) === null || _a === void 0 ? void 0 : _a.hideItem(exports.BULK_EDIT_WIDGET_NAME);
    }
};
exports.BulkEditTreeWidget = BulkEditTreeWidget;
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_2.FileResourceResolver),
    tslib_1.__metadata("design:type", browser_2.FileResourceResolver)
], BulkEditTreeWidget.prototype, "fileResourceResolver", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_3.EditorManager),
    tslib_1.__metadata("design:type", browser_3.EditorManager)
], BulkEditTreeWidget.prototype, "editorManager", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.QuickViewService),
    (0, inversify_1.optional)(),
    tslib_1.__metadata("design:type", browser_1.QuickViewService)
], BulkEditTreeWidget.prototype, "quickView", void 0);
exports.BulkEditTreeWidget = BulkEditTreeWidget = tslib_1.__decorate([
    (0, inversify_1.injectable)(),
    tslib_1.__param(0, (0, inversify_1.inject)(browser_1.TreeProps)),
    tslib_1.__param(1, (0, inversify_1.inject)(bulk_edit_tree_model_1.BulkEditTreeModel)),
    tslib_1.__param(2, (0, inversify_1.inject)(browser_1.ContextMenuRenderer)),
    tslib_1.__metadata("design:paramtypes", [Object, bulk_edit_tree_model_1.BulkEditTreeModel,
        browser_1.ContextMenuRenderer])
], BulkEditTreeWidget);


/***/ }),

/***/ "../../node_modules/@theia/bulk-edit/lib/browser/bulk-edit-tree/bulk-edit-tree.js":
/*!****************************************************************************************!*\
  !*** ../../node_modules/@theia/bulk-edit/lib/browser/bulk-edit-tree/bulk-edit-tree.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2021 SAP SE or an SAP affiliate company and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BulkEditInfoNode = exports.BulkEditNode = exports.BulkEditTree = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const selection_1 = __webpack_require__(/*! @theia/core/lib/common/selection */ "../../node_modules/@theia/core/lib/common/selection.js");
const bulk_edit_node_selection_1 = __webpack_require__(/*! ./bulk-edit-node-selection */ "../../node_modules/@theia/bulk-edit/lib/browser/bulk-edit-tree/bulk-edit-node-selection.js");
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "../../node_modules/@theia/core/lib/common/uri.js");
const monaco_workspace_1 = __webpack_require__(/*! @theia/monaco/lib/browser/monaco-workspace */ "../../node_modules/@theia/monaco/lib/browser/monaco-workspace.js");
let BulkEditTree = class BulkEditTree extends browser_1.TreeImpl {
    async initTree(edits, fileContents) {
        this.root = {
            visible: false,
            id: 'theia-bulk-edit-tree-widget',
            name: 'BulkEditTree',
            children: this.getChildren(edits, fileContents),
            parent: undefined
        };
    }
    getChildren(edits, fileContentsMap) {
        let bulkEditInfos = [];
        if (edits) {
            bulkEditInfos = edits
                .map(edit => this.getResourcePath(edit))
                .filter((path, index, arr) => path && arr.indexOf(path) === index)
                .map((path) => this.createBulkEditInfo(path, new uri_1.default(path), fileContentsMap.get(path)))
                .filter(Boolean);
            if (bulkEditInfos.length > 0) {
                bulkEditInfos.forEach(editInfo => {
                    editInfo.children = edits.filter(edit => {
                        var _a, _b;
                        return ((('resource' in edit) && ((_a = edit === null || edit === void 0 ? void 0 : edit.resource) === null || _a === void 0 ? void 0 : _a.path) === editInfo.id)) ||
                            (('newResource' in edit) && ((_b = edit === null || edit === void 0 ? void 0 : edit.newResource) === null || _b === void 0 ? void 0 : _b.path) === editInfo.id);
                    })
                        .map((edit, index) => this.createBulkEditNode(('resource' in edit ? edit :
                        edit), index, editInfo));
                });
            }
        }
        return bulkEditInfos;
    }
    createBulkEditNode(bulkEdit, index, parent) {
        const id = parent.id + '_' + index;
        const existing = this.getNode(id);
        if (BulkEditNode.is(existing)) {
            existing.bulkEdit = bulkEdit;
            return existing;
        }
        return {
            id,
            name: 'bulkEdit',
            parent,
            selected: false,
            uri: parent.uri,
            bulkEdit
        };
    }
    createBulkEditInfo(id, uri, fileContents) {
        return {
            id,
            uri,
            expanded: true,
            selected: false,
            parent: this.root,
            fileContents,
            children: []
        };
    }
    getResourcePath(edit) {
        return monaco_workspace_1.ResourceTextEdit.is(edit) ? edit.resource.path :
            monaco_workspace_1.ResourceFileEdit.is(edit) && edit.newResource ? edit.newResource.path : undefined;
    }
};
exports.BulkEditTree = BulkEditTree;
exports.BulkEditTree = BulkEditTree = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], BulkEditTree);
var BulkEditNode;
(function (BulkEditNode) {
    function is(node) {
        return selection_1.UriSelection.is(node) && browser_1.SelectableTreeNode.is(node) && bulk_edit_node_selection_1.BulkEditNodeSelection.is(node);
    }
    BulkEditNode.is = is;
})(BulkEditNode || (exports.BulkEditNode = BulkEditNode = {}));
var BulkEditInfoNode;
(function (BulkEditInfoNode) {
    function is(node) {
        return browser_1.ExpandableTreeNode.is(node) && selection_1.UriSelection.is(node) && 'fileContents' in node;
    }
    BulkEditInfoNode.is = is;
})(BulkEditInfoNode || (exports.BulkEditInfoNode = BulkEditInfoNode = {}));


/***/ }),

/***/ "../../node_modules/@theia/bulk-edit/lib/browser/bulk-edit-tree/index.js":
/*!*******************************************************************************!*\
  !*** ../../node_modules/@theia/bulk-edit/lib/browser/bulk-edit-tree/index.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2021 SAP SE or an SAP affiliate company and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
tslib_1.__exportStar(__webpack_require__(/*! ./bulk-edit-tree */ "../../node_modules/@theia/bulk-edit/lib/browser/bulk-edit-tree/bulk-edit-tree.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./bulk-edit-tree-model */ "../../node_modules/@theia/bulk-edit/lib/browser/bulk-edit-tree/bulk-edit-tree-model.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./bulk-edit-node-selection */ "../../node_modules/@theia/bulk-edit/lib/browser/bulk-edit-tree/bulk-edit-node-selection.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./bulk-edit-tree-widget */ "../../node_modules/@theia/bulk-edit/lib/browser/bulk-edit-tree/bulk-edit-tree-widget.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./bulk-edit-tree-container */ "../../node_modules/@theia/bulk-edit/lib/browser/bulk-edit-tree/bulk-edit-tree-container.js"), exports);


/***/ }),

/***/ "../../node_modules/@theia/bulk-edit/src/browser/style/bulk-edit.css":
/*!***************************************************************************!*\
  !*** ../../node_modules/@theia/bulk-edit/src/browser/style/bulk-edit.css ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../../../style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_loader_dist_cjs_js_bulk_edit_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !!../../../../../css-loader/dist/cjs.js!./bulk-edit.css */ "../../node_modules/css-loader/dist/cjs.js!../../node_modules/@theia/bulk-edit/src/browser/style/bulk-edit.css");

            

var options = {};

options.insert = "head";
options.singleton = false;

var update = _style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_css_loader_dist_cjs_js_bulk_edit_css__WEBPACK_IMPORTED_MODULE_1__["default"], options);



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_css_loader_dist_cjs_js_bulk_edit_css__WEBPACK_IMPORTED_MODULE_1__["default"].locals || {});

/***/ }),

/***/ "../../node_modules/@theia/workspace/lib/browser/index.js":
/*!****************************************************************!*\
  !*** ../../node_modules/@theia/workspace/lib/browser/index.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2017 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
tslib_1.__exportStar(__webpack_require__(/*! ./workspace-commands */ "../../node_modules/@theia/workspace/lib/browser/workspace-commands.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./workspace-service */ "../../node_modules/@theia/workspace/lib/browser/workspace-service.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./canonical-uri-service */ "../../node_modules/@theia/workspace/lib/browser/canonical-uri-service.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./workspace-frontend-contribution */ "../../node_modules/@theia/workspace/lib/browser/workspace-frontend-contribution.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./workspace-frontend-module */ "../../node_modules/@theia/workspace/lib/browser/workspace-frontend-module.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./workspace-preferences */ "../../node_modules/@theia/workspace/lib/browser/workspace-preferences.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./workspace-trust-service */ "../../node_modules/@theia/workspace/lib/browser/workspace-trust-service.js"), exports);


/***/ }),

/***/ "../../node_modules/css-loader/dist/cjs.js!../../node_modules/@theia/bulk-edit/src/browser/style/bulk-edit.css":
/*!*********************************************************************************************************************!*\
  !*** ../../node_modules/css-loader/dist/cjs.js!../../node_modules/@theia/bulk-edit/src/browser/style/bulk-edit.css ***!
  \*********************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../css-loader/dist/runtime/sourceMaps.js */ "../../node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../../css-loader/dist/runtime/api.js */ "../../node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/********************************************************************************
 * Copyright (c) 2021 SAP SE or an SAP affiliate company and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
 ********************************************************************************/

.theia-bulk-edit-container {
  font-size: var(--theia-ui-font-size1);
}

.theia-bulk-edit-container .bulkEditNode,
.theia-bulk-edit-container .bulkEditInfoNode {
  display: flex;
  align-items: center;
}

.theia-bulk-edit-container .bulkEditNode,
.theia-bulk-edit-container .bulkEditInfoNode {
  width: calc(100% - 32px);
}

.theia-bulk-edit-container .bulkEditNode div,
.theia-bulk-edit-container .bulkEditInfoNode div {
  margin-right: 5px;
}

.theia-bulk-edit-container .bulkEditInfoNode .name,
.theia-bulk-edit-container .bulkEditInfoNode .path {
  overflow: hidden;
  text-overflow: ellipsis;
  white-space: nowrap;
}

.theia-bulk-edit-container .bulkEditInfoNode .path {
  font-size: var(--theia-ui-font-size0);
  color: var(--theia-descriptionForeground);
  align-self: flex-end;
  white-space: nowrap;
}

.theia-bulk-edit-container .bulkEditNode .message {
  white-space: nowrap;
  overflow: hidden;
  text-overflow: ellipsis;
}

.theia-bulk-edit-container .bulkEditNode .message .replaced-text {
  text-decoration: line-through;
  background: var(--theia-diffEditor-removedTextBackground);
  border-color: var(--theia-diffEditor-removedTextBorder);
}

.theia-bulk-edit-container .bulkEditNode .message .inserted-text {
  background: var(--theia-diffEditor-insertedTextBackground);
  border: 1px solid var(--theia-diffEditor-insertedTextBorder);
}
`, "",{"version":3,"sources":["webpack://./../../node_modules/@theia/bulk-edit/src/browser/style/bulk-edit.css"],"names":[],"mappings":"AAAA;;;;;;;;;;;;;;iFAciF;;AAEjF;EACE,qCAAqC;AACvC;;AAEA;;EAEE,aAAa;EACb,mBAAmB;AACrB;;AAEA;;EAEE,wBAAwB;AAC1B;;AAEA;;EAEE,iBAAiB;AACnB;;AAEA;;EAEE,gBAAgB;EAChB,uBAAuB;EACvB,mBAAmB;AACrB;;AAEA;EACE,qCAAqC;EACrC,yCAAyC;EACzC,oBAAoB;EACpB,mBAAmB;AACrB;;AAEA;EACE,mBAAmB;EACnB,gBAAgB;EAChB,uBAAuB;AACzB;;AAEA;EACE,6BAA6B;EAC7B,yDAAyD;EACzD,uDAAuD;AACzD;;AAEA;EACE,0DAA0D;EAC1D,4DAA4D;AAC9D","sourcesContent":["/********************************************************************************\n * Copyright (c) 2021 SAP SE or an SAP affiliate company and others.\n *\n * This program and the accompanying materials are made available under the\n * terms of the Eclipse Public License v. 2.0 which is available at\n * http://www.eclipse.org/legal/epl-2.0.\n *\n * This Source Code may also be made available under the following Secondary\n * Licenses when the conditions for such availability set forth in the Eclipse\n * Public License v. 2.0 are satisfied: GNU General Public License, version 2\n * with the GNU Classpath Exception which is available at\n * https://www.gnu.org/software/classpath/license.html.\n *\n * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0\n ********************************************************************************/\n\n.theia-bulk-edit-container {\n  font-size: var(--theia-ui-font-size1);\n}\n\n.theia-bulk-edit-container .bulkEditNode,\n.theia-bulk-edit-container .bulkEditInfoNode {\n  display: flex;\n  align-items: center;\n}\n\n.theia-bulk-edit-container .bulkEditNode,\n.theia-bulk-edit-container .bulkEditInfoNode {\n  width: calc(100% - 32px);\n}\n\n.theia-bulk-edit-container .bulkEditNode div,\n.theia-bulk-edit-container .bulkEditInfoNode div {\n  margin-right: 5px;\n}\n\n.theia-bulk-edit-container .bulkEditInfoNode .name,\n.theia-bulk-edit-container .bulkEditInfoNode .path {\n  overflow: hidden;\n  text-overflow: ellipsis;\n  white-space: nowrap;\n}\n\n.theia-bulk-edit-container .bulkEditInfoNode .path {\n  font-size: var(--theia-ui-font-size0);\n  color: var(--theia-descriptionForeground);\n  align-self: flex-end;\n  white-space: nowrap;\n}\n\n.theia-bulk-edit-container .bulkEditNode .message {\n  white-space: nowrap;\n  overflow: hidden;\n  text-overflow: ellipsis;\n}\n\n.theia-bulk-edit-container .bulkEditNode .message .replaced-text {\n  text-decoration: line-through;\n  background: var(--theia-diffEditor-removedTextBackground);\n  border-color: var(--theia-diffEditor-removedTextBorder);\n}\n\n.theia-bulk-edit-container .bulkEditNode .message .inserted-text {\n  background: var(--theia-diffEditor-insertedTextBackground);\n  border: 1px solid var(--theia-diffEditor-insertedTextBorder);\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_bulk-edit_lib_browser_bulk-edit-frontend-module_js.js.map