"use strict";
(self["webpackChunkcdt_cloud_blueprint_app"] = self["webpackChunkcdt_cloud_blueprint_app"] || []).push([["vendors-node_modules_theia_ai-chat_lib_browser_ai-chat-frontend-contribution_js-node_modules_-4d79fd"],{

/***/ "../../node_modules/@theia/ai-chat/lib/browser/ai-chat-frontend-contribution.js":
/*!**************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat/lib/browser/ai-chat-frontend-contribution.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AIChatFrontendContribution = exports.VARIABLE_ADD_CONTEXT_COMMAND = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const ai_core_1 = __webpack_require__(/*! @theia/ai-core */ "../../node_modules/@theia/ai-core/lib/common/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const common_1 = __webpack_require__(/*! ../common */ "../../node_modules/@theia/ai-chat/lib/common/index.js");
exports.VARIABLE_ADD_CONTEXT_COMMAND = core_1.Command.toLocalizedCommand({
    id: 'add-context-variable',
    label: 'Add context variable'
}, 'theia/ai/chat-ui/addContextVariable');
let AIChatFrontendContribution = class AIChatFrontendContribution {
    registerCommands(registry) {
        registry.registerCommand(exports.VARIABLE_ADD_CONTEXT_COMMAND, {
            execute: (...args) => args.length > 1 && this.addContextVariable(args[0], args[1]),
            isVisible: () => false,
        });
    }
    async addContextVariable(variableName, arg) {
        var _a;
        const variable = this.variableService.getVariable(variableName);
        if (!variable || !ai_core_1.AIContextVariable.is(variable)) {
            return;
        }
        (_a = this.chatService.getActiveSession()) === null || _a === void 0 ? void 0 : _a.model.context.addVariables({ variable, arg });
    }
};
exports.AIChatFrontendContribution = AIChatFrontendContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(ai_core_1.AIVariableService),
    tslib_1.__metadata("design:type", Object)
], AIChatFrontendContribution.prototype, "variableService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(common_1.ChatService),
    tslib_1.__metadata("design:type", Object)
], AIChatFrontendContribution.prototype, "chatService", void 0);
exports.AIChatFrontendContribution = AIChatFrontendContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], AIChatFrontendContribution);


/***/ }),

/***/ "../../node_modules/@theia/ai-chat/lib/browser/change-set-decorator-service.js":
/*!*************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat/lib/browser/change-set-decorator-service.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeSetDecoratorService = exports.ChangeSetDecorator = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const debounce = __webpack_require__(/*! @theia/core/shared/lodash.debounce */ "../../node_modules/@theia/core/shared/lodash.debounce/index.js");
/**
 * A decorator for a change set element.
 * It allows to add additional information to the element, such as icons.
 */
exports.ChangeSetDecorator = Symbol('ChangeSetDecorator');
let ChangeSetDecoratorService = class ChangeSetDecoratorService {
    constructor() {
        this.onDidChangeDecorationsEmitter = new core_1.Emitter();
        this.onDidChangeDecorations = this.onDidChangeDecorationsEmitter.event;
        this.fireDidChangeDecorations = debounce(() => {
            this.onDidChangeDecorationsEmitter.fire(undefined);
        }, 150);
    }
    initialize() {
        this.contributions.getContributions().map(decorator => decorator.onDidChangeDecorations(this.fireDidChangeDecorations));
    }
    getDecorations(element) {
        const decorators = this.contributions.getContributions();
        const decorations = [];
        for (const decorator of decorators) {
            const decoration = decorator.decorate(element);
            if (decoration) {
                decorations.push(decoration);
            }
        }
        decorations.sort((a, b) => { var _a, _b; return ((_a = b.priority) !== null && _a !== void 0 ? _a : 0) - ((_b = a.priority) !== null && _b !== void 0 ? _b : 0); });
        return decorations;
    }
    getAdditionalInfoSuffixIcon(element) {
        var _a;
        const decorations = this.getDecorations(element);
        return (_a = decorations.find(d => d.additionalInfoSuffixIcon)) === null || _a === void 0 ? void 0 : _a.additionalInfoSuffixIcon;
    }
};
exports.ChangeSetDecoratorService = ChangeSetDecoratorService;
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.ContributionProvider),
    (0, inversify_1.named)(exports.ChangeSetDecorator),
    tslib_1.__metadata("design:type", Object)
], ChangeSetDecoratorService.prototype, "contributions", void 0);
exports.ChangeSetDecoratorService = ChangeSetDecoratorService = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ChangeSetDecoratorService);


/***/ }),

/***/ "../../node_modules/@theia/ai-chat/lib/common/chat-agent-service.js":
/*!**************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat/lib/common/chat-agent-service.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
// Partially copied from https://github.com/microsoft/vscode/blob/a2cab7255c0df424027be05d58e1b7b941f4ea60/src/vs/workbench/contrib/chat/common/chatAgents.ts
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChatAgentServiceImpl = exports.ChatAgentService = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const chat_agents_1 = __webpack_require__(/*! ./chat-agents */ "../../node_modules/@theia/ai-chat/lib/common/chat-agents.js");
const ai_core_1 = __webpack_require__(/*! @theia/ai-core */ "../../node_modules/@theia/ai-core/lib/common/index.js");
exports.ChatAgentService = Symbol('ChatAgentService');
let ChatAgentServiceImpl = class ChatAgentServiceImpl {
    constructor() {
        this._agents = [];
    }
    get agents() {
        // We can't collect the contributions at @postConstruct because this will lead to a circular dependency
        // with chat agents reusing the chat agent service (e.g. orchestrator)
        return [...this.agentContributions.getContributions(), ...this._agents];
    }
    registerChatAgent(agent) {
        this._agents.push(agent);
    }
    unregisterChatAgent(agentId) {
        this._agents = this._agents.filter(a => a.id !== agentId);
    }
    getAgent(id) {
        if (!this._agentIsEnabled(id)) {
            return undefined;
        }
        return this.getAgents().find(agent => agent.id === id);
    }
    getAgents() {
        return this.agents.filter(a => this._agentIsEnabled(a.id));
    }
    getAllAgents() {
        return this.agents;
    }
    _agentIsEnabled(id) {
        return this.agentService.isEnabled(id);
    }
};
exports.ChatAgentServiceImpl = ChatAgentServiceImpl;
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.ContributionProvider),
    (0, inversify_1.named)(chat_agents_1.ChatAgent),
    tslib_1.__metadata("design:type", Object)
], ChatAgentServiceImpl.prototype, "agentContributions", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.ILogger),
    tslib_1.__metadata("design:type", Object)
], ChatAgentServiceImpl.prototype, "logger", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(ai_core_1.AgentService),
    tslib_1.__metadata("design:type", Object)
], ChatAgentServiceImpl.prototype, "agentService", void 0);
exports.ChatAgentServiceImpl = ChatAgentServiceImpl = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ChatAgentServiceImpl);


/***/ }),

/***/ "../../node_modules/@theia/ai-chat/lib/common/chat-agents.js":
/*!*******************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat/lib/common/chat-agents.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
// Partially copied from https://github.com/microsoft/vscode/blob/a2cab7255c0df424027be05d58e1b7b941f4ea60/src/vs/workbench/contrib/chat/common/chatAgents.ts
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AbstractStreamParsingChatAgent = exports.ToolCallChatResponseContentFactory = exports.AbstractTextToModelParsingChatAgent = exports.AbstractChatAgent = exports.ChatAgent = exports.ChatAgentLocation = exports.ChatSessionContext = exports.SystemMessageDescription = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const ai_core_1 = __webpack_require__(/*! @theia/ai-core */ "../../node_modules/@theia/ai-core/lib/common/index.js");
const common_1 = __webpack_require__(/*! @theia/ai-core/lib/common */ "../../node_modules/@theia/ai-core/lib/common/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const chat_model_1 = __webpack_require__(/*! ./chat-model */ "../../node_modules/@theia/ai-chat/lib/common/chat-model.js");
const parse_contents_1 = __webpack_require__(/*! ./parse-contents */ "../../node_modules/@theia/ai-chat/lib/common/parse-contents.js");
const response_content_matcher_1 = __webpack_require__(/*! ./response-content-matcher */ "../../node_modules/@theia/ai-chat/lib/common/response-content-matcher.js");
const chat_tool_request_service_1 = __webpack_require__(/*! ./chat-tool-request-service */ "../../node_modules/@theia/ai-chat/lib/common/chat-tool-request-service.js");
var SystemMessageDescription;
(function (SystemMessageDescription) {
    function fromResolvedPromptTemplate(resolvedPrompt) {
        return {
            text: resolvedPrompt.text,
            functionDescriptions: resolvedPrompt.functionDescriptions
        };
    }
    SystemMessageDescription.fromResolvedPromptTemplate = fromResolvedPromptTemplate;
})(SystemMessageDescription || (exports.SystemMessageDescription = SystemMessageDescription = {}));
var ChatSessionContext;
(function (ChatSessionContext) {
    function is(candidate) {
        return typeof candidate === 'object' && !!candidate && 'model' in candidate;
    }
    ChatSessionContext.is = is;
    function getVariables(context) {
        var _a, _b;
        return (_b = (_a = context.request) === null || _a === void 0 ? void 0 : _a.context.variables.map(ai_core_1.AIVariableResolutionRequest.fromResolved)) !== null && _b !== void 0 ? _b : context.model.context.getVariables();
    }
    ChatSessionContext.getVariables = getVariables;
})(ChatSessionContext || (exports.ChatSessionContext = ChatSessionContext = {}));
/**
 * The location from where an chat agent may be invoked.
 * Based on the location, a different context may be available.
 */
var ChatAgentLocation;
(function (ChatAgentLocation) {
    ChatAgentLocation["Panel"] = "panel";
    ChatAgentLocation["Terminal"] = "terminal";
    ChatAgentLocation["Notebook"] = "notebook";
    ChatAgentLocation["Editor"] = "editor";
})(ChatAgentLocation || (exports.ChatAgentLocation = ChatAgentLocation = {}));
(function (ChatAgentLocation) {
    ChatAgentLocation.ALL = [ChatAgentLocation.Panel, ChatAgentLocation.Terminal, ChatAgentLocation.Notebook, ChatAgentLocation.Editor];
    function fromRaw(value) {
        switch (value) {
            case 'panel': return ChatAgentLocation.Panel;
            case 'terminal': return ChatAgentLocation.Terminal;
            case 'notebook': return ChatAgentLocation.Notebook;
            case 'editor': return ChatAgentLocation.Editor;
        }
        return ChatAgentLocation.Panel;
    }
    ChatAgentLocation.fromRaw = fromRaw;
})(ChatAgentLocation || (exports.ChatAgentLocation = ChatAgentLocation = {}));
exports.ChatAgent = Symbol('ChatAgent');
let AbstractChatAgent = class AbstractChatAgent {
    constructor() {
        this.iconClass = 'codicon codicon-copilot';
        this.locations = ChatAgentLocation.ALL;
        this.tags = ['Chat'];
        this.description = '';
        this.variables = [];
        this.promptTemplates = [];
        this.agentSpecificVariables = [];
        this.functions = [];
        this.systemPromptId = undefined;
        this.additionalToolRequests = [];
        this.contentMatchers = [];
    }
    init() {
        this.initializeContentMatchers();
    }
    initializeContentMatchers() {
        const contributedContentMatchers = this.contentMatcherProviders.getContributions().flatMap(provider => provider.matchers);
        this.contentMatchers.push(...contributedContentMatchers);
    }
    async invoke(request) {
        var _a;
        try {
            const languageModel = await this.getLanguageModel(this.defaultLanguageModelPurpose);
            if (!languageModel) {
                throw new Error('Couldn\'t find a matching language model. Please check your setup!');
            }
            const systemMessageDescription = await this.getSystemMessageDescription({ model: request.session, request });
            const messages = await this.getMessages(request.session);
            if (systemMessageDescription) {
                const systemMsg = {
                    actor: 'system',
                    type: 'text',
                    text: systemMessageDescription.text
                };
                // insert system message at the beginning of the request messages
                messages.unshift(systemMsg);
            }
            const systemMessageToolRequests = (_a = systemMessageDescription === null || systemMessageDescription === void 0 ? void 0 : systemMessageDescription.functionDescriptions) === null || _a === void 0 ? void 0 : _a.values();
            const tools = [
                ...this.chatToolRequestService.getChatToolRequests(request),
                ...this.chatToolRequestService.toChatToolRequests(systemMessageToolRequests ? Array.from(systemMessageToolRequests) : [], request),
                ...this.chatToolRequestService.toChatToolRequests(this.additionalToolRequests, request)
            ];
            const languageModelResponse = await this.sendLlmRequest(request, messages, tools, languageModel);
            await this.addContentsToResponse(languageModelResponse, request);
            await this.onResponseComplete(request);
        }
        catch (e) {
            this.handleError(request, e);
        }
    }
    parseContents(text, request) {
        var _a;
        return (0, parse_contents_1.parseContents)(text, request, this.contentMatchers, (_a = this.defaultContentFactory) === null || _a === void 0 ? void 0 : _a.create.bind(this.defaultContentFactory));
    }
    ;
    handleError(request, error) {
        request.response.response.addContent(new chat_model_1.ErrorChatResponseContentImpl(error));
        request.response.error(error);
    }
    getLanguageModelSelector(languageModelPurpose) {
        return this.languageModelRequirements.find(req => req.purpose === languageModelPurpose);
    }
    async getLanguageModel(languageModelPurpose) {
        return this.selectLanguageModel(this.getLanguageModelSelector(languageModelPurpose));
    }
    async selectLanguageModel(selector) {
        const languageModel = await this.languageModelRegistry.selectLanguageModel({ agent: this.id, ...selector });
        if (!languageModel) {
            throw new Error('Couldn\'t find a language model. Please check your setup!');
        }
        return languageModel;
    }
    async getSystemMessageDescription(context) {
        if (this.systemPromptId === undefined) {
            return undefined;
        }
        const resolvedPrompt = await this.promptService.getPrompt(this.systemPromptId, undefined, context);
        return resolvedPrompt ? SystemMessageDescription.fromResolvedPromptTemplate(resolvedPrompt) : undefined;
    }
    async getMessages(model, includeResponseInProgress = false) {
        const requestMessages = model.getRequests().flatMap(request => {
            const messages = [];
            const text = request.message.parts.map(part => part.promptText).join('');
            messages.push({
                actor: 'user',
                type: 'text',
                text: text,
            });
            if (request.response.isComplete || includeResponseInProgress) {
                const responseMessages = request.response.response.content.flatMap(c => {
                    var _a, _b, _c, _d;
                    if (chat_model_1.ChatResponseContent.hasToLanguageModelMessage(c)) {
                        return c.toLanguageModelMessage();
                    }
                    return {
                        actor: 'ai',
                        type: 'text',
                        text: (_d = (_b = (_a = c.asString) === null || _a === void 0 ? void 0 : _a.call(c)) !== null && _b !== void 0 ? _b : (_c = c.asDisplayString) === null || _c === void 0 ? void 0 : _c.call(c)) !== null && _d !== void 0 ? _d : '',
                    };
                });
                messages.push(...responseMessages);
            }
            return messages;
        });
        return requestMessages;
    }
    async sendLlmRequest(request, messages, toolRequests, languageModel) {
        const agentSettings = this.getLlmSettings();
        const settings = { ...agentSettings, ...request.session.settings };
        const tools = toolRequests.length > 0 ? toolRequests : undefined;
        this.recordingService.recordRequest({
            agentId: this.id,
            sessionId: request.session.id,
            requestId: request.id,
            request: messages
        });
        return this.languageModelService.sendRequest(languageModel, {
            messages,
            tools,
            settings,
            agentId: this.id,
            sessionId: request.session.id,
            requestId: request.id,
            cancellationToken: request.response.cancellationToken
        });
    }
    /**
     * @returns the settings, such as `temperature`, to be used in all language model requests. Returns `undefined` by default.
     */
    getLlmSettings() {
        return undefined;
    }
    /**
     * Invoked after the response by the LLM completed successfully.
     *
     * The default implementation sets the state of the response to `complete`.
     * Subclasses may override this method to perform additional actions or keep the response open for processing further requests.
     */
    async onResponseComplete(request) {
        this.recordingService.recordResponse({
            agentId: this.id,
            sessionId: request.session.id,
            requestId: request.id,
            response: request.response.response.content.flatMap(c => { var _a, _b, _c, _d, _e, _f; return (_b = (_a = c.toLanguageModelMessage) === null || _a === void 0 ? void 0 : _a.call(c)) !== null && _b !== void 0 ? _b : ({ type: 'text', actor: 'ai', text: (_f = (_d = (_c = c.asDisplayString) === null || _c === void 0 ? void 0 : _c.call(c)) !== null && _d !== void 0 ? _d : (_e = c.asString) === null || _e === void 0 ? void 0 : _e.call(c)) !== null && _f !== void 0 ? _f : JSON.stringify(c) }); })
        });
        return request.response.complete();
    }
};
exports.AbstractChatAgent = AbstractChatAgent;
tslib_1.__decorate([
    (0, inversify_1.inject)(common_1.LanguageModelRegistry),
    tslib_1.__metadata("design:type", Object)
], AbstractChatAgent.prototype, "languageModelRegistry", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.ILogger),
    tslib_1.__metadata("design:type", Object)
], AbstractChatAgent.prototype, "logger", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(chat_tool_request_service_1.ChatToolRequestService),
    tslib_1.__metadata("design:type", chat_tool_request_service_1.ChatToolRequestService)
], AbstractChatAgent.prototype, "chatToolRequestService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(ai_core_1.LanguageModelService),
    tslib_1.__metadata("design:type", Object)
], AbstractChatAgent.prototype, "languageModelService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(ai_core_1.PromptService),
    tslib_1.__metadata("design:type", Object)
], AbstractChatAgent.prototype, "promptService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.ContributionProvider),
    (0, inversify_1.named)(response_content_matcher_1.ResponseContentMatcherProvider),
    tslib_1.__metadata("design:type", Object)
], AbstractChatAgent.prototype, "contentMatcherProviders", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(response_content_matcher_1.DefaultResponseContentFactory),
    tslib_1.__metadata("design:type", response_content_matcher_1.DefaultResponseContentFactory)
], AbstractChatAgent.prototype, "defaultContentFactory", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(ai_core_1.CommunicationRecordingService),
    tslib_1.__metadata("design:type", Object)
], AbstractChatAgent.prototype, "recordingService", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], AbstractChatAgent.prototype, "init", null);
exports.AbstractChatAgent = AbstractChatAgent = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], AbstractChatAgent);
let AbstractTextToModelParsingChatAgent = class AbstractTextToModelParsingChatAgent extends AbstractChatAgent {
    async addContentsToResponse(languageModelResponse, request) {
        const responseAsText = await (0, ai_core_1.getTextOfResponse)(languageModelResponse);
        const parsedCommand = await this.parseTextResponse(responseAsText);
        const content = this.createResponseContent(parsedCommand, request);
        request.response.response.addContent(content);
    }
};
exports.AbstractTextToModelParsingChatAgent = AbstractTextToModelParsingChatAgent;
exports.AbstractTextToModelParsingChatAgent = AbstractTextToModelParsingChatAgent = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], AbstractTextToModelParsingChatAgent);
/**
 * Factory for creating ToolCallChatResponseContent instances.
 */
let ToolCallChatResponseContentFactory = class ToolCallChatResponseContentFactory {
    create(toolCall) {
        var _a, _b;
        return new chat_model_1.ToolCallChatResponseContentImpl(toolCall.id, (_a = toolCall.function) === null || _a === void 0 ? void 0 : _a.name, (_b = toolCall.function) === null || _b === void 0 ? void 0 : _b.arguments, toolCall.finished, toolCall.result);
    }
};
exports.ToolCallChatResponseContentFactory = ToolCallChatResponseContentFactory;
exports.ToolCallChatResponseContentFactory = ToolCallChatResponseContentFactory = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ToolCallChatResponseContentFactory);
let AbstractStreamParsingChatAgent = class AbstractStreamParsingChatAgent extends AbstractChatAgent {
    async addContentsToResponse(languageModelResponse, request) {
        if ((0, common_1.isLanguageModelTextResponse)(languageModelResponse)) {
            const contents = this.parseContents(languageModelResponse.text, request);
            request.response.response.addContents(contents);
            return;
        }
        if ((0, common_1.isLanguageModelStreamResponse)(languageModelResponse)) {
            await this.addStreamResponse(languageModelResponse, request);
            return;
        }
        this.logger.error('Received unknown response in agent. Return response as text');
        request.response.response.addContent(new chat_model_1.MarkdownChatResponseContentImpl(JSON.stringify(languageModelResponse)));
    }
    async addStreamResponse(languageModelResponse, request) {
        let completeTextBuffer = '';
        let startIndex = Math.max(0, request.response.response.content.length - 1);
        for await (const token of languageModelResponse.stream) {
            const newContent = this.parse(token, request);
            if (!((0, ai_core_1.isTextResponsePart)(token) && token.content)) {
                // For non-text tokens (like tool calls), add them directly
                if ((0, core_1.isArray)(newContent)) {
                    request.response.response.addContents(newContent);
                }
                else {
                    request.response.response.addContent(newContent);
                }
                // And reset the marker index and the text buffer as we skip matching across non-text tokens
                startIndex = request.response.response.content.length - 1;
                completeTextBuffer = '';
            }
            else {
                // parse the entire text so far (since beginning of the stream or last non-text token)
                // and replace the entire content with the currently parsed content parts
                completeTextBuffer += token.content;
                const parsedContents = this.parseContents(completeTextBuffer, request);
                const contentBeforeMarker = startIndex > 0
                    ? request.response.response.content.slice(0, startIndex)
                    : [];
                request.response.response.clearContent();
                request.response.response.addContents(contentBeforeMarker);
                request.response.response.addContents(parsedContents);
            }
        }
    }
    parse(token, request) {
        if ((0, ai_core_1.isTextResponsePart)(token)) {
            const content = token.content;
            // eslint-disable-next-line no-null/no-null
            if (content !== undefined && content !== null) {
                return this.defaultContentFactory.create(content, request);
            }
        }
        if ((0, ai_core_1.isToolCallResponsePart)(token)) {
            const toolCalls = token.tool_calls;
            if (toolCalls !== undefined) {
                const toolCallContents = toolCalls.map(toolCall => this.createToolCallResponseContent(toolCall));
                return toolCallContents;
            }
        }
        if ((0, ai_core_1.isThinkingResponsePart)(token)) {
            return new chat_model_1.ThinkingChatResponseContentImpl(token.thought, token.signature);
        }
        if ((0, ai_core_1.isUsageResponsePart)(token)) {
            return [];
        }
        return this.defaultContentFactory.create('', request);
    }
    /**
     * Creates a ToolCallChatResponseContent instance from the provided tool call data.
     *
     * This method is called when parsing stream response tokens that contain tool call data.
     * Subclasses can override this method to customize the creation of tool call response contents.
     *
     * @param toolCall The ToolCall.
     * @returns A ChatResponseContent representing the tool call.
     */
    createToolCallResponseContent(toolCall) {
        return this.toolCallResponseContentFactory.create(toolCall);
    }
};
exports.AbstractStreamParsingChatAgent = AbstractStreamParsingChatAgent;
tslib_1.__decorate([
    (0, inversify_1.inject)(ToolCallChatResponseContentFactory),
    tslib_1.__metadata("design:type", ToolCallChatResponseContentFactory)
], AbstractStreamParsingChatAgent.prototype, "toolCallResponseContentFactory", void 0);
exports.AbstractStreamParsingChatAgent = AbstractStreamParsingChatAgent = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], AbstractStreamParsingChatAgent);


/***/ }),

/***/ "../../node_modules/@theia/ai-chat/lib/common/chat-model-util.js":
/*!***********************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat/lib/common/chat-model-util.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.unansweredQuestions = exports.lastProgressMessageOfResponse = exports.lastProgressMessage = exports.lastContentOfResponse = exports.lastResponseContent = void 0;
// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
const chat_model_1 = __webpack_require__(/*! ./chat-model */ "../../node_modules/@theia/ai-chat/lib/common/chat-model.js");
function lastResponseContent(request) {
    var _a;
    return lastContentOfResponse((_a = request.response) === null || _a === void 0 ? void 0 : _a.response);
}
exports.lastResponseContent = lastResponseContent;
function lastContentOfResponse(response) {
    const content = response === null || response === void 0 ? void 0 : response.content;
    return content && content.length > 0 ? content[content.length - 1] : undefined;
}
exports.lastContentOfResponse = lastContentOfResponse;
function lastProgressMessage(request) {
    return lastProgressMessageOfResponse(request.response);
}
exports.lastProgressMessage = lastProgressMessage;
function lastProgressMessageOfResponse(response) {
    const progressMessages = response === null || response === void 0 ? void 0 : response.progressMessages;
    return progressMessages && progressMessages.length > 0 ? progressMessages[progressMessages.length - 1] : undefined;
}
exports.lastProgressMessageOfResponse = lastProgressMessageOfResponse;
function unansweredQuestions(request) {
    const response = request.response;
    return unansweredQuestionsOfResponse(response);
}
exports.unansweredQuestions = unansweredQuestions;
function unansweredQuestionsOfResponse(response) {
    if (!response || !response.response) {
        return [];
    }
    return response.response.content.filter((c) => chat_model_1.QuestionResponseContent.is(c) && c.selectedOption === undefined);
}


/***/ }),

/***/ "../../node_modules/@theia/ai-chat/lib/common/chat-model.js":
/*!******************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat/lib/common/chat-model.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
// Partially copied from https://github.com/microsoft/vscode/blob/a2cab7255c0df424027be05d58e1b7b941f4ea60/src/vs/workbench/contrib/chat/common/chatModel.ts
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ProgressChatResponseContentImpl = exports.ErrorChatResponseModel = exports.MutableChatResponseModel = exports.QuestionResponseContentImpl = exports.HorizontalLayoutChatResponseContentImpl = exports.CommandChatResponseContentImpl = exports.COMMAND_CHAT_RESPONSE_COMMAND = exports.ToolCallChatResponseContentImpl = exports.CodeChatResponseContentImpl = exports.InformationalChatResponseContentImpl = exports.MarkdownChatResponseContentImpl = exports.ThinkingChatResponseContentImpl = exports.TextChatResponseContentImpl = exports.ErrorChatResponseContentImpl = exports.MutableChatRequestModel = exports.ChatContextManagerImpl = exports.ChangeSetImpl = exports.ChatRequestHierarchyBranchImpl = exports.ChatRequestHierarchyImpl = exports.MutableChatModel = exports.QuestionResponseContent = exports.ProgressChatResponseContent = exports.ThinkingChatResponseContent = exports.ErrorChatResponseContent = exports.ToolCallChatResponseContent = exports.HorizontalLayoutChatResponseContent = exports.CodeChatResponseContent = exports.CommandChatResponseContent = exports.InformationalChatResponseContent = exports.MarkdownChatResponseContent = exports.TextChatResponseContent = exports.Location = exports.ChatResponseContent = exports.EditableChatRequestModel = exports.ChatRequestModel = exports.ChatSuggestionCallback = exports.ChatChangeEvent = void 0;
const ai_core_1 = __webpack_require__(/*! @theia/ai-core */ "../../node_modules/@theia/ai-core/lib/common/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const markdown_rendering_1 = __webpack_require__(/*! @theia/core/lib/common/markdown-rendering */ "../../node_modules/@theia/core/lib/common/markdown-rendering/index.js");
const vscode_languageserver_protocol_1 = __webpack_require__(/*! @theia/core/shared/vscode-languageserver-protocol */ "../../node_modules/@theia/core/shared/vscode-languageserver-protocol/index.js");
const chat_agents_1 = __webpack_require__(/*! ./chat-agents */ "../../node_modules/@theia/ai-chat/lib/common/chat-agents.js");
var ChatChangeEvent;
(function (ChatChangeEvent) {
    function isChangeSetEvent(event) {
        return event.kind === 'setChangeSet' || event.kind === 'removeChangeSet' || event.kind === 'updateChangeSet';
    }
    ChatChangeEvent.isChangeSetEvent = isChangeSetEvent;
})(ChatChangeEvent || (exports.ChatChangeEvent = ChatChangeEvent = {}));
var ChatSuggestionCallback;
(function (ChatSuggestionCallback) {
    function is(candidate) {
        return typeof candidate === 'object' && 'callback' in candidate;
    }
    ChatSuggestionCallback.is = is;
    function containsCallbackLink(candidate) {
        if (!is(candidate)) {
            return false;
        }
        const text = typeof candidate.content === 'string' ? candidate.content : candidate.content.value;
        return text.includes('](_callback)');
    }
    ChatSuggestionCallback.containsCallbackLink = containsCallbackLink;
})(ChatSuggestionCallback || (exports.ChatSuggestionCallback = ChatSuggestionCallback = {}));
var ChatRequestModel;
(function (ChatRequestModel) {
    function is(request) {
        return !!(request &&
            typeof request === 'object' &&
            'id' in request &&
            typeof request.id === 'string' &&
            'session' in request &&
            'request' in request &&
            'response' in request &&
            'message' in request);
    }
    ChatRequestModel.is = is;
    function isInProgress(request) {
        if (!request) {
            return false;
        }
        const response = request.response;
        return !(response.isComplete ||
            response.isCanceled ||
            response.isError);
    }
    ChatRequestModel.isInProgress = isInProgress;
})(ChatRequestModel || (exports.ChatRequestModel = ChatRequestModel = {}));
var EditableChatRequestModel;
(function (EditableChatRequestModel) {
    function is(request) {
        return !!(ChatRequestModel.is(request) &&
            'enableEdit' in request &&
            'cancelEdit' in request &&
            'submitEdit' in request);
    }
    EditableChatRequestModel.is = is;
    function isEditing(request) {
        return is(request) && request.isEditing;
    }
    EditableChatRequestModel.isEditing = isEditing;
})(EditableChatRequestModel || (exports.EditableChatRequestModel = EditableChatRequestModel = {}));
var ChatResponseContent;
(function (ChatResponseContent) {
    function is(obj) {
        return !!(obj &&
            typeof obj === 'object' &&
            'kind' in obj &&
            typeof obj.kind === 'string');
    }
    ChatResponseContent.is = is;
    function hasAsString(obj) {
        return typeof obj.asString === 'function';
    }
    ChatResponseContent.hasAsString = hasAsString;
    function hasDisplayString(obj) {
        return typeof obj.asDisplayString === 'function';
    }
    ChatResponseContent.hasDisplayString = hasDisplayString;
    function hasMerge(obj) {
        return typeof obj.merge === 'function';
    }
    ChatResponseContent.hasMerge = hasMerge;
    function hasToLanguageModelMessage(obj) {
        return typeof obj.toLanguageModelMessage === 'function';
    }
    ChatResponseContent.hasToLanguageModelMessage = hasToLanguageModelMessage;
})(ChatResponseContent || (exports.ChatResponseContent = ChatResponseContent = {}));
var Location;
(function (Location) {
    function is(obj) {
        return !!obj && typeof obj === 'object' &&
            'uri' in obj && obj.uri instanceof core_1.URI &&
            'position' in obj && vscode_languageserver_protocol_1.Position.is(obj.position);
    }
    Location.is = is;
})(Location || (exports.Location = Location = {}));
var TextChatResponseContent;
(function (TextChatResponseContent) {
    function is(obj) {
        return (ChatResponseContent.is(obj) &&
            obj.kind === 'text' &&
            'content' in obj &&
            typeof obj.content === 'string');
    }
    TextChatResponseContent.is = is;
})(TextChatResponseContent || (exports.TextChatResponseContent = TextChatResponseContent = {}));
var MarkdownChatResponseContent;
(function (MarkdownChatResponseContent) {
    function is(obj) {
        return (ChatResponseContent.is(obj) &&
            obj.kind === 'markdownContent' &&
            'content' in obj &&
            markdown_rendering_1.MarkdownString.is(obj.content));
    }
    MarkdownChatResponseContent.is = is;
})(MarkdownChatResponseContent || (exports.MarkdownChatResponseContent = MarkdownChatResponseContent = {}));
var InformationalChatResponseContent;
(function (InformationalChatResponseContent) {
    function is(obj) {
        return (ChatResponseContent.is(obj) &&
            obj.kind === 'informational' &&
            'content' in obj &&
            markdown_rendering_1.MarkdownString.is(obj.content));
    }
    InformationalChatResponseContent.is = is;
})(InformationalChatResponseContent || (exports.InformationalChatResponseContent = InformationalChatResponseContent = {}));
var CommandChatResponseContent;
(function (CommandChatResponseContent) {
    function is(obj) {
        return (ChatResponseContent.is(obj) &&
            obj.kind === 'command' &&
            'command' in obj &&
            core_1.Command.is(obj.command));
    }
    CommandChatResponseContent.is = is;
})(CommandChatResponseContent || (exports.CommandChatResponseContent = CommandChatResponseContent = {}));
var CodeChatResponseContent;
(function (CodeChatResponseContent) {
    function is(obj) {
        return (ChatResponseContent.is(obj) &&
            obj.kind === 'code' &&
            'code' in obj &&
            typeof obj.code === 'string');
    }
    CodeChatResponseContent.is = is;
})(CodeChatResponseContent || (exports.CodeChatResponseContent = CodeChatResponseContent = {}));
var HorizontalLayoutChatResponseContent;
(function (HorizontalLayoutChatResponseContent) {
    function is(obj) {
        return (ChatResponseContent.is(obj) &&
            obj.kind === 'horizontal' &&
            'content' in obj &&
            Array.isArray(obj.content) &&
            obj.content.every(ChatResponseContent.is));
    }
    HorizontalLayoutChatResponseContent.is = is;
})(HorizontalLayoutChatResponseContent || (exports.HorizontalLayoutChatResponseContent = HorizontalLayoutChatResponseContent = {}));
var ToolCallChatResponseContent;
(function (ToolCallChatResponseContent) {
    function is(obj) {
        return ChatResponseContent.is(obj) && obj.kind === 'toolCall';
    }
    ToolCallChatResponseContent.is = is;
})(ToolCallChatResponseContent || (exports.ToolCallChatResponseContent = ToolCallChatResponseContent = {}));
var ErrorChatResponseContent;
(function (ErrorChatResponseContent) {
    function is(obj) {
        return (ChatResponseContent.is(obj) &&
            obj.kind === 'error' &&
            'error' in obj &&
            obj.error instanceof Error);
    }
    ErrorChatResponseContent.is = is;
})(ErrorChatResponseContent || (exports.ErrorChatResponseContent = ErrorChatResponseContent = {}));
var ThinkingChatResponseContent;
(function (ThinkingChatResponseContent) {
    function is(obj) {
        return (ChatResponseContent.is(obj) &&
            obj.kind === 'thinking' &&
            'content' in obj &&
            typeof obj.content === 'string');
    }
    ThinkingChatResponseContent.is = is;
})(ThinkingChatResponseContent || (exports.ThinkingChatResponseContent = ThinkingChatResponseContent = {}));
var ProgressChatResponseContent;
(function (ProgressChatResponseContent) {
    function is(obj) {
        return (ChatResponseContent.is(obj) &&
            obj.kind === 'progress' &&
            'message' in obj &&
            typeof obj.message === 'string');
    }
    ProgressChatResponseContent.is = is;
})(ProgressChatResponseContent || (exports.ProgressChatResponseContent = ProgressChatResponseContent = {}));
var QuestionResponseContent;
(function (QuestionResponseContent) {
    function is(obj) {
        return (ChatResponseContent.is(obj) &&
            obj.kind === 'question' &&
            'question' in obj &&
            typeof obj.question === 'string' &&
            'options' in obj &&
            Array.isArray(obj.options) &&
            obj.options.every(option => typeof option === 'object' &&
                option && 'text' in option &&
                typeof option.text === 'string' &&
                ('value' in option ? typeof option.value === 'string' || typeof option.value === 'undefined' : true)) &&
            'handler' in obj &&
            typeof obj.handler === 'function' &&
            'request' in obj &&
            obj.request instanceof MutableChatRequestModel);
    }
    QuestionResponseContent.is = is;
})(QuestionResponseContent || (exports.QuestionResponseContent = QuestionResponseContent = {}));
/**********************
 * Implementations
 **********************/
class MutableChatModel {
    constructor(location = chat_agents_1.ChatAgentLocation.Panel) {
        this.location = location;
        this._onDidChangeEmitter = new core_1.Emitter();
        this.onDidChange = this._onDidChangeEmitter.event;
        this.toDispose = new core_1.DisposableCollection();
        this._suggestions = [];
        this._contextManager = new ChatContextManagerImpl();
        // TODO accept serialized data as a parameter to restore a previously saved ChatModel
        this._hierarchy = new ChatRequestHierarchyImpl();
        this._id = (0, core_1.generateUuid)();
        this.toDispose.pushAll([
            this._onDidChangeEmitter,
            this._contextManager.onDidChange(e => this._onDidChangeEmitter.fire(e)),
            this._hierarchy.onDidChange(event => this._onDidChangeEmitter.fire({
                kind: 'changeHierarchyBranch',
                branch: event.branch,
            })),
        ]);
    }
    getBranches() {
        return this._hierarchy.activeBranches();
    }
    getBranch(requestId) {
        return this._hierarchy.findBranch(requestId);
    }
    getRequests() {
        return this._hierarchy.activeRequests();
    }
    getRequest(id) {
        return this.getRequests().find(request => request.id === id);
    }
    get id() {
        return this._id;
    }
    get changeSet() {
        return this._changeSet;
    }
    get suggestions() {
        return this._suggestions;
    }
    get context() {
        return this._contextManager;
    }
    get settings() {
        return this._settings;
    }
    setSettings(settings) {
        this._settings = settings;
    }
    setChangeSet(changeSet) {
        if (!changeSet) {
            return this.removeChangeSet();
        }
        const oldChangeSet = this._changeSet;
        oldChangeSet === null || oldChangeSet === void 0 ? void 0 : oldChangeSet.dispose();
        this._changeSet = changeSet;
        this._onDidChangeEmitter.fire({
            kind: 'setChangeSet',
            changeSet,
            oldChangeSet,
        });
        changeSet.onDidChange(() => {
            this._onDidChangeEmitter.fire({
                kind: 'updateChangeSet',
                changeSet,
            });
        });
    }
    removeChangeSet() {
        if (this._changeSet) {
            const oldChangeSet = this._changeSet;
            this._changeSet = undefined;
            oldChangeSet.dispose();
            this._onDidChangeEmitter.fire({
                kind: 'removeChangeSet',
                changeSet: oldChangeSet,
            });
        }
    }
    addRequest(parsedChatRequest, agentId, context = { variables: [] }) {
        if (parsedChatRequest.request.referencedRequestId) {
            return this.applyEdit(parsedChatRequest, agentId, context);
        }
        const requestModel = new MutableChatRequestModel(this, parsedChatRequest, agentId, context);
        this.toDispose.push(requestModel);
        this._hierarchy.append(requestModel);
        this._onDidChangeEmitter.fire({
            kind: 'addRequest',
            request: requestModel,
        });
        return requestModel;
    }
    setSuggestions(suggestions) {
        this._suggestions = Object.freeze(suggestions);
        this._onDidChangeEmitter.fire({
            kind: 'suggestionsChanged',
            suggestions
        });
    }
    isEmpty() {
        return this.getRequests().length === 0;
    }
    applyEdit(parsedChatRequest, agentId, context = { variables: [] }) {
        const requestId = parsedChatRequest.request.referencedRequestId;
        const branch = this._hierarchy.findBranch(requestId);
        if (!branch) {
            throw new Error(`Cannot find branch for requestId: ${requestId}`);
        }
        const requestModel = new MutableChatRequestModel(this, parsedChatRequest, agentId, context);
        this.toDispose.push(requestModel);
        branch.add(requestModel);
        this.removeChangeSet();
        this._onDidChangeEmitter.fire({
            kind: 'addRequest',
            request: requestModel,
        });
        return requestModel;
    }
    dispose() {
        this.removeChangeSet(); // Signal disposal of last change set.
        this.toDispose.dispose();
    }
    emit(event) {
        this._onDidChangeEmitter.fire(event);
    }
}
exports.MutableChatModel = MutableChatModel;
class ChatRequestHierarchyImpl {
    constructor() {
        this.onDidChangeActiveBranchEmitter = new core_1.Emitter();
        this.onDidChange = this.onDidChangeActiveBranchEmitter.event;
        this.branch = new ChatRequestHierarchyBranchImpl(this);
    }
    append(request) {
        const branches = this.activeBranches();
        if (branches.length === 0) {
            this.branch.add(request);
            return this.branch;
        }
        return branches.at(-1).continue(request);
    }
    activeRequests() {
        return this.activeBranches().map(h => h.get());
    }
    activeBranches() {
        return Array.from(this.iterateBranches());
    }
    *iterateBranches() {
        let current = this.branch;
        while (current) {
            if (current.items.length > 0) {
                yield current;
                current = current.next();
            }
            else {
                break;
            }
        }
    }
    findRequest(requestId) {
        var _a;
        const branch = this.findInBranch(this.branch, requestId);
        return (_a = branch === null || branch === void 0 ? void 0 : branch.items.find(item => item.element.id === requestId)) === null || _a === void 0 ? void 0 : _a.element;
    }
    findBranch(requestId) {
        return this.findInBranch(this.branch, requestId);
    }
    findInBranch(branch, requestId) {
        for (const item of branch.items) {
            if (item.element.id === requestId) {
                return branch;
            }
        }
        for (const item of branch.items) {
            if (item.next) {
                const found = this.findInBranch(item.next, requestId);
                if (found) {
                    return found;
                }
            }
        }
        return undefined;
    }
    notifyChange(event) {
        this.onDidChangeActiveBranchEmitter.fire(event);
    }
}
exports.ChatRequestHierarchyImpl = ChatRequestHierarchyImpl;
class ChatRequestHierarchyBranchImpl {
    constructor(hierarchy, previous, items = [], _activeIndex = -1) {
        this.hierarchy = hierarchy;
        this.previous = previous;
        this.items = items;
        this._activeIndex = _activeIndex;
        this.id = (0, core_1.generateUuid)();
    }
    get activeBranchIndex() {
        return this._activeIndex;
    }
    set activeBranchIndex(value) {
        this._activeIndex = value;
        this.hierarchy.notifyChange({
            branch: this,
            item: this.items[this._activeIndex]
        });
    }
    next() {
        var _a;
        return (_a = this.items[this.activeBranchIndex]) === null || _a === void 0 ? void 0 : _a.next;
    }
    get() {
        return this.items[this.activeBranchIndex].element;
    }
    add(request) {
        const branch = {
            element: request
        };
        this.items.push(branch);
        this.activeBranchIndex = this.items.length - 1;
    }
    remove(request) {
        const requestId = typeof request === 'string' ? request : request.id;
        const index = this.items.findIndex(version => version.element.id === requestId);
        if (index !== -1) {
            this.items.splice(index, 1);
            if (this.activeBranchIndex >= index) {
                this.activeBranchIndex--;
            }
        }
    }
    continue(request) {
        if (this.items.length === 0) {
            this.add(request);
            return this;
        }
        const item = this.items[this.activeBranchIndex];
        if (item) {
            const next = new ChatRequestHierarchyBranchImpl(this.hierarchy, this, [{ element: request }], 0);
            this.items[this.activeBranchIndex] = {
                ...item,
                next
            };
            return next;
        }
        throw new Error(`No current branch to continue from. Active Index: ${this.activeBranchIndex}`);
    }
    enable(request) {
        this.activeBranchIndex = this.items.findIndex(pred => pred.element.id === request.id);
        return this.items[this.activeBranchIndex];
    }
    enablePrevious() {
        if (this.activeBranchIndex > 0) {
            this.activeBranchIndex--;
            return this.items[this.activeBranchIndex];
        }
        return this.items[0];
    }
    enableNext() {
        if (this.activeBranchIndex < this.items.length - 1) {
            this.activeBranchIndex++;
            return this.items[this.activeBranchIndex];
        }
        return this.items[this.activeBranchIndex];
    }
    succeedingBranches() {
        const branches = [];
        let current = this;
        while (current !== undefined) {
            branches.push(current);
            current = current.next();
        }
        return branches;
    }
}
exports.ChatRequestHierarchyBranchImpl = ChatRequestHierarchyBranchImpl;
class ChangeSetImpl {
    constructor(title, elements = []) {
        this.title = title;
        this._onDidChangeEmitter = new core_1.Emitter();
        this.onDidChange = this._onDidChangeEmitter.event;
        this._elements = [];
        this.addElements(...elements);
    }
    getElements() {
        return this._elements;
    }
    /** Will replace any element that is already present, using URI as identity criterion. */
    addElements(...elements) {
        const added = [];
        const modified = [];
        const toDispose = [];
        const current = new Map(this.getElements().map((element, index) => [element.uri.toString(), index]));
        elements.forEach(element => {
            var _a;
            const existingIndex = current.get(element.uri.toString());
            if (existingIndex !== undefined) {
                modified.push(element.uri);
                toDispose.push(this._elements[existingIndex]);
                this._elements[existingIndex] = element;
            }
            else {
                added.push(element.uri);
                this._elements.push(element);
            }
            (_a = element.onDidChange) === null || _a === void 0 ? void 0 : _a.call(element, () => this.notifyChange({ state: [element.uri] }));
        });
        toDispose.forEach(element => { var _a; return (_a = element.dispose) === null || _a === void 0 ? void 0 : _a.call(element); });
        this.notifyChange({ added, modified });
    }
    removeElements(...indices) {
        // From highest to lowest so that we don't affect lower indices with our splicing.
        const sorted = indices.slice().sort((left, right) => left - right);
        const deletions = sorted.flatMap(index => this._elements.splice(index, 1));
        deletions.forEach(deleted => { var _a; return (_a = deleted.dispose) === null || _a === void 0 ? void 0 : _a.call(deleted); });
        this.notifyChange({ removed: deletions.map(element => element.uri) });
    }
    notifyChange(change) {
        this._onDidChangeEmitter.fire(change);
    }
    dispose() {
        this._onDidChangeEmitter.dispose();
        this._elements.forEach(element => { var _a; return (_a = element.dispose) === null || _a === void 0 ? void 0 : _a.call(element); });
    }
}
exports.ChangeSetImpl = ChangeSetImpl;
class ChatContextManagerImpl {
    get onDidChange() {
        return this.onDidChangeEmitter.event;
    }
    constructor(context) {
        this.variables = new Array();
        this.onDidChangeEmitter = new core_1.Emitter();
        if (context) {
            this.variables.push(...context.variables.map(ai_core_1.AIVariableResolutionRequest.fromResolved));
        }
    }
    getVariables() {
        const result = this.variables.slice();
        Object.freeze(result);
        return result;
    }
    addVariables(...variables) {
        let modified = false;
        variables.forEach(variable => {
            if (this.variables.some(existing => existing.variable.id === variable.variable.id && existing.arg === variable.arg)) {
                return;
            }
            this.variables.push(variable);
            modified = true;
        });
        if (modified) {
            this.onDidChangeEmitter.fire({ kind: 'addVariable' });
        }
    }
    deleteVariables(...indices) {
        const toDelete = indices.filter(candidate => candidate <= this.variables.length).sort((left, right) => right - left);
        if (toDelete.length) {
            toDelete.forEach(index => {
                this.variables.splice(index, 1);
            });
            this.onDidChangeEmitter.fire({ kind: 'removeVariable' });
        }
    }
    setVariables(variables) {
        this.variables.length = 0;
        variables.forEach(variable => {
            if (this.variables.some(existing => existing.variable.id === variable.variable.id && existing.arg === variable.arg)) {
                return;
            }
            this.variables.push(variable);
        });
        this.onDidChangeEmitter.fire({ kind: 'setVariables' });
    }
    clear() {
        if (this.variables.length) {
            this.variables.length = 0;
            this.onDidChangeEmitter.fire({ kind: 'removeVariable' });
        }
    }
}
exports.ChatContextManagerImpl = ChatContextManagerImpl;
class MutableChatRequestModel {
    constructor(session, message, agentId, context = { variables: [] }, data = {}) {
        this.message = message;
        this._isEditing = false;
        this.toDispose = new core_1.DisposableCollection();
        // TODO accept serialized data as a parameter to restore a previously saved ChatRequestModel
        this._request = message.request;
        this._id = (0, core_1.generateUuid)();
        this._session = session;
        this._response = new MutableChatResponseModel(this._id, agentId);
        this._context = context;
        this._agentId = agentId;
        this._data = data;
        this.editContextManager = new ChatContextManagerImpl(context);
        this.toDispose.pushAll([
            this.editContextManager.onDidChange(e => this.session.emit(e))
        ]);
    }
    get isEditing() {
        return this._isEditing;
    }
    enableEdit() {
        this._isEditing = true;
        this.emitEditRequest(this);
    }
    get data() {
        return this._data;
    }
    addData(key, value) {
        this._data[key] = value;
    }
    getDataByKey(key) {
        return this._data[key];
    }
    get id() {
        return this._id;
    }
    get session() {
        return this._session;
    }
    get request() {
        return this._request;
    }
    get response() {
        return this._response;
    }
    get context() {
        return this._context;
    }
    get agentId() {
        return this._agentId;
    }
    cancelEdit() {
        if (this.isEditing) {
            this._isEditing = false;
            this.emitCancelEdit(this);
            this.clearEditContext();
        }
    }
    submitEdit(newRequest) {
        var _a;
        if (this.isEditing) {
            this._isEditing = false;
            const variables = (_a = this.editContextManager.getVariables()) !== null && _a !== void 0 ? _a : [];
            this.emitSubmitEdit(this, {
                ...newRequest,
                referencedRequestId: this.id,
                variables
            });
            this.clearEditContext();
        }
    }
    cancel() {
        this.response.cancel();
    }
    dispose() {
        this.toDispose.dispose();
    }
    clearEditContext() {
        this.editContextManager.setVariables(this.context.variables.map(ai_core_1.AIVariableResolutionRequest.fromResolved));
    }
    emitEditRequest(request) {
        const branch = this.session.getBranch(request.id);
        if (!branch) {
            throw new Error(`Cannot find hierarchy for requestId: ${request.id}`);
        }
        this.session.emit({
            kind: 'enableEdit',
            request,
            branch,
        });
    }
    emitCancelEdit(request) {
        const branch = this.session.getBranch(request.id);
        if (!branch) {
            throw new Error(`Cannot find branch for requestId: ${request.id}`);
        }
        this.session.emit({
            kind: 'cancelEdit',
            request,
            branch,
        });
    }
    emitSubmitEdit(request, newRequest) {
        const branch = this.session.getBranch(request.id);
        if (!branch) {
            throw new Error(`Cannot find branch for requestId: ${request.id}`);
        }
        this.session.emit({
            kind: 'submitEdit',
            request,
            branch,
            newRequest
        });
    }
}
exports.MutableChatRequestModel = MutableChatRequestModel;
class ErrorChatResponseContentImpl {
    constructor(error) {
        this.kind = 'error';
        this._error = error;
    }
    get error() {
        return this._error;
    }
    asString() {
        return undefined;
    }
}
exports.ErrorChatResponseContentImpl = ErrorChatResponseContentImpl;
class TextChatResponseContentImpl {
    constructor(content) {
        this.kind = 'text';
        this._content = content;
    }
    get content() {
        return this._content;
    }
    asString() {
        return this._content;
    }
    asDisplayString() {
        return this.asString();
    }
    merge(nextChatResponseContent) {
        this._content += nextChatResponseContent.content;
        return true;
    }
    toLanguageModelMessage() {
        return {
            actor: 'ai',
            type: 'text',
            text: this.content
        };
    }
}
exports.TextChatResponseContentImpl = TextChatResponseContentImpl;
class ThinkingChatResponseContentImpl {
    constructor(content, signature) {
        this.kind = 'thinking';
        this._content = content;
        this._signature = signature;
    }
    get content() {
        return this._content;
    }
    get signature() {
        return this._signature;
    }
    asString() {
        return JSON.stringify({
            type: 'thinking',
            thinking: this.content,
            signature: this.signature
        });
    }
    asDisplayString() {
        return `<Thinking>${this.content}</Thinking>`;
    }
    merge(nextChatResponseContent) {
        this._content += nextChatResponseContent.content;
        this._signature += nextChatResponseContent.signature;
        return true;
    }
    toLanguageModelMessage() {
        return {
            actor: 'ai',
            type: 'thinking',
            thinking: this.content,
            signature: this.signature
        };
    }
}
exports.ThinkingChatResponseContentImpl = ThinkingChatResponseContentImpl;
class MarkdownChatResponseContentImpl {
    constructor(content) {
        this.kind = 'markdownContent';
        this._content = new markdown_rendering_1.MarkdownStringImpl();
        this._content.appendMarkdown(content);
    }
    get content() {
        return this._content;
    }
    asString() {
        return this._content.value;
    }
    asDisplayString() {
        return this.asString();
    }
    merge(nextChatResponseContent) {
        this._content.appendMarkdown(nextChatResponseContent.content.value);
        return true;
    }
    toLanguageModelMessage() {
        return {
            actor: 'ai',
            type: 'text',
            text: this.content.value
        };
    }
}
exports.MarkdownChatResponseContentImpl = MarkdownChatResponseContentImpl;
class InformationalChatResponseContentImpl {
    constructor(content) {
        this.kind = 'informational';
        this._content = new markdown_rendering_1.MarkdownStringImpl(content);
    }
    get content() {
        return this._content;
    }
    asString() {
        return undefined;
    }
    merge(nextChatResponseContent) {
        this._content.appendMarkdown(nextChatResponseContent.content.value);
        return true;
    }
}
exports.InformationalChatResponseContentImpl = InformationalChatResponseContentImpl;
class CodeChatResponseContentImpl {
    constructor(code, language, location) {
        this.kind = 'code';
        this._code = code;
        this._language = language;
        this._location = location;
    }
    get code() {
        return this._code;
    }
    get language() {
        return this._language;
    }
    get location() {
        return this._location;
    }
    asString() {
        var _a;
        return `\`\`\`${(_a = this._language) !== null && _a !== void 0 ? _a : ''}\n${this._code}\n\`\`\``;
    }
    merge(nextChatResponseContent) {
        this._code += `${nextChatResponseContent.code}`;
        return true;
    }
}
exports.CodeChatResponseContentImpl = CodeChatResponseContentImpl;
class ToolCallChatResponseContentImpl {
    constructor(id, name, arg_string, finished, result) {
        this.kind = 'toolCall';
        this._id = id;
        this._name = name;
        this._arguments = arg_string;
        this._finished = finished;
        this._result = result;
    }
    get id() {
        return this._id;
    }
    get name() {
        return this._name;
    }
    get arguments() {
        return this._arguments;
    }
    get finished() {
        return this._finished === undefined ? false : this._finished;
    }
    get result() {
        return this._result;
    }
    asString() {
        return '';
    }
    asDisplayString() {
        var _a;
        return `Tool call: ${this._name}(${(_a = this._arguments) !== null && _a !== void 0 ? _a : ''})`;
    }
    merge(nextChatResponseContent) {
        if (nextChatResponseContent.id === this.id) {
            this._finished = nextChatResponseContent.finished;
            this._result = nextChatResponseContent.result;
            return true;
        }
        if (nextChatResponseContent.name !== undefined) {
            return false;
        }
        if (nextChatResponseContent.arguments === undefined) {
            return false;
        }
        this._arguments += `${nextChatResponseContent.arguments}`;
        return true;
    }
    toLanguageModelMessage() {
        var _a, _b, _c, _d;
        return [{
                actor: 'ai',
                type: 'tool_use',
                id: (_a = this.id) !== null && _a !== void 0 ? _a : '',
                input: this.arguments && this.arguments.length !== 0 ? JSON.parse(this.arguments) : {},
                name: (_b = this.name) !== null && _b !== void 0 ? _b : ''
            }, {
                actor: 'user',
                type: 'tool_result',
                tool_use_id: (_c = this.id) !== null && _c !== void 0 ? _c : '',
                content: this.result,
                name: (_d = this.name) !== null && _d !== void 0 ? _d : ''
            }];
    }
}
exports.ToolCallChatResponseContentImpl = ToolCallChatResponseContentImpl;
exports.COMMAND_CHAT_RESPONSE_COMMAND = {
    id: 'ai-chat.command-chat-response.generic'
};
class CommandChatResponseContentImpl {
    constructor(command, customCallback, args) {
        this.command = command;
        this.customCallback = customCallback;
        this.args = args;
        this.kind = 'command';
    }
    get arguments() {
        var _a;
        return (_a = this.args) !== null && _a !== void 0 ? _a : [];
    }
    asString() {
        var _a, _b;
        return ((_a = this.command) === null || _a === void 0 ? void 0 : _a.id) || ((_b = this.customCallback) === null || _b === void 0 ? void 0 : _b.label) || 'command';
    }
}
exports.CommandChatResponseContentImpl = CommandChatResponseContentImpl;
class HorizontalLayoutChatResponseContentImpl {
    constructor(content = []) {
        this.kind = 'horizontal';
        this._content = content;
    }
    get content() {
        return this._content;
    }
    asString() {
        return this._content.map(child => child.asString && child.asString()).join(' ');
    }
    asDisplayString() {
        return this.asString();
    }
    merge(nextChatResponseContent) {
        if (HorizontalLayoutChatResponseContent.is(nextChatResponseContent)) {
            this._content.push(...nextChatResponseContent.content);
        }
        else {
            this._content.push(nextChatResponseContent);
        }
        return true;
    }
}
exports.HorizontalLayoutChatResponseContentImpl = HorizontalLayoutChatResponseContentImpl;
/**
 * Default implementation for the QuestionResponseContent.
 */
class QuestionResponseContentImpl {
    constructor(question, options, request, handler) {
        this.question = question;
        this.options = options;
        this.request = request;
        this.handler = handler;
        this.kind = 'question';
    }
    set selectedOption(option) {
        this._selectedOption = option;
        this.request.response.response.responseContentChanged();
    }
    get selectedOption() {
        return this._selectedOption;
    }
    asString() {
        var _a;
        return `Question: ${this.question}
${this.selectedOption ? `Answer: ${(_a = this.selectedOption) === null || _a === void 0 ? void 0 : _a.text}` : 'No answer'}`;
    }
    merge() {
        return false;
    }
}
exports.QuestionResponseContentImpl = QuestionResponseContentImpl;
class ChatResponseImpl {
    constructor() {
        this._onDidChangeEmitter = new core_1.Emitter();
        this.onDidChange = this._onDidChangeEmitter.event;
        // TODO accept serialized data as a parameter to restore a previously saved ChatResponse
        this._content = [];
    }
    get content() {
        return this._content;
    }
    clearContent() {
        this._content = [];
        this._updateResponseRepresentation();
        this._onDidChangeEmitter.fire();
    }
    addContents(contents) {
        contents.forEach(c => this.doAddContent(c));
        this._onDidChangeEmitter.fire();
    }
    addContent(nextContent) {
        // TODO: Support more complex merges affecting different content than the last, e.g. via some kind of ProcessorRegistry
        // TODO: Support more of the built-in VS Code behavior, see
        //   https://github.com/microsoft/vscode/blob/a2cab7255c0df424027be05d58e1b7b941f4ea60/src/vs/workbench/contrib/chat/common/chatModel.ts#L188-L244
        this.doAddContent(nextContent);
        this._onDidChangeEmitter.fire();
    }
    doAddContent(nextContent) {
        var _a;
        if (ToolCallChatResponseContent.is(nextContent) && nextContent.id !== undefined) {
            const fittingTool = this._content.find(c => ToolCallChatResponseContent.is(c) && c.id === nextContent.id);
            if (fittingTool !== undefined) {
                (_a = fittingTool.merge) === null || _a === void 0 ? void 0 : _a.call(fittingTool, nextContent);
            }
            else {
                this._content.push(nextContent);
            }
        }
        else {
            const lastElement = this._content.length > 0
                ? this._content[this._content.length - 1]
                : undefined;
            if ((lastElement === null || lastElement === void 0 ? void 0 : lastElement.kind) === nextContent.kind && ChatResponseContent.hasMerge(lastElement)) {
                const mergeSuccess = lastElement.merge(nextContent);
                if (!mergeSuccess) {
                    this._content.push(nextContent);
                }
            }
            else {
                this._content.push(nextContent);
            }
        }
        this._updateResponseRepresentation();
    }
    responseContentChanged() {
        this._updateResponseRepresentation();
        this._onDidChangeEmitter.fire();
    }
    _updateResponseRepresentation() {
        this._responseRepresentation = this.responseRepresentationsToString(this._content, 'asString');
        this._responseRepresentationForDisplay = this.responseRepresentationsToString(this.content, 'asDisplayString');
    }
    responseRepresentationsToString(content, collect) {
        return content
            .map(responseContent => {
            if (collect === 'asDisplayString') {
                if (ChatResponseContent.hasDisplayString(responseContent)) {
                    return responseContent.asDisplayString();
                }
            }
            if (ChatResponseContent.hasAsString(responseContent)) {
                return responseContent.asString();
            }
            if (TextChatResponseContent.is(responseContent)) {
                return responseContent.content;
            }
            console.warn('Was not able to map responseContent to a string', responseContent);
            return undefined;
        })
            .filter(text => (text !== undefined && text !== ''))
            .join('\n\n');
    }
    asString() {
        return this._responseRepresentation;
    }
    asDisplayString() {
        return this._responseRepresentationForDisplay;
    }
}
class MutableChatResponseModel {
    constructor(requestId, agentId) {
        this._onDidChangeEmitter = new core_1.Emitter();
        this.onDidChange = this._onDidChangeEmitter.event;
        this.data = {};
        // TODO accept serialized data as a parameter to restore a previously saved ChatResponseModel
        this._requestId = requestId;
        this._id = (0, core_1.generateUuid)();
        this._progressMessages = [];
        const response = new ChatResponseImpl();
        response.onDidChange(() => this._onDidChangeEmitter.fire());
        this._response = response;
        this._isComplete = false;
        this._isWaitingForInput = false;
        this._agentId = agentId;
        this._cancellationToken = new core_1.CancellationTokenSource();
    }
    get id() {
        return this._id;
    }
    get requestId() {
        return this._requestId;
    }
    get progressMessages() {
        return this._progressMessages;
    }
    addProgressMessage(message) {
        var _a, _b, _c;
        const id = (_a = message.id) !== null && _a !== void 0 ? _a : (0, core_1.generateUuid)();
        const existingMessage = this.getProgressMessage(id);
        if (existingMessage) {
            this.updateProgressMessage({ id, ...message });
            return existingMessage;
        }
        const newMessage = {
            kind: 'progressMessage',
            id,
            status: (_b = message.status) !== null && _b !== void 0 ? _b : 'inProgress',
            show: (_c = message.show) !== null && _c !== void 0 ? _c : 'untilFirstContent',
            ...message,
        };
        this._progressMessages.push(newMessage);
        this._onDidChangeEmitter.fire();
        return newMessage;
    }
    getProgressMessage(id) {
        return this._progressMessages.find(message => message.id === id);
    }
    updateProgressMessage(message) {
        const progressMessage = this.getProgressMessage(message.id);
        if (progressMessage) {
            Object.assign(progressMessage, message);
            this._onDidChangeEmitter.fire();
        }
    }
    get response() {
        return this._response;
    }
    get isComplete() {
        return this._isComplete;
    }
    get isCanceled() {
        return this._cancellationToken.token.isCancellationRequested;
    }
    get isWaitingForInput() {
        return this._isWaitingForInput;
    }
    get agentId() {
        return this._agentId;
    }
    overrideAgentId(agentId) {
        this._agentId = agentId;
    }
    complete() {
        this._isComplete = true;
        this._isWaitingForInput = false;
        this._onDidChangeEmitter.fire();
    }
    cancel() {
        this._cancellationToken.cancel();
        this._isComplete = true;
        this._isWaitingForInput = false;
        this._onDidChangeEmitter.fire();
    }
    get cancellationToken() {
        return this._cancellationToken.token;
    }
    waitForInput() {
        this._isWaitingForInput = true;
        this._onDidChangeEmitter.fire();
    }
    stopWaitingForInput() {
        this._isWaitingForInput = false;
        this._onDidChangeEmitter.fire();
    }
    error(error) {
        this._isComplete = true;
        this._isWaitingForInput = false;
        this._isError = true;
        this._errorObject = error;
        this._onDidChangeEmitter.fire();
    }
    get errorObject() {
        return this._errorObject;
    }
    get isError() {
        return this._isError;
    }
}
exports.MutableChatResponseModel = MutableChatResponseModel;
class ErrorChatResponseModel extends MutableChatResponseModel {
    constructor(requestId, error, agentId) {
        super(requestId, agentId);
        this.error(error);
    }
}
exports.ErrorChatResponseModel = ErrorChatResponseModel;
class ProgressChatResponseContentImpl {
    constructor(message) {
        this.kind = 'progress';
        this._message = message;
    }
    get message() {
        return this._message;
    }
    asString() {
        return JSON.stringify({
            type: 'progress',
            message: this.message
        });
    }
    asDisplayString() {
        return `<Progress>${this.message}</Progress>`;
    }
    merge(nextChatResponseContent) {
        this._message = nextChatResponseContent.message;
        return true;
    }
    toLanguageModelMessage() {
        return {
            actor: 'ai',
            type: 'text',
            text: this.message
        };
    }
}
exports.ProgressChatResponseContentImpl = ProgressChatResponseContentImpl;


/***/ }),

/***/ "../../node_modules/@theia/ai-chat/lib/common/chat-request-parser.js":
/*!***************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat/lib/common/chat-request-parser.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
// Partially copied from https://github.com/microsoft/vscode/blob/a2cab7255c0df424027be05d58e1b7b941f4ea60/src/vs/workbench/contrib/chat/common/chatRequestParser.ts
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChatRequestParserImpl = exports.ChatRequestParser = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const chat_agent_service_1 = __webpack_require__(/*! ./chat-agent-service */ "../../node_modules/@theia/ai-chat/lib/common/chat-agent-service.js");
const parsed_chat_request_1 = __webpack_require__(/*! ./parsed-chat-request */ "../../node_modules/@theia/ai-chat/lib/common/parsed-chat-request.js");
const ai_core_1 = __webpack_require__(/*! @theia/ai-core */ "../../node_modules/@theia/ai-core/lib/common/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const agentReg = /^@([\w_\-\.]+)(?=(\s|$|\b))/i; // An @-agent
const functionReg = /^~([\w_\-\.]+)(?=(\s|$|\b))/i; // A ~ tool function
const functionPromptFormatReg = /^\~\{\s*(.*?)\s*\}/i; // A ~{} prompt-format tool function
const variableReg = /^#([\w_\-]+)(?::([\w_\-_\/\\.:]+))?(?=(\s|$|\b))/i; // A #-variable with an optional : arg (#file:workspace/path/name.ext)
exports.ChatRequestParser = Symbol('ChatRequestParser');
function offsetRange(start, endExclusive) {
    if (start > endExclusive) {
        throw new Error(`Invalid range: start=${start} endExclusive=${endExclusive}`);
    }
    return { start, endExclusive };
}
let ChatRequestParserImpl = class ChatRequestParserImpl {
    constructor(agentService, variableService, toolInvocationRegistry, logger) {
        this.agentService = agentService;
        this.variableService = variableService;
        this.toolInvocationRegistry = toolInvocationRegistry;
        this.logger = logger;
    }
    async parseChatRequest(request, location, context) {
        // Parse the request into parts
        const { parts, toolRequests } = this.parseParts(request, location);
        // Resolve all variables and add them to the variable parts.
        // Parse resolved variable texts again for tool requests.
        // These are not added to parts as they are not visible in the initial chat message.
        // However, they need to be added to the result to be considered by the executing agent.
        const variableCache = (0, ai_core_1.createAIResolveVariableCache)();
        for (const part of parts) {
            if (part instanceof parsed_chat_request_1.ParsedChatRequestVariablePart) {
                const resolvedVariable = await this.variableService.resolveVariable({ variable: part.variableName, arg: part.variableArg }, context, variableCache);
                if (resolvedVariable) {
                    part.resolution = resolvedVariable;
                    // Resolve tool requests in resolved variables
                    this.parseFunctionsFromVariableText(resolvedVariable.value, toolRequests);
                }
                else {
                    this.logger.warn(`Failed to resolve variable ${part.variableName} for ${location}`);
                }
            }
        }
        // Get resolved variables from variable cache after all variables have been resolved.
        // We want to return all recursively resolved variables, thus use the whole cache.
        const resolvedVariables = await (0, ai_core_1.getAllResolvedAIVariables)(variableCache);
        return { request, parts, toolRequests, variables: resolvedVariables };
    }
    parseParts(request, location) {
        var _a, _b;
        const parts = [];
        const variables = new Map();
        const toolRequests = new Map();
        const message = request.text;
        for (let i = 0; i < message.length; i++) {
            const previousChar = message.charAt(i - 1);
            const char = message.charAt(i);
            let newPart;
            if (previousChar.match(/\s/) || i === 0) {
                if (char === parsed_chat_request_1.chatFunctionLeader) {
                    const functionPart = this.tryToParseFunction(message.slice(i), i);
                    newPart = functionPart;
                    if (functionPart) {
                        toolRequests.set(functionPart.toolRequest.id, functionPart.toolRequest);
                    }
                }
                else if (char === parsed_chat_request_1.chatVariableLeader) {
                    const variablePart = this.tryToParseVariable(message.slice(i), i, parts);
                    newPart = variablePart;
                    if (variablePart) {
                        const variable = this.variableService.getVariable(variablePart.variableName);
                        if (variable) {
                            variables.set(variable.name, variable);
                        }
                    }
                }
                else if (char === parsed_chat_request_1.chatAgentLeader) {
                    newPart = this.tryToParseAgent(message.slice(i), i, parts, location);
                }
            }
            if (newPart) {
                if (i !== 0) {
                    // Insert a part for all the text we passed over, then insert the new parsed part
                    const previousPart = parts.at(-1);
                    const previousPartEnd = (_a = previousPart === null || previousPart === void 0 ? void 0 : previousPart.range.endExclusive) !== null && _a !== void 0 ? _a : 0;
                    parts.push(new parsed_chat_request_1.ParsedChatRequestTextPart(offsetRange(previousPartEnd, i), message.slice(previousPartEnd, i)));
                }
                parts.push(newPart);
            }
        }
        const lastPart = parts.at(-1);
        const lastPartEnd = (_b = lastPart === null || lastPart === void 0 ? void 0 : lastPart.range.endExclusive) !== null && _b !== void 0 ? _b : 0;
        if (lastPartEnd < message.length) {
            parts.push(new parsed_chat_request_1.ParsedChatRequestTextPart(offsetRange(lastPartEnd, message.length), message.slice(lastPartEnd, message.length)));
        }
        return { parts, toolRequests, variables };
    }
    /**
     * Parse text for tool requests and add them to the given map
     */
    parseFunctionsFromVariableText(text, toolRequests) {
        for (let i = 0; i < text.length; i++) {
            const char = text.charAt(i);
            // Check for function markers at start of words
            if (char === parsed_chat_request_1.chatFunctionLeader) {
                const functionPart = this.tryToParseFunction(text.slice(i), i);
                if (functionPart) {
                    // Add the found tool request to the given map
                    toolRequests.set(functionPart.toolRequest.id, functionPart.toolRequest);
                }
            }
        }
    }
    tryToParseAgent(message, offset, parts, location) {
        const nextAgentMatch = message.match(agentReg);
        if (!nextAgentMatch) {
            return;
        }
        const [full, name] = nextAgentMatch;
        const agentRange = offsetRange(offset, offset + full.length);
        let agents = this.agentService.getAgents().filter(a => a.name === name);
        if (!agents.length) {
            const fqAgent = this.agentService.getAgent(name);
            if (fqAgent) {
                agents = [fqAgent];
            }
        }
        // If there is more than one agent with this name, and the user picked it from the suggest widget, then the selected agent should be in the
        // context and we use that one. Otherwise just pick the first.
        const agent = agents[0];
        if (!agent || !agent.locations.includes(location)) {
            return;
        }
        if (parts.some(p => p instanceof parsed_chat_request_1.ParsedChatRequestAgentPart)) {
            // Only one agent allowed
            return;
        }
        // The agent must come first
        if (parts.some(p => (p instanceof parsed_chat_request_1.ParsedChatRequestTextPart &&
            p.text.trim() !== '') ||
            !(p instanceof parsed_chat_request_1.ParsedChatRequestAgentPart))) {
            return;
        }
        return new parsed_chat_request_1.ParsedChatRequestAgentPart(agentRange, agent.id, agent.name);
    }
    tryToParseVariable(message, offset, _parts) {
        const nextVariableMatch = message.match(variableReg);
        if (!nextVariableMatch) {
            return;
        }
        const [full, name] = nextVariableMatch;
        const variableArg = nextVariableMatch[2];
        const varRange = offsetRange(offset, offset + full.length);
        return new parsed_chat_request_1.ParsedChatRequestVariablePart(varRange, name, variableArg);
    }
    tryToParseFunction(message, offset) {
        // Support both the and chat and prompt formats for functions
        const nextFunctionMatch = message.match(functionPromptFormatReg) || message.match(functionReg);
        if (!nextFunctionMatch) {
            return;
        }
        const [full, id] = nextFunctionMatch;
        const maybeToolRequest = this.toolInvocationRegistry.getFunction(id);
        if (!maybeToolRequest) {
            return;
        }
        const functionRange = offsetRange(offset, offset + full.length);
        return new parsed_chat_request_1.ParsedChatRequestFunctionPart(functionRange, maybeToolRequest);
    }
};
exports.ChatRequestParserImpl = ChatRequestParserImpl;
exports.ChatRequestParserImpl = ChatRequestParserImpl = tslib_1.__decorate([
    (0, inversify_1.injectable)(),
    tslib_1.__param(0, (0, inversify_1.inject)(chat_agent_service_1.ChatAgentService)),
    tslib_1.__param(1, (0, inversify_1.inject)(ai_core_1.AIVariableService)),
    tslib_1.__param(2, (0, inversify_1.inject)(ai_core_1.ToolInvocationRegistry)),
    tslib_1.__param(3, (0, inversify_1.inject)(core_1.ILogger)),
    tslib_1.__metadata("design:paramtypes", [Object, Object, Object, Object])
], ChatRequestParserImpl);


/***/ }),

/***/ "../../node_modules/@theia/ai-chat/lib/common/chat-service.js":
/*!********************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat/lib/common/chat-service.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
// Partially copied from https://github.com/microsoft/vscode/blob/a2cab7255c0df424027be05d58e1b7b941f4ea60/src/vs/workbench/contrib/chat/common/chatService.ts
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChatServiceImpl = exports.ChatService = exports.PinChatAgent = exports.FallbackChatAgentId = exports.DefaultChatAgentId = exports.isSessionDeletedEvent = exports.isSessionCreatedEvent = exports.isActiveSessionChangedEvent = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const ai_core_1 = __webpack_require__(/*! @theia/ai-core */ "../../node_modules/@theia/ai-core/lib/common/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const chat_agent_service_1 = __webpack_require__(/*! ./chat-agent-service */ "../../node_modules/@theia/ai-chat/lib/common/chat-agent-service.js");
const chat_agents_1 = __webpack_require__(/*! ./chat-agents */ "../../node_modules/@theia/ai-chat/lib/common/chat-agents.js");
const chat_model_1 = __webpack_require__(/*! ./chat-model */ "../../node_modules/@theia/ai-chat/lib/common/chat-model.js");
const chat_request_parser_1 = __webpack_require__(/*! ./chat-request-parser */ "../../node_modules/@theia/ai-chat/lib/common/chat-request-parser.js");
const parsed_chat_request_1 = __webpack_require__(/*! ./parsed-chat-request */ "../../node_modules/@theia/ai-chat/lib/common/parsed-chat-request.js");
const chat_session_naming_service_1 = __webpack_require__(/*! ./chat-session-naming-service */ "../../node_modules/@theia/ai-chat/lib/common/chat-session-naming-service.js");
const promise_util_1 = __webpack_require__(/*! @theia/core/lib/common/promise-util */ "../../node_modules/@theia/core/lib/common/promise-util.js");
function isActiveSessionChangedEvent(obj) {
    // eslint-disable-next-line no-null/no-null
    return typeof obj === 'object' && obj !== null && 'type' in obj && obj.type === 'activeChange';
}
exports.isActiveSessionChangedEvent = isActiveSessionChangedEvent;
function isSessionCreatedEvent(obj) {
    // eslint-disable-next-line no-null/no-null
    return typeof obj === 'object' && obj !== null && 'type' in obj && obj.type === 'created';
}
exports.isSessionCreatedEvent = isSessionCreatedEvent;
function isSessionDeletedEvent(obj) {
    // eslint-disable-next-line no-null/no-null
    return typeof obj === 'object' && obj !== null && 'type' in obj && obj.type === 'deleted';
}
exports.isSessionDeletedEvent = isSessionDeletedEvent;
/**
 * The default chat agent to invoke
 */
exports.DefaultChatAgentId = Symbol('DefaultChatAgentId');
/**
 * In case no fitting chat agent is available, this one will be used (if it is itself available)
 */
exports.FallbackChatAgentId = Symbol('FallbackChatAgentId');
exports.PinChatAgent = Symbol('PinChatAgent');
exports.ChatService = Symbol('ChatService');
let ChatServiceImpl = class ChatServiceImpl {
    constructor() {
        this.onSessionEventEmitter = new core_1.Emitter();
        this.onSessionEvent = this.onSessionEventEmitter.event;
        this._sessions = [];
    }
    getSessions() {
        return [...this._sessions];
    }
    getSession(id) {
        return this._sessions.find(session => session.id === id);
    }
    createSession(location = chat_agents_1.ChatAgentLocation.Panel, options, pinnedAgent) {
        const model = new chat_model_1.MutableChatModel(location);
        const session = {
            id: model.id,
            model,
            isActive: true,
            pinnedAgent
        };
        this._sessions.push(session);
        this.setActiveSession(session.id, options);
        this.onSessionEventEmitter.fire({ type: 'created', sessionId: session.id });
        return session;
    }
    deleteSession(sessionId) {
        var _a;
        const sessionIndex = this._sessions.findIndex(candidate => candidate.id === sessionId);
        if (sessionIndex === -1) {
            return;
        }
        const session = this._sessions[sessionIndex];
        // If the removed session is the active one, set the newest one as active
        if (session.isActive) {
            this.setActiveSession((_a = this._sessions[this._sessions.length - 1]) === null || _a === void 0 ? void 0 : _a.id);
        }
        session.model.dispose();
        this._sessions.splice(sessionIndex, 1);
        this.onSessionEventEmitter.fire({ type: 'deleted', sessionId: sessionId });
    }
    getActiveSession() {
        const activeSessions = this._sessions.filter(candidate => candidate.isActive);
        if (activeSessions.length > 1) {
            throw new Error('More than one session marked as active. This indicates an error in ChatService.');
        }
        return activeSessions.at(0);
    }
    setActiveSession(sessionId, options) {
        this._sessions.forEach(session => {
            session.isActive = session.id === sessionId;
        });
        this.onSessionEventEmitter.fire({ type: 'activeChange', sessionId: sessionId, ...options });
    }
    async sendRequest(sessionId, request) {
        var _a;
        const session = this.getSession(sessionId);
        if (!session) {
            return undefined;
        }
        const resolutionContext = { model: session.model };
        const resolvedContext = await this.resolveChatContext((_a = request.variables) !== null && _a !== void 0 ? _a : session.model.context.getVariables(), resolutionContext);
        const parsedRequest = await this.chatRequestParser.parseChatRequest(request, session.model.location, resolvedContext);
        const agent = this.getAgent(parsedRequest, session);
        if (agent === undefined) {
            const error = 'No ChatAgents available to handle request!';
            this.logger.error(error);
            const chatResponseModel = new chat_model_1.ErrorChatResponseModel((0, core_1.generateUuid)(), new Error(error));
            return {
                requestCompleted: Promise.reject(error),
                responseCreated: Promise.reject(error),
                responseCompleted: Promise.resolve(chatResponseModel),
            };
        }
        const requestModel = session.model.addRequest(parsedRequest, agent === null || agent === void 0 ? void 0 : agent.id, resolvedContext);
        this.updateSessionMetadata(session, requestModel);
        resolutionContext.request = requestModel;
        const responseCompletionDeferred = new promise_util_1.Deferred();
        const invocation = {
            requestCompleted: Promise.resolve(requestModel),
            responseCreated: Promise.resolve(requestModel.response),
            responseCompleted: responseCompletionDeferred.promise,
        };
        requestModel.response.onDidChange(() => {
            if (requestModel.response.isComplete) {
                responseCompletionDeferred.resolve(requestModel.response);
            }
            if (requestModel.response.isError) {
                responseCompletionDeferred.resolve(requestModel.response);
            }
        });
        agent.invoke(requestModel).catch(error => requestModel.response.error(error));
        return invocation;
    }
    updateSessionMetadata(session, request) {
        var _a;
        session.lastInteraction = new Date();
        if (session.title) {
            return;
        }
        const requestText = (_a = request.request.displayText) !== null && _a !== void 0 ? _a : request.request.text;
        session.title = requestText;
        if (this.chatSessionNamingService) {
            const otherSessionNames = this._sessions.map(s => s.title).filter((title) => title !== undefined);
            const namingService = this.chatSessionNamingService;
            let didGenerateName = false;
            request.response.onDidChange(() => {
                if (request.response.isComplete && !didGenerateName) {
                    namingService.generateChatSessionName(session, otherSessionNames).then(name => {
                        if (name && session.title === requestText) {
                            session.title = name;
                        }
                        didGenerateName = true;
                    }).catch(error => this.logger.error('Failed to generate chat session name', error));
                }
            });
        }
    }
    async resolveChatContext(resolutionRequests, context) {
        // TODO use a common cache to resolve variables and return recursively resolved variables?
        const resolvedVariables = await Promise.all(resolutionRequests.map(async (contextVariable) => this.variableService.resolveVariable(contextVariable, context)))
            .then(results => results.filter(ai_core_1.ResolvedAIContextVariable.is));
        return { variables: resolvedVariables };
    }
    async cancelRequest(sessionId, requestId) {
        var _a, _b;
        return (_b = (_a = this.getSession(sessionId)) === null || _a === void 0 ? void 0 : _a.model.getRequest(requestId)) === null || _b === void 0 ? void 0 : _b.response.cancel();
    }
    getAgent(parsedRequest, session) {
        var _a;
        let agent = this.initialAgentSelection(parsedRequest);
        if (this.pinChatAgent === false) {
            return agent;
        }
        if (!session.pinnedAgent && agent && agent.id !== ((_a = this.defaultChatAgentId) === null || _a === void 0 ? void 0 : _a.id)) {
            session.pinnedAgent = agent;
        }
        else if (session.pinnedAgent && this.getMentionedAgent(parsedRequest) === undefined) {
            agent = session.pinnedAgent;
        }
        return agent;
    }
    initialAgentSelection(parsedRequest) {
        var _a;
        const agentPart = this.getMentionedAgent(parsedRequest);
        if (agentPart) {
            return this.chatAgentService.getAgent(agentPart.agentId);
        }
        let chatAgent = undefined;
        if (this.defaultChatAgentId) {
            chatAgent = this.chatAgentService.getAgent(this.defaultChatAgentId.id);
        }
        if (!chatAgent && this.fallbackChatAgentId) {
            chatAgent = this.chatAgentService.getAgent(this.fallbackChatAgentId.id);
        }
        if (chatAgent) {
            return chatAgent;
        }
        this.logger.warn('Neither the default chat agent nor the fallback chat agent are configured or available. Falling back to the first registered agent');
        return (_a = this.chatAgentService.getAgents()[0]) !== null && _a !== void 0 ? _a : undefined;
    }
    getMentionedAgent(parsedRequest) {
        return parsedRequest.parts.find(p => p instanceof parsed_chat_request_1.ParsedChatRequestAgentPart);
    }
    deleteChangeSet(sessionId) {
        var _a;
        (_a = this.getSession(sessionId)) === null || _a === void 0 ? void 0 : _a.model.removeChangeSet();
    }
    deleteChangeSetElement(sessionId, index) {
        var _a, _b, _c, _d;
        (_b = (_a = this.getSession(sessionId)) === null || _a === void 0 ? void 0 : _a.model.changeSet) === null || _b === void 0 ? void 0 : _b.removeElements(index);
        const elements = (_d = (_c = this.getSession(sessionId)) === null || _c === void 0 ? void 0 : _c.model.changeSet) === null || _d === void 0 ? void 0 : _d.getElements();
        if ((elements === null || elements === void 0 ? void 0 : elements.length) === 0) {
            this.deleteChangeSet(sessionId);
        }
    }
};
exports.ChatServiceImpl = ChatServiceImpl;
tslib_1.__decorate([
    (0, inversify_1.inject)(chat_agent_service_1.ChatAgentService),
    tslib_1.__metadata("design:type", Object)
], ChatServiceImpl.prototype, "chatAgentService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(exports.DefaultChatAgentId),
    (0, inversify_1.optional)(),
    tslib_1.__metadata("design:type", Object)
], ChatServiceImpl.prototype, "defaultChatAgentId", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(exports.FallbackChatAgentId),
    (0, inversify_1.optional)(),
    tslib_1.__metadata("design:type", Object)
], ChatServiceImpl.prototype, "fallbackChatAgentId", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(chat_session_naming_service_1.ChatSessionNamingService),
    (0, inversify_1.optional)(),
    tslib_1.__metadata("design:type", Object)
], ChatServiceImpl.prototype, "chatSessionNamingService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(exports.PinChatAgent),
    (0, inversify_1.optional)(),
    tslib_1.__metadata("design:type", Object)
], ChatServiceImpl.prototype, "pinChatAgent", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(chat_request_parser_1.ChatRequestParser),
    tslib_1.__metadata("design:type", Object)
], ChatServiceImpl.prototype, "chatRequestParser", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(ai_core_1.AIVariableService),
    tslib_1.__metadata("design:type", Object)
], ChatServiceImpl.prototype, "variableService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.ILogger),
    tslib_1.__metadata("design:type", Object)
], ChatServiceImpl.prototype, "logger", void 0);
exports.ChatServiceImpl = ChatServiceImpl = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ChatServiceImpl);


/***/ }),

/***/ "../../node_modules/@theia/ai-chat/lib/common/chat-session-naming-service.js":
/*!***********************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat/lib/common/chat-session-naming-service.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var ChatSessionNamingAgent_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChatSessionNamingAgent = exports.ChatSessionNamingService = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const ai_core_1 = __webpack_require__(/*! @theia/ai-core */ "../../node_modules/@theia/ai-core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const CHAT_SESSION_NAMING_PROMPT = {
    id: 'chat-session-naming-prompt',
    template: '{{!-- Made improvements or adaptations to this prompt template? We\'d love for you to share it with the community! Contribute back here: ' +
        'https://github.com/eclipse-theia/theia/discussions/new?category=prompt-template-contribution --}}\n\n' +
        'Provide a short and descriptive name for the given AI chat conversation of an AI-powered tool based on the conversation below.\n\n' +
        'The purpose of the name is for users to recognize the chat conversation easily in a list of conversations. ' +
        'Use the same language for the chat conversation name as used in the provided conversation, if in doubt default to English. ' +
        'Start the chat conversation name with an upper-case letter. ' +
        'Below we also provide the already existing other conversation names, make sure your suggestion for a name is unique with respect to the existing ones.\n\n' +
        'IMPORTANT: Your answer MUST ONLY CONTAIN THE PROPOSED NAME and must not be preceded or followed by any other text.' +
        '\n\nOther session names:\n{{listOfSessionNames}}' +
        '\n\nConversation:\n{{conversation}}',
};
let ChatSessionNamingService = class ChatSessionNamingService {
    async generateChatSessionName(chatSession, otherNames) {
        const chatSessionNamingAgent = this.agentService.getAgents().find(agent => ChatSessionNamingAgent.ID === agent.id);
        if (!(chatSessionNamingAgent instanceof ChatSessionNamingAgent)) {
            return undefined;
        }
        return chatSessionNamingAgent.generateChatSessionName(chatSession, otherNames);
    }
};
exports.ChatSessionNamingService = ChatSessionNamingService;
tslib_1.__decorate([
    (0, inversify_1.inject)(ai_core_1.AgentService),
    tslib_1.__metadata("design:type", Object)
], ChatSessionNamingService.prototype, "agentService", void 0);
exports.ChatSessionNamingService = ChatSessionNamingService = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ChatSessionNamingService);
let ChatSessionNamingAgent = ChatSessionNamingAgent_1 = class ChatSessionNamingAgent {
    constructor() {
        this.id = ChatSessionNamingAgent_1.ID;
        this.name = 'Chat Session Naming';
        this.description = 'Agent for generating chat session names';
        this.variables = [];
        this.promptTemplates = [CHAT_SESSION_NAMING_PROMPT];
        this.languageModelRequirements = [{
                purpose: 'chat-session-naming',
                identifier: 'openai/gpt-4o-mini',
            }];
        this.agentSpecificVariables = [
            { name: 'conversation', usedInPrompt: true, description: 'The content of the chat conversation.' },
            { name: 'listOfSessionNames', usedInPrompt: true, description: 'The list of existing session names.' }
        ];
        this.functions = [];
    }
    async generateChatSessionName(chatSession, otherNames) {
        const lm = await this.lmRegistry.selectLanguageModel({ agent: this.id, ...this.languageModelRequirements[0] });
        if (!lm) {
            throw new Error('No language model found for chat session naming');
        }
        if (chatSession.model.getRequests().length < 1) {
            throw new Error('No chat request available to generate chat session name');
        }
        const conversation = chatSession.model.getRequests()
            .map(req => `<user>${req.message.parts.map(chunk => chunk.promptText).join('')}</user>` +
            (req.response.response ? `<assistant>${req.response.response.asString()}</assistant>` : ''))
            .join('\n\n');
        const listOfSessionNames = otherNames.map(name => name).join(', ');
        const prompt = await this.promptService.getPrompt(CHAT_SESSION_NAMING_PROMPT.id, { conversation, listOfSessionNames });
        const message = prompt === null || prompt === void 0 ? void 0 : prompt.text;
        if (!message) {
            throw new Error('Unable to create prompt message for generating chat session name');
        }
        const sessionId = (0, core_1.generateUuid)();
        const requestId = (0, core_1.generateUuid)();
        const request = {
            messages: [{
                    actor: 'user',
                    text: message,
                    type: 'text'
                }],
            requestId,
            sessionId,
            agentId: this.id
        };
        this.recordingService.recordRequest({ ...request, request: request.messages });
        const result = await lm.request(request);
        const response = await (0, ai_core_1.getTextOfResponse)(result);
        this.recordingService.recordResponse({
            agentId: this.id,
            sessionId,
            requestId,
            response: [{ actor: 'ai', text: response, type: 'text' }]
        });
        return response.replace(/\s+/g, ' ').substring(0, 100);
    }
};
exports.ChatSessionNamingAgent = ChatSessionNamingAgent;
ChatSessionNamingAgent.ID = 'chat-session-naming-agent';
tslib_1.__decorate([
    (0, inversify_1.inject)(ai_core_1.LanguageModelRegistry),
    tslib_1.__metadata("design:type", Object)
], ChatSessionNamingAgent.prototype, "lmRegistry", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(ai_core_1.CommunicationRecordingService),
    tslib_1.__metadata("design:type", Object)
], ChatSessionNamingAgent.prototype, "recordingService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(ai_core_1.PromptService),
    tslib_1.__metadata("design:type", Object)
], ChatSessionNamingAgent.prototype, "promptService", void 0);
exports.ChatSessionNamingAgent = ChatSessionNamingAgent = ChatSessionNamingAgent_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ChatSessionNamingAgent);


/***/ }),

/***/ "../../node_modules/@theia/ai-chat/lib/common/chat-tool-request-service.js":
/*!*********************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat/lib/common/chat-tool-request-service.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChatToolRequestService = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
/**
 * Wraps tool requests in a chat context.
 *
 * This service extracts tool requests from a given chat request model and wraps their
 * handler functions to provide additional context, such as the chat request model.
 */
let ChatToolRequestService = class ChatToolRequestService {
    getChatToolRequests(request) {
        const toolRequests = request.message.toolRequests.size > 0 ? [...request.message.toolRequests.values()] : undefined;
        if (!toolRequests) {
            return [];
        }
        return this.toChatToolRequests(toolRequests, request);
    }
    toChatToolRequests(toolRequests, request) {
        if (!toolRequests) {
            return [];
        }
        return toolRequests.map(toolRequest => this.toChatToolRequest(toolRequest, request));
    }
    toChatToolRequest(toolRequest, request) {
        return {
            ...toolRequest,
            handler: async (arg_string) => toolRequest.handler(arg_string, request)
        };
    }
};
exports.ChatToolRequestService = ChatToolRequestService;
exports.ChatToolRequestService = ChatToolRequestService = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ChatToolRequestService);


/***/ }),

/***/ "../../node_modules/@theia/ai-chat/lib/common/context-variables.js":
/*!*************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat/lib/common/context-variables.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CHANGE_SET_SUMMARY_VARIABLE_ID = exports.CHAT_CONTEXT_DETAILS_VARIABLE_ID = exports.CHAT_CONTEXT_VARIABLE_ID = void 0;
exports.CHAT_CONTEXT_VARIABLE_ID = 'contextSummary';
exports.CHAT_CONTEXT_DETAILS_VARIABLE_ID = 'contextDetails';
exports.CHANGE_SET_SUMMARY_VARIABLE_ID = 'changeSetSummary';


/***/ }),

/***/ "../../node_modules/@theia/ai-chat/lib/common/custom-chat-agent.js":
/*!*************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat/lib/common/custom-chat-agent.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CustomChatAgent = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const chat_agents_1 = __webpack_require__(/*! ./chat-agents */ "../../node_modules/@theia/ai-chat/lib/common/chat-agents.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
let CustomChatAgent = class CustomChatAgent extends chat_agents_1.AbstractStreamParsingChatAgent {
    constructor() {
        super(...arguments);
        this.id = 'CustomChatAgent';
        this.name = 'CustomChatAgent';
        this.languageModelRequirements = [{ purpose: 'chat' }];
        this.defaultLanguageModelPurpose = 'chat';
    }
    set prompt(prompt) {
        // the name is dynamic, so we set the propmptId here
        this.systemPromptId = `${this.name}_prompt`;
        this.promptTemplates.push({ id: `${this.name}_prompt`, template: prompt });
    }
};
exports.CustomChatAgent = CustomChatAgent;
exports.CustomChatAgent = CustomChatAgent = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], CustomChatAgent);


/***/ }),

/***/ "../../node_modules/@theia/ai-chat/lib/common/index.js":
/*!*************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat/lib/common/index.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
tslib_1.__exportStar(__webpack_require__(/*! ./chat-agents */ "../../node_modules/@theia/ai-chat/lib/common/chat-agents.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./chat-agent-service */ "../../node_modules/@theia/ai-chat/lib/common/chat-agent-service.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./chat-model */ "../../node_modules/@theia/ai-chat/lib/common/chat-model.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./chat-model-util */ "../../node_modules/@theia/ai-chat/lib/common/chat-model-util.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./chat-request-parser */ "../../node_modules/@theia/ai-chat/lib/common/chat-request-parser.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./chat-service */ "../../node_modules/@theia/ai-chat/lib/common/chat-service.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./custom-chat-agent */ "../../node_modules/@theia/ai-chat/lib/common/custom-chat-agent.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./parsed-chat-request */ "../../node_modules/@theia/ai-chat/lib/common/parsed-chat-request.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./context-variables */ "../../node_modules/@theia/ai-chat/lib/common/context-variables.js"), exports);


/***/ }),

/***/ "../../node_modules/@theia/ai-chat/lib/common/parse-contents.js":
/*!**********************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat/lib/common/parse-contents.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.findFirstMatch = exports.parseContents = void 0;
const response_content_matcher_1 = __webpack_require__(/*! ./response-content-matcher */ "../../node_modules/@theia/ai-chat/lib/common/response-content-matcher.js");
function parseContents(text, request, contentMatchers = [response_content_matcher_1.CodeContentMatcher], defaultContentFactory = response_content_matcher_1.MarkdownContentFactory) {
    const result = [];
    let currentIndex = 0;
    while (currentIndex < text.length) {
        const remainingText = text.substring(currentIndex);
        const match = findFirstMatch(contentMatchers, remainingText);
        if (!match) {
            // Add the remaining text as default content
            if (remainingText.length > 0) {
                result.push(defaultContentFactory(remainingText, request));
            }
            break;
        }
        // We have a match
        // 1. Add preceding text as default content
        if (match.index > 0) {
            const precedingContent = remainingText.substring(0, match.index);
            if (precedingContent.trim().length > 0) {
                result.push(defaultContentFactory(precedingContent, request));
            }
        }
        // 2. Add the matched content object
        if (match.isComplete) {
            // Complete match, use regular content factory
            result.push(match.matcher.contentFactory(match.content, request));
        }
        else if (match.matcher.incompleteContentFactory) {
            // Incomplete match with an incomplete content factory available
            result.push(match.matcher.incompleteContentFactory(match.content, request));
        }
        else {
            // Incomplete match but no incomplete content factory available, use default
            result.push(defaultContentFactory(match.content, request));
        }
        // Update currentIndex to the end of the end of the match
        // And continue with the search after the end of the match
        currentIndex += match.index + match.content.length;
    }
    return result;
}
exports.parseContents = parseContents;
function findFirstMatch(contentMatchers, text) {
    let firstMatch;
    let firstIncompleteMatch;
    for (const matcher of contentMatchers) {
        const startMatch = matcher.start.exec(text);
        if (!startMatch) {
            // No start match found, try next matcher.
            continue;
        }
        const endOfStartMatch = startMatch.index + startMatch[0].length;
        if (endOfStartMatch >= text.length) {
            // There is no text after the start match.
            // This is an incomplete match if the matcher has an incompleteContentFactory
            if (matcher.incompleteContentFactory) {
                const incompleteMatch = {
                    matcher,
                    index: startMatch.index,
                    content: text.substring(startMatch.index),
                    isComplete: false
                };
                if (!firstIncompleteMatch || incompleteMatch.index < firstIncompleteMatch.index) {
                    firstIncompleteMatch = incompleteMatch;
                }
            }
            continue;
        }
        const remainingTextAfterStartMatch = text.substring(endOfStartMatch);
        const endMatch = matcher.end.exec(remainingTextAfterStartMatch);
        if (!endMatch) {
            // No end match found, this is an incomplete match
            if (matcher.incompleteContentFactory) {
                const incompleteMatch = {
                    matcher,
                    index: startMatch.index,
                    content: text.substring(startMatch.index),
                    isComplete: false
                };
                if (!firstIncompleteMatch || incompleteMatch.index < firstIncompleteMatch.index) {
                    firstIncompleteMatch = incompleteMatch;
                }
            }
            continue;
        }
        // Found start and end match.
        // Record the full match, if it is the earliest found so far.
        const index = startMatch.index;
        const contentEnd = index + startMatch[0].length + endMatch.index + endMatch[0].length;
        const content = text.substring(index, contentEnd);
        const completeMatch = { matcher, index, content, isComplete: true };
        if (!firstMatch || index < firstMatch.index) {
            firstMatch = completeMatch;
        }
    }
    // If we found a complete match, return it
    if (firstMatch) {
        return firstMatch;
    }
    // Otherwise, return the first incomplete match if one exists
    return firstIncompleteMatch;
}
exports.findFirstMatch = findFirstMatch;


/***/ }),

/***/ "../../node_modules/@theia/ai-chat/lib/common/parsed-chat-request.js":
/*!***************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat/lib/common/parsed-chat-request.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
// Partially copied from https://github.com/microsoft/vscode/blob/a2cab7255c0df424027be05d58e1b7b941f4ea60/src/vs/workbench/contrib/chat/common/chatParserTypes.ts
// Partially copied from https://github.com/microsoft/vscode/blob/a2cab7255c0df424027be05d58e1b7b941f4ea60/src/vs/editor/common/core/offsetRange.ts
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ParsedChatRequestAgentPart = exports.ParsedChatRequestFunctionPart = exports.ParsedChatRequestVariablePart = exports.ParsedChatRequestTextPart = exports.chatSubcommandLeader = exports.chatFunctionLeader = exports.chatAgentLeader = exports.chatVariableLeader = void 0;
const ai_core_1 = __webpack_require__(/*! @theia/ai-core */ "../../node_modules/@theia/ai-core/lib/common/index.js");
exports.chatVariableLeader = '#';
exports.chatAgentLeader = '@';
exports.chatFunctionLeader = '~';
exports.chatSubcommandLeader = '/';
class ParsedChatRequestTextPart {
    constructor(range, text) {
        this.range = range;
        this.text = text;
    }
    get promptText() {
        return this.text;
    }
}
exports.ParsedChatRequestTextPart = ParsedChatRequestTextPart;
class ParsedChatRequestVariablePart {
    constructor(range, variableName, variableArg) {
        this.range = range;
        this.variableName = variableName;
        this.variableArg = variableArg;
    }
    get text() {
        const argPart = this.variableArg ? `:${this.variableArg}` : '';
        return `${exports.chatVariableLeader}${this.variableName}${argPart}`;
    }
    get promptText() {
        var _a, _b;
        return (_b = (_a = this.resolution) === null || _a === void 0 ? void 0 : _a.value) !== null && _b !== void 0 ? _b : this.text;
    }
}
exports.ParsedChatRequestVariablePart = ParsedChatRequestVariablePart;
class ParsedChatRequestFunctionPart {
    constructor(range, toolRequest) {
        this.range = range;
        this.toolRequest = toolRequest;
    }
    get text() {
        return `${exports.chatFunctionLeader}${this.toolRequest.id}`;
    }
    get promptText() {
        return (0, ai_core_1.toolRequestToPromptText)(this.toolRequest);
    }
}
exports.ParsedChatRequestFunctionPart = ParsedChatRequestFunctionPart;
class ParsedChatRequestAgentPart {
    constructor(range, agentId, agentName) {
        this.range = range;
        this.agentId = agentId;
        this.agentName = agentName;
    }
    get text() {
        return `${exports.chatAgentLeader}${this.agentName}`;
    }
    get promptText() {
        return '';
    }
}
exports.ParsedChatRequestAgentPart = ParsedChatRequestAgentPart;


/***/ }),

/***/ "../../node_modules/@theia/ai-chat/lib/common/response-content-matcher.js":
/*!********************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat/lib/common/response-content-matcher.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DefaultResponseContentMatcherProvider = exports.ResponseContentMatcherProvider = exports.CodeContentMatcher = exports.DefaultResponseContentFactory = exports.MarkdownContentFactory = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
/*
 * Copyright (C) 2024 EclipseSource GmbH.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
 */
const chat_model_1 = __webpack_require__(/*! ./chat-model */ "../../node_modules/@theia/ai-chat/lib/common/chat-model.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const MarkdownContentFactory = (content, request) => new chat_model_1.MarkdownChatResponseContentImpl(content);
exports.MarkdownContentFactory = MarkdownContentFactory;
/**
 * Default response content factory used if no other `ResponseContentMatcher` applies.
 * By default, this factory creates a markdown content object.
 *
 * @see MarkdownChatResponseContentImpl
 */
let DefaultResponseContentFactory = class DefaultResponseContentFactory {
    create(content, request) {
        return (0, exports.MarkdownContentFactory)(content, request);
    }
};
exports.DefaultResponseContentFactory = DefaultResponseContentFactory;
exports.DefaultResponseContentFactory = DefaultResponseContentFactory = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], DefaultResponseContentFactory);
exports.CodeContentMatcher = {
    // Only match when we have the complete first line ending with a newline
    // This ensures we have the full language specification before creating the editor
    start: /^```.*\n/m,
    end: /^```$/m,
    contentFactory: (content, request) => {
        var _a;
        const language = ((_a = content.match(/^```(\w+)/)) === null || _a === void 0 ? void 0 : _a[1]) || '';
        const code = content.replace(/^```(\w+)\n|```$/g, '');
        return new chat_model_1.CodeChatResponseContentImpl(code.trim(), language);
    },
    incompleteContentFactory: (content, request) => {
        var _a;
        // By this point, we know we have at least the complete first line with ```
        const firstLine = content.split('\n')[0];
        const language = ((_a = firstLine.match(/^```(\w+)/)) === null || _a === void 0 ? void 0 : _a[1]) || '';
        // Remove the first line to get just the code content
        const code = content.substring(content.indexOf('\n') + 1);
        return new chat_model_1.CodeChatResponseContentImpl(code.trim(), language);
    }
};
/**
 * Clients can contribute response content matchers to parse the response content.
 *
 * The default chat user interface will collect all contributed matchers and use them
 * to parse the response into structured content parts (e.g. code blocks, markdown blocks),
 * which are then rendered with a `ChatResponsePartRenderer` registered for the respective
 * content part type.
 *
 * ### Example
 * ```ts
 * bind(ResponseContentMatcherProvider).to(MyResponseContentMatcherProvider);
 * ...
 * @injectable()
 * export class MyResponseContentMatcherProvider implements ResponseContentMatcherProvider {
 *     readonly matchers: ResponseContentMatcher[] = [{
 *       start: /^<command>$/m,
 *       end: /^</command>$/m,
 *       contentFactory: (content: string) => {
 *         const command = content.replace(/^<command>\n|<\/command>$/g, '');
 *         return new MyChatResponseContentImpl(command.trim());
 *       }
 *   }];
 * }
 * ```
 *
 * @see ResponseContentMatcher
 */
exports.ResponseContentMatcherProvider = Symbol('ResponseContentMatcherProvider');
let DefaultResponseContentMatcherProvider = class DefaultResponseContentMatcherProvider {
    constructor() {
        this.matchers = [exports.CodeContentMatcher];
    }
};
exports.DefaultResponseContentMatcherProvider = DefaultResponseContentMatcherProvider;
exports.DefaultResponseContentMatcherProvider = DefaultResponseContentMatcherProvider = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], DefaultResponseContentMatcherProvider);


/***/ }),

/***/ "../../node_modules/@theia/ai-core/lib/browser/ai-view-contribution.js":
/*!*****************************************************************************!*\
  !*** ../../node_modules/@theia/ai-core/lib/browser/ai-view-contribution.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AIViewContribution = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const ai_activation_service_1 = __webpack_require__(/*! ./ai-activation-service */ "../../node_modules/@theia/ai-core/lib/browser/ai-activation-service.js");
const ai_command_handler_factory_1 = __webpack_require__(/*! ./ai-command-handler-factory */ "../../node_modules/@theia/ai-core/lib/browser/ai-command-handler-factory.js");
let AIViewContribution = class AIViewContribution extends browser_1.AbstractViewContribution {
    init() {
        this.activationService.onDidChangeActiveStatus(active => {
            if (!active) {
                this.closeView();
            }
        });
    }
    registerCommands(commands) {
        var _a;
        if (this.toggleCommand) {
            commands.registerCommand(this.toggleCommand, this.commandHandlerFactory({
                execute: () => this.toggleView(),
            }));
        }
        (_a = this.quickView) === null || _a === void 0 ? void 0 : _a.registerItem({
            label: this.viewLabel,
            when: ai_activation_service_1.ENABLE_AI_CONTEXT_KEY,
            open: () => this.openView({ activate: true })
        });
    }
    registerMenus(menus) {
        if (this.toggleCommand) {
            menus.registerMenuAction(browser_1.CommonMenus.VIEW_VIEWS, {
                commandId: this.toggleCommand.id,
                when: ai_activation_service_1.ENABLE_AI_CONTEXT_KEY,
                label: this.viewLabel
            });
        }
    }
    registerKeybindings(keybindings) {
        if (this.toggleCommand && this.options.toggleKeybinding) {
            keybindings.registerKeybinding({
                command: this.toggleCommand.id,
                when: ai_activation_service_1.ENABLE_AI_CONTEXT_KEY,
                keybinding: this.options.toggleKeybinding
            });
        }
    }
};
exports.AIViewContribution = AIViewContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.PreferenceService),
    tslib_1.__metadata("design:type", Object)
], AIViewContribution.prototype, "preferenceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(ai_activation_service_1.AIActivationService),
    tslib_1.__metadata("design:type", ai_activation_service_1.AIActivationService)
], AIViewContribution.prototype, "activationService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(ai_command_handler_factory_1.AICommandHandlerFactory),
    tslib_1.__metadata("design:type", Function)
], AIViewContribution.prototype, "commandHandlerFactory", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], AIViewContribution.prototype, "init", null);
exports.AIViewContribution = AIViewContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], AIViewContribution);


/***/ }),

/***/ "../../node_modules/@theia/ai-core/lib/browser/index.js":
/*!**************************************************************!*\
  !*** ../../node_modules/@theia/ai-core/lib/browser/index.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
tslib_1.__exportStar(__webpack_require__(/*! ./ai-activation-service */ "../../node_modules/@theia/ai-core/lib/browser/ai-activation-service.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./ai-core-frontend-application-contribution */ "../../node_modules/@theia/ai-core/lib/browser/ai-core-frontend-application-contribution.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./ai-core-frontend-module */ "../../node_modules/@theia/ai-core/lib/browser/ai-core-frontend-module.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./ai-core-preferences */ "../../node_modules/@theia/ai-core/lib/browser/ai-core-preferences.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./ai-settings-service */ "../../node_modules/@theia/ai-core/lib/browser/ai-settings-service.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./ai-view-contribution */ "../../node_modules/@theia/ai-core/lib/browser/ai-view-contribution.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./frontend-language-model-registry */ "../../node_modules/@theia/ai-core/lib/browser/frontend-language-model-registry.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./frontend-variable-service */ "../../node_modules/@theia/ai-core/lib/browser/frontend-variable-service.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./prompttemplate-contribution */ "../../node_modules/@theia/ai-core/lib/browser/prompttemplate-contribution.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./theia-variable-contribution */ "../../node_modules/@theia/ai-core/lib/browser/theia-variable-contribution.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./frontend-variable-service */ "../../node_modules/@theia/ai-core/lib/browser/frontend-variable-service.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./ai-core-command-contribution */ "../../node_modules/@theia/ai-core/lib/browser/ai-core-command-contribution.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ../common/language-model-service */ "../../node_modules/@theia/ai-core/lib/common/language-model-service.js"), exports);


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_ai-chat_lib_browser_ai-chat-frontend-contribution_js-node_modules_-4d79fd.js.map