"use strict";
(self["webpackChunkcdt_cloud_blueprint_app"] = self["webpackChunkcdt_cloud_blueprint_app"] || []).push([["vendors-node_modules_theia_filesystem_lib_electron-browser_file-dialog_electron-file-dialog-s-8b3e2f"],{

/***/ "../../node_modules/@theia/core/lib/common/file-uri.js":
/*!*************************************************************!*\
  !*** ../../node_modules/@theia/core/lib/common/file-uri.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2017 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FileUri = void 0;
const vscode_uri_1 = __webpack_require__(/*! vscode-uri */ "../../node_modules/vscode-uri/lib/esm/index.js");
const uri_1 = __webpack_require__(/*! ./uri */ "../../node_modules/@theia/core/lib/common/uri.js");
const os_1 = __webpack_require__(/*! ./os */ "../../node_modules/@theia/core/lib/common/os.js");
var FileUri;
(function (FileUri) {
    const windowsDriveRegex = /^([^:/?#]+?):$/;
    /**
     * Creates a new file URI from the filesystem path argument.
     * @param fsPath the filesystem path.
     */
    function create(fsPath_) {
        return new uri_1.default(vscode_uri_1.URI.file(fsPath_));
    }
    FileUri.create = create;
    /**
     * Returns with the platform specific FS path that is represented by the URI argument.
     *
     * @param uri the file URI that has to be resolved to a platform specific FS path.
     */
    function fsPath(uri) {
        if (typeof uri === 'string') {
            return fsPath(new uri_1.default(uri));
        }
        else {
            /*
             * A uri for the root of a Windows drive, eg file:\\\c%3A, is converted to c:
             * by the Uri class.  However file:\\\c%3A is unambiguously a uri to the root of
             * the drive and c: is interpreted as the default directory for the c drive
             * (by, for example, the readdir function in the fs-extra module).
             * A backslash must be appended to the drive, eg c:\, to ensure the correct path.
             */
            // eslint-disable-next-line @typescript-eslint/no-explicit-any
            const fsPathFromVsCodeUri = uri.codeUri.fsPath;
            if (os_1.isWindows) {
                const isWindowsDriveRoot = windowsDriveRegex.exec(fsPathFromVsCodeUri);
                if (isWindowsDriveRoot) {
                    return fsPathFromVsCodeUri + '\\';
                }
            }
            return fsPathFromVsCodeUri;
        }
    }
    FileUri.fsPath = fsPath;
})(FileUri || (exports.FileUri = FileUri = {}));


/***/ }),

/***/ "../../node_modules/@theia/core/lib/electron-common/electron-api.js":
/*!**************************************************************************!*\
  !*** ../../node_modules/@theia/core/lib/electron-common/electron-api.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


// *****************************************************************************
// Copyright (C) 2023 STMicroelectronics and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CHANNEL_IPC_CONNECTION = exports.CHANNEL_KEYBOARD_LAYOUT_CHANGED = exports.CHANNEL_WRITE_CLIPBOARD = exports.CHANNEL_READ_CLIPBOARD = exports.CHANNEL_APP_STATE_CHANGED = exports.CHANNEL_RESTART = exports.CHANNEL_REQUEST_RELOAD = exports.CHANNEL_REQUEST_CLOSE = exports.CHANNEL_REQUEST_SECONDARY_CLOSE = exports.CHANNEL_TOGGLE_FULL_SCREEN = exports.CHANNEL_IS_FULL_SCREEN = exports.CHANNEL_IS_FULL_SCREENABLE = exports.CHANNEL_SET_ZOOM_LEVEL = exports.CHANNEL_GET_ZOOM_LEVEL = exports.CHANNEL_TOGGLE_DEVTOOLS = exports.CHANNEL_ON_WINDOW_EVENT = exports.CHANNEL_UNMAXIMIZE = exports.CHANNEL_OPEN_URL = exports.CHANNEL_ABOUT_TO_CLOSE = exports.CHANNEL_IS_MAXIMIZED = exports.CHANNEL_MAXIMIZE = exports.CHANNEL_MINIMIZE = exports.CHANNEL_CLOSE = exports.CHANNEL_SET_THEME = exports.CHANNEL_SET_BACKGROUND_COLOR = exports.CHANNEL_SET_TITLE_STYLE = exports.CHANNEL_GET_TITLE_STYLE_AT_STARTUP = exports.CHANNEL_ATTACH_SECURITY_TOKEN = exports.CHANNEL_OPEN_WITH_SYSTEM_APP = exports.CHANNEL_SHOW_ITEM_IN_FOLDER = exports.CHANNEL_SHOW_SAVE = exports.CHANNEL_SHOW_OPEN = exports.CHANNEL_FOCUS_WINDOW = exports.CHANNEL_GET_SECURITY_TOKEN = exports.CHANNEL_CLOSE_POPUP = exports.CHANNEL_ON_CLOSE_POPUP = exports.CHANNEL_OPEN_POPUP = exports.CHANNEL_INVOKE_MENU = exports.CHANNEL_SET_MENU_BAR_VISIBLE = exports.CHANNEL_SET_MENU = exports.CHANNEL_WC_METADATA = void 0;
exports.CHANNEL_WC_METADATA = 'WebContentMetadata';
exports.CHANNEL_SET_MENU = 'SetMenu';
exports.CHANNEL_SET_MENU_BAR_VISIBLE = 'SetMenuBarVisible';
exports.CHANNEL_INVOKE_MENU = 'InvokeMenu';
exports.CHANNEL_OPEN_POPUP = 'OpenPopup';
exports.CHANNEL_ON_CLOSE_POPUP = 'OnClosePopup';
exports.CHANNEL_CLOSE_POPUP = 'ClosePopup';
exports.CHANNEL_GET_SECURITY_TOKEN = 'GetSecurityToken';
exports.CHANNEL_FOCUS_WINDOW = 'FocusWindow';
exports.CHANNEL_SHOW_OPEN = 'ShowOpenDialog';
exports.CHANNEL_SHOW_SAVE = 'ShowSaveDialog';
exports.CHANNEL_SHOW_ITEM_IN_FOLDER = 'ShowItemInFolder';
exports.CHANNEL_OPEN_WITH_SYSTEM_APP = 'OpenWithSystemApp';
exports.CHANNEL_ATTACH_SECURITY_TOKEN = 'AttachSecurityToken';
exports.CHANNEL_GET_TITLE_STYLE_AT_STARTUP = 'GetTitleStyleAtStartup';
exports.CHANNEL_SET_TITLE_STYLE = 'SetTitleStyle';
exports.CHANNEL_SET_BACKGROUND_COLOR = 'SetBackgroundColor';
exports.CHANNEL_SET_THEME = 'SetTheme';
exports.CHANNEL_CLOSE = 'Close';
exports.CHANNEL_MINIMIZE = 'Minimize';
exports.CHANNEL_MAXIMIZE = 'Maximize';
exports.CHANNEL_IS_MAXIMIZED = 'IsMaximized';
exports.CHANNEL_ABOUT_TO_CLOSE = 'AboutToClose';
exports.CHANNEL_OPEN_URL = 'OpenUrl';
exports.CHANNEL_UNMAXIMIZE = 'UnMaximize';
exports.CHANNEL_ON_WINDOW_EVENT = 'OnWindowEvent';
exports.CHANNEL_TOGGLE_DEVTOOLS = 'ToggleDevtools';
exports.CHANNEL_GET_ZOOM_LEVEL = 'GetZoomLevel';
exports.CHANNEL_SET_ZOOM_LEVEL = 'SetZoomLevel';
exports.CHANNEL_IS_FULL_SCREENABLE = 'IsFullScreenable';
exports.CHANNEL_IS_FULL_SCREEN = 'IsFullScreen';
exports.CHANNEL_TOGGLE_FULL_SCREEN = 'ToggleFullScreen';
exports.CHANNEL_REQUEST_SECONDARY_CLOSE = 'RequestSecondaryClose';
exports.CHANNEL_REQUEST_CLOSE = 'RequestClose';
exports.CHANNEL_REQUEST_RELOAD = 'RequestReload';
exports.CHANNEL_RESTART = 'Restart';
exports.CHANNEL_APP_STATE_CHANGED = 'ApplicationStateChanged';
exports.CHANNEL_READ_CLIPBOARD = 'ReadClipboard';
exports.CHANNEL_WRITE_CLIPBOARD = 'WriteClipboard';
exports.CHANNEL_KEYBOARD_LAYOUT_CHANGED = 'KeyboardLayoutChanged';
exports.CHANNEL_IPC_CONNECTION = 'IpcConnection';


/***/ }),

/***/ "../../node_modules/@theia/filesystem/lib/electron-browser/file-dialog/electron-file-dialog-service.js":
/*!*************************************************************************************************************!*\
  !*** ../../node_modules/@theia/filesystem/lib/electron-browser/file-dialog/electron-file-dialog-service.js ***!
  \*************************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ElectronFileDialogService = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const message_service_1 = __webpack_require__(/*! @theia/core/lib/common/message-service */ "../../node_modules/@theia/core/lib/common/message-service.js");
const filesystem_1 = __webpack_require__(/*! ../../common/filesystem */ "../../node_modules/@theia/filesystem/lib/common/filesystem.js");
const file_dialog_1 = __webpack_require__(/*! ../../browser/file-dialog */ "../../node_modules/@theia/filesystem/lib/browser/file-dialog/index.js");
//
// We are OK to use this here because the electron backend and frontend are on the same host.
// If required, we can move this single service (and its module) to a dedicated Theia extension,
// and at packaging time, clients can decide whether they need the native or the browser-based
// solution.
//
// eslint-disable-next-line @theia/runtime-import-check
const file_uri_1 = __webpack_require__(/*! @theia/core/lib/common/file-uri */ "../../node_modules/@theia/core/lib/common/file-uri.js");
__webpack_require__(/*! @theia/core/lib/electron-common/electron-api */ "../../node_modules/@theia/core/lib/electron-common/electron-api.js");
let ElectronFileDialogService = class ElectronFileDialogService extends file_dialog_1.DefaultFileDialogService {
    async showOpenDialog(props, folder) {
        if (window.electronTheiaCore.useNativeElements) {
            const rootNode = await this.getRootNode(folder);
            if (rootNode) {
                const filePaths = await window.electronTheiaFilesystem.showOpenDialog(this.toOpenDialogOptions(rootNode.uri, props));
                if (!filePaths || filePaths.length === 0) {
                    return undefined;
                }
                const uris = filePaths.map(path => file_uri_1.FileUri.create(path));
                const canAccess = await this.canRead(uris);
                const result = canAccess ? uris.length === 1 ? uris[0] : uris : undefined;
                return result;
            }
            return undefined;
        }
        return super.showOpenDialog(props, folder);
    }
    async showSaveDialog(props, folder) {
        if (window.electronTheiaCore.useNativeElements) {
            const rootNode = await this.getRootNode(folder);
            if (rootNode) {
                const filePath = await window.electronTheiaFilesystem.showSaveDialog(this.toSaveDialogOptions(rootNode.uri, props));
                if (!filePath) {
                    return undefined;
                }
                const uri = file_uri_1.FileUri.create(filePath);
                const exists = await this.fileService.exists(uri);
                if (!exists) {
                    return uri;
                }
                const canWrite = await this.canReadWrite(uri);
                return canWrite ? uri : undefined;
            }
            return undefined;
        }
        return super.showSaveDialog(props, folder);
    }
    async canReadWrite(uris) {
        for (const uri of Array.isArray(uris) ? uris : [uris]) {
            if (!(await this.fileService.access(uri, filesystem_1.FileAccess.Constants.R_OK | filesystem_1.FileAccess.Constants.W_OK))) {
                this.messageService.error(`Cannot access resource at ${uri.path}.`);
                return false;
            }
        }
        return true;
    }
    async canRead(uris) {
        const resources = Array.isArray(uris) ? uris : [uris];
        const unreadableResourcePaths = [];
        await Promise.all(resources.map(async (resource) => {
            if (!await this.fileService.access(resource, filesystem_1.FileAccess.Constants.R_OK)) {
                unreadableResourcePaths.push(resource.path.toString());
            }
        }));
        if (unreadableResourcePaths.length > 0) {
            this.messageService.error(`Cannot read ${unreadableResourcePaths.length} resource(s): ${unreadableResourcePaths.join(', ')}`);
        }
        return unreadableResourcePaths.length === 0;
    }
    toOpenDialogOptions(uri, props) {
        var _a;
        const result = {
            path: file_uri_1.FileUri.fsPath(uri)
        };
        result.title = props.title;
        result.buttonLabel = props.openLabel;
        result.maxWidth = props.maxWidth;
        result.modal = (_a = props.modal) !== null && _a !== void 0 ? _a : true;
        result.openFiles = props.canSelectFiles;
        result.openFolders = props.canSelectFolders;
        result.selectMany = props.canSelectMany;
        if (props.filters) {
            result.filters = [];
            const filters = Object.entries(props.filters);
            for (const [label, extensions] of filters) {
                result.filters.push({ name: label, extensions: extensions });
            }
            if (props.canSelectFiles) {
                if (filters.length > 0) {
                    result.filters.push({ name: 'All Files', extensions: ['*'] });
                }
            }
        }
        return result;
    }
    toSaveDialogOptions(uri, props) {
        var _a;
        if (props.inputValue) {
            uri = uri.resolve(props.inputValue);
        }
        const result = {
            path: file_uri_1.FileUri.fsPath(uri)
        };
        result.title = props.title;
        result.buttonLabel = props.saveLabel;
        result.maxWidth = props.maxWidth;
        result.modal = (_a = props.modal) !== null && _a !== void 0 ? _a : true;
        if (props.filters) {
            result.filters = [];
            const filters = Object.entries(props.filters);
            for (const [label, extensions] of filters) {
                result.filters.push({ name: label, extensions: extensions });
            }
        }
        return result;
    }
};
exports.ElectronFileDialogService = ElectronFileDialogService;
tslib_1.__decorate([
    (0, inversify_1.inject)(message_service_1.MessageService),
    tslib_1.__metadata("design:type", message_service_1.MessageService)
], ElectronFileDialogService.prototype, "messageService", void 0);
exports.ElectronFileDialogService = ElectronFileDialogService = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ElectronFileDialogService);


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_filesystem_lib_electron-browser_file-dialog_electron-file-dialog-s-8b3e2f.js.map