"use strict";
(self["webpackChunkcdt_cloud_blueprint_app"] = self["webpackChunkcdt_cloud_blueprint_app"] || []).push([["vendors-node_modules_theia_console_lib_browser_console-widget_js"],{

/***/ "../../node_modules/@theia/console/lib/browser/console-content-widget.js":
/*!*******************************************************************************!*\
  !*** ../../node_modules/@theia/console/lib/browser/console-content-widget.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var ConsoleContentWidget_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ConsoleContentWidget = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const source_tree_1 = __webpack_require__(/*! @theia/core/lib/browser/source-tree */ "../../node_modules/@theia/core/lib/browser/source-tree/index.js");
const console_session_1 = __webpack_require__(/*! ./console-session */ "../../node_modules/@theia/console/lib/browser/console-session.js");
const severity_1 = __webpack_require__(/*! @theia/core/lib/common/severity */ "../../node_modules/@theia/core/lib/common/severity.js");
let ConsoleContentWidget = ConsoleContentWidget_1 = class ConsoleContentWidget extends source_tree_1.SourceTreeWidget {
    static createContainer(parent, props) {
        const child = source_tree_1.SourceTreeWidget.createContainer(parent, {
            contextMenuPath: ConsoleContentWidget_1.CONTEXT_MENU,
            viewProps: {
                followOutput: true
            },
            ...props
        });
        child.unbind(source_tree_1.SourceTreeWidget);
        child.bind(ConsoleContentWidget_1).toSelf();
        return child;
    }
    createTreeElementNodeClassNames(node) {
        const classNames = super.createTreeElementNodeClassNames(node);
        if (node.element) {
            const className = this.toClassName(node.element);
            if (className) {
                classNames.push(className);
            }
        }
        return classNames;
    }
    toClassName(item) {
        if (item.severity === severity_1.Severity.Error) {
            return console_session_1.ConsoleItem.errorClassName;
        }
        if (item.severity === severity_1.Severity.Warning) {
            return console_session_1.ConsoleItem.warningClassName;
        }
        if (item.severity === severity_1.Severity.Info) {
            return console_session_1.ConsoleItem.infoClassName;
        }
        if (item.severity === severity_1.Severity.Log) {
            return console_session_1.ConsoleItem.logClassName;
        }
        return undefined;
    }
};
exports.ConsoleContentWidget = ConsoleContentWidget;
ConsoleContentWidget.CONTEXT_MENU = ['console-context-menu'];
exports.ConsoleContentWidget = ConsoleContentWidget = ConsoleContentWidget_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ConsoleContentWidget);


/***/ }),

/***/ "../../node_modules/@theia/console/lib/browser/console-history.js":
/*!************************************************************************!*\
  !*** ../../node_modules/@theia/console/lib/browser/console-history.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var ConsoleHistory_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ConsoleHistory = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
let ConsoleHistory = ConsoleHistory_1 = class ConsoleHistory {
    constructor() {
        this.values = [];
        this.index = -1;
    }
    push(value) {
        this.delete(value);
        this.values.push(value);
        this.trim();
        this.index = this.values.length;
    }
    delete(value) {
        const index = this.values.indexOf(value);
        if (index !== -1) {
            this.values.splice(index, 1);
        }
    }
    trim() {
        const index = this.values.length - ConsoleHistory_1.limit;
        if (index > 0) {
            this.values = this.values.slice(index);
        }
    }
    get current() {
        return this.values[this.index];
    }
    get previous() {
        this.index = Math.max(this.index - 1, -1);
        return this.current;
    }
    get next() {
        this.index = Math.min(this.index + 1, this.values.length);
        return this.current;
    }
    store() {
        const { values, index } = this;
        return { values, index };
    }
    restore(object) {
        this.values = object.values;
        this.index = object.index;
    }
};
exports.ConsoleHistory = ConsoleHistory;
ConsoleHistory.limit = 50;
exports.ConsoleHistory = ConsoleHistory = ConsoleHistory_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ConsoleHistory);


/***/ }),

/***/ "../../node_modules/@theia/console/lib/browser/console-session-manager.js":
/*!********************************************************************************!*\
  !*** ../../node_modules/@theia/console/lib/browser/console-session-manager.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2021 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ConsoleSessionManager = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const severity_1 = __webpack_require__(/*! @theia/core/lib/common/severity */ "../../node_modules/@theia/core/lib/common/severity.js");
let ConsoleSessionManager = class ConsoleSessionManager {
    constructor() {
        this.sessions = new Map();
        this.sessionAddedEmitter = new core_1.Emitter();
        this.sessionDeletedEmitter = new core_1.Emitter();
        this.sessionWasShownEmitter = new core_1.Emitter();
        this.sessionWasHiddenEmitter = new core_1.Emitter();
        this.selectedSessionChangedEmitter = new core_1.Emitter();
        this.severityChangedEmitter = new core_1.Emitter();
        this.toDispose = new core_1.DisposableCollection();
        this.toDisposeOnSessionDeletion = new Map();
    }
    get onDidAddSession() {
        return this.sessionAddedEmitter.event;
    }
    get onDidDeleteSession() {
        return this.sessionDeletedEmitter.event;
    }
    get onDidShowSession() {
        return this.sessionWasShownEmitter.event;
    }
    get onDidHideSession() {
        return this.sessionWasHiddenEmitter.event;
    }
    get onDidChangeSelectedSession() {
        return this.selectedSessionChangedEmitter.event;
    }
    get onDidChangeSeverity() {
        return this.severityChangedEmitter.event;
    }
    dispose() {
        this.toDispose.dispose();
    }
    get severity() {
        return this._severity;
    }
    set severity(value) {
        value = value || severity_1.Severity.Ignore;
        this._severity = value;
        for (const session of this.sessions.values()) {
            session.severity = value;
        }
        this.severityChangedEmitter.fire(undefined);
    }
    get all() {
        return Array.from(this.sessions.values());
    }
    get selectedSession() {
        return this._selectedSession;
    }
    set selectedSession(session) {
        const oldSession = this.selectedSession;
        this._selectedSession = session;
        this.selectedSessionChangedEmitter.fire(session);
        if (oldSession !== session) {
            if (oldSession) {
                this.sessionWasHiddenEmitter.fire(oldSession);
            }
            if (session) {
                this.sessionWasShownEmitter.fire(session);
            }
        }
    }
    get(id) {
        return this.sessions.get(id);
    }
    add(session) {
        this.sessions.set(session.id, session);
        this.sessionAddedEmitter.fire(session);
        if (this.sessions.size === 1) {
            this.selectedSession = session;
        }
    }
    delete(id) {
        const session = this.sessions.get(id);
        if (this.sessions.delete(id) && session) {
            if (this.selectedSession === session) {
                // select a new sessions or undefined if none are left
                this.selectedSession = this.sessions.values().next().value;
            }
            session.dispose();
            this.sessionDeletedEmitter.fire(session);
        }
    }
};
exports.ConsoleSessionManager = ConsoleSessionManager;
exports.ConsoleSessionManager = ConsoleSessionManager = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ConsoleSessionManager);


/***/ }),

/***/ "../../node_modules/@theia/console/lib/browser/console-session.js":
/*!************************************************************************!*\
  !*** ../../node_modules/@theia/console/lib/browser/console-session.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ConsoleSession = exports.ConsoleItem = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const source_tree_1 = __webpack_require__(/*! @theia/core/lib/browser/source-tree */ "../../node_modules/@theia/core/lib/browser/source-tree/index.js");
const event_1 = __webpack_require__(/*! @theia/core/lib/common/event */ "../../node_modules/@theia/core/lib/common/event.js");
var ConsoleItem;
(function (ConsoleItem) {
    ConsoleItem.errorClassName = 'theia-console-error';
    ConsoleItem.warningClassName = 'theia-console-warning';
    ConsoleItem.infoClassName = 'theia-console-info';
    ConsoleItem.logClassName = 'theia-console-log';
})(ConsoleItem || (exports.ConsoleItem = ConsoleItem = {}));
let ConsoleSession = class ConsoleSession extends source_tree_1.TreeSource {
    constructor() {
        super(...arguments);
        this.selectionEmitter = new event_1.Emitter();
        this.onSelectionChange = this.selectionEmitter.event;
    }
    get severity() {
        return this.selectedSeverity;
    }
    set severity(severity) {
        if (severity === this.selectedSeverity) {
            return;
        }
        this.selectedSeverity = severity;
        this.selectionEmitter.fire(undefined);
        this.fireDidChange();
    }
};
exports.ConsoleSession = ConsoleSession;
exports.ConsoleSession = ConsoleSession = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ConsoleSession);


/***/ }),

/***/ "../../node_modules/@theia/console/lib/browser/console-widget.js":
/*!***********************************************************************!*\
  !*** ../../node_modules/@theia/console/lib/browser/console-widget.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var ConsoleWidget_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ConsoleWidget = exports.ConsoleOptions = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const domutils_1 = __webpack_require__(/*! @theia/core/shared/@lumino/domutils */ "../../node_modules/@theia/core/shared/@lumino/domutils/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const source_tree_1 = __webpack_require__(/*! @theia/core/lib/browser/source-tree */ "../../node_modules/@theia/core/lib/browser/source-tree/index.js");
const context_key_service_1 = __webpack_require__(/*! @theia/core/lib/browser/context-key-service */ "../../node_modules/@theia/core/lib/browser/context-key-service.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const monaco_editor_provider_1 = __webpack_require__(/*! @theia/monaco/lib/browser/monaco-editor-provider */ "../../node_modules/@theia/monaco/lib/browser/monaco-editor-provider.js");
const console_history_1 = __webpack_require__(/*! ./console-history */ "../../node_modules/@theia/console/lib/browser/console-history.js");
const console_content_widget_1 = __webpack_require__(/*! ./console-content-widget */ "../../node_modules/@theia/console/lib/browser/console-content-widget.js");
const console_session_manager_1 = __webpack_require__(/*! ./console-session-manager */ "../../node_modules/@theia/console/lib/browser/console-session-manager.js");
const monaco = __webpack_require__(/*! @theia/monaco-editor-core */ "../../node_modules/@theia/monaco-editor-core/esm/vs/editor/editor.main.js");
const disposable_1 = __webpack_require__(/*! @theia/core/lib/common/disposable */ "../../node_modules/@theia/core/lib/common/disposable.js");
const browser_2 = __webpack_require__(/*! @theia/editor/lib/browser */ "../../node_modules/@theia/editor/lib/browser/index.js");
const monaco_editor_service_1 = __webpack_require__(/*! @theia/monaco/lib/browser/monaco-editor-service */ "../../node_modules/@theia/monaco/lib/browser/monaco-editor-service.js");
exports.ConsoleOptions = Symbol('ConsoleWidgetOptions');
let ConsoleWidget = ConsoleWidget_1 = class ConsoleWidget extends browser_1.BaseWidget {
    static createContainer(parent, options) {
        const child = console_content_widget_1.ConsoleContentWidget.createContainer(parent);
        child.bind(console_history_1.ConsoleHistory).toSelf();
        child.bind(exports.ConsoleOptions).toConstantValue(options);
        child.bind(ConsoleWidget_1).toSelf();
        return child;
    }
    get ready() {
        if (!this._ready) {
            throw new Error('ready must not be accessed in the construction phase');
        }
        return this._ready;
    }
    constructor() {
        super();
        this.modelChangeListener = disposable_1.Disposable.NULL;
        this.totalHeight = -1;
        this.totalWidth = -1;
        this.node.classList.add(ConsoleWidget_1.styles.node);
    }
    init() {
        this._ready = this.doInit();
    }
    async doInit() {
        const { id, title, inputFocusContextKey } = this.options;
        const { label, iconClass, caption } = Object.assign({}, title);
        this.id = id;
        this.title.closable = true;
        this.title.label = label || id;
        if (iconClass) {
            this.title.iconClass = iconClass;
        }
        this.title.caption = caption || label || id;
        const layout = this.layout = new browser_1.PanelLayout();
        this.content.node.classList.add(ConsoleWidget_1.styles.content);
        this.toDispose.push(this.content);
        layout.addWidget(this.content);
        const inputWidget = new browser_1.Widget();
        inputWidget.node.classList.add(ConsoleWidget_1.styles.input);
        layout.addWidget(inputWidget);
        const input = this._input = await this.createInput(inputWidget.node);
        this.toDispose.push(input);
        this.toDispose.push(input.getControl().onDidLayoutChange(() => this.resizeContent()));
        this.toDispose.push(input.getControl().onDidChangeConfiguration(event => {
            if (event.hasChanged(monaco.editor.EditorOption.fontInfo)) {
                this.updateFont();
            }
        }));
        this.session = this.sessionManager.selectedSession;
        this.toDispose.push(this.sessionManager.onDidChangeSelectedSession(session => {
            // Do not clear the session output when `undefined`.
            if (session) {
                this.session = session;
            }
        }));
        this.updateFont();
        if (inputFocusContextKey) {
            this.toDispose.push(input.onFocusChanged(() => inputFocusContextKey.set(this.hasInputFocus())));
            this.toDispose.push(input.onCursorPositionChanged(() => input.getControl().createContextKey('consoleNavigationBackEnabled', this.consoleNavigationBackEnabled)));
            this.toDispose.push(input.onCursorPositionChanged(() => input.getControl().createContextKey('consoleNavigationForwardEnabled', this.consoleNavigationForwardEnabled)));
        }
        input.getControl().createContextKey('consoleInputFocus', true);
        const contentContext = this.contextKeyService.createScoped(this.content.node);
        contentContext.setContext('consoleContentFocus', true);
        this.toDispose.pushAll([
            this.editorManager.onActiveEditorChanged(() => this.setMode()),
            this.onDidChangeVisibility(() => this.setMode())
        ]);
    }
    createInput(node) {
        return this.editorProvider.createInline(this.options.input.uri, node, this.options.input.options);
    }
    updateFont() {
        const { fontFamily, fontSize, lineHeight } = this._input.getControl().getOption(monaco.editor.EditorOption.fontInfo);
        this.content.node.style.fontFamily = fontFamily;
        this.content.node.style.fontSize = fontSize + 'px';
        this.content.node.style.lineHeight = lineHeight + 'px';
    }
    set session(session) {
        if (this._session === session) {
            return;
        }
        this._session = session;
        this.content.source = session;
    }
    get session() {
        return this._session;
    }
    get input() {
        return this._input;
    }
    get consoleNavigationBackEnabled() {
        const editor = this.input.getControl();
        return !!editor.getPosition().equals({ lineNumber: 1, column: 1 });
    }
    get consoleNavigationForwardEnabled() {
        const editor = this.input.getControl();
        const model = editor.getModel();
        if (!model) {
            return false;
        }
        const lineNumber = editor.getModel().getLineCount();
        const column = editor.getModel().getLineMaxColumn(lineNumber);
        return !!editor.getPosition().equals({ lineNumber, column });
    }
    selectAll() {
        const selection = document.getSelection();
        if (selection) {
            selection.selectAllChildren(this.content.node);
        }
    }
    collapseAll() {
        const { root } = this.content.model;
        if (browser_1.CompositeTreeNode.is(root)) {
            this.content.model.collapseAll(root);
        }
    }
    clear() {
        if (this.session) {
            this.session.clear();
        }
    }
    async execute() {
        const value = this._input.getControl().getValue();
        this._input.getControl().setValue('');
        this.history.push(value);
        if (this.session) {
            const listener = this.content.model.onNodeRefreshed(() => {
                listener.dispose();
                this.revealLastOutput();
            });
            await this.session.execute(value);
        }
    }
    navigateBack() {
        const value = this.history.previous;
        if (value === undefined) {
            return;
        }
        const editor = this.input.getControl();
        editor.setValue(value);
        editor.setPosition({
            lineNumber: 1,
            column: 1
        });
    }
    navigateForward() {
        const value = this.history.next || '';
        const editor = this.input.getControl();
        editor.setValue(value);
        const lineNumber = editor.getModel().getLineCount();
        const column = editor.getModel().getLineMaxColumn(lineNumber);
        editor.setPosition({ lineNumber, column });
    }
    revealLastOutput() {
        const { root } = this.content.model;
        if (source_tree_1.TreeSourceNode.is(root)) {
            this.content.model.selectNode(root.children[root.children.length - 1]);
        }
    }
    onActivateRequest(msg) {
        super.onActivateRequest(msg);
        this._input.focus();
    }
    onResize(msg) {
        super.onResize(msg);
        this.totalWidth = msg.width;
        this.totalHeight = msg.height;
        this._input.resizeToFit();
        this.resizeContent();
    }
    resizeContent() {
        this.totalHeight = this.totalHeight < 0 ? this.computeHeight() : this.totalHeight;
        const inputHeight = this._input.getControl().getLayoutInfo().height;
        const contentHeight = this.totalHeight - inputHeight;
        this.content.node.style.height = `${contentHeight}px`;
        browser_1.MessageLoop.sendMessage(this.content, new browser_1.Widget.ResizeMessage(this.totalWidth, contentHeight));
    }
    computeHeight() {
        const { verticalSum } = domutils_1.ElementExt.boxSizing(this.node);
        return this.node.offsetHeight - verticalSum;
    }
    storeState() {
        const history = this.history.store();
        const input = this.input.storeViewState();
        return {
            history,
            input
        };
    }
    restoreState(oldState) {
        if ('history' in oldState) {
            // eslint-disable-next-line @typescript-eslint/no-explicit-any
            this.history.restore(oldState['history']);
        }
        this.input.getControl().setValue(this.history.current || '');
        if ('input' in oldState) {
            // eslint-disable-next-line @typescript-eslint/no-explicit-any
            this.input.restoreViewState(oldState['input']);
        }
    }
    hasInputFocus() {
        return this._input && this._input.isFocused({ strict: true });
    }
    dispose() {
        super.dispose();
        this.modelChangeListener.dispose();
    }
    // To set the active language for the console input text model.
    // https://github.com/microsoft/vscode/blob/2af422737386e792c3fcde7884f9bf47a1aff2f5/src/vs/workbench/contrib/debug/browser/repl.ts#L371-L384
    setMode() {
        if (this.isHidden) {
            return;
        }
        const activeEditorControl = this.editorService.getActiveCodeEditor();
        if (activeEditorControl) {
            this.modelChangeListener.dispose();
            this.modelChangeListener = activeEditorControl.onDidChangeModelLanguage(() => this.setMode());
            const consoleModel = this._input.getControl().getModel();
            const activeEditorModel = activeEditorControl.getModel();
            if (consoleModel && activeEditorModel) {
                monaco.editor.setModelLanguage(consoleModel, activeEditorModel.getLanguageId());
            }
        }
    }
};
exports.ConsoleWidget = ConsoleWidget;
ConsoleWidget.styles = {
    node: 'theia-console-widget',
    content: 'theia-console-content',
    input: 'theia-console-input',
};
tslib_1.__decorate([
    (0, inversify_1.inject)(exports.ConsoleOptions),
    tslib_1.__metadata("design:type", Object)
], ConsoleWidget.prototype, "options", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(console_content_widget_1.ConsoleContentWidget),
    tslib_1.__metadata("design:type", console_content_widget_1.ConsoleContentWidget)
], ConsoleWidget.prototype, "content", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(console_history_1.ConsoleHistory),
    tslib_1.__metadata("design:type", console_history_1.ConsoleHistory)
], ConsoleWidget.prototype, "history", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(console_session_manager_1.ConsoleSessionManager),
    tslib_1.__metadata("design:type", console_session_manager_1.ConsoleSessionManager)
], ConsoleWidget.prototype, "sessionManager", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(monaco_editor_provider_1.MonacoEditorProvider),
    tslib_1.__metadata("design:type", monaco_editor_provider_1.MonacoEditorProvider)
], ConsoleWidget.prototype, "editorProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(context_key_service_1.ContextKeyService),
    tslib_1.__metadata("design:type", Object)
], ConsoleWidget.prototype, "contextKeyService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(monaco_editor_service_1.MonacoEditorService),
    tslib_1.__metadata("design:type", monaco_editor_service_1.MonacoEditorService)
], ConsoleWidget.prototype, "editorService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_2.EditorManager),
    tslib_1.__metadata("design:type", browser_2.EditorManager)
], ConsoleWidget.prototype, "editorManager", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], ConsoleWidget.prototype, "init", null);
exports.ConsoleWidget = ConsoleWidget = ConsoleWidget_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)(),
    tslib_1.__metadata("design:paramtypes", [])
], ConsoleWidget);


/***/ }),

/***/ "../../node_modules/@theia/core/lib/browser/source-tree/index.js":
/*!***********************************************************************!*\
  !*** ../../node_modules/@theia/core/lib/browser/source-tree/index.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
tslib_1.__exportStar(__webpack_require__(/*! ./tree-source */ "../../node_modules/@theia/core/lib/browser/source-tree/tree-source.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./source-tree */ "../../node_modules/@theia/core/lib/browser/source-tree/source-tree.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./source-tree-widget */ "../../node_modules/@theia/core/lib/browser/source-tree/source-tree-widget.js"), exports);


/***/ }),

/***/ "../../node_modules/@theia/core/lib/browser/source-tree/source-tree-widget.js":
/*!************************************************************************************!*\
  !*** ../../node_modules/@theia/core/lib/browser/source-tree/source-tree-widget.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var SourceTreeWidget_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SourceTreeWidget = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const React = __webpack_require__(/*! react */ "../../node_modules/react/index.js");
const inversify_1 = __webpack_require__(/*! inversify */ "../../node_modules/inversify/lib/cjs/index.js");
const disposable_1 = __webpack_require__(/*! ../../common/disposable */ "../../node_modules/@theia/core/lib/common/disposable.js");
const tree_1 = __webpack_require__(/*! ../tree */ "../../node_modules/@theia/core/lib/browser/tree/index.js");
const source_tree_1 = __webpack_require__(/*! ./source-tree */ "../../node_modules/@theia/core/lib/browser/source-tree/source-tree.js");
let SourceTreeWidget = SourceTreeWidget_1 = class SourceTreeWidget extends tree_1.TreeWidget {
    constructor() {
        super(...arguments);
        this.toDisposeOnSource = new disposable_1.DisposableCollection();
    }
    static createContainer(parent, props) {
        const child = (0, tree_1.createTreeContainer)(parent, {
            props,
            tree: source_tree_1.SourceTree,
            widget: SourceTreeWidget_1,
        });
        return child;
    }
    init() {
        super.init();
        this.addClass('theia-source-tree');
        this.toDispose.push(this.model.onOpenNode(node => {
            if (source_tree_1.TreeElementNode.is(node) && node.element.open) {
                node.element.open();
            }
        }));
    }
    get source() {
        const root = this.model.root;
        return source_tree_1.TreeSourceNode.is(root) ? root.source : undefined;
    }
    set source(source) {
        if (this.source === source) {
            return;
        }
        this.toDisposeOnSource.dispose();
        this.toDispose.push(this.toDisposeOnSource);
        this.model.root = source_tree_1.TreeSourceNode.to(source);
        if (source) {
            this.toDisposeOnSource.push(source.onDidChange(() => this.model.refresh()));
        }
    }
    get selectedElement() {
        const node = this.model.selectedNodes[0];
        return source_tree_1.TreeElementNode.is(node) && node.element || undefined;
    }
    renderTree(model) {
        if (source_tree_1.TreeSourceNode.is(model.root) && model.root.children.length === 0) {
            const { placeholder } = model.root.source;
            if (placeholder) {
                return React.createElement("div", { className: 'theia-tree-source-node-placeholder noselect' }, placeholder);
            }
        }
        return super.renderTree(model);
    }
    renderCaption(node) {
        if (source_tree_1.TreeElementNode.is(node)) {
            const classNames = this.createTreeElementNodeClassNames(node);
            return React.createElement("div", { className: classNames.join(' ') }, node.element.render(this));
        }
        return undefined;
    }
    createTreeElementNodeClassNames(node) {
        return [tree_1.TREE_NODE_SEGMENT_GROW_CLASS];
    }
    storeState() {
        // no-op
        return {};
    }
    superStoreState() {
        return super.storeState();
    }
    restoreState(state) {
        // no-op
    }
    superRestoreState(state) {
        super.restoreState(state);
        return;
    }
};
exports.SourceTreeWidget = SourceTreeWidget;
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], SourceTreeWidget.prototype, "init", null);
exports.SourceTreeWidget = SourceTreeWidget = SourceTreeWidget_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], SourceTreeWidget);


/***/ }),

/***/ "../../node_modules/@theia/core/lib/browser/source-tree/source-tree.js":
/*!*****************************************************************************!*\
  !*** ../../node_modules/@theia/core/lib/browser/source-tree/source-tree.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TreeSourceNode = exports.CompositeTreeElementNode = exports.TreeElementNode = exports.SourceTree = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
/* eslint-disable @typescript-eslint/no-explicit-any */
const inversify_1 = __webpack_require__(/*! inversify */ "../../node_modules/inversify/lib/cjs/index.js");
const tree_1 = __webpack_require__(/*! ../tree */ "../../node_modules/@theia/core/lib/browser/tree/index.js");
const tree_source_1 = __webpack_require__(/*! ./tree-source */ "../../node_modules/@theia/core/lib/browser/source-tree/tree-source.js");
let SourceTree = class SourceTree extends tree_1.TreeImpl {
    async resolveChildren(parent) {
        const elements = await this.resolveElements(parent);
        const nodes = [];
        let index = 0;
        for (const element of elements) {
            if (element.visible !== false) {
                nodes.push(this.toNode(element, index++, parent));
            }
        }
        return nodes;
    }
    resolveElements(parent) {
        if (TreeSourceNode.is(parent)) {
            return parent.source.getElements();
        }
        return parent.element.getElements();
    }
    toNode(element, index, parent) {
        const id = element.id ? String(element.id) : (parent.id + ':' + index);
        const name = id;
        const existing = this.getNode(id);
        const updated = existing && Object.assign(existing, { element, parent });
        if (tree_source_1.CompositeTreeElement.hasElements(element)) {
            const expand = element.expandByDefault ? element.expandByDefault() : false;
            if (updated) {
                if (!tree_1.ExpandableTreeNode.is(updated)) {
                    Object.assign(updated, { expanded: expand });
                }
                if (!tree_1.CompositeTreeNode.is(updated)) {
                    Object.assign(updated, { children: [] });
                }
                return updated;
            }
            return {
                element,
                parent,
                id,
                name,
                selected: false,
                expanded: expand,
                children: []
            };
        }
        if (CompositeTreeElementNode.is(updated)) {
            delete updated.expanded;
            delete updated.children;
        }
        if (updated) {
            if (tree_1.ExpandableTreeNode.is(updated)) {
                delete updated.expanded;
            }
            if (tree_1.CompositeTreeNode.is(updated)) {
                delete updated.children;
            }
            return updated;
        }
        return {
            element,
            parent,
            id,
            name,
            selected: false
        };
    }
};
exports.SourceTree = SourceTree;
exports.SourceTree = SourceTree = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], SourceTree);
var TreeElementNode;
(function (TreeElementNode) {
    function is(node) {
        return tree_1.SelectableTreeNode.is(node) && 'element' in node;
    }
    TreeElementNode.is = is;
})(TreeElementNode || (exports.TreeElementNode = TreeElementNode = {}));
var CompositeTreeElementNode;
(function (CompositeTreeElementNode) {
    function is(node) {
        return TreeElementNode.is(node) && tree_1.CompositeTreeNode.is(node) && tree_1.ExpandableTreeNode.is(node) && !!node.visible;
    }
    CompositeTreeElementNode.is = is;
})(CompositeTreeElementNode || (exports.CompositeTreeElementNode = CompositeTreeElementNode = {}));
var TreeSourceNode;
(function (TreeSourceNode) {
    function is(node) {
        return tree_1.CompositeTreeNode.is(node) && !node.visible && 'source' in node;
    }
    TreeSourceNode.is = is;
    function to(source) {
        if (!source) {
            return source;
        }
        const id = source.id || '__source__';
        return {
            id,
            name: id,
            visible: false,
            children: [],
            source,
            parent: undefined,
            selected: false
        };
    }
    TreeSourceNode.to = to;
})(TreeSourceNode || (exports.TreeSourceNode = TreeSourceNode = {}));


/***/ }),

/***/ "../../node_modules/@theia/core/lib/browser/source-tree/tree-source.js":
/*!*****************************************************************************!*\
  !*** ../../node_modules/@theia/core/lib/browser/source-tree/tree-source.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TreeSource = exports.CompositeTreeElement = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! inversify */ "../../node_modules/inversify/lib/cjs/index.js");
const common_1 = __webpack_require__(/*! ../../common */ "../../node_modules/@theia/core/lib/common/index.js");
var CompositeTreeElement;
(function (CompositeTreeElement) {
    function is(element) {
        return (0, common_1.isObject)(element) && 'getElements' in element;
    }
    CompositeTreeElement.is = is;
    function hasElements(element) {
        return is(element) && element.hasElements !== false;
    }
    CompositeTreeElement.hasElements = hasElements;
})(CompositeTreeElement || (exports.CompositeTreeElement = CompositeTreeElement = {}));
let TreeSource = class TreeSource {
    fireDidChange() {
        this.onDidChangeEmitter.fire(undefined);
    }
    constructor(options = {}) {
        this.onDidChangeEmitter = new common_1.Emitter();
        this.onDidChange = this.onDidChangeEmitter.event;
        this.toDispose = new common_1.DisposableCollection(this.onDidChangeEmitter);
        this.id = options.id;
        this.placeholder = options.placeholder;
    }
    dispose() {
        this.toDispose.dispose();
    }
};
exports.TreeSource = TreeSource;
exports.TreeSource = TreeSource = tslib_1.__decorate([
    (0, inversify_1.injectable)(),
    tslib_1.__param(0, (0, inversify_1.unmanaged)()),
    tslib_1.__metadata("design:paramtypes", [Object])
], TreeSource);


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_console_lib_browser_console-widget_js.js.map