/// <reference types="node" />
/*********************************************************************
 * Copyright (c) 2024 Renesas Electronics Corporation and others
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *********************************************************************/
import { AttachRequestArguments, LaunchRequestArguments } from '../../types/session';
import { ChildProcess } from 'child_process';
import { GDBFileSystemProcessManagerBase } from './GDBFileSystemProcessManagerBase';
import { IGDBProcessManager, IStdioProcess } from '../../types/gdb';
export declare class GDBFileSystemProcessManager extends GDBFileSystemProcessManagerBase implements IGDBProcessManager {
    protected proc?: ChildProcess;
    gdbVersion?: string;
    protected token: number;
    protected requestArgs?: LaunchRequestArguments | AttachRequestArguments;
    constructor();
    protected getGdbCwd(requestArgs: LaunchRequestArguments | AttachRequestArguments): string;
    getVersion(requestArgs?: LaunchRequestArguments | AttachRequestArguments): Promise<string>;
    start(requestArgs: LaunchRequestArguments | AttachRequestArguments): Promise<IStdioProcess>;
    stop(): Promise<void>;
}
