/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.plugin.internal;

import com.microsoft.java.debug.core.DebugException;
import com.microsoft.java.debug.core.StackFrameUtility;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.sourcelookup.containers.JavaProjectSourceContainer;
import org.eclipse.jdt.launching.sourcelookup.containers.PackageFragmentRootSourceContainer;

public class JdtUtils {
    private static final String TEST_SCOPE = "test";
    private static final String MAVEN_SCOPE_ATTRIBUTE = "maven.scope";
    private static final String GRADLE_SCOPE_ATTRIBUTE = "gradle_scope";

    public static String getModuleName(IJavaProject project) {
        IModuleDescription module;
        if (project == null || !JavaRuntime.isModularProject((IJavaProject)project)) {
            return null;
        }
        try {
            module = project.getModuleDescription();
        }
        catch (CoreException coreException) {
            return null;
        }
        return module == null ? null : module.getElementName();
    }

    public static boolean isJavaProject(IProject project) {
        if (project == null || !project.exists()) {
            return false;
        }
        try {
            return project.isNatureEnabled("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static IJavaProject getJavaProject(IProject project) {
        if (JdtUtils.isJavaProject(project)) {
            return JavaCore.create((IProject)project);
        }
        return null;
    }

    public static IJavaProject getJavaProject(String projectName) {
        if (StringUtils.isBlank((CharSequence)projectName)) {
            return null;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        return JdtUtils.getJavaProject(project);
    }

    public static List<IJavaProject> listJavaProjects(IWorkspaceRoot workspace) {
        ArrayList<IJavaProject> results = new ArrayList<IJavaProject>();
        IProject[] iProjectArray = workspace.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (JdtUtils.isJavaProject(project)) {
                results.add(JavaCore.create((IProject)project));
            }
            ++n2;
        }
        return results;
    }

    public static IProject getProject(String projectName) {
        if (StringUtils.isBlank((CharSequence)projectName)) {
            return null;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        return root.getProject(projectName);
    }

    public static IPackageFragmentRoot[] getTestPackageFragmentRoots(IJavaProject project) {
        try {
            IPackageFragmentRoot[] packageFragmentRoot = project.getPackageFragmentRoots();
            ArrayList<IPackageFragmentRoot> sources = new ArrayList<IPackageFragmentRoot>();
            int i = 0;
            while (i < packageFragmentRoot.length) {
                IClasspathEntry cpe;
                if (packageFragmentRoot[i].getElementType() == 3 && packageFragmentRoot[i].getKind() == 1 && JdtUtils.isTest(cpe = packageFragmentRoot[i].getResolvedClasspathEntry())) {
                    sources.add(packageFragmentRoot[i]);
                }
                ++i;
            }
            return sources.toArray(new IPackageFragmentRoot[0]);
        }
        catch (JavaModelException javaModelException) {
            return new IPackageFragmentRoot[0];
        }
    }

    public static boolean isTest(IClasspathEntry classpathEntry) {
        IClasspathAttribute[] iClasspathAttributeArray = classpathEntry.getExtraAttributes();
        int n = iClasspathAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathAttribute attribute = iClasspathAttributeArray[n2];
            if (GRADLE_SCOPE_ATTRIBUTE.equals(attribute.getName()) || MAVEN_SCOPE_ATTRIBUTE.equals(attribute.getName())) {
                return TEST_SCOPE.equals(attribute.getValue());
            }
            ++n2;
        }
        return classpathEntry.isTest();
    }

    public static ISourceContainer[] getSourceContainers(String projectName) {
        LinkedHashSet containers = new LinkedHashSet();
        ArrayList<IProject> projects = new ArrayList<IProject>();
        IProject targetProject = JdtUtils.getProject(projectName);
        if (targetProject != null) {
            projects.add(targetProject);
        }
        List<IProject> workspaceProjects = Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects());
        projects.addAll(workspaceProjects);
        LinkedHashSet calculated = new LinkedHashSet();
        projects.stream().distinct().map(project -> JdtUtils.getJavaProject(project)).filter(javaProject -> javaProject != null && javaProject.exists()).forEach(javaProject -> {
            containers.add(new JavaProjectSourceContainer(javaProject));
            containers.addAll(Arrays.asList(JdtUtils.getSourceContainers(javaProject, calculated)));
        });
        return containers.toArray(new ISourceContainer[0]);
    }

    private static ISourceContainer[] getSourceContainers(IJavaProject project, Set<IRuntimeClasspathEntry> calculated) {
        if (project == null || !project.exists()) {
            return new ISourceContainer[0];
        }
        try {
            int n;
            IRuntimeClasspathEntry[] unresolved = JavaRuntime.computeUnresolvedRuntimeClasspath((IJavaProject)project);
            ArrayList<IRuntimeClasspathEntry> resolved = new ArrayList<IRuntimeClasspathEntry>();
            IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray = unresolved;
            int n2 = unresolved.length;
            int n3 = 0;
            while (n3 < n2) {
                IRuntimeClasspathEntry entry2 = iRuntimeClasspathEntryArray[n3];
                IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray2 = JavaRuntime.resolveRuntimeClasspathEntry((IRuntimeClasspathEntry)entry2, (IJavaProject)project);
                int n4 = iRuntimeClasspathEntryArray2.length;
                n = 0;
                while (n < n4) {
                    IRuntimeClasspathEntry resolvedEntry = iRuntimeClasspathEntryArray2[n];
                    if (!calculated.contains(resolvedEntry)) {
                        calculated.add(resolvedEntry);
                        resolved.add(resolvedEntry);
                    }
                    ++n;
                }
                ++n3;
            }
            LinkedHashSet<Object> containers = new LinkedHashSet<Object>();
            containers.addAll(Arrays.asList(JavaRuntime.getSourceContainers((IRuntimeClasspathEntry[])resolved.toArray(new IRuntimeClasspathEntry[0]))));
            IRuntimeClasspathEntry jrtFs = resolved.stream().filter(entry -> entry.getType() == 2 && entry.getPath().lastSegment().equals("jrt-fs.jar")).findFirst().orElse(null);
            if (jrtFs != null && project.isOpen()) {
                IPackageFragmentRoot[] allRoots;
                IPackageFragmentRoot[] iPackageFragmentRootArray = allRoots = project.getPackageFragmentRoots();
                n = allRoots.length;
                int n5 = 0;
                while (n5 < n) {
                    IPackageFragmentRoot root = iPackageFragmentRootArray[n5];
                    if (root.getPath().equals((Object)jrtFs.getPath()) && JdtUtils.isSourceAttachmentEqual(root, jrtFs)) {
                        containers.add(new PackageFragmentRootSourceContainer(root));
                    }
                    ++n5;
                }
            }
            return containers.toArray(new ISourceContainer[0]);
        }
        catch (CoreException coreException) {
            return new ISourceContainer[0];
        }
    }

    private static boolean isSourceAttachmentEqual(IPackageFragmentRoot root, IRuntimeClasspathEntry entry) throws JavaModelException {
        IPath entryPath = entry.getSourceAttachmentPath();
        if (entryPath == null) {
            return true;
        }
        IPath rootPath = root.getSourceAttachmentPath();
        if (rootPath == null) {
            return false;
        }
        return rootPath.equals((Object)entryPath);
    }

    public static Object findSourceElement(String sourcePath, ISourceContainer[] containers) {
        if (containers == null) {
            return null;
        }
        ISourceContainer[] iSourceContainerArray = containers;
        int n = containers.length;
        int n2 = 0;
        while (n2 < n) {
            ISourceContainer container = iSourceContainerArray[n2];
            try {
                Object[] objects = container.findSourceElements(sourcePath);
                if (objects.length > 0 && (objects[0] instanceof IResource || objects[0] instanceof IClassFile)) {
                    return objects[0];
                }
            }
            catch (CoreException coreException) {}
            ++n2;
        }
        return null;
    }

    public static IJavaProject findProject(StackFrame stackFrame, ISourceContainer[] containers) {
        Location location = stackFrame.location();
        try {
            IJavaProject javaProject;
            Object sourceElement = JdtUtils.findSourceElement(location.sourcePath(), containers);
            if (sourceElement instanceof IResource) {
                return JavaCore.create((IProject)((IResource)sourceElement).getProject());
            }
            if (sourceElement instanceof IClassFile && (javaProject = ((IClassFile)sourceElement).getJavaProject()) != null) {
                return javaProject;
            }
        }
        catch (AbsentInformationException absentInformationException) {}
        return null;
    }

    public static String getDeclaringTypeName(StackFrame frame) throws DebugException {
        return JdtUtils.getGenericName(StackFrameUtility.getDeclaringType((StackFrame)frame));
    }

    private static String getGenericName(ReferenceType type) throws DebugException {
        String[] typeParameters;
        if (type instanceof ArrayType) {
            try {
                Type componentType = ((ArrayType)type).componentType();
                if (componentType instanceof ReferenceType) {
                    return String.valueOf(JdtUtils.getGenericName((ReferenceType)componentType)) + "[]";
                }
                return type.name();
            }
            catch (ClassNotLoadedException classNotLoadedException) {}
        }
        String signature = type.signature();
        StringBuffer res = new StringBuffer(JdtUtils.getTypeName(signature));
        String genericSignature = type.genericSignature();
        if (genericSignature != null && (typeParameters = Signature.getTypeParameters((String)genericSignature)).length > 0) {
            res.append('<').append(Signature.getTypeVariable((String)typeParameters[0]));
            int i = 1;
            while (i < typeParameters.length) {
                res.append(',').append(Signature.getTypeVariable((String)typeParameters[i]));
                ++i;
            }
            res.append('>');
        }
        return res.toString();
    }

    private static String getTypeName(String genericTypeSignature) {
        int arrayDimension = 0;
        while (genericTypeSignature.charAt(arrayDimension) == '[') {
            ++arrayDimension;
        }
        int parameterStart = genericTypeSignature.indexOf(60);
        StringBuffer name = new StringBuffer();
        if (parameterStart < 0) {
            name.append(genericTypeSignature.substring(arrayDimension + 1, genericTypeSignature.length() - 1).replace('/', '.'));
        } else {
            if (parameterStart != 0) {
                name.append(genericTypeSignature.substring(arrayDimension + 1, parameterStart).replace('/', '.'));
            }
            try {
                String sig = Signature.toString((String)genericTypeSignature).substring(Math.max(parameterStart - 1, 0) - arrayDimension);
                name.append(sig.replace('/', '.'));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                name.append(genericTypeSignature);
            }
        }
        int i = 0;
        while (i < arrayDimension) {
            name.append("[]");
            ++i;
        }
        return name.toString();
    }

    public static boolean isSameFile(IResource resource1, IResource resource2) {
        if (resource1 == null || resource2 == null) {
            return false;
        }
        if (Objects.equals(resource1, resource2)) {
            return true;
        }
        return Objects.equals(resource1.getLocation(), resource2.getLocation());
    }
}

