/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.nls;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.formatter.IndentManipulation;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSElement;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSLine;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSScanner;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Region;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.TextEdit;

public class NLSUtil {
    private NLSUtil() {
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String readString(InputStream is, String encoding) {
        if (is == null) {
            return null;
        }
        BufferedReader reader = null;
        StringBuilder buffer = new StringBuilder();
        char[] part = new char[2048];
        int read = 0;
        reader = new BufferedReader(new InputStreamReader(is, encoding));
        while ((read = reader.read(part)) != -1) {
            buffer.append(part, 0, read);
        }
        String string = buffer.toString();
        if (reader == null) return string;
        try {
            reader.close();
            return string;
        }
        catch (IOException iOException) {}
        return string;
        catch (IOException iOException) {
            try {
                if (reader == null) return null;
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                reader.close();
                return null;
            }
            catch (IOException iOException3) {}
            return null;
        }
    }

    public static TextEdit createNLSEdit(ICompilationUnit cu, int position) throws CoreException {
        NLSLine nlsLine = NLSUtil.scanCurrentLine(cu, position);
        if (nlsLine == null) {
            return null;
        }
        NLSElement element = NLSUtil.findElement(nlsLine, position);
        if (element.hasTag()) {
            return null;
        }
        NLSElement[] elements = nlsLine.getElements();
        int indexInElementList = Arrays.asList(elements).indexOf(element);
        int editOffset = NLSUtil.computeInsertOffset(elements, indexInElementList, cu);
        String editText = String.valueOf(' ') + NLSElement.createTagText(indexInElementList + 1);
        return new InsertEdit(editOffset, editText);
    }

    public static TextEdit[] createNLSEdits(ICompilationUnit cu, int[] positions) throws CoreException {
        ArrayList<InsertEdit> result = new ArrayList<InsertEdit>();
        try {
            NLSLine[] nLSLineArray = NLSScanner.scan(cu);
            int n = nLSLineArray.length;
            int n2 = 0;
            while (n2 < n) {
                NLSLine line = nLSLineArray[n2];
                NLSElement[] elements = line.getElements();
                int j = 0;
                while (j < elements.length) {
                    NLSElement element = elements[j];
                    if (!element.hasTag()) {
                        int[] nArray = positions;
                        int n3 = positions.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            int position = nArray[n4];
                            if (NLSUtil.isPositionInElement(element, position)) {
                                int editOffset;
                                if (j == 0) {
                                    if (elements.length > j + 1) {
                                        editOffset = elements[j + 1].getTagPosition().getOffset();
                                    } else {
                                        editOffset = NLSUtil.findLineEnd(cu, element.getPosition().getOffset());
                                        if (editOffset < element.getPosition().getOffset() + element.getPosition().getLength()) {
                                            editOffset = NLSUtil.findLineEnd(cu, element.getPosition().getOffset() + element.getPosition().getLength());
                                        }
                                    }
                                } else {
                                    Region previousPosition = elements[j - 1].getTagPosition();
                                    editOffset = previousPosition.getOffset() + previousPosition.getLength();
                                }
                                String editText = String.valueOf(' ') + NLSElement.createTagText(j + 1);
                                result.add(new InsertEdit(editOffset, editText));
                            }
                            ++n4;
                        }
                    }
                    ++j;
                }
                ++n2;
            }
        }
        catch (InvalidInputException | BadLocationException throwable) {
            return null;
        }
        if (result.isEmpty()) {
            return null;
        }
        return result.toArray(new TextEdit[result.size()]);
    }

    public static NLSLine scanCurrentLine(ICompilationUnit cu, int position) throws JavaModelException {
        try {
            Assert.isTrue((position >= 0 && position <= cu.getBuffer().getLength() ? 1 : 0) != 0);
            NLSLine[] nLSLineArray = NLSScanner.scan(cu);
            int n = nLSLineArray.length;
            int n2 = 0;
            while (n2 < n) {
                NLSLine line = nLSLineArray[n2];
                if (NLSUtil.findElement(line, position) != null) {
                    return line;
                }
                ++n2;
            }
            return null;
        }
        catch (InvalidInputException | BadLocationException throwable) {
            return null;
        }
    }

    private static boolean isPositionInElement(NLSElement element, int position) {
        Region elementPosition = element.getPosition();
        return elementPosition.getOffset() <= position && position <= elementPosition.getOffset() + elementPosition.getLength();
    }

    private static NLSElement findElement(NLSLine line, int position) {
        NLSElement[] nLSElementArray = line.getElements();
        int n = nLSElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            NLSElement element = nLSElementArray[n2];
            if (NLSUtil.isPositionInElement(element, position)) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    private static int computeInsertOffset(NLSElement[] elements, int index, ICompilationUnit cu) throws CoreException {
        NLSElement previousTagged = NLSUtil.findPreviousTagged(index, elements);
        if (previousTagged != null) {
            return previousTagged.getTagPosition().getOffset() + previousTagged.getTagPosition().getLength();
        }
        NLSElement nextTagged = NLSUtil.findNextTagged(index, elements);
        if (nextTagged != null) {
            return nextTagged.getTagPosition().getOffset();
        }
        Region position = elements[index].getPosition();
        int lineEnd = NLSUtil.findLineEnd(cu, position.getOffset());
        if (lineEnd < position.getOffset() + position.getLength()) {
            lineEnd = NLSUtil.findLineEnd(cu, position.getOffset() + position.getLength());
        }
        return lineEnd;
    }

    private static NLSElement findPreviousTagged(int startIndex, NLSElement[] elements) {
        int i = startIndex - 1;
        while (i >= 0) {
            if (elements[i].hasTag()) {
                return elements[i];
            }
            --i;
        }
        return null;
    }

    private static NLSElement findNextTagged(int startIndex, NLSElement[] elements) {
        int i = startIndex + 1;
        while (i < elements.length) {
            if (elements[i].hasTag()) {
                return elements[i];
            }
            ++i;
        }
        return null;
    }

    private static int findLineEnd(ICompilationUnit cu, int position) throws JavaModelException {
        IBuffer buffer = cu.getBuffer();
        int length = buffer.getLength();
        int i = position;
        while (i < length) {
            if (IndentManipulation.isLineDelimiterChar((char)buffer.getChar(i))) {
                return i;
            }
            ++i;
        }
        return length;
    }

    public static int getInsertionPosition(String key, List<String> keys) {
        int result = 0;
        int invertDistance = Integer.MIN_VALUE;
        int i = 0;
        for (String string : keys) {
            int currentInvertDistance = NLSUtil.invertDistance(key, string);
            if (currentInvertDistance > invertDistance) {
                invertDistance = currentInvertDistance;
                result = Collator.getInstance().compare(key, string) >= 0 ? i : i - 1;
            } else if (currentInvertDistance == invertDistance && Collator.getInstance().compare(key, string) >= 0) {
                result = i;
            }
            ++i;
        }
        return result;
    }

    public static int invertDistance(String insertKey, String existingKey) {
        int existingKeyLength = existingKey.length();
        int insertKeyLength = insertKey.length();
        int minLen = Math.min(insertKeyLength, existingKeyLength);
        int prefixMatchCount = 0;
        int i = 0;
        while (i < minLen) {
            if (insertKey.charAt(i) == existingKey.charAt(i)) {
                ++prefixMatchCount;
            } else {
                return prefixMatchCount << 16;
            }
            ++i;
        }
        if (insertKeyLength > existingKeyLength && NLSUtil.isSeparator(insertKey.charAt(existingKeyLength))) {
            return prefixMatchCount + 1 << 16;
        }
        int existingLonger = existingKeyLength - insertKeyLength;
        return (prefixMatchCount << 16) - Math.max(0, existingLonger);
    }

    private static boolean isSeparator(char ch) {
        return ch == '.' || ch == '-' || ch == '_';
    }
}

