/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.text.correction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.CreationReference;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodReference;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SuperMethodReference;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchExpression;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeMethodReference;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.UnionType;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.manipulation.CodeStyleConfiguration;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.core.manipulation.util.Strings;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility2Core;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.CodeScopeBuilder;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;
import org.eclipse.jdt.internal.corext.dom.JdtASTMatcher;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.fix.StringConcatToTextBlockFixCore;
import org.eclipse.jdt.internal.corext.fix.SwitchExpressionsFixCore;
import org.eclipse.jdt.internal.corext.refactoring.surround.SurroundWithTryWithResourcesAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.surround.SurroundWithTryWithResourcesRefactoringCore;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.text.correction.IProblemLocationCore;
import org.eclipse.jdt.internal.ui.text.correction.QuickAssistProcessorUtil;
import org.eclipse.jdt.ls.core.internal.Messages;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.code.ExtractMethodRefactoring;
import org.eclipse.jdt.ls.core.internal.corrections.CorrectionMessages;
import org.eclipse.jdt.ls.core.internal.corrections.IInvocationContext;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.AssignToVariableAssistProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.ChangeCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.JavadocTagsSubProcessor;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.LinkedCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.RefactoringCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.text.correction.RefactorProposalUtility;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.ltk.core.refactoring.Change;

public class QuickAssistProcessor {
    public static final String SPLIT_JOIN_VARIABLE_DECLARATION_ID = "org.eclipse.jdt.ls.correction.splitJoinVariableDeclaration.assist";
    public static final String CONVERT_FOR_LOOP_ID = "org.eclipse.jdt.ls.correction.convertForLoop.assist";
    public static final String ASSIGN_TO_LOCAL_ID = "org.eclipse.jdt.ls.correction.assignToLocal.assist";
    public static final String ASSIGN_TO_FIELD_ID = "org.eclipse.jdt.ls.correction.assignToField.assist";
    public static final String ASSIGN_PARAM_TO_FIELD_ID = "org.eclipse.jdt.ls.correction.assignParamToField.assist";
    public static final String ASSIGN_ALL_PARAMS_TO_NEW_FIELDS_ID = "org.eclipse.jdt.ls.correction.assignAllParamsToNewFields.assist";
    public static final String ADD_BLOCK_ID = "org.eclipse.jdt.ls.correction.addBlock.assist";
    public static final String EXTRACT_LOCAL_ID = "org.eclipse.jdt.ls.correction.extractLocal.assist";
    public static final String EXTRACT_LOCAL_NOT_REPLACE_ID = "org.eclipse.jdt.ls.correction.extractLocalNotReplaceOccurrences.assist";
    public static final String EXTRACT_CONSTANT_ID = "org.eclipse.jdt.ls.correction.extractConstant.assist";
    public static final String INLINE_LOCAL_ID = "org.eclipse.jdt.ls.correction.inlineLocal.assist";
    public static final String CONVERT_LOCAL_TO_FIELD_ID = "org.eclipse.jdt.ls.correction.convertLocalToField.assist";
    public static final String CONVERT_ANONYMOUS_TO_LOCAL_ID = "org.eclipse.jdt.ls.correction.convertAnonymousToLocal.assist";
    public static final String CONVERT_TO_STRING_BUFFER_ID = "org.eclipse.jdt.ls.correction.convertToStringBuffer.assist";
    public static final String CONVERT_TO_MESSAGE_FORMAT_ID = "org.eclipse.jdt.ls.correction.convertToMessageFormat.assist";
    public static final String EXTRACT_METHOD_INPLACE_ID = "org.eclipse.jdt.ls.correction.extractMethodInplace.assist";
    private PreferenceManager preferenceManager;

    public QuickAssistProcessor(PreferenceManager preferenceManager) {
        this.preferenceManager = preferenceManager;
    }

    public List<ChangeCorrectionProposal> getAssists(CodeActionParams params, IInvocationContext context, IProblemLocationCore[] locations) throws CoreException {
        ASTNode coveringNode = context.getCoveringNode();
        if (coveringNode != null) {
            ArrayList<ChangeCorrectionProposal> resultingCollections = new ArrayList<ChangeCorrectionProposal>();
            QuickAssistProcessor.getAssignParamToFieldProposals(context, coveringNode, resultingCollections);
            QuickAssistProcessor.getAssignAllParamsToFieldsProposals(context, coveringNode, resultingCollections);
            boolean problemsAtLocation = locations.length != 0;
            QuickAssistProcessor.getExtractMethodFromLambdaProposal(context, coveringNode, problemsAtLocation, resultingCollections);
            QuickAssistProcessor.getConvertMethodReferenceToLambdaProposal(context, coveringNode, resultingCollections);
            QuickAssistProcessor.getConvertLambdaToMethodReferenceProposal(context, coveringNode, resultingCollections);
            QuickAssistProcessor.getStringConcatToTextBlockProposal(context, coveringNode, resultingCollections);
            QuickAssistProcessor.getAddMethodDeclaration(context, coveringNode, resultingCollections);
            QuickAssistProcessor.getTryWithResourceProposals(locations, context, coveringNode, resultingCollections);
            QuickAssistProcessor.getConvertToSwitchExpressionProposals(context, coveringNode, resultingCollections);
            List<Integer> javaDocCommentProblems = Arrays.asList(-1610612250);
            if (!QuickAssistProcessor.problemExists(locations, javaDocCommentProblems)) {
                JavadocTagsSubProcessor.getMissingJavadocCommentProposals(context, coveringNode, resultingCollections, "quickassist");
            }
            return resultingCollections;
        }
        return Collections.emptyList();
    }

    private static boolean getExtractMethodFromLambdaProposal(IInvocationContext context, ASTNode coveringNode, boolean problemsAtLocation, Collection<ChangeCorrectionProposal> proposals) throws CoreException {
        if (coveringNode instanceof Block && coveringNode.getLocationInParent() == LambdaExpression.BODY_PROPERTY) {
            return false;
        }
        ASTNode node = ASTNodes.getFirstAncestorOrNull((ASTNode)coveringNode, LambdaExpression.class, (Class[])new Class[]{BodyDeclaration.class});
        if (!(node instanceof LambdaExpression)) {
            return false;
        }
        ASTNode body = ((LambdaExpression)node).getBody();
        ICompilationUnit cu = context.getCompilationUnit();
        ExtractMethodRefactoring extractMethodRefactoring = new ExtractMethodRefactoring(context.getASTRoot(), body.getStartPosition(), body.getLength());
        String uniqueMethodName = RefactorProposalUtility.getUniqueMethodName(coveringNode, "extracted");
        extractMethodRefactoring.setMethodName(uniqueMethodName);
        if (extractMethodRefactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
            if (proposals == null) {
                return true;
            }
            String label = CorrectionMessages.QuickAssistProcessor_extractmethod_from_lambda_description;
            LinkedProposalModelCore linkedProposalModel = new LinkedProposalModelCore();
            extractMethodRefactoring.setLinkedProposalModel(linkedProposalModel);
            int relevance = problemsAtLocation ? 1 : 3;
            RefactoringCorrectionProposal proposal = new RefactoringCorrectionProposal(label, "quickassist", cu, extractMethodRefactoring, relevance);
            proposal.setLinkedProposalModel(linkedProposalModel);
            proposals.add(proposal);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean getAssignParamToFieldProposals(IInvocationContext context, ASTNode node, Collection<ChangeCorrectionProposal> resultingCollections) {
        ASTNode parent = (node = ASTNodes.getNormalizedNode((ASTNode)node)).getParent();
        if (!(parent instanceof SingleVariableDeclaration) || !(parent.getParent() instanceof MethodDeclaration)) {
            return false;
        }
        SingleVariableDeclaration paramDecl = (SingleVariableDeclaration)parent;
        IVariableBinding binding = paramDecl.resolveBinding();
        MethodDeclaration methodDecl = (MethodDeclaration)parent.getParent();
        if (binding == null || methodDecl.getBody() == null) {
            return false;
        }
        ITypeBinding typeBinding = binding.getType();
        if (typeBinding == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        ITypeBinding parentType = Bindings.getBindingOfParentType((ASTNode)node);
        if (parentType != null) {
            if (parentType.isInterface()) {
                return false;
            }
            CompilationUnit root = context.getASTRoot();
            IVariableBinding[] declaredFields = parentType.getDeclaredFields();
            boolean isStaticContext = ASTResolving.isInStaticContext((ASTNode)node);
            int i = 0;
            while (i < declaredFields.length) {
                ASTNode fieldDeclFrag;
                ASTNode aSTNode;
                IVariableBinding curr = declaredFields[i];
                if (isStaticContext == Modifier.isStatic((int)curr.getModifiers()) && typeBinding.isAssignmentCompatible(curr.getType()) && (aSTNode = (fieldDeclFrag = root.findDeclaringNode((IBinding)curr))) instanceof VariableDeclarationFragment) {
                    void fragment;
                    VariableDeclarationFragment cfr_ignored_0 = (VariableDeclarationFragment)aSTNode;
                    VariableDeclarationFragment cfr_ignored_1 = (VariableDeclarationFragment)aSTNode;
                    if (fragment.getInitializer() == null) {
                        resultingCollections.add(new AssignToVariableAssistProposal(context.getCompilationUnit(), paramDecl, (VariableDeclarationFragment)fragment, typeBinding, 1));
                    }
                }
                ++i;
            }
        }
        AssignToVariableAssistProposal fieldProposal = new AssignToVariableAssistProposal(context.getCompilationUnit(), paramDecl, null, typeBinding, 3);
        resultingCollections.add(fieldProposal);
        return true;
    }

    private static boolean getAssignAllParamsToFieldsProposals(IInvocationContext context, ASTNode node, Collection<ChangeCorrectionProposal> resultingCollections) {
        ASTNode parent = (node = ASTNodes.getNormalizedNode((ASTNode)node)).getParent();
        if (!(parent instanceof SingleVariableDeclaration) || !(parent.getParent() instanceof MethodDeclaration)) {
            return false;
        }
        MethodDeclaration methodDecl = (MethodDeclaration)parent.getParent();
        if (methodDecl.getBody() == null) {
            return false;
        }
        List parameters = methodDecl.parameters();
        if (parameters.size() <= 1) {
            return false;
        }
        ITypeBinding parentType = Bindings.getBindingOfParentType((ASTNode)node);
        if (parentType == null || parentType.isInterface()) {
            return false;
        }
        for (SingleVariableDeclaration param : parameters) {
            IVariableBinding binding = param.resolveBinding();
            if (binding != null && binding.getType() != null) continue;
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AssignToVariableAssistProposal fieldProposal = new AssignToVariableAssistProposal(context.getCompilationUnit(), parameters, 2);
        resultingCollections.add(fieldProposal);
        return true;
    }

    public static ArrayList<ASTNode> getFullyCoveredNodes(IInvocationContext context, ASTNode coveringNode) {
        final ArrayList<ASTNode> coveredNodes = new ArrayList<ASTNode>();
        final int selectionBegin = context.getSelectionOffset();
        final int selectionEnd = selectionBegin + context.getSelectionLength();
        coveringNode.accept((ASTVisitor)new GenericVisitor(){

            protected boolean visitNode(ASTNode node) {
                ASTNode parent;
                int nodeStart = node.getStartPosition();
                int nodeEnd = nodeStart + node.getLength();
                if (nodeEnd < selectionBegin || selectionEnd < nodeStart) {
                    return false;
                }
                if (this.isCovered(node) && ((parent = node.getParent()) == null || !this.isCovered(parent))) {
                    coveredNodes.add(node);
                    return false;
                }
                return true;
            }

            private boolean isCovered(ASTNode node) {
                int begin = node.getStartPosition();
                int end = begin + node.getLength();
                return begin >= selectionBegin && end <= selectionEnd;
            }
        });
        return coveredNodes;
    }

    public static IMethodBinding getFunctionalMethodForMethodReference(MethodReference methodReference) {
        ITypeBinding targetTypeBinding = ASTNodes.getTargetType((Expression)methodReference);
        if (targetTypeBinding == null) {
            return null;
        }
        IMethodBinding functionalMethod = targetTypeBinding.getFunctionalInterfaceMethod();
        if (functionalMethod != null && functionalMethod.isSynthetic()) {
            functionalMethod = Bindings.findOverriddenMethodInType((ITypeBinding)functionalMethod.getDeclaringClass(), (IMethodBinding)functionalMethod);
        }
        return functionalMethod;
    }

    /*
     * WARNING - void declaration
     */
    public static LambdaExpression convertMethodRefernceToLambda(MethodReference methodReference, IMethodBinding functionalMethod, CompilationUnit astRoot, ASTRewrite rewrite, LinkedProposalModelCore linkedProposalModel, boolean createBlockBody) throws JavaModelException {
        SimpleName name;
        AST ast = astRoot.getAST();
        LambdaExpression lambda = ast.newLambdaExpression();
        String[] lambdaParamNames = QuickAssistProcessor.getUniqueParameterNames(methodReference, functionalMethod);
        List lambdaParameters = lambda.parameters();
        int i = 0;
        while (i < lambdaParamNames.length) {
            String paramName = lambdaParamNames[i];
            VariableDeclarationFragment lambdaParameter = ast.newVariableDeclarationFragment();
            name = ast.newSimpleName(paramName);
            lambdaParameter.setName(name);
            lambdaParameters.add(lambdaParameter);
            if (linkedProposalModel != null) {
                linkedProposalModel.getPositionGroup(name.getIdentifier(), true).addPosition(rewrite.track((ASTNode)name), i == 0);
            }
            ++i;
        }
        int noOfLambdaParameters = lambdaParamNames.length;
        lambda.setParentheses(noOfLambdaParameters != 1);
        ITypeBinding returnTypeBinding = functionalMethod.getReturnType();
        IMethodBinding referredMethodBinding = methodReference.resolveMethodBinding();
        MethodReference methodReference2 = methodReference;
        if (methodReference2 instanceof CreationReference) {
            void creationRef;
            name = (CreationReference)methodReference2;
            CreationReference cfr_ignored_0 = (CreationReference)methodReference2;
            Type type = creationRef.getType();
            if (type instanceof ArrayType) {
                ArrayCreation arrayCreation = ast.newArrayCreation();
                if (createBlockBody) {
                    Block blockBody = QuickAssistProcessor.getBlockBodyForLambda((Expression)arrayCreation, returnTypeBinding, ast);
                    lambda.setBody((ASTNode)blockBody);
                } else {
                    lambda.setBody((ASTNode)arrayCreation);
                }
                ArrayType arrayType = (ArrayType)type;
                Type copiedElementType = (Type)rewrite.createCopyTarget((ASTNode)arrayType.getElementType());
                arrayCreation.setType(ast.newArrayType(copiedElementType, arrayType.getDimensions()));
                SimpleName name2 = ast.newSimpleName(lambdaParamNames[0]);
                arrayCreation.dimensions().add(name2);
                if (linkedProposalModel != null) {
                    linkedProposalModel.getPositionGroup(name2.getIdentifier(), false).addPosition(rewrite.track((ASTNode)name2), -1);
                }
            } else {
                ClassInstanceCreation cic = ast.newClassInstanceCreation();
                if (createBlockBody) {
                    Block blockBody = QuickAssistProcessor.getBlockBodyForLambda((Expression)cic, returnTypeBinding, ast);
                    lambda.setBody((ASTNode)blockBody);
                } else {
                    lambda.setBody((ASTNode)cic);
                }
                ITypeBinding typeBinding = type.resolveBinding();
                if (!(type instanceof ParameterizedType) && typeBinding != null && typeBinding.getTypeDeclaration().isGenericType()) {
                    cic.setType((Type)ast.newParameterizedType((Type)rewrite.createCopyTarget((ASTNode)type)));
                } else {
                    cic.setType((Type)rewrite.createCopyTarget((ASTNode)type));
                }
                List<SimpleName> invocationArgs = QuickAssistProcessor.getInvocationArguments(ast, 0, noOfLambdaParameters, lambdaParamNames);
                cic.arguments().addAll(invocationArgs);
                if (linkedProposalModel != null) {
                    for (SimpleName name3 : invocationArgs) {
                        linkedProposalModel.getPositionGroup(name3.getIdentifier(), false).addPosition(rewrite.track((ASTNode)name3), -1);
                    }
                }
                cic.typeArguments().addAll(QuickAssistProcessor.getCopiedTypeArguments(rewrite, methodReference.typeArguments()));
            }
        } else if (referredMethodBinding != null && Modifier.isStatic((int)referredMethodBinding.getModifiers())) {
            MethodInvocation methodInvocation = ast.newMethodInvocation();
            if (createBlockBody) {
                Block blockBody = QuickAssistProcessor.getBlockBodyForLambda((Expression)methodInvocation, returnTypeBinding, ast);
                lambda.setBody((ASTNode)blockBody);
            } else {
                lambda.setBody((ASTNode)methodInvocation);
            }
            Expression expr = null;
            boolean hasConflict = QuickAssistProcessor.hasConflict(methodReference.getStartPosition(), referredMethodBinding, 17, astRoot);
            if (hasConflict || !Bindings.isSuperType((ITypeBinding)referredMethodBinding.getDeclaringClass(), (ITypeBinding)ASTNodes.getEnclosingType((ASTNode)methodReference)) || methodReference.typeArguments().size() != 0) {
                MethodReference methodReference3 = methodReference;
                if (methodReference3 instanceof ExpressionMethodReference) {
                    void expressionMethodReference;
                    ExpressionMethodReference invocationArgs = (ExpressionMethodReference)methodReference3;
                    ExpressionMethodReference cfr_ignored_1 = (ExpressionMethodReference)methodReference3;
                    expr = (Expression)rewrite.createCopyTarget((ASTNode)expressionMethodReference.getExpression());
                } else {
                    MethodReference methodReference4 = methodReference;
                    if (methodReference4 instanceof TypeMethodReference) {
                        void typedMethodReference;
                        TypeMethodReference typeMethodReference = (TypeMethodReference)methodReference4;
                        TypeMethodReference cfr_ignored_2 = (TypeMethodReference)methodReference4;
                        Type type = typedMethodReference.getType();
                        ITypeBinding typeBinding = type.resolveBinding();
                        if (typeBinding != null) {
                            ImportRewrite importRewrite = CodeStyleConfiguration.createImportRewrite((CompilationUnit)astRoot, (boolean)true);
                            expr = ast.newName(importRewrite.addImport(typeBinding));
                        }
                    }
                }
            }
            methodInvocation.setExpression(expr);
            SimpleName methodName = QuickAssistProcessor.getMethodInvocationName(methodReference);
            methodInvocation.setName((SimpleName)rewrite.createCopyTarget((ASTNode)methodName));
            List<SimpleName> invocationArgs = QuickAssistProcessor.getInvocationArguments(ast, 0, noOfLambdaParameters, lambdaParamNames);
            methodInvocation.arguments().addAll(invocationArgs);
            if (linkedProposalModel != null) {
                for (SimpleName name4 : invocationArgs) {
                    linkedProposalModel.getPositionGroup(name4.getIdentifier(), false).addPosition(rewrite.track((ASTNode)name4), -1);
                }
            }
            methodInvocation.typeArguments().addAll(QuickAssistProcessor.getCopiedTypeArguments(rewrite, methodReference.typeArguments()));
        } else if (methodReference instanceof SuperMethodReference) {
            SuperMethodInvocation superMethodInvocation = ast.newSuperMethodInvocation();
            if (createBlockBody) {
                Block blockBody = QuickAssistProcessor.getBlockBodyForLambda((Expression)superMethodInvocation, returnTypeBinding, ast);
                lambda.setBody((ASTNode)blockBody);
            } else {
                lambda.setBody((ASTNode)superMethodInvocation);
            }
            Name superQualifier = ((SuperMethodReference)methodReference).getQualifier();
            if (superQualifier != null) {
                superMethodInvocation.setQualifier((Name)rewrite.createCopyTarget((ASTNode)superQualifier));
            }
            SimpleName methodName = QuickAssistProcessor.getMethodInvocationName(methodReference);
            superMethodInvocation.setName((SimpleName)rewrite.createCopyTarget((ASTNode)methodName));
            List<SimpleName> invocationArgs = QuickAssistProcessor.getInvocationArguments(ast, 0, noOfLambdaParameters, lambdaParamNames);
            superMethodInvocation.arguments().addAll(invocationArgs);
            if (linkedProposalModel != null) {
                for (SimpleName name5 : invocationArgs) {
                    linkedProposalModel.getPositionGroup(name5.getIdentifier(), false).addPosition(rewrite.track((ASTNode)name5), -1);
                }
            }
            superMethodInvocation.typeArguments().addAll(QuickAssistProcessor.getCopiedTypeArguments(rewrite, methodReference.typeArguments()));
        } else {
            MethodInvocation methodInvocation = ast.newMethodInvocation();
            if (createBlockBody) {
                Block blockBody = QuickAssistProcessor.getBlockBodyForLambda((Expression)methodInvocation, returnTypeBinding, ast);
                lambda.setBody((ASTNode)blockBody);
            } else {
                lambda.setBody((ASTNode)methodInvocation);
            }
            boolean isTypeReference = QuickAssistProcessor.isTypeReferenceToInstanceMethod(methodReference);
            if (isTypeReference) {
                SimpleName name6 = ast.newSimpleName(lambdaParamNames[0]);
                methodInvocation.setExpression((Expression)name6);
                if (linkedProposalModel != null) {
                    linkedProposalModel.getPositionGroup(name6.getIdentifier(), false).addPosition(rewrite.track((ASTNode)name6), -1);
                }
            } else {
                Expression expr = ((ExpressionMethodReference)methodReference).getExpression();
                if (!(expr instanceof ThisExpression) || methodReference.typeArguments().size() != 0) {
                    methodInvocation.setExpression((Expression)rewrite.createCopyTarget((ASTNode)expr));
                }
            }
            SimpleName methodName = QuickAssistProcessor.getMethodInvocationName(methodReference);
            methodInvocation.setName((SimpleName)rewrite.createCopyTarget((ASTNode)methodName));
            List<SimpleName> invocationArgs = QuickAssistProcessor.getInvocationArguments(ast, isTypeReference ? 1 : 0, noOfLambdaParameters, lambdaParamNames);
            methodInvocation.arguments().addAll(invocationArgs);
            if (linkedProposalModel != null) {
                for (SimpleName name7 : invocationArgs) {
                    linkedProposalModel.getPositionGroup(name7.getIdentifier(), false).addPosition(rewrite.track((ASTNode)name7), -1);
                }
            }
            methodInvocation.typeArguments().addAll(QuickAssistProcessor.getCopiedTypeArguments(rewrite, methodReference.typeArguments()));
        }
        rewrite.replace((ASTNode)methodReference, (ASTNode)lambda, null);
        return lambda;
    }

    private static boolean hasConflict(int startPosition, IMethodBinding referredMethodBinding, int flags, CompilationUnit cu) {
        ScopeAnalyzer analyzer = new ScopeAnalyzer(cu);
        IBinding[] declarationsInScope = analyzer.getDeclarationsInScope(startPosition, flags);
        int i = 0;
        while (i < declarationsInScope.length) {
            IBinding decl = declarationsInScope[i];
            if (decl.getName().equals(referredMethodBinding.getName()) && !referredMethodBinding.getMethodDeclaration().isEqualTo(decl)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static String[] getUniqueParameterNames(MethodReference methodReference, IMethodBinding functionalMethod) throws JavaModelException {
        String[] parameterNames = ((IMethod)functionalMethod.getJavaElement()).getParameterNames();
        ArrayList<String> oldNames = new ArrayList<String>(Arrays.asList(parameterNames));
        String[] newNames = new String[oldNames.size()];
        ArrayList<String> excludedNames = new ArrayList<String>(ASTNodes.getVisibleLocalVariablesInScope((ASTNode)methodReference));
        int i = 0;
        while (i < oldNames.size()) {
            String paramName = (String)oldNames.get(i);
            ArrayList<String> allNamesToExclude = new ArrayList<String>(excludedNames);
            allNamesToExclude.addAll(oldNames.subList(0, i));
            allNamesToExclude.addAll(oldNames.subList(i + 1, oldNames.size()));
            if (allNamesToExclude.contains(paramName)) {
                String newParamName = QuickAssistProcessor.createName(paramName, allNamesToExclude);
                excludedNames.add(newParamName);
                newNames[i] = newParamName;
            } else {
                newNames[i] = paramName;
            }
            ++i;
        }
        return newNames;
    }

    private static String createName(String candidate, List<String> excludedNames) {
        int i = 1;
        String result = candidate;
        while (excludedNames.contains(result)) {
            result = String.valueOf(candidate) + i++;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isTypeReferenceToInstanceMethod(MethodReference methodReference) {
        if (methodReference instanceof TypeMethodReference) {
            return true;
        }
        MethodReference methodReference2 = methodReference;
        if (methodReference2 instanceof ExpressionMethodReference) {
            void expressionMethodReference;
            Expression expression;
            ExpressionMethodReference expressionMethodReference2 = (ExpressionMethodReference)methodReference2;
            ExpressionMethodReference cfr_ignored_0 = (ExpressionMethodReference)methodReference2;
            Expression expression2 = expression = expressionMethodReference.getExpression();
            if (expression2 instanceof Name) {
                void name;
                Name name2 = (Name)expression2;
                Name cfr_ignored_1 = (Name)expression2;
                IBinding nameBinding = name.resolveBinding();
                if (nameBinding != null && nameBinding instanceof ITypeBinding) {
                    return true;
                }
            }
        }
        return false;
    }

    private static List<SimpleName> getInvocationArguments(AST ast, int begIndex, int noOfLambdaParameters, String[] lambdaParamNames) {
        ArrayList<SimpleName> args = new ArrayList<SimpleName>();
        int i = begIndex;
        while (i < noOfLambdaParameters) {
            args.add(ast.newSimpleName(lambdaParamNames[i]));
            ++i;
        }
        return args;
    }

    private static List<Type> getCopiedTypeArguments(ASTRewrite rewrite, List<Type> typeArguments) {
        ArrayList<Type> copiedTypeArgs = new ArrayList<Type>();
        for (Type typeArg : typeArguments) {
            copiedTypeArgs.add((Type)rewrite.createCopyTarget((ASTNode)typeArg));
        }
        return copiedTypeArgs;
    }

    /*
     * WARNING - void declaration
     */
    private static SimpleName getMethodInvocationName(MethodReference methodReference) {
        SimpleName name = null;
        MethodReference methodReference2 = methodReference;
        if (methodReference2 instanceof ExpressionMethodReference) {
            void expressionMethodReference;
            ExpressionMethodReference expressionMethodReference2 = (ExpressionMethodReference)methodReference2;
            ExpressionMethodReference cfr_ignored_0 = (ExpressionMethodReference)methodReference2;
            name = expressionMethodReference.getName();
        } else {
            MethodReference methodReference3 = methodReference;
            if (methodReference3 instanceof TypeMethodReference) {
                void typeMethodReference;
                TypeMethodReference typeMethodReference2 = (TypeMethodReference)methodReference3;
                TypeMethodReference cfr_ignored_1 = (TypeMethodReference)methodReference3;
                name = typeMethodReference.getName();
            } else {
                MethodReference methodReference4 = methodReference;
                if (methodReference4 instanceof SuperMethodReference) {
                    void superMethodReference;
                    SuperMethodReference superMethodReference2 = (SuperMethodReference)methodReference4;
                    SuperMethodReference cfr_ignored_2 = (SuperMethodReference)methodReference4;
                    name = superMethodReference.getName();
                }
            }
        }
        return name;
    }

    public static void changeLambdaBodyToBlock(LambdaExpression lambda, AST ast, ASTRewrite rewrite) {
        Expression bodyExpr = (Expression)rewrite.createMoveTarget(lambda.getBody());
        Block blockBody = QuickAssistProcessor.getBlockBodyForLambda(bodyExpr, lambda.resolveMethodBinding().getReturnType(), ast);
        rewrite.set((ASTNode)lambda, (StructuralPropertyDescriptor)LambdaExpression.BODY_PROPERTY, (Object)blockBody, null);
    }

    private static Block getBlockBodyForLambda(Expression bodyExpr, ITypeBinding returnTypeBinding, AST ast) {
        ExpressionStatement statementInBlockBody;
        if (ast.resolveWellKnownType("void").isEqualTo((IBinding)returnTypeBinding)) {
            ExpressionStatement expressionStatement;
            statementInBlockBody = expressionStatement = ast.newExpressionStatement(bodyExpr);
        } else {
            ReturnStatement returnStatement = ast.newReturnStatement();
            returnStatement.setExpression(bodyExpr);
            statementInBlockBody = returnStatement;
        }
        Block blockBody = ast.newBlock();
        blockBody.statements().add(statementInBlockBody);
        return blockBody;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean getCatchClauseToThrowsProposals(IInvocationContext context, ASTNode node, Collection<ChangeCorrectionProposal> resultingCollections) {
        ASTRewriteCorrectionProposal proposal;
        String label;
        ASTRewrite rewrite;
        BodyDeclaration bodyDeclaration;
        MethodDeclaration topMostName;
        ASTNode aSTNode;
        if (resultingCollections == null) {
            return true;
        }
        CatchClause catchClause = (CatchClause)ASTResolving.findAncestor((ASTNode)node, (int)12);
        if (catchClause == null) {
            return false;
        }
        Statement statement = ASTResolving.findParentStatement((ASTNode)node);
        if (statement != catchClause.getParent() && statement != catchClause.getBody()) {
            return false;
        }
        Type type = catchClause.getException().getType();
        if (!(type.isSimpleType() || type.isUnionType() || type.isNameQualifiedType())) {
            return false;
        }
        BodyDeclaration bodyDeclaration2 = ASTResolving.findParentBodyDeclaration((ASTNode)catchClause);
        if (!(bodyDeclaration2 instanceof MethodDeclaration) && !(bodyDeclaration2 instanceof Initializer)) {
            return false;
        }
        AST ast = bodyDeclaration2.getAST();
        Type selectedMultiCatchType = null;
        if (type.isUnionType() && (aSTNode = node) instanceof Name) {
            ASTNode parent;
            void name;
            Name name2 = (Name)aSTNode;
            Name cfr_ignored_0 = (Name)aSTNode;
            topMostName = ASTNodes.getTopMostName((Name)name);
            ASTNode aSTNode2 = parent = topMostName.getParent();
            if (aSTNode2 instanceof SimpleType) {
                void simpleType;
                bodyDeclaration = (SimpleType)aSTNode2;
                SimpleType cfr_ignored_1 = (SimpleType)aSTNode2;
                selectedMultiCatchType = simpleType;
            } else {
                ASTNode aSTNode3 = parent;
                if (aSTNode3 instanceof NameQualifiedType) {
                    void nameQualifiedType;
                    NameQualifiedType nameQualifiedType2 = (NameQualifiedType)aSTNode3;
                    NameQualifiedType cfr_ignored_2 = (NameQualifiedType)aSTNode3;
                    selectedMultiCatchType = nameQualifiedType;
                }
            }
        }
        if ((bodyDeclaration = bodyDeclaration2) instanceof MethodDeclaration) {
            topMostName = (MethodDeclaration)bodyDeclaration;
            MethodDeclaration cfr_ignored_3 = (MethodDeclaration)bodyDeclaration;
            rewrite = ASTRewrite.create((AST)ast);
            if (selectedMultiCatchType != null) {
                QuickAssistProcessor.removeException(rewrite, (UnionType)type, selectedMultiCatchType);
                QuickAssistProcessor.addExceptionToThrows(ast, (MethodDeclaration)methodDeclaration, rewrite, selectedMultiCatchType);
                label = CorrectionMessages.QuickAssistProcessor_exceptiontothrows_description;
                proposal = new ASTRewriteCorrectionProposal(label, "quickfix", context.getCompilationUnit(), rewrite, 6);
                resultingCollections.add(proposal);
            } else {
                QuickAssistProcessor.removeCatchBlock(rewrite, catchClause);
                if (type.isUnionType()) {
                    UnionType unionType = (UnionType)type;
                    List types = unionType.types();
                    for (Type elementType : types) {
                        if (!(elementType instanceof SimpleType) && !(elementType instanceof NameQualifiedType)) {
                            return false;
                        }
                        QuickAssistProcessor.addExceptionToThrows(ast, (MethodDeclaration)methodDeclaration, rewrite, elementType);
                    }
                } else {
                    QuickAssistProcessor.addExceptionToThrows(ast, (MethodDeclaration)methodDeclaration, rewrite, type);
                }
                label = CorrectionMessages.QuickAssistProcessor_catchclausetothrows_description;
                proposal = new ASTRewriteCorrectionProposal(label, "quickfix", context.getCompilationUnit(), rewrite, 4);
                resultingCollections.add(proposal);
            }
        }
        rewrite = ASTRewrite.create((AST)ast);
        if (selectedMultiCatchType != null) {
            QuickAssistProcessor.removeException(rewrite, (UnionType)type, selectedMultiCatchType);
            label = CorrectionMessages.QuickAssistProcessor_removeexception_description;
            proposal = new ASTRewriteCorrectionProposal(label, "quickfix", context.getCompilationUnit(), rewrite, 6);
            resultingCollections.add(proposal);
        } else {
            QuickAssistProcessor.removeCatchBlock(rewrite, catchClause);
            label = CorrectionMessages.QuickAssistProcessor_removecatchclause_description;
            proposal = new ASTRewriteCorrectionProposal(label, "quickfix", context.getCompilationUnit(), rewrite, 5);
            resultingCollections.add(proposal);
        }
        return true;
    }

    private static void removeException(ASTRewrite rewrite, UnionType unionType, Type exception) {
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)unionType, UnionType.TYPES_PROPERTY);
        List types = unionType.types();
        for (Type type : types) {
            if (!type.equals((Object)exception)) continue;
            listRewrite.remove((ASTNode)type, null);
        }
    }

    private static void addExceptionToThrows(AST ast, MethodDeclaration methodDeclaration, ASTRewrite rewrite, Type type2) {
        ITypeBinding binding = type2.resolveBinding();
        if (binding == null || QuickAssistProcessor.isNotYetThrown(binding, methodDeclaration.thrownExceptionTypes())) {
            Type newType = (Type)ASTNode.copySubtree((AST)ast, (ASTNode)type2);
            ListRewrite listRewriter = rewrite.getListRewrite((ASTNode)methodDeclaration, MethodDeclaration.THROWN_EXCEPTION_TYPES_PROPERTY);
            listRewriter.insertLast((ASTNode)newType, null);
        }
    }

    private static void removeCatchBlock(ASTRewrite rewrite, CatchClause catchClause) {
        TryStatement tryStatement = (TryStatement)catchClause.getParent();
        if (tryStatement.catchClauses().size() > 1 || tryStatement.getFinally() != null || !tryStatement.resources().isEmpty()) {
            rewrite.remove((ASTNode)catchClause, null);
        } else {
            Block block = tryStatement.getBody();
            List statements = block.statements();
            int nStatements = statements.size();
            if (nStatements == 1) {
                ASTNode first = (ASTNode)statements.get(0);
                rewrite.replace((ASTNode)tryStatement, rewrite.createCopyTarget(first), null);
            } else if (nStatements > 1) {
                ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)block, Block.STATEMENTS_PROPERTY);
                ASTNode first = (ASTNode)statements.get(0);
                ASTNode last = (ASTNode)statements.get(statements.size() - 1);
                ASTNode newStatement = listRewrite.createCopyTarget(first, last);
                if (ASTNodes.isControlStatementBody((StructuralPropertyDescriptor)tryStatement.getLocationInParent())) {
                    Block newBlock = rewrite.getAST().newBlock();
                    newBlock.statements().add(newStatement);
                    newStatement = newBlock;
                }
                rewrite.replace((ASTNode)tryStatement, newStatement, null);
            } else {
                rewrite.remove((ASTNode)tryStatement, null);
            }
        }
    }

    private static boolean isNotYetThrown(ITypeBinding binding, List<Type> thrownExceptions) {
        for (Type thrownException : thrownExceptions) {
            ITypeBinding elem = thrownException.resolveBinding();
            if (elem == null || !Bindings.isSuperType((ITypeBinding)elem, (ITypeBinding)binding)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean getConvertMethodReferenceToLambdaProposal(IInvocationContext context, ASTNode covering, Collection<ChangeCorrectionProposal> resultingCollections) throws JavaModelException {
        void methodReference;
        ASTNode aSTNode = covering;
        if (aSTNode instanceof MethodReference) {
            void ref;
            MethodReference methodReference2 = (MethodReference)aSTNode;
            MethodReference cfr_ignored_0 = (MethodReference)aSTNode;
            methodReference = ref;
        } else {
            ASTNode aSTNode2 = covering.getParent();
            if (aSTNode2 instanceof MethodReference) {
                void parentMethodRef;
                MethodReference methodReference3 = (MethodReference)aSTNode2;
                MethodReference cfr_ignored_1 = (MethodReference)aSTNode2;
                methodReference = parentMethodRef;
            } else {
                return false;
            }
        }
        IMethodBinding functionalMethod = QuickAssistProcessor.getFunctionalMethodForMethodReference((MethodReference)methodReference);
        if (functionalMethod == null || functionalMethod.isGenericMethod()) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        ASTRewrite rewrite = ASTRewrite.create((AST)methodReference.getAST());
        LinkedProposalModelCore linkedProposalModel = new LinkedProposalModelCore();
        LambdaExpression lambda = QuickAssistProcessor.convertMethodRefernceToLambda((MethodReference)methodReference, functionalMethod, context.getASTRoot(), rewrite, linkedProposalModel, false);
        String label = CorrectionMessages.QuickAssistProcessor_convert_to_lambda_expression;
        LinkedCorrectionProposal proposal = new LinkedCorrectionProposal(label, "quickfix", context.getCompilationUnit(), rewrite, 6);
        proposal.setLinkedProposalModel(linkedProposalModel);
        proposal.setEndPosition(rewrite.track((ASTNode)lambda));
        resultingCollections.add(proposal);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean getConvertLambdaToMethodReferenceProposal(IInvocationContext context, ASTNode coveringNode, Collection<ChangeCorrectionProposal> resultingCollections) {
        CreationReference replacement;
        ClassInstanceCreation lambdaMethodBinding;
        Expression exprBody;
        ASTNode lambdaBody;
        LambdaExpression lambda;
        ASTNode aSTNode = coveringNode;
        if (aSTNode instanceof LambdaExpression) {
            void lambdaExpr;
            LambdaExpression lambdaExpression = (LambdaExpression)aSTNode;
            LambdaExpression cfr_ignored_0 = (LambdaExpression)aSTNode;
            lambda = lambdaExpr;
        } else if (coveringNode.getLocationInParent() == LambdaExpression.BODY_PROPERTY) {
            lambda = (LambdaExpression)coveringNode.getParent();
        } else {
            lambda = ASTResolving.findEnclosingLambdaExpression((ASTNode)coveringNode);
            if (lambda == null) {
                return false;
            }
        }
        ASTNode aSTNode2 = lambdaBody = lambda.getBody();
        if (aSTNode2 instanceof Block) {
            void block;
            Block block2 = (Block)aSTNode2;
            Block cfr_ignored_1 = (Block)aSTNode2;
            exprBody = QuickAssistProcessor.getSingleExpressionFromLambdaBody((Block)block);
        } else {
            exprBody = (Expression)lambdaBody;
        }
        exprBody = ASTNodes.getUnparenthesedExpression((Expression)exprBody);
        if (exprBody == null || !QuickAssistProcessor.isValidLambdaReferenceToMethod(exprBody)) {
            return false;
        }
        if (!ASTNodes.isParent((ASTNode)exprBody, (ASTNode)coveringNode) && !QuickAssistProcessor.representsDefiningNode(coveringNode, (ASTNode)exprBody)) {
            return false;
        }
        ArrayList<Expression> lambdaParameters = new ArrayList<Expression>();
        for (VariableDeclaration param : lambda.parameters()) {
            lambdaParameters.add((Expression)param.getName());
        }
        Expression expression = exprBody;
        if (expression instanceof ClassInstanceCreation) {
            void cic;
            VariableDeclaration param;
            param = (ClassInstanceCreation)expression;
            ClassInstanceCreation cfr_ignored_2 = (ClassInstanceCreation)expression;
            if (cic.getExpression() != null || cic.getAnonymousClassDeclaration() != null) {
                return false;
            }
            if (!QuickAssistProcessor.matches(lambdaParameters, cic.arguments())) {
                return false;
            }
        } else {
            Expression expression2 = exprBody;
            if (expression2 instanceof ArrayCreation) {
                void arrayCreation;
                ArrayCreation arrayCreation2 = (ArrayCreation)expression2;
                ArrayCreation cfr_ignored_3 = (ArrayCreation)expression2;
                List dimensions = arrayCreation.dimensions();
                if (dimensions.size() != 1) {
                    return false;
                }
                if (!QuickAssistProcessor.matches(lambdaParameters, dimensions)) {
                    return false;
                }
            } else {
                Expression expression3 = exprBody;
                if (expression3 instanceof SuperMethodInvocation) {
                    ITypeBinding invocationTypeBinding;
                    void superMethodInvocation;
                    SuperMethodInvocation dimensions = (SuperMethodInvocation)expression3;
                    SuperMethodInvocation cfr_ignored_4 = (SuperMethodInvocation)expression3;
                    IMethodBinding methodBinding = superMethodInvocation.resolveMethodBinding();
                    if (methodBinding == null) {
                        return false;
                    }
                    if (Modifier.isStatic((int)methodBinding.getModifiers()) && (invocationTypeBinding = ASTNodes.getInvocationType((ASTNode)superMethodInvocation, (IMethodBinding)methodBinding, (Expression)superMethodInvocation.getQualifier())) == null) {
                        return false;
                    }
                    if (!QuickAssistProcessor.matches(lambdaParameters, superMethodInvocation.arguments())) {
                        return false;
                    }
                } else {
                    MethodInvocation methodInvocation = (MethodInvocation)exprBody;
                    IMethodBinding methodBinding = methodInvocation.resolveMethodBinding();
                    if (methodBinding == null) {
                        return false;
                    }
                    Expression invocationExpr = methodInvocation.getExpression();
                    if (Modifier.isStatic((int)methodBinding.getModifiers())) {
                        invocationTypeBinding = ASTNodes.getInvocationType((ASTNode)methodInvocation, (IMethodBinding)methodBinding, (Expression)invocationExpr);
                        if (invocationTypeBinding == null) {
                            return false;
                        }
                        if (!QuickAssistProcessor.matches(lambdaParameters, methodInvocation.arguments())) {
                            return false;
                        }
                    } else if (lambda.parameters().size() - methodInvocation.arguments().size() == 1) {
                        if (invocationExpr == null) {
                            return false;
                        }
                        invocationTypeBinding = invocationExpr.resolveTypeBinding();
                        if (invocationTypeBinding == null) {
                            return false;
                        }
                        lambdaMethodBinding = lambda.resolveMethodBinding();
                        if (lambdaMethodBinding == null) {
                            return false;
                        }
                        ITypeBinding firstParamType = lambdaMethodBinding.getParameterTypes()[0];
                        if (!Bindings.equals((IBinding)invocationTypeBinding, (IBinding)firstParamType) && !Bindings.isSuperType((ITypeBinding)invocationTypeBinding, (ITypeBinding)firstParamType) || !JdtASTMatcher.doNodesMatch((ASTNode)((ASTNode)lambdaParameters.get(0)), (ASTNode)invocationExpr) || !QuickAssistProcessor.matches(lambdaParameters.subList(1, lambdaParameters.size()), methodInvocation.arguments())) {
                            return false;
                        }
                    } else if (!QuickAssistProcessor.matches(lambdaParameters, methodInvocation.arguments())) {
                        return false;
                    }
                }
            }
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = lambda.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        ImportRewrite importRewrite = null;
        Expression expression4 = exprBody;
        if (expression4 instanceof ClassInstanceCreation) {
            void cic;
            CreationReference creationReference2;
            lambdaMethodBinding = (ClassInstanceCreation)expression4;
            ClassInstanceCreation cfr_ignored_5 = (ClassInstanceCreation)expression4;
            replacement = creationReference2 = ast.newCreationReference();
            Type type = cic.getType();
            if (type.isParameterizedType() && ((ParameterizedType)type).typeArguments().size() == 0) {
                type = ((ParameterizedType)type).getType();
            }
            creationReference2.setType((Type)rewrite.createCopyTarget((ASTNode)type));
            creationReference2.typeArguments().addAll(QuickAssistProcessor.getCopiedTypeArguments(rewrite, cic.typeArguments()));
        } else {
            Expression expression5 = exprBody;
            if (expression5 instanceof ArrayCreation) {
                void arrayCreation;
                CreationReference creationReference;
                ArrayCreation creationReference2 = (ArrayCreation)expression5;
                ArrayCreation cfr_ignored_6 = (ArrayCreation)expression5;
                replacement = creationReference = ast.newCreationReference();
                ArrayType arrayType = arrayCreation.getType();
                Type copiedElementType = (Type)rewrite.createCopyTarget((ASTNode)arrayType.getElementType());
                creationReference.setType((Type)ast.newArrayType(copiedElementType, arrayType.getDimensions()));
            } else {
                Expression expression6 = exprBody;
                if (expression6 instanceof SuperMethodInvocation) {
                    void superMethodInvocation;
                    SuperMethodInvocation creationReference = (SuperMethodInvocation)expression6;
                    SuperMethodInvocation cfr_ignored_7 = (SuperMethodInvocation)expression6;
                    IMethodBinding methodBinding = superMethodInvocation.resolveMethodBinding();
                    Name superQualifier = superMethodInvocation.getQualifier();
                    if (Modifier.isStatic((int)methodBinding.getModifiers())) {
                        TypeMethodReference typeMethodReference = ast.newTypeMethodReference();
                        replacement = typeMethodReference;
                        typeMethodReference.setName((SimpleName)rewrite.createCopyTarget((ASTNode)superMethodInvocation.getName()));
                        importRewrite = StubUtility.createImportRewrite((CompilationUnit)context.getASTRoot(), (boolean)true);
                        ITypeBinding invocationTypeBinding = ASTNodes.getInvocationType((ASTNode)superMethodInvocation, (IMethodBinding)methodBinding, (Expression)superQualifier);
                        typeMethodReference.setType(importRewrite.addImport(invocationTypeBinding.getTypeDeclaration(), ast));
                        typeMethodReference.typeArguments().addAll(QuickAssistProcessor.getCopiedTypeArguments(rewrite, superMethodInvocation.typeArguments()));
                    } else {
                        SuperMethodReference superMethodReference = ast.newSuperMethodReference();
                        replacement = superMethodReference;
                        if (superQualifier != null) {
                            superMethodReference.setQualifier((Name)rewrite.createCopyTarget((ASTNode)superQualifier));
                        }
                        superMethodReference.setName((SimpleName)rewrite.createCopyTarget((ASTNode)superMethodInvocation.getName()));
                        superMethodReference.typeArguments().addAll(QuickAssistProcessor.getCopiedTypeArguments(rewrite, superMethodInvocation.typeArguments()));
                    }
                } else {
                    boolean isTypeRefToInstanceMethod;
                    MethodInvocation methodInvocation = (MethodInvocation)exprBody;
                    IMethodBinding methodBinding = methodInvocation.resolveMethodBinding();
                    Expression invocationQualifier = methodInvocation.getExpression();
                    boolean isStaticMethod = Modifier.isStatic((int)methodBinding.getModifiers());
                    boolean bl = isTypeRefToInstanceMethod = methodInvocation.arguments().size() != lambda.parameters().size();
                    if (isStaticMethod || isTypeRefToInstanceMethod) {
                        TypeMethodReference typeMethodReference = ast.newTypeMethodReference();
                        replacement = typeMethodReference;
                        typeMethodReference.setName((SimpleName)rewrite.createCopyTarget((ASTNode)methodInvocation.getName()));
                        importRewrite = StubUtility.createImportRewrite((CompilationUnit)context.getASTRoot(), (boolean)true);
                        ITypeBinding invocationTypeBinding = ASTNodes.getInvocationType((ASTNode)methodInvocation, (IMethodBinding)methodBinding, (Expression)invocationQualifier);
                        invocationTypeBinding = StubUtility2Core.replaceWildcardsAndCaptures((ITypeBinding)invocationTypeBinding);
                        ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext((ASTNode)lambda, importRewrite);
                        typeMethodReference.setType(importRewrite.addImport(invocationTypeBinding, ast, (ImportRewrite.ImportRewriteContext)importRewriteContext, ImportRewrite.TypeLocation.OTHER));
                        typeMethodReference.typeArguments().addAll(QuickAssistProcessor.getCopiedTypeArguments(rewrite, methodInvocation.typeArguments()));
                    } else {
                        ExpressionMethodReference exprMethodReference = ast.newExpressionMethodReference();
                        replacement = exprMethodReference;
                        exprMethodReference.setName((SimpleName)rewrite.createCopyTarget((ASTNode)methodInvocation.getName()));
                        if (invocationQualifier != null) {
                            exprMethodReference.setExpression((Expression)rewrite.createCopyTarget((ASTNode)invocationQualifier));
                        } else {
                            TypeDeclaration lambdaParentType = (TypeDeclaration)ASTResolving.findParentType((ASTNode)lambda);
                            ITypeBinding lambdaMethodInvokingClass = lambdaParentType.resolveBinding();
                            ITypeBinding lambdaMethodDeclaringClass = methodBinding.getDeclaringClass();
                            ThisExpression newThisExpression = ast.newThisExpression();
                            ITypeBinding nestedRootClass = QuickAssistProcessor.getNestedRootClass(lambdaMethodInvokingClass);
                            boolean isSuperClass = QuickAssistProcessor.isSuperClass(lambdaMethodDeclaringClass, lambdaMethodInvokingClass);
                            boolean isNestedClass = QuickAssistProcessor.isNestedClass(lambdaMethodDeclaringClass, lambdaMethodInvokingClass);
                            if (lambdaMethodDeclaringClass != lambdaMethodInvokingClass) {
                                if (Modifier.isDefault((int)methodBinding.getModifiers())) {
                                    boolean nestedInterfaceClass = QuickAssistProcessor.isNestedInterfaceClass(ast, lambdaMethodDeclaringClass, lambdaMethodInvokingClass);
                                    if (!(isNestedClass || nestedInterfaceClass && !isNestedClass && !isSuperClass || nestedInterfaceClass && nestedRootClass == lambdaMethodInvokingClass)) {
                                        newThisExpression.setQualifier(ast.newName(nestedRootClass.getName()));
                                    }
                                } else if (lambdaMethodDeclaringClass.isInterface()) {
                                    if (!isSuperClass) {
                                        newThisExpression.setQualifier(ast.newName(nestedRootClass.getName()));
                                    }
                                } else if (!isSuperClass) {
                                    newThisExpression.setQualifier(ast.newName(nestedRootClass.getName()));
                                }
                            }
                            exprMethodReference.setExpression((Expression)newThisExpression);
                        }
                        exprMethodReference.typeArguments().addAll(QuickAssistProcessor.getCopiedTypeArguments(rewrite, methodInvocation.typeArguments()));
                    }
                }
            }
        }
        rewrite.replace((ASTNode)lambda, (ASTNode)replacement, null);
        String label = CorrectionMessages.QuickAssistProcessor_convert_to_method_reference;
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, "quickfix", context.getCompilationUnit(), rewrite, 6);
        if (importRewrite != null) {
            proposal.setImportRewrite(importRewrite);
        }
        resultingCollections.add(proposal);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static Expression getSingleExpressionFromLambdaBody(Block lambdaBody) {
        if (lambdaBody.statements().size() != 1) {
            return null;
        }
        Statement singleStatement = (Statement)lambdaBody.statements().get(0);
        Statement statement = singleStatement;
        if (statement instanceof ReturnStatement) {
            void returnStatement;
            ReturnStatement returnStatement2 = (ReturnStatement)statement;
            ReturnStatement cfr_ignored_0 = (ReturnStatement)statement;
            return returnStatement.getExpression();
        }
        Statement statement2 = singleStatement;
        if (statement2 instanceof ExpressionStatement) {
            void expressionStatement;
            ExpressionStatement expressionStatement2 = (ExpressionStatement)statement2;
            ExpressionStatement cfr_ignored_1 = (ExpressionStatement)statement2;
            Expression expression = expressionStatement.getExpression();
            if (QuickAssistProcessor.isValidLambdaExpressionBody(expression)) {
                return expression;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isValidLambdaExpressionBody(Expression expression) {
        if (expression instanceof Assignment || expression instanceof ClassInstanceCreation || expression instanceof MethodInvocation || expression instanceof PostfixExpression || expression instanceof SuperMethodInvocation) {
            return true;
        }
        Expression expression2 = expression;
        if (expression2 instanceof PrefixExpression) {
            void prefixExpression;
            PrefixExpression prefixExpression2 = (PrefixExpression)expression2;
            PrefixExpression cfr_ignored_0 = (PrefixExpression)expression2;
            PrefixExpression.Operator operator = prefixExpression.getOperator();
            if (operator == PrefixExpression.Operator.INCREMENT || operator == PrefixExpression.Operator.DECREMENT) {
                return true;
            }
        }
        return false;
    }

    private static boolean isValidLambdaReferenceToMethod(Expression expression) {
        return expression instanceof ClassInstanceCreation || expression instanceof ArrayCreation || expression instanceof SuperMethodInvocation || expression instanceof MethodInvocation;
    }

    private static boolean matches(List<Expression> expected, List<Expression> toMatch) {
        if (toMatch.size() != expected.size()) {
            return false;
        }
        int i = 0;
        while (i < toMatch.size()) {
            if (!JdtASTMatcher.doNodesMatch((ASTNode)((ASTNode)expected.get(i)), (ASTNode)((ASTNode)toMatch.get(i)))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean representsDefiningNode(ASTNode innerNode, ASTNode definingNode) {
        if (innerNode == definingNode) {
            return true;
        }
        switch (definingNode.getNodeType()) {
            case 14: {
                return QuickAssistProcessor.representsDefiningNode(innerNode, (ASTNode)((ClassInstanceCreation)definingNode).getType());
            }
            case 3: {
                return QuickAssistProcessor.representsDefiningNode(innerNode, (ASTNode)((ArrayCreation)definingNode).getType());
            }
            case 48: {
                return innerNode == ((SuperMethodInvocation)definingNode).getName();
            }
            case 32: {
                return innerNode == ((MethodInvocation)definingNode).getName();
            }
            case 88: {
                return innerNode == ((NameQualifiedType)definingNode).getName();
            }
            case 75: {
                return innerNode == ((QualifiedType)definingNode).getName();
            }
            case 43: {
                return innerNode == ((SimpleType)definingNode).getName();
            }
            case 5: {
                return QuickAssistProcessor.representsDefiningNode(innerNode, (ASTNode)((ArrayType)definingNode).getElementType());
            }
            case 74: {
                return QuickAssistProcessor.representsDefiningNode(innerNode, (ASTNode)((ParameterizedType)definingNode).getType());
            }
        }
        return false;
    }

    private static boolean isNestedInterfaceClass(AST ast, ITypeBinding lambdaMethodDeclaringClass, ITypeBinding lambdaMethodInvokingClass) {
        ITypeBinding[] methodNarrowingTypes = ASTResolving.getRelaxingTypes((AST)ast, (ITypeBinding)lambdaMethodDeclaringClass);
        ITypeBinding[] lambdaNarrowingTypes = ASTResolving.getRelaxingTypes((AST)ast, (ITypeBinding)lambdaMethodInvokingClass);
        if (methodNarrowingTypes.length != 1) {
            return false;
        }
        ITypeBinding methodNarrowingType = methodNarrowingTypes[0];
        ITypeBinding[] iTypeBindingArray = lambdaNarrowingTypes;
        int n = lambdaNarrowingTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding lambdaNarrowingType = iTypeBindingArray[n2];
            if (methodNarrowingType == lambdaNarrowingType) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean isNestedClass(ITypeBinding methodDeclarationType, ITypeBinding lambdaDeclarationType) {
        ITypeBinding parent = lambdaDeclarationType;
        while (parent.isNested()) {
            if ((parent = parent.getDeclaringClass()) != methodDeclarationType) continue;
            return true;
        }
        return false;
    }

    private static ITypeBinding getNestedRootClass(ITypeBinding lambdaDeclarationType) {
        ITypeBinding parent = lambdaDeclarationType;
        while (parent.isNested()) {
            parent = parent.getDeclaringClass();
        }
        return parent;
    }

    private static boolean isSuperClass(ITypeBinding methodDeclarationType, ITypeBinding lambdaDeclarationType) {
        ITypeBinding parent = lambdaDeclarationType.getSuperclass();
        while (parent != null) {
            if (parent == methodDeclarationType) {
                return true;
            }
            parent = parent.getSuperclass();
        }
        return false;
    }

    private static void addIfMissing(MethodDeclaration methodDeclaration, TypeParameter newTypeParameter) {
        List typeParameters = methodDeclaration.typeParameters();
        for (TypeParameter typeParameter : typeParameters) {
            boolean equals = typeParameter.getName().getFullyQualifiedName().equals(newTypeParameter.getName().getFullyQualifiedName());
            if (!equals) continue;
            return;
        }
        typeParameters.add(newTypeParameter);
    }

    /*
     * WARNING - void declaration
     */
    private static ReturnType getReturnType(AST ast, ImportRewrite importRewrite, Type variableType) {
        ReturnType returnType = new ReturnType();
        Type type = variableType;
        if (type instanceof ParameterizedType) {
            void parameterizedType;
            ParameterizedType parameterizedType2 = (ParameterizedType)type;
            ParameterizedType cfr_ignored_0 = (ParameterizedType)type;
            variableType = (Type)parameterizedType.typeArguments().get(0);
            ITypeBinding returnTypeBinding = variableType.resolveBinding();
            if (returnTypeBinding != null) {
                if (returnTypeBinding.isCapture()) {
                    returnType.binding = returnTypeBinding.getErasure();
                    returnType.type = importRewrite.addImport(returnTypeBinding.getErasure(), ast);
                } else if (returnTypeBinding.isWildcardType()) {
                    returnType.binding = returnTypeBinding.getBound();
                    returnType.type = importRewrite.addImport(returnTypeBinding.getBound(), ast);
                } else {
                    returnType.type = importRewrite.addImport(returnTypeBinding, ast);
                    returnType.binding = returnTypeBinding;
                }
            }
        }
        return returnType;
    }

    private static Block getNewReturnBlock(AST ast, ITypeBinding returnTypeBinding) {
        Block newBlock = ast.newBlock();
        if (!"void".equals(returnTypeBinding.getName())) {
            ReturnStatement newReturnStatement = ast.newReturnStatement();
            String bName = returnTypeBinding.getBinaryName();
            if ("Z".equals(bName)) {
                newReturnStatement.setExpression((Expression)ast.newBooleanLiteral(false));
            } else if (returnTypeBinding.isPrimitive()) {
                newReturnStatement.setExpression((Expression)ast.newNumberLiteral());
            } else if ("java.lang.String".equals(bName)) {
                newReturnStatement.setExpression((Expression)ast.newStringLiteral());
            } else {
                newReturnStatement.setExpression((Expression)ast.newNullLiteral());
            }
            newBlock.statements().add(newReturnStatement);
        }
        return newBlock;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean getAddMethodDeclaration(IInvocationContext context, ASTNode covering, Collection<ChangeCorrectionProposal> resultingCollections) {
        Type newReturnType;
        MethodDeclaration newMethodDeclaration;
        ITypeBinding returnTypeBindingFunctionalInterface;
        ITypeBinding[] parameterTypesFunctionalInterface;
        ITypeBinding[] typeArguments;
        ImportRewrite importRewrite;
        ASTRewriteCorrectionProposal proposal;
        ListRewrite listRewrite;
        ASTRewrite rewrite;
        AST ast;
        TypeDeclaration typeDeclaration;
        ExpressionMethodReference methodReferenceNode;
        block31: {
            IMethodBinding methodBinding;
            CompilationUnit astRoot = context.getASTRoot();
            ASTNode aSTNode = covering;
            if (aSTNode instanceof ExpressionMethodReference) {
                void expressionMethodReference;
                ExpressionMethodReference expressionMethodReference2 = (ExpressionMethodReference)aSTNode;
                ExpressionMethodReference cfr_ignored_0 = (ExpressionMethodReference)aSTNode;
                v0 = expressionMethodReference;
            } else {
                v0 = methodReferenceNode = (ExpressionMethodReference)ASTNodes.getParent((ASTNode)covering, ExpressionMethodReference.class);
            }
            if (methodReferenceNode == null) {
                return false;
            }
            boolean addStaticModifier = false;
            typeDeclaration = (TypeDeclaration)ASTNodes.getParent((ASTNode)methodReferenceNode, TypeDeclaration.class);
            if (QuickAssistProcessor.isTypeReferenceToInstanceMethod((MethodReference)methodReferenceNode)) {
                String typeDeclarationName;
                String methodReferenceQualifiedName = ((Name)methodReferenceNode.getExpression()).getFullyQualifiedName();
                if (!methodReferenceQualifiedName.equals(typeDeclarationName = String.valueOf(astRoot.getPackage().getName().getFullyQualifiedName()) + '.' + typeDeclaration.getName().getFullyQualifiedName()) && !methodReferenceQualifiedName.equals(typeDeclaration.getName().getFullyQualifiedName())) {
                    return false;
                }
                addStaticModifier = true;
            }
            ast = astRoot.getAST();
            rewrite = ASTRewrite.create((AST)ast);
            listRewrite = rewrite.getListRewrite((ASTNode)typeDeclaration, TypeDeclaration.BODY_DECLARATIONS_PROPERTY);
            String label = Messages.format(CorrectionMessages.AddUnimplementedMethodReferenceOperation_AddMissingMethod_group, new String[]{methodReferenceNode.getName().getIdentifier(), typeDeclaration.getName().getIdentifier()});
            proposal = new ASTRewriteCorrectionProposal(label, "quickfix", context.getCompilationUnit(), rewrite, 3);
            importRewrite = StubUtility.createImportRewrite((CompilationUnit)astRoot, (boolean)true);
            VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)ASTNodes.getParent((ASTNode)methodReferenceNode, VariableDeclarationStatement.class);
            MethodInvocation methodInvocationNode = (MethodInvocation)ASTNodes.getParent((ASTNode)methodReferenceNode, MethodInvocation.class);
            Assignment variableAssignment = (Assignment)ASTNodes.getParent((ASTNode)methodReferenceNode, Assignment.class);
            if ((variableAssignment != null || variableDeclarationStatement != null) && methodInvocationNode == null) {
                IMethodBinding functionalInterfaceMethod;
                Type type = null;
                ReturnType returnType = null;
                if (variableDeclarationStatement != null) {
                    type = variableDeclarationStatement.getType();
                    returnType = QuickAssistProcessor.getReturnType(ast, importRewrite, type);
                } else {
                    Expression leftHandSide = variableAssignment.getLeftHandSide();
                    ITypeBinding assignmentTypeBinding = leftHandSide.resolveTypeBinding();
                    if (assignmentTypeBinding == null) {
                        return false;
                    }
                    type = importRewrite.addImport(assignmentTypeBinding, ast);
                    returnType = new ReturnType();
                    returnType.type = type;
                    returnType.binding = assignmentTypeBinding;
                }
                if (returnType.binding == null) {
                    return false;
                }
                MethodDeclaration newMethodDeclaration2 = ast.newMethodDeclaration();
                newMethodDeclaration2.setName((SimpleName)rewrite.createCopyTarget((ASTNode)methodReferenceNode.getName()));
                newMethodDeclaration2.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.PRIVATE_KEYWORD));
                if (addStaticModifier) {
                    newMethodDeclaration2.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.STATIC_KEYWORD));
                }
                IMethodBinding iMethodBinding = functionalInterfaceMethod = variableDeclarationStatement == null ? returnType.binding.getFunctionalInterfaceMethod() : variableDeclarationStatement.getType().resolveBinding().getFunctionalInterfaceMethod();
                if (functionalInterfaceMethod != null) {
                    returnType.type = importRewrite.addImport(functionalInterfaceMethod.getReturnType(), ast);
                    returnType.binding = functionalInterfaceMethod.getReturnType();
                    ITypeBinding[] typeArguments2 = functionalInterfaceMethod.getParameterTypes();
                    int i = 0;
                    while (i < typeArguments2.length) {
                        ITypeBinding iTypeBinding = typeArguments2[i];
                        SingleVariableDeclaration newSingleVariableDeclaration = ast.newSingleVariableDeclaration();
                        newSingleVariableDeclaration.setName(ast.newSimpleName(String.valueOf(iTypeBinding.getErasure().getName().toLowerCase()) + (i + 1)));
                        newSingleVariableDeclaration.setType(importRewrite.addImport(iTypeBinding.getErasure(), ast));
                        newMethodDeclaration2.parameters().add(newSingleVariableDeclaration);
                        ++i;
                    }
                }
                newMethodDeclaration2.setReturnType2(returnType.type);
                Block newBlock = QuickAssistProcessor.getNewReturnBlock(ast, returnType.binding);
                newMethodDeclaration2.setBody(newBlock);
                listRewrite.insertLast((ASTNode)newMethodDeclaration2, null);
                resultingCollections.add(proposal);
                return true;
            }
            IMethodBinding iMethodBinding = methodBinding = methodInvocationNode == null ? null : methodInvocationNode.resolveMethodBinding();
            if (methodBinding == null) {
                return false;
            }
            List arguments = methodInvocationNode.arguments();
            int index = -1;
            int i = 0;
            while (i < arguments.size()) {
                ASTNode node = (ASTNode)arguments.get(i);
                if (node.equals((Object)methodReferenceNode)) {
                    index = i;
                    break;
                }
                ++i;
            }
            ITypeBinding[] parameterTypes = methodBinding.getParameterTypes();
            typeArguments = methodBinding.getTypeArguments();
            parameterTypesFunctionalInterface = parameterTypes[index].getFunctionalInterfaceMethod().getParameterTypes();
            returnTypeBindingFunctionalInterface = parameterTypes[index].getFunctionalInterfaceMethod().getReturnType();
            newMethodDeclaration = ast.newMethodDeclaration();
            newMethodDeclaration.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.PRIVATE_KEYWORD));
            if (addStaticModifier) {
                newMethodDeclaration.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.STATIC_KEYWORD));
            }
            newReturnType = null;
            if (returnTypeBindingFunctionalInterface.isPrimitive()) {
                newReturnType = ast.newPrimitiveType(PrimitiveType.toCode((String)returnTypeBindingFunctionalInterface.getName()));
            } else {
                newReturnType = importRewrite.addImport(returnTypeBindingFunctionalInterface, ast);
                ITypeBinding[] typeParameters = typeDeclaration.resolveBinding().getTypeParameters();
                if (returnTypeBindingFunctionalInterface.isTypeVariable() || returnTypeBindingFunctionalInterface.isParameterizedType()) {
                    ITypeBinding[] iTypeBindingArray = typeParameters;
                    int n = typeParameters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ITypeBinding typeParameter = iTypeBindingArray[n2];
                        if (!Bindings.equals((IBinding)typeParameter, (IBinding)returnTypeBindingFunctionalInterface)) {
                            ++n2;
                            continue;
                        }
                        break block31;
                    }
                    TypeParameter newTypeParameter = ast.newTypeParameter();
                    newTypeParameter.setName(ast.newSimpleName(returnTypeBindingFunctionalInterface.getName()));
                    QuickAssistProcessor.addIfMissing(newMethodDeclaration, newTypeParameter);
                }
            }
        }
        newMethodDeclaration.setName((SimpleName)rewrite.createCopyTarget((ASTNode)methodReferenceNode.getName()));
        newMethodDeclaration.setReturnType2(newReturnType);
        int i = 0;
        while (i < parameterTypesFunctionalInterface.length) {
            block32: {
                ITypeBinding parameterType2 = parameterTypesFunctionalInterface[i];
                SingleVariableDeclaration newSingleVariableDeclaration = ast.newSingleVariableDeclaration();
                if (parameterType2.isCapture()) {
                    newSingleVariableDeclaration.setName(ast.newSimpleName(String.valueOf(parameterType2.getErasure().getName().toLowerCase()) + (i + 1)));
                    newSingleVariableDeclaration.setType(importRewrite.addImport(parameterType2.getErasure(), ast));
                } else {
                    newSingleVariableDeclaration.setName(ast.newSimpleName(String.valueOf(parameterType2.getName().toLowerCase()) + (i + 1)));
                    newSingleVariableDeclaration.setType(importRewrite.addImport(parameterType2, ast));
                }
                newMethodDeclaration.parameters().add(newSingleVariableDeclaration);
                ITypeBinding[] typeParameters = typeDeclaration.resolveBinding().getTypeParameters();
                if (parameterType2.isTypeVariable()) {
                    ITypeBinding[] typeBounds;
                    ITypeBinding[] iTypeBindingArray = typeParameters;
                    int n = typeParameters.length;
                    int n3 = 0;
                    while (n3 < n) {
                        ITypeBinding typeParameter = iTypeBindingArray[n3];
                        if (!Bindings.equals((IBinding)typeParameter, (IBinding)parameterType2)) {
                            ++n3;
                            continue;
                        }
                        break block32;
                    }
                    TypeParameter newTypeParameter = ast.newTypeParameter();
                    newTypeParameter.setName(ast.newSimpleName(importRewrite.addImport(parameterType2)));
                    ITypeBinding[] iTypeBindingArray2 = typeBounds = parameterType2.getTypeBounds();
                    int n4 = typeBounds.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        ITypeBinding typeBound = iTypeBindingArray2[n5];
                        newTypeParameter.typeBounds().add(importRewrite.addImport(typeBound, ast));
                        ++n5;
                    }
                    QuickAssistProcessor.addIfMissing(newMethodDeclaration, newTypeParameter);
                }
            }
            ++i;
        }
        i = 0;
        while (i < typeArguments.length) {
            ITypeBinding typeArgument = typeArguments[i];
            SingleVariableDeclaration newSingleVariableDeclaration = ast.newSingleVariableDeclaration();
            newSingleVariableDeclaration.setName(ast.newSimpleName(String.valueOf(typeArgument.getName().toLowerCase()) + (i + 1)));
            newSingleVariableDeclaration.setType(importRewrite.addImport(typeArgument, ast));
            newMethodDeclaration.parameters().add(newSingleVariableDeclaration);
            if (typeArgument.isTypeVariable()) {
                TypeParameter newTypeParameter = ast.newTypeParameter();
                newTypeParameter.setName(ast.newSimpleName(importRewrite.addImport(typeArgument)));
                newMethodDeclaration.typeParameters().add(newTypeParameter);
            }
            ++i;
        }
        Block newBlock = QuickAssistProcessor.getNewReturnBlock(ast, returnTypeBindingFunctionalInterface);
        newMethodDeclaration.setBody(newBlock);
        listRewrite.insertLast((ASTNode)newMethodDeclaration, null);
        resultingCollections.add(proposal);
        return true;
    }

    public static boolean getTryWithResourceProposals(IProblemLocationCore[] locations, IInvocationContext context, ASTNode node, Collection<ChangeCorrectionProposal> resultingCollections) throws IllegalArgumentException, CoreException {
        List<Integer> exceptionProblems = Arrays.asList(536871799, 536871799, 536871797, 16777384);
        if (QuickAssistProcessor.problemExists(locations, exceptionProblems)) {
            return false;
        }
        ArrayList<ASTNode> coveredNodes = QuickAssistProcessor.getFullyCoveredNodes(context, context.getCoveringNode());
        return QuickAssistProcessor.getTryWithResourceProposals(context, node, coveredNodes, resultingCollections);
    }

    public static boolean problemExists(IProblemLocationCore[] locations, List<Integer> problems) {
        IProblemLocationCore[] iProblemLocationCoreArray = locations;
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            IProblemLocationCore location = iProblemLocationCoreArray[n2];
            if (problems.contains(location.getProblemId())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean getTryWithResourceProposals(IInvocationContext context, ASTNode node, ArrayList<ASTNode> coveredNodes, Collection<ChangeCorrectionProposal> resultingCollections) throws IllegalArgumentException, CoreException {
        int start;
        if (!JavaModelUtil.is1d8OrHigher((IJavaProject)context.getCompilationUnit().getJavaProject())) {
            return false;
        }
        ASTNode parentStatement = ASTResolving.findAncestor((ASTNode)node, (int)60);
        if (!(parentStatement instanceof VariableDeclarationStatement || parentStatement instanceof ExpressionStatement || node instanceof SimpleName || coveredNodes != null && !coveredNodes.isEmpty())) {
            return false;
        }
        ArrayList<Object> coveredStatements = new ArrayList<Object>();
        if (coveredNodes == null || coveredNodes.isEmpty() && parentStatement != null) {
            coveredStatements.add(parentStatement);
        } else {
            for (ASTNode coveredNode : coveredNodes) {
                Statement statement = ASTResolving.findParentStatement((ASTNode)coveredNode);
                if (statement == null || coveredStatements.contains(statement)) continue;
                coveredStatements.add(statement);
            }
        }
        List coveredAutoClosableNodes = QuickAssistProcessorUtil.getCoveredAutoClosableNodes(coveredStatements);
        if (coveredAutoClosableNodes.isEmpty()) {
            return false;
        }
        ASTNode parentBodyDeclaration = node instanceof Block || node instanceof BodyDeclaration ? node : ASTNodes.getFirstAncestorOrNull((ASTNode)node, Block.class, (Class[])new Class[]{BodyDeclaration.class});
        int end = start = ((ASTNode)coveredAutoClosableNodes.get(0)).getStartPosition();
        for (ASTNode astNode : coveredAutoClosableNodes) {
            int endPosition = QuickAssistProcessorUtil.findEndPostion((ASTNode)astNode);
            end = Math.max(end, endPosition);
        }
        List nodesInRange = SurroundWithTryWithResourcesRefactoringCore.findNodesInRange((ASTNode)parentBodyDeclaration, (int)start, (int)end);
        int oldEnd = end;
        while (true) {
            int newEnd = oldEnd;
            for (ASTNode astNode : nodesInRange) {
                int endPosition = QuickAssistProcessorUtil.findEndPostion((ASTNode)astNode);
                newEnd = Math.max(newEnd, endPosition);
            }
            if (newEnd <= oldEnd) break;
            oldEnd = newEnd;
            nodesInRange = SurroundWithTryWithResourcesRefactoringCore.findNodesInRange((ASTNode)parentBodyDeclaration, (int)start, (int)newEnd);
        }
        nodesInRange.removeAll(coveredAutoClosableNodes);
        CompilationUnit cu = (CompilationUnit)node.getRoot();
        IBuffer buffer = context.getCompilationUnit().getBuffer();
        AST ast = node.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        boolean modifyExistingTry = false;
        TryStatement newTryStatement = null;
        Block newTryBody = null;
        TryStatement enclosingTry = (TryStatement)ASTResolving.findAncestor((ASTNode)node, (int)54);
        ListRewrite resourcesRewriter = null;
        ListRewrite clausesRewriter = null;
        if (enclosingTry == null || enclosingTry.getBody() == null || enclosingTry.getBody().statements().get(0) != coveredNodes.get(0)) {
            newTryStatement = ast.newTryStatement();
            newTryBody = ast.newBlock();
            newTryStatement.setBody(newTryBody);
        } else {
            modifyExistingTry = true;
            resourcesRewriter = rewrite.getListRewrite((ASTNode)enclosingTry, TryStatement.RESOURCES2_PROPERTY);
            clausesRewriter = rewrite.getListRewrite((ASTNode)enclosingTry, TryStatement.CATCH_CLAUSES_PROPERTY);
        }
        ICompilationUnit icu = context.getCompilationUnit();
        ASTNode lastNode = nodesInRange.isEmpty() ? (ASTNode)coveredAutoClosableNodes.get(coveredAutoClosableNodes.size() - 1) : (ASTNode)nodesInRange.get(nodesInRange.size() - 1);
        Selection selection = Selection.createFromStartLength((int)start, (int)(lastNode.getStartPosition() - start + lastNode.getLength()));
        SurroundWithTryWithResourcesAnalyzer analyzer = new SurroundWithTryWithResourcesAnalyzer(icu, selection);
        cu.accept((ASTVisitor)analyzer);
        ITypeBinding[] exceptions = analyzer.getExceptions(analyzer.getSelection());
        ArrayList<ITypeBinding> allExceptions = new ArrayList<ITypeBinding>(Arrays.asList(exceptions));
        int resourceCount = 0;
        for (ASTNode coveredNode : coveredAutoClosableNodes) {
            IMethodBinding close;
            Type type;
            ITypeBinding typeBinding;
            void vds;
            ASTNode aSTNode;
            ASTNode findAncestor = ASTResolving.findAncestor((ASTNode)coveredNode, (int)60);
            if (findAncestor == null) {
                findAncestor = ASTResolving.findAncestor((ASTNode)coveredNode, (int)7);
            }
            if (!((aSTNode = findAncestor) instanceof VariableDeclarationStatement)) continue;
            VariableDeclarationStatement cfr_ignored_0 = (VariableDeclarationStatement)aSTNode;
            VariableDeclarationStatement cfr_ignored_1 = (VariableDeclarationStatement)aSTNode;
            String commentToken = null;
            int extendedStatementStart = cu.getExtendedStartPosition((ASTNode)vds);
            if (vds.getStartPosition() > extendedStatementStart) {
                commentToken = buffer.getText(extendedStatementStart, vds.getStartPosition() - extendedStatementStart);
            }
            if ((typeBinding = (type = vds.getType()).resolveBinding()) != null && (close = SurroundWithTryWithResourcesRefactoringCore.findAutocloseMethod((ITypeBinding)typeBinding)) != null) {
                ITypeBinding[] iTypeBindingArray = close.getExceptionTypes();
                int n = iTypeBindingArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITypeBinding exceptionType = iTypeBindingArray[n2];
                    if (!allExceptions.contains(exceptionType)) {
                        allExceptions.add(exceptionType);
                    }
                    ++n2;
                }
            }
            String typeName = buffer.getText(type.getStartPosition(), type.getLength());
            for (Object object : vds.fragments()) {
                VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)object;
                VariableDeclarationFragment newVariableDeclarationFragment = ast.newVariableDeclarationFragment();
                SimpleName name = variableDeclarationFragment.getName();
                if (commentToken == null) {
                    int extendedStart = cu.getExtendedStartPosition((ASTNode)variableDeclarationFragment);
                    commentToken = buffer.getText(extendedStart, variableDeclarationFragment.getStartPosition() - extendedStart);
                }
                commentToken = Strings.trimTrailingTabsAndSpaces((String)commentToken);
                newVariableDeclarationFragment.setName(ast.newSimpleName(name.getIdentifier()));
                Expression newExpression = null;
                Expression initializer = variableDeclarationFragment.getInitializer();
                if (initializer == null) {
                    rewrite.remove(coveredNode, null);
                    continue;
                }
                newExpression = (Expression)rewrite.createMoveTarget((ASTNode)initializer);
                newVariableDeclarationFragment.setInitializer(newExpression);
                VariableDeclarationExpression newVariableDeclarationExpression = ast.newVariableDeclarationExpression(newVariableDeclarationFragment);
                newVariableDeclarationExpression.setType((Type)rewrite.createStringPlaceholder(String.valueOf(commentToken) + typeName, type.getNodeType()));
                ++resourceCount;
                if (modifyExistingTry) {
                    resourcesRewriter.insertLast((ASTNode)newVariableDeclarationExpression, null);
                } else {
                    newTryStatement.resources().add(newVariableDeclarationExpression);
                }
                commentToken = null;
            }
        }
        if (resourceCount == 0) {
            return false;
        }
        String label = CorrectionMessages.QuickAssistProcessor_convert_to_try_with_resource;
        LinkedCorrectionProposal proposal = new LinkedCorrectionProposal(label, "quickfix", context.getCompilationUnit(), rewrite, 6);
        ImportRewrite imports = proposal.createImportRewrite(context.getASTRoot());
        ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext(node, imports);
        CatchClause catchClause = ast.newCatchClause();
        SingleVariableDeclaration decl = ast.newSingleVariableDeclaration();
        String varName = StubUtility.getExceptionVariableName((IJavaProject)icu.getJavaProject());
        parentBodyDeclaration.getRoot().accept((ASTVisitor)analyzer);
        CodeScopeBuilder.Scope scope = CodeScopeBuilder.perform((BodyDeclaration)analyzer.getEnclosingBodyDeclaration(), (Selection)selection).findScope(selection.getOffset(), selection.getLength());
        scope.setCursor(selection.getOffset());
        String name = scope.createName(varName, false);
        decl.setName(ast.newSimpleName(name));
        ArrayList mustRethrowList = new ArrayList();
        List catchExceptions = analyzer.calculateCatchesAndRethrows(ASTNodes.filterSubtypes(allExceptions), mustRethrowList);
        List filteredExceptions = ASTNodes.filterSubtypes((List)catchExceptions);
        if (catchExceptions.size() > 0) {
            String GROUP_EXC_NAME = "exc_name";
            String GROUP_EXC_TYPE = "exc_type";
            LinkedProposalModelCore linkedProposalModel = new LinkedProposalModelCore();
            int i = 0;
            if (!modifyExistingTry) {
                for (ITypeBinding mustThrow : mustRethrowList) {
                    CatchClause newClause = ast.newCatchClause();
                    SingleVariableDeclaration newDecl = ast.newSingleVariableDeclaration();
                    newDecl.setName(ast.newSimpleName(name));
                    Type importType = imports.addImport(mustThrow, ast, (ImportRewrite.ImportRewriteContext)importRewriteContext, ImportRewrite.TypeLocation.EXCEPTION);
                    newDecl.setType(importType);
                    newClause.setException(newDecl);
                    ThrowStatement newThrowStatement = ast.newThrowStatement();
                    newThrowStatement.setExpression((Expression)ast.newSimpleName(name));
                    linkedProposalModel.getPositionGroup("exc_name" + i, true).addPosition(rewrite.track((ASTNode)decl.getName()), false);
                    newClause.getBody().statements().add(newThrowStatement);
                    newTryStatement.catchClauses().add(newClause);
                    ++i;
                }
            }
            UnionType unionType = ast.newUnionType();
            List types = unionType.types();
            for (ITypeBinding exception : filteredExceptions) {
                Type type = imports.addImport(exception, ast, (ImportRewrite.ImportRewriteContext)importRewriteContext, ImportRewrite.TypeLocation.EXCEPTION);
                types.add(type);
                linkedProposalModel.getPositionGroup("exc_type" + i, true).addPosition(rewrite.track((ASTNode)type), i == 0);
                ++i;
            }
            decl.setType((Type)unionType);
            catchClause.setException(decl);
            linkedProposalModel.getPositionGroup("exc_name0", true).addPosition(rewrite.track((ASTNode)decl.getName()), false);
            Statement st = null;
            String s = StubUtility.getCatchBodyContent((ICompilationUnit)icu, (String)"Exception", (String)name, (ASTNode)(coveredNodes.isEmpty() ? node : coveredNodes.get(0)), (String)icu.findRecommendedLineSeparator());
            if (s != null) {
                st = (Statement)rewrite.createStringPlaceholder(s, 41);
            }
            if (st != null) {
                catchClause.getBody().statements().add(st);
            }
            if (modifyExistingTry) {
                clausesRewriter.insertLast((ASTNode)catchClause, null);
            } else {
                newTryStatement.catchClauses().add(catchClause);
            }
        }
        if (modifyExistingTry) {
            int i = 0;
            while (i < coveredAutoClosableNodes.size()) {
                rewrite.remove((ASTNode)coveredAutoClosableNodes.get(i), null);
                ++i;
            }
        } else {
            if (!nodesInRange.isEmpty()) {
                ASTNode firstNode = (ASTNode)nodesInRange.get(0);
                ASTNode methodDeclaration = ASTResolving.findAncestor((ASTNode)firstNode, (int)8);
                ListRewrite listRewrite = rewrite.getListRewrite(methodDeclaration, Block.STATEMENTS_PROPERTY);
                ASTNode createCopyTarget = listRewrite.createMoveTarget(firstNode, (ASTNode)nodesInRange.get(nodesInRange.size() - 1));
                rewrite.getListRewrite((ASTNode)newTryBody, Block.STATEMENTS_PROPERTY).insertFirst(createCopyTarget, null);
            }
            rewrite.replace((ASTNode)coveredAutoClosableNodes.get(0), (ASTNode)newTryStatement, null);
            int i = 1;
            while (i < coveredAutoClosableNodes.size()) {
                rewrite.remove((ASTNode)coveredAutoClosableNodes.get(i), null);
                ++i;
            }
        }
        resultingCollections.add(proposal);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean getConvertToSwitchExpressionProposals(IInvocationContext context, ASTNode covering, Collection<ChangeCorrectionProposal> resultingCollections) {
        block7: {
            var5_3 = covering;
            if (!(var5_3 instanceof Block)) ** GOTO lbl14
            var3_4 = (Block)var5_3;
            (Block)var5_3;
            statements = block.statements();
            startIndex = QuickAssistProcessorUtil.getIndex((int)context.getSelectionOffset(), (List)statements);
            if (startIndex == -1 || startIndex >= statements.size()) {
                return false;
            }
            covering = (ASTNode)statements.get(startIndex);
            break block7;
lbl-1000:
            // 1 sources

            {
                covering = covering.getParent();
lbl14:
                // 2 sources

                ** while (covering instanceof SwitchCase || covering instanceof SwitchExpression)
            }
        }
        var9_8 = covering;
        if (!(var9_8 instanceof SwitchStatement)) {
            return false;
        }
        startIndex = (SwitchStatement)var9_8;
        (SwitchStatement)var9_8;
        switchStatement = statement;
        fix = SwitchExpressionsFixCore.createConvertToSwitchExpressionFix((SwitchStatement)switchStatement);
        if (fix == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        try {
            change = fix.createChange(null);
            proposal = new ChangeCorrectionProposal(fix.getDisplayString(), "quickassist", (Change)change, 2);
            resultingCollections.add(proposal);
        }
        catch (CoreException var11_11) {
            // empty catch block
        }
        return true;
    }

    private static boolean getStringConcatToTextBlockProposal(IInvocationContext context, ASTNode node, Collection<ChangeCorrectionProposal> resultingCollections) {
        if (resultingCollections == null) {
            return false;
        }
        ASTNode exp = null;
        if (node instanceof Assignment || node instanceof VariableDeclarationFragment || node instanceof FieldDeclaration || node instanceof InfixExpression) {
            exp = node;
        } else {
            ASTNode parent = node.getParent();
            if (parent instanceof Assignment || parent instanceof VariableDeclarationFragment || parent instanceof FieldDeclaration || parent instanceof InfixExpression) {
                exp = parent;
            }
        }
        if (exp == null) {
            return false;
        }
        StringConcatToTextBlockFixCore fix = StringConcatToTextBlockFixCore.createStringConcatToTextBlockFix((ASTNode)exp);
        if (fix == null) {
            return false;
        }
        try {
            CompilationUnitChange change = fix.createChange(null);
            ChangeCorrectionProposal proposal = new ChangeCorrectionProposal(fix.getDisplayString(), "quickassist", (Change)change, 5);
            resultingCollections.add(proposal);
            return true;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private static class ReturnType {
        public Type type;
        public ITypeBinding binding;

        private ReturnType() {
        }
    }
}

