/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.internal.jobs.JobMessages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.ProgressProvider;
import org.eclipse.jdt.ls.core.internal.CancellableProgressMonitor;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.ProgressReport;
import org.eclipse.jdt.ls.core.internal.ServiceStatus;
import org.eclipse.jdt.ls.core.internal.StatusReport;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.lsp4j.ProgressParams;
import org.eclipse.lsp4j.WorkDoneProgressBegin;
import org.eclipse.lsp4j.WorkDoneProgressEnd;
import org.eclipse.lsp4j.WorkDoneProgressReport;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class ProgressReporterManager
extends ProgressProvider {
    private JavaClientConnection.JavaLanguageClient client;
    private long delay;
    private PreferenceManager preferenceManager;

    public ProgressReporterManager(JavaClientConnection.JavaLanguageClient client, PreferenceManager preferenceManager) {
        this.client = client;
        this.preferenceManager = preferenceManager;
        this.delay = 200L;
    }

    public IProgressMonitor createMonitor(Job job) {
        if (job.belongsTo((Object)"java-ls-initialization-jobs")) {
            List<IProgressMonitor> monitors = Arrays.asList(new IProgressMonitor[]{new ServerStatusMonitor(), this.createJobMonitor(job)});
            return new MulticastProgressReporter(monitors);
        }
        IProgressMonitor monitor = this.createJobMonitor(job);
        return monitor;
    }

    private IProgressMonitor createJobMonitor(Job job) {
        return new ProgressReporter(job);
    }

    public IProgressMonitor getDefaultMonitor() {
        return new ProgressReporter();
    }

    public IProgressMonitor getProgressReporter(CancelChecker checker) {
        return new ProgressReporter(checker);
    }

    public IProgressMonitor createProgressGroup() {
        return this.getDefaultMonitor();
    }

    public void setReportThrottle(long delay) {
        this.delay = delay;
    }

    private class MulticastProgressReporter
    implements IProgressMonitor {
        protected List<IProgressMonitor> monitors;

        public MulticastProgressReporter(List<IProgressMonitor> monitors) {
            this.monitors = monitors;
        }

        public void done() {
            for (IProgressMonitor monitor : this.monitors) {
                monitor.done();
            }
        }

        public boolean isCanceled() {
            for (IProgressMonitor monitor : this.monitors) {
                if (monitor.isCanceled()) continue;
                return false;
            }
            return true;
        }

        public void beginTask(String name, int totalWork) {
            for (IProgressMonitor monitor : this.monitors) {
                monitor.beginTask(name, totalWork);
            }
        }

        public void internalWorked(double work) {
            for (IProgressMonitor monitor : this.monitors) {
                monitor.internalWorked(work);
            }
        }

        public void setCanceled(boolean cancelled) {
            for (IProgressMonitor monitor : this.monitors) {
                monitor.setCanceled(cancelled);
            }
        }

        public void setTaskName(String name) {
            for (IProgressMonitor monitor : this.monitors) {
                monitor.setTaskName(name);
            }
        }

        public void subTask(String name) {
            for (IProgressMonitor monitor : this.monitors) {
                monitor.subTask(name);
            }
        }

        public void worked(int work) {
            for (IProgressMonitor monitor : this.monitors) {
                monitor.worked(work);
            }
        }
    }

    private class ProgressReporter
    extends CancellableProgressMonitor {
        protected static final String SEPARATOR = " - ";
        protected static final String IMPORTING_MAVEN_PROJECTS = "Importing Maven project(s)";
        protected Job job;
        protected int totalWork;
        protected String taskName;
        protected String subTaskName;
        protected int progress;
        protected long lastReport;
        protected String progressId;
        private boolean sentBegin;

        public ProgressReporter() {
            super(null);
            this.lastReport = 0L;
            this.sentBegin = false;
            this.progressId = UUID.randomUUID().toString();
        }

        public ProgressReporter(Job job) {
            this();
            this.job = job;
        }

        public ProgressReporter(CancelChecker checker) {
            super(checker);
            this.lastReport = 0L;
            this.sentBegin = false;
            this.progressId = UUID.randomUUID().toString();
        }

        public void setTaskName(String name) {
            super.setTaskName(name);
            this.taskName = name;
        }

        public void beginTask(String task, int totalWork) {
            this.taskName = task;
            this.totalWork = totalWork;
            this.sendProgress();
        }

        public void subTask(String name) {
            this.subTaskName = name;
            if (IMPORTING_MAVEN_PROJECTS.equals(this.taskName) && (this.subTaskName == null || this.subTaskName.isEmpty())) {
                return;
            }
            this.sendProgress();
        }

        public void worked(int work) {
            this.progress += work;
            this.sendProgress();
        }

        @Override
        public void done() {
            super.done();
            this.sendProgress();
        }

        @Override
        public boolean isDone() {
            return super.isDone() || this.totalWork > 0 && this.progress >= this.totalWork;
        }

        private void sendProgress() {
            if (this.job != null && this.job.isSystem() || JobMessages.jobs_blocked0.equals(this.taskName)) {
                return;
            }
            long currentTime = System.currentTimeMillis();
            if (this.lastReport == 0L || this.isDone() || currentTime - this.lastReport >= ProgressReporterManager.this.delay) {
                this.lastReport = currentTime;
                this.sendStatus();
            }
        }

        protected void sendStatus() {
            if (ProgressReporterManager.this.client == null || ProgressReporterManager.this.preferenceManager == null || ProgressReporterManager.this.preferenceManager.getClientPreferences() == null) {
                return;
            }
            String task = (String)StringUtils.defaultIfBlank((CharSequence)this.taskName, (CharSequence)(this.job == null || StringUtils.isBlank((CharSequence)this.job.getName()) ? "Background task" : this.job.getName()));
            if (ProgressReporterManager.this.preferenceManager.getClientPreferences().isProgressReportSupported()) {
                ProgressReport progressReport = new ProgressReport(this.progressId);
                progressReport.setTask(task);
                progressReport.setSubTask(this.subTaskName);
                progressReport.setTotalWork(this.totalWork);
                progressReport.setWorkDone(this.progress);
                progressReport.setComplete(this.isDone());
                if (task != null && this.subTaskName != null && !this.subTaskName.isEmpty() && task.equals(IMPORTING_MAVEN_PROJECTS)) {
                    progressReport.setStatus(String.valueOf(task) + SEPARATOR + this.subTaskName);
                } else {
                    progressReport.setStatus(this.formatMessage(task));
                }
                ProgressReporterManager.this.client.sendProgressReport(progressReport);
            } else {
                WorkDoneProgressEnd notification;
                Either id = Either.forLeft((Object)this.progressId);
                if (!this.sentBegin) {
                    WorkDoneProgressBegin workDoneProgressBegin = new WorkDoneProgressBegin();
                    workDoneProgressBegin.setMessage(task);
                    workDoneProgressBegin.setTitle(this.subTaskName == null ? task : this.subTaskName);
                    ProgressReporterManager.this.client.notifyProgress(new ProgressParams(id, Either.forLeft((Object)workDoneProgressBegin)));
                    this.sentBegin = true;
                }
                if (this.isDone()) {
                    WorkDoneProgressEnd endNotification = new WorkDoneProgressEnd();
                    endNotification.setMessage(task);
                    notification = endNotification;
                    this.sentBegin = false;
                } else {
                    WorkDoneProgressReport reportNotification = new WorkDoneProgressReport();
                    reportNotification.setMessage(task);
                    reportNotification.setPercentage(Integer.valueOf((int)((double)this.progress / (double)this.totalWork * 100.0)));
                    notification = reportNotification;
                }
                ProgressReporterManager.this.client.notifyProgress(new ProgressParams(id, Either.forLeft((Object)notification)));
            }
        }

        protected String formatMessage(String task) {
            String message = this.getMessage(task);
            return this.totalWork > 0 ? String.format("%.0f%% %s", (double)this.progress / (double)this.totalWork * 100.0, message) : message;
        }

        protected String getMessage(String task) {
            String message = this.subTaskName == null || this.subTaskName.isEmpty() ? "" : this.subTaskName;
            return message;
        }
    }

    private class ServerStatusMonitor
    extends ProgressReporter {
        private ServerStatusMonitor() {
        }

        @Override
        protected String formatMessage(String task) {
            String message = this.getMessage(task);
            if (this.totalWork > 0 && !message.isEmpty()) {
                message = " - " + message;
            }
            return String.format("%.0f%% Starting Java Language Server%s", (double)this.progress / (double)this.totalWork * 100.0, message);
        }

        @Override
        protected void sendStatus() {
            if (ProgressReporterManager.this.client == null) {
                return;
            }
            String task = (String)StringUtils.defaultIfBlank((CharSequence)this.taskName, (CharSequence)(this.job == null || StringUtils.isBlank((CharSequence)this.job.getName()) ? "Background task" : this.job.getName()));
            String message = this.formatMessage(task);
            ProgressReporterManager.this.client.sendStatusReport(new StatusReport().withType(ServiceStatus.Starting.name()).withMessage(message));
        }
    }
}

