/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.ProgressProvider;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.launching.IVMInstallChangedListener;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ls.core.internal.BaseJDTLanguageServer;
import org.eclipse.jdt.ls.core.internal.BuildWorkspaceStatus;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JSONUtility;
import org.eclipse.jdt.ls.core.internal.JVMConfigurator;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.JobHelpers;
import org.eclipse.jdt.ls.core.internal.LanguageServerApplication;
import org.eclipse.jdt.ls.core.internal.LanguageServerWorkingCopyOwner;
import org.eclipse.jdt.ls.core.internal.ServiceStatus;
import org.eclipse.jdt.ls.core.internal.codemanipulation.GenerateGetterSetterOperation;
import org.eclipse.jdt.ls.core.internal.handlers.BaseDocumentLifeCycleHandler;
import org.eclipse.jdt.ls.core.internal.handlers.BuildWorkspaceHandler;
import org.eclipse.jdt.ls.core.internal.handlers.BundleUtils;
import org.eclipse.jdt.ls.core.internal.handlers.CallHierarchyHandler;
import org.eclipse.jdt.ls.core.internal.handlers.ClasspathUpdateHandler;
import org.eclipse.jdt.ls.core.internal.handlers.CodeActionHandler;
import org.eclipse.jdt.ls.core.internal.handlers.CodeActionResolveHandler;
import org.eclipse.jdt.ls.core.internal.handlers.CodeLensHandler;
import org.eclipse.jdt.ls.core.internal.handlers.CompletionHandler;
import org.eclipse.jdt.ls.core.internal.handlers.CompletionResolveHandler;
import org.eclipse.jdt.ls.core.internal.handlers.DocumentHighlightHandler;
import org.eclipse.jdt.ls.core.internal.handlers.DocumentLifeCycleHandler;
import org.eclipse.jdt.ls.core.internal.handlers.DocumentSymbolHandler;
import org.eclipse.jdt.ls.core.internal.handlers.ExtractInterfaceHandler;
import org.eclipse.jdt.ls.core.internal.handlers.FileEventHandler;
import org.eclipse.jdt.ls.core.internal.handlers.FindLinksHandler;
import org.eclipse.jdt.ls.core.internal.handlers.FoldingRangeHandler;
import org.eclipse.jdt.ls.core.internal.handlers.FormatterHandler;
import org.eclipse.jdt.ls.core.internal.handlers.GenerateAccessorsHandler;
import org.eclipse.jdt.ls.core.internal.handlers.GenerateConstructorsHandler;
import org.eclipse.jdt.ls.core.internal.handlers.GenerateDelegateMethodsHandler;
import org.eclipse.jdt.ls.core.internal.handlers.GenerateToStringHandler;
import org.eclipse.jdt.ls.core.internal.handlers.GetRefactorEditHandler;
import org.eclipse.jdt.ls.core.internal.handlers.HashCodeEqualsHandler;
import org.eclipse.jdt.ls.core.internal.handlers.HoverHandler;
import org.eclipse.jdt.ls.core.internal.handlers.ImplementationsHandler;
import org.eclipse.jdt.ls.core.internal.handlers.IndexUtils;
import org.eclipse.jdt.ls.core.internal.handlers.InferSelectionHandler;
import org.eclipse.jdt.ls.core.internal.handlers.InitHandler;
import org.eclipse.jdt.ls.core.internal.handlers.InlayHintsHandler;
import org.eclipse.jdt.ls.core.internal.handlers.MoveHandler;
import org.eclipse.jdt.ls.core.internal.handlers.NavigateToDefinitionHandler;
import org.eclipse.jdt.ls.core.internal.handlers.NavigateToTypeDefinitionHandler;
import org.eclipse.jdt.ls.core.internal.handlers.OrganizeImportsHandler;
import org.eclipse.jdt.ls.core.internal.handlers.OverrideMethodsHandler;
import org.eclipse.jdt.ls.core.internal.handlers.PrepareRenameHandler;
import org.eclipse.jdt.ls.core.internal.handlers.ProgressReporterManager;
import org.eclipse.jdt.ls.core.internal.handlers.ProjectConfigurationUpdateHandler;
import org.eclipse.jdt.ls.core.internal.handlers.ReferencesHandler;
import org.eclipse.jdt.ls.core.internal.handlers.RenameHandler;
import org.eclipse.jdt.ls.core.internal.handlers.SaveActionHandler;
import org.eclipse.jdt.ls.core.internal.handlers.SelectionRangeHandler;
import org.eclipse.jdt.ls.core.internal.handlers.SemanticTokensHandler;
import org.eclipse.jdt.ls.core.internal.handlers.SignatureHelpHandler;
import org.eclipse.jdt.ls.core.internal.handlers.WorkspaceDiagnosticsHandler;
import org.eclipse.jdt.ls.core.internal.handlers.WorkspaceEventsHandler;
import org.eclipse.jdt.ls.core.internal.handlers.WorkspaceExecuteCommandHandler;
import org.eclipse.jdt.ls.core.internal.handlers.WorkspaceFolderChangeHandler;
import org.eclipse.jdt.ls.core.internal.handlers.WorkspaceSymbolHandler;
import org.eclipse.jdt.ls.core.internal.lsp.JavaProtocolExtensions;
import org.eclipse.jdt.ls.core.internal.lsp.ValidateDocumentParams;
import org.eclipse.jdt.ls.core.internal.managers.ContentProviderManager;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.jdt.ls.core.internal.managers.TelemetryManager;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.lsp4j.CallHierarchyIncomingCall;
import org.eclipse.lsp4j.CallHierarchyIncomingCallsParams;
import org.eclipse.lsp4j.CallHierarchyItem;
import org.eclipse.lsp4j.CallHierarchyOutgoingCall;
import org.eclipse.lsp4j.CallHierarchyOutgoingCallsParams;
import org.eclipse.lsp4j.CallHierarchyPrepareParams;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionOptions;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensOptions;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.DefinitionParams;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.DidChangeWorkspaceFoldersParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentHighlightParams;
import org.eclipse.lsp4j.DocumentOnTypeFormattingOptions;
import org.eclipse.lsp4j.DocumentOnTypeFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.FoldingRange;
import org.eclipse.lsp4j.FoldingRangeRequestParams;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.HoverParams;
import org.eclipse.lsp4j.ImplementationParams;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.InitializedParams;
import org.eclipse.lsp4j.InlayHint;
import org.eclipse.lsp4j.InlayHintParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.PrepareRenameDefaultBehavior;
import org.eclipse.lsp4j.PrepareRenameParams;
import org.eclipse.lsp4j.PrepareRenameResult;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.RenameFilesParams;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.SelectionRange;
import org.eclipse.lsp4j.SelectionRangeParams;
import org.eclipse.lsp4j.SemanticTokens;
import org.eclipse.lsp4j.SemanticTokensParams;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.SignatureHelpParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.TypeDefinitionParams;
import org.eclipse.lsp4j.WillSaveTextDocumentParams;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.WorkspaceSymbol;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.eclipse.lsp4j.extended.ProjectBuildParams;
import org.eclipse.lsp4j.extended.ProjectConfigurationsUpdateParam;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.eclipse.lsp4j.jsonrpc.CompletableFutures;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.messages.Either3;
import org.eclipse.lsp4j.jsonrpc.services.JsonDelegate;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.lsp4j.services.NotebookDocumentService;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.eclipse.lsp4j.services.WorkspaceService;

public class JDTLanguageServer
extends BaseJDTLanguageServer
implements LanguageServer,
TextDocumentService,
WorkspaceService,
JavaProtocolExtensions {
    public static final String JAVA_LSP_JOIN_ON_COMPLETION = "java.lsp.joinOnCompletion";
    public static final String JAVA_LSP_INITIALIZE_WORKSPACE = "java.lsp.initializeWorkspace";
    private ProjectsManager pm;
    private LanguageServerWorkingCopyOwner workingCopyOwner;
    private PreferenceManager preferenceManager;
    private DocumentLifeCycleHandler documentLifeCycleHandler;
    private WorkspaceEventsHandler workspaceEventHandler;
    private WorkspaceDiagnosticsHandler workspaceDiagnosticsHandler;
    private ClasspathUpdateHandler classpathUpdateHandler;
    private JVMConfigurator jvmConfigurator;
    private WorkspaceExecuteCommandHandler commandHandler;
    private ProgressReporterManager progressReporterManager;
    private ServiceStatus status;
    private TelemetryManager telemetryManager;
    private Job shutdownJob = new Job("Shutdown..."){

        protected IStatus run(IProgressMonitor monitor) {
            try {
                JavaRuntime.removeVMInstallChangedListener((IVMInstallChangedListener)JDTLanguageServer.this.jvmConfigurator);
                if (JDTLanguageServer.this.workspaceDiagnosticsHandler != null) {
                    JDTLanguageServer.this.workspaceDiagnosticsHandler.removeResourceChangeListener();
                    JDTLanguageServer.this.workspaceDiagnosticsHandler = null;
                }
                if (JDTLanguageServer.this.classpathUpdateHandler != null) {
                    JDTLanguageServer.this.classpathUpdateHandler.removeElementChangeListener();
                    JDTLanguageServer.this.classpathUpdateHandler = null;
                }
                ResourcesPlugin.getWorkspace().save(true, monitor);
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException(e.getMessage(), e);
            }
            return Status.OK_STATUS;
        }
    };

    @Override
    public LanguageServerWorkingCopyOwner getWorkingCopyOwner() {
        return this.workingCopyOwner;
    }

    public JDTLanguageServer(ProjectsManager projects, PreferenceManager preferenceManager) {
        this(projects, preferenceManager, WorkspaceExecuteCommandHandler.getInstance());
    }

    public JDTLanguageServer(ProjectsManager projects, PreferenceManager preferenceManager, TelemetryManager telemetryManager) {
        this(projects, preferenceManager, WorkspaceExecuteCommandHandler.getInstance(), telemetryManager);
    }

    public JDTLanguageServer(ProjectsManager projects, PreferenceManager preferenceManager, WorkspaceExecuteCommandHandler commandHandler) {
        this(projects, preferenceManager, commandHandler, new TelemetryManager());
    }

    public JDTLanguageServer(ProjectsManager projects, PreferenceManager preferenceManager, WorkspaceExecuteCommandHandler commandHandler, TelemetryManager telemetryManager) {
        this.pm = projects;
        this.preferenceManager = preferenceManager;
        this.jvmConfigurator = new JVMConfigurator();
        JavaRuntime.addVMInstallChangedListener((IVMInstallChangedListener)this.jvmConfigurator);
        this.commandHandler = commandHandler;
        this.telemetryManager = telemetryManager;
    }

    @Override
    public void connectClient(JavaClientConnection.JavaLanguageClient client) {
        super.connectClient(client);
        this.progressReporterManager = new ProgressReporterManager(client, this.preferenceManager);
        Job.getJobManager().setProgressProvider((ProgressProvider)this.progressReporterManager);
        this.workingCopyOwner = new LanguageServerWorkingCopyOwner(this.client);
        this.pm.setConnection(client);
        WorkingCopyOwner.setPrimaryBufferProvider((WorkingCopyOwner)this.workingCopyOwner);
        this.documentLifeCycleHandler = new DocumentLifeCycleHandler(this.client, this.preferenceManager, this.pm, true);
        this.workspaceEventHandler = new WorkspaceEventsHandler(this.pm, this.client, this.documentLifeCycleHandler);
        this.telemetryManager.setLanguageClient(client);
        this.telemetryManager.setPreferenceManager(this.preferenceManager);
    }

    public void setClientConnection(JavaClientConnection client) {
        this.client = client;
    }

    public void disconnectClient() {
        Job.getJobManager().setProgressProvider(null);
        this.client.disconnect();
    }

    public CompletableFuture<InitializeResult> initialize(InitializeParams params) {
        JavaLanguageServerPlugin.logInfo(">> initialize");
        this.status = ServiceStatus.Starting;
        InitHandler handler = new InitHandler(this.pm, this.preferenceManager, this.client, this.commandHandler, this.telemetryManager);
        return CompletableFuture.completedFuture(handler.initialize(params));
    }

    public void initialized(InitializedParams params) {
        JavaLanguageServerPlugin.logInfo(">> initialized");
        try {
            JobHelpers.waitForInitializeJobs(3600000);
        }
        catch (OperationCanceledException e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
        }
        JavaLanguageServerPlugin.logInfo(">> initialization job finished");
        Job initializeWorkspace = new Job("Initialize workspace"){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    JDTLanguageServer.this.workspaceDiagnosticsHandler = new WorkspaceDiagnosticsHandler(JDTLanguageServer.this.client, JDTLanguageServer.this.pm, JDTLanguageServer.this.preferenceManager.getClientPreferences(), JDTLanguageServer.this.documentLifeCycleHandler);
                    JDTLanguageServer.this.workspaceDiagnosticsHandler.addResourceChangeListener();
                    JDTLanguageServer.this.classpathUpdateHandler = new ClasspathUpdateHandler(JDTLanguageServer.this.client);
                    JDTLanguageServer.this.classpathUpdateHandler.addElementChangeListener();
                    JDTLanguageServer.this.pm.registerWatchers();
                    JavaLanguageServerPlugin.debugTrace(">> watchers registered");
                    JDTLanguageServer.this.registerCapabilities();
                    JDTLanguageServer.this.syncCapabilitiesToSettings();
                    JDTLanguageServer.this.synchronizeBundles();
                    JDTLanguageServer.this.client.sendStatus(ServiceStatus.ServiceReady, "ServiceReady");
                    JDTLanguageServer.this.status = ServiceStatus.ServiceReady;
                    JDTLanguageServer.this.telemetryManager.onServiceReady(System.currentTimeMillis());
                    JDTLanguageServer.this.pm.projectsImported(monitor);
                    IndexUtils.copyIndexesToSharedLocation();
                    JobHelpers.waitForBuildJobs(3600000);
                    JavaLanguageServerPlugin.logInfo(">> build jobs finished");
                    JDTLanguageServer.this.telemetryManager.onBuildFinished(System.currentTimeMillis());
                    JDTLanguageServer.this.workspaceDiagnosticsHandler.publishDiagnostics(monitor);
                }
                catch (CoreException | OperationCanceledException e) {
                    JavaLanguageServerPlugin.logException(e.getMessage(), e);
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return JDTLanguageServer.JAVA_LSP_INITIALIZE_WORKSPACE.equals(family);
            }
        };
        initializeWorkspace.setPriority(40);
        initializeWorkspace.setSystem(true);
        initializeWorkspace.schedule();
    }

    private void registerCapabilities() {
        if (this.preferenceManager.getClientPreferences().isWorkspaceSymbolDynamicRegistered()) {
            this.registerCapability(Preferences.WORKSPACE_SYMBOL_ID, "workspace/symbol");
        }
        if (!this.preferenceManager.getClientPreferences().isClientDocumentSymbolProviderRegistered() && this.preferenceManager.getClientPreferences().isDocumentSymbolDynamicRegistered()) {
            this.registerCapability(Preferences.DOCUMENT_SYMBOL_ID, "textDocument/documentSymbol");
        }
        if (this.preferenceManager.getClientPreferences().isDefinitionDynamicRegistered()) {
            this.registerCapability(Preferences.DEFINITION_ID, "textDocument/definition");
        }
        if (this.preferenceManager.getClientPreferences().isTypeDefinitionDynamicRegistered()) {
            this.registerCapability(Preferences.TYPEDEFINITION_ID, "textDocument/typeDefinition");
        }
        if (!this.preferenceManager.getClientPreferences().isClientHoverProviderRegistered() && this.preferenceManager.getClientPreferences().isHoverDynamicRegistered()) {
            this.registerCapability(Preferences.HOVER_ID, "textDocument/hover");
        }
        if (this.preferenceManager.getClientPreferences().isReferencesDynamicRegistered()) {
            this.registerCapability(Preferences.REFERENCES_ID, "textDocument/references");
        }
        if (this.preferenceManager.getClientPreferences().isDocumentHighlightDynamicRegistered()) {
            this.registerCapability(Preferences.DOCUMENT_HIGHLIGHT_ID, "textDocument/documentHighlight");
        }
        if (this.preferenceManager.getClientPreferences().isWorkspaceFoldersSupported()) {
            this.registerCapability(Preferences.WORKSPACE_CHANGE_FOLDERS_ID, "workspace/didChangeWorkspaceFolders");
        }
        if (this.preferenceManager.getClientPreferences().isImplementationDynamicRegistered()) {
            this.registerCapability(Preferences.IMPLEMENTATION_ID, "textDocument/implementation");
        }
        if (this.preferenceManager.getClientPreferences().isInlayHintDynamicRegistered()) {
            this.registerCapability(Preferences.INLAY_HINT_ID, "textDocument/inlayHint");
        }
    }

    private void syncCapabilitiesToSettings() {
        if (this.preferenceManager.getClientPreferences().isCompletionDynamicRegistered()) {
            this.toggleCapability(this.preferenceManager.getPreferences().isCompletionEnabled(), Preferences.COMPLETION_ID, "textDocument/completion", CompletionHandler.getDefaultCompletionOptions(this.preferenceManager));
        }
        if (this.preferenceManager.getClientPreferences().isFormattingDynamicRegistrationSupported()) {
            this.toggleCapability(this.preferenceManager.getPreferences().isJavaFormatEnabled(), Preferences.FORMATTING_ID, "textDocument/formatting", null);
        }
        if (this.preferenceManager.getClientPreferences().isRangeFormattingDynamicRegistrationSupported()) {
            this.toggleCapability(this.preferenceManager.getPreferences().isJavaFormatEnabled(), Preferences.FORMATTING_RANGE_ID, "textDocument/rangeFormatting", null);
        }
        if (this.preferenceManager.getClientPreferences().isOnTypeFormattingDynamicRegistrationSupported()) {
            this.toggleCapability(this.preferenceManager.getPreferences().isJavaFormatOnTypeEnabled(), Preferences.FORMATTING_ON_TYPE_ID, "textDocument/onTypeFormatting", new DocumentOnTypeFormattingOptions(";", Arrays.asList("\n", "}")));
        }
        if (this.preferenceManager.getClientPreferences().isCodeLensDynamicRegistrationSupported()) {
            this.toggleCapability(this.preferenceManager.getPreferences().isCodeLensEnabled(), Preferences.CODE_LENS_ID, "textDocument/codeLens", new CodeLensOptions(Boolean.valueOf(true)));
        }
        if (this.preferenceManager.getClientPreferences().isSignatureHelpDynamicRegistrationSupported()) {
            this.toggleCapability(this.preferenceManager.getPreferences().isSignatureHelpEnabled(), Preferences.SIGNATURE_HELP_ID, "textDocument/signatureHelp", SignatureHelpHandler.createOptions());
        }
        if (this.preferenceManager.getClientPreferences().isRenameDynamicRegistrationSupported()) {
            this.toggleCapability(this.preferenceManager.getPreferences().isRenameEnabled(), Preferences.RENAME_ID, "textDocument/rename", RenameHandler.createOptions());
        }
        if (this.preferenceManager.getClientPreferences().isExecuteCommandDynamicRegistrationSupported()) {
            this.toggleCapability(this.preferenceManager.getPreferences().isExecuteCommandEnabled(), Preferences.EXECUTE_COMMAND_ID, "workspace/executeCommand", new ExecuteCommandOptions(new ArrayList<String>(this.commandHandler.getNonStaticCommands())));
        }
        if (this.preferenceManager.getClientPreferences().isCodeActionDynamicRegistered()) {
            this.toggleCapability(this.preferenceManager.getClientPreferences().isCodeActionDynamicRegistered(), Preferences.CODE_ACTION_ID, "textDocument/codeAction", this.getCodeActionOptions());
        }
        if (this.preferenceManager.getClientPreferences().isFoldgingRangeDynamicRegistered()) {
            this.toggleCapability(this.preferenceManager.getPreferences().isFoldingRangeEnabled(), Preferences.FOLDINGRANGE_ID, "textDocument/foldingRange", null);
        }
        if (this.preferenceManager.getClientPreferences().isSelectionRangeDynamicRegistered()) {
            this.toggleCapability(this.preferenceManager.getPreferences().isSelectionRangeEnabled(), Preferences.SELECTION_RANGE_ID, "textDocument/selectionRange", null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void synchronizeBundles() {
        try {
            Object commandResult;
            Object object = commandResult = JavaLanguageServerPlugin.getInstance().getClientConnection().executeClientCommand("_java.reloadBundles.command", new Object[0]);
            if (object instanceof List) {
                List list = (List)object;
                List cfr_ignored_0 = (List)object;
                List bundlesToRefresh = (List)commandResult;
                if (bundlesToRefresh.size() > 0) {
                    BundleUtils.loadBundles(bundlesToRefresh);
                }
            } else {
                Object object2 = commandResult;
                if (object2 instanceof Map) {
                    void m;
                    Map bundlesToRefresh = (Map)object2;
                    Map cfr_ignored_1 = (Map)object2;
                    String message = (String)m.get("message");
                    JavaLanguageServerPlugin.logError(message);
                } else {
                    JavaLanguageServerPlugin.logError("Unexpected result from executeClientCommand: " + commandResult);
                }
            }
        }
        catch (Exception e) {
            JavaLanguageServerPlugin.logException(e);
        }
    }

    private CodeActionOptions getCodeActionOptions() {
        String[] kinds = new String[]{"quickfix", "refactor", "refactor.extract", "refactor.inline", "refactor.rewrite", "source", "source.organizeImports"};
        ArrayList<String> codeActionKinds = new ArrayList<String>();
        String[] stringArray = kinds;
        int n = kinds.length;
        int n2 = 0;
        while (n2 < n) {
            String kind = stringArray[n2];
            if (this.preferenceManager.getClientPreferences().isSupportedCodeActionKind(kind)) {
                codeActionKinds.add(kind);
            }
            ++n2;
        }
        CodeActionOptions options = new CodeActionOptions(codeActionKinds);
        options.setResolveProvider(Boolean.valueOf(this.preferenceManager.getClientPreferences().isResolveCodeActionSupported()));
        return options;
    }

    public CompletableFuture<Object> shutdown() {
        JavaLanguageServerPlugin.logInfo(">> shutdown");
        return this.computeAsync(monitor -> {
            this.shutdownJob.setSystem(true);
            this.shutdownJob.schedule();
            this.shutdownReceived = true;
            if (this.preferenceManager.getClientPreferences().shouldLanguageServerExitOnShutdown()) {
                Executors.newSingleThreadScheduledExecutor().schedule(() -> this.exit(), 1L, TimeUnit.SECONDS);
            }
            return new Object();
        });
    }

    public void exit() {
        JavaLanguageServerPlugin.logInfo(">> exit");
        LanguageServerApplication application = JavaLanguageServerPlugin.getLanguageServer();
        if (application != null && application.getParentProcessId() != ProcessHandle.current().pid()) {
            Executors.newSingleThreadScheduledExecutor().schedule(() -> {
                JavaLanguageServerPlugin.logInfo("Forcing exit after 1 min.");
                System.exit(1);
            }, 1L, TimeUnit.MINUTES);
        }
        if (!this.shutdownReceived) {
            this.shutdownJob.setSystem(true);
            this.shutdownJob.schedule();
        }
        try {
            this.shutdownJob.join();
        }
        catch (InterruptedException e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
        }
        JavaLanguageServerPlugin.getLanguageServer().exit();
    }

    public TextDocumentService getTextDocumentService() {
        return this;
    }

    public WorkspaceService getWorkspaceService() {
        return this;
    }

    @JsonDelegate
    public JavaProtocolExtensions getJavaExtensions() {
        return this;
    }

    public CompletableFuture<Either<List<? extends SymbolInformation>, List<? extends WorkspaceSymbol>>> symbol(WorkspaceSymbolParams params) {
        JavaLanguageServerPlugin.debugTrace(">> workspace/symbol");
        return this.computeAsync(monitor -> Either.forLeft(WorkspaceSymbolHandler.search(params.getQuery(), monitor)));
    }

    public void didChangeConfiguration(DidChangeConfigurationParams params) {
        JavaLanguageServerPlugin.debugTrace(">> workspace/didChangeConfiguration");
        Map settings = JSONUtility.toModel(params.getSettings(), Map.class);
        boolean nullAnalysisOptionsUpdated = false;
        if (settings instanceof Map) {
            Collection<IPath> rootPaths = this.preferenceManager.getPreferences().getRootPaths();
            Preferences prefs = Preferences.createFrom(settings);
            prefs.setRootPaths(rootPaths);
            boolean nullAnalysisConfigurationsChanged = !prefs.getNullableTypes().equals(this.preferenceManager.getPreferences().getNullableTypes()) || !prefs.getNonnullTypes().equals(this.preferenceManager.getPreferences().getNonnullTypes()) || !prefs.getNullAnalysisMode().equals((Object)this.preferenceManager.getPreferences().getNullAnalysisMode());
            this.preferenceManager.update(prefs);
            if (nullAnalysisConfigurationsChanged) {
                nullAnalysisOptionsUpdated = this.preferenceManager.getPreferences().updateAnnotationNullAnalysisOptions();
            }
        }
        if (this.status == ServiceStatus.ServiceReady) {
            this.syncCapabilitiesToSettings();
        }
        boolean jvmChanged = false;
        try {
            jvmChanged = JVMConfigurator.configureJVMs(this.preferenceManager.getPreferences(), this.client);
        }
        catch (Exception e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
        }
        try {
            boolean isAutobuildEnabled = this.preferenceManager.getPreferences().isAutobuildEnabled();
            boolean autoBuildChanged = ProjectsManager.setAutoBuilding(isAutobuildEnabled);
            if (jvmChanged || nullAnalysisOptionsUpdated && isAutobuildEnabled) {
                this.buildWorkspace((Either<Boolean, boolean[]>)Either.forLeft((Object)true));
            } else if (autoBuildChanged && isAutobuildEnabled) {
                this.buildWorkspace((Either<Boolean, boolean[]>)Either.forLeft((Object)false));
            } else if (nullAnalysisOptionsUpdated && !isAutobuildEnabled) {
                this.documentLifeCycleHandler.publishDiagnostics((IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
        }
        JavaLanguageServerPlugin.debugTrace(">> New configuration: " + settings);
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
        JavaLanguageServerPlugin.debugTrace(">> workspace/didChangeWatchedFiles ");
        this.workspaceEventHandler.didChangeWatchedFiles(params);
    }

    public CompletableFuture<Object> executeCommand(ExecuteCommandParams params) {
        JavaLanguageServerPlugin.debugTrace(">> workspace/executeCommand " + (params == null ? null : params.getCommand()));
        return this.computeAsync(monitor -> this.commandHandler.executeCommand(params, (IProgressMonitor)monitor));
    }

    public CompletableFuture<Either<List<CompletionItem>, CompletionList>> completion(CompletionParams position) {
        JavaLanguageServerPlugin.debugTrace(">> document/completion");
        try {
            CompletionHandler handler = new CompletionHandler(this.preferenceManager);
            NullProgressMonitor monitor = new NullProgressMonitor();
            if (Boolean.getBoolean(JAVA_LSP_JOIN_ON_COMPLETION)) {
                this.waitForLifecycleJobs((IProgressMonitor)monitor);
            }
            Either<List<CompletionItem>, CompletionList> result = handler.completion(position, (IProgressMonitor)monitor);
            return CompletableFuture.completedFuture(result);
        }
        catch (Exception ex) {
            return CompletableFuture.failedFuture(ex);
        }
    }

    public CompletableFuture<CompletionItem> resolveCompletionItem(CompletionItem unresolved) {
        JavaLanguageServerPlugin.debugTrace(">> document/resolveCompletionItem");
        try {
            CompletionResolveHandler handler = new CompletionResolveHandler(this.preferenceManager);
            NullProgressMonitor monitor = new NullProgressMonitor();
            if (Boolean.getBoolean(JAVA_LSP_JOIN_ON_COMPLETION)) {
                this.waitForLifecycleJobs((IProgressMonitor)monitor);
            }
            CompletionItem result = handler.resolve(unresolved, (IProgressMonitor)monitor);
            return CompletableFuture.completedFuture(result);
        }
        catch (Exception ex) {
            return CompletableFuture.failedFuture(ex);
        }
    }

    public CompletableFuture<Hover> hover(HoverParams position) {
        JavaLanguageServerPlugin.debugTrace(">> document/hover");
        HoverHandler handler = new HoverHandler(this.preferenceManager);
        return this.computeAsync(monitor -> handler.hover((TextDocumentPositionParams)position, (IProgressMonitor)monitor));
    }

    public CompletableFuture<SignatureHelp> signatureHelp(SignatureHelpParams position) {
        JavaLanguageServerPlugin.debugTrace(">> document/signatureHelp");
        SignatureHelpHandler handler = new SignatureHelpHandler(this.preferenceManager);
        return this.computeAsync(monitor -> handler.signatureHelp(position, (IProgressMonitor)monitor));
    }

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> definition(DefinitionParams position) {
        JavaLanguageServerPlugin.debugTrace(">> document/definition");
        NavigateToDefinitionHandler handler = new NavigateToDefinitionHandler(this.preferenceManager);
        return this.computeAsync(monitor -> {
            this.waitForLifecycleJobs((IProgressMonitor)monitor);
            return Either.forLeft(handler.definition((TextDocumentPositionParams)position, (IProgressMonitor)monitor));
        });
    }

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> typeDefinition(TypeDefinitionParams position) {
        JavaLanguageServerPlugin.debugTrace(">> document/typeDefinition");
        NavigateToTypeDefinitionHandler handler = new NavigateToTypeDefinitionHandler();
        return this.computeAsync(monitor -> {
            this.waitForLifecycleJobs((IProgressMonitor)monitor);
            return Either.forLeft(handler.typeDefinition((TextDocumentPositionParams)position, (IProgressMonitor)monitor));
        });
    }

    public CompletableFuture<List<? extends Location>> references(ReferenceParams params) {
        JavaLanguageServerPlugin.debugTrace(">> document/references");
        ReferencesHandler handler = new ReferencesHandler(this.preferenceManager);
        return this.computeAsync(monitor -> handler.findReferences(params, (IProgressMonitor)monitor));
    }

    @Override
    public CompletableFuture<List<? extends Location>> findLinks(FindLinksHandler.FindLinksParams params) {
        JavaLanguageServerPlugin.debugTrace(">> java/findLinks");
        return this.computeAsync(monitor -> FindLinksHandler.findLinks(findLinksParams.type, findLinksParams.position, monitor));
    }

    public CompletableFuture<List<? extends DocumentHighlight>> documentHighlight(DocumentHighlightParams position) {
        JavaLanguageServerPlugin.debugTrace(">> document/documentHighlight");
        return this.computeAsync(monitor -> DocumentHighlightHandler.documentHighlight((TextDocumentPositionParams)position, monitor));
    }

    public CompletableFuture<List<Either<SymbolInformation, DocumentSymbol>>> documentSymbol(DocumentSymbolParams params) {
        JavaLanguageServerPlugin.debugTrace(">> document/documentSymbol");
        DocumentSymbolHandler handler = new DocumentSymbolHandler(this.preferenceManager);
        return this.computeAsync(monitor -> {
            this.waitForLifecycleJobs((IProgressMonitor)monitor);
            return handler.documentSymbol(params, (IProgressMonitor)monitor);
        });
    }

    public CompletableFuture<List<Either<Command, CodeAction>>> codeAction(CodeActionParams params) {
        JavaLanguageServerPlugin.debugTrace(">> document/codeAction");
        CodeActionHandler handler = new CodeActionHandler(this.preferenceManager);
        return this.computeAsync(monitor -> {
            this.waitForLifecycleJobs((IProgressMonitor)monitor);
            return handler.getCodeActionCommands(params, (IProgressMonitor)monitor);
        });
    }

    /*
     * WARNING - void declaration
     */
    public CompletableFuture<CodeAction> resolveCodeAction(CodeAction params) {
        JavaLanguageServerPlugin.debugTrace(">> codeAction/resolve");
        Object data = params.getData();
        if (data == null) {
            return CompletableFuture.completedFuture(params);
        }
        Object object = data;
        if (object instanceof CodeActionHandler.CodeActionData) {
            void codeActionData;
            CodeActionHandler.CodeActionData codeActionData2 = (CodeActionHandler.CodeActionData)object;
            CodeActionHandler.CodeActionData cfr_ignored_0 = (CodeActionHandler.CodeActionData)object;
            if (codeActionData.getProposal() == null) {
                return CompletableFuture.completedFuture(params);
            }
        }
        if (CodeActionHandler.codeActionStore.isEmpty()) {
            return CompletableFuture.completedFuture(params);
        }
        CodeActionResolveHandler handler = new CodeActionResolveHandler();
        return this.computeAsync(monitor -> {
            this.waitForLifecycleJobs((IProgressMonitor)monitor);
            return handler.resolve(params, (IProgressMonitor)monitor);
        });
    }

    public CompletableFuture<List<? extends CodeLens>> codeLens(CodeLensParams params) {
        JavaLanguageServerPlugin.debugTrace(">> document/codeLens");
        CodeLensHandler handler = new CodeLensHandler(this.preferenceManager);
        return this.computeAsync(monitor -> {
            this.waitForLifecycleJobs((IProgressMonitor)monitor);
            return handler.getCodeLensSymbols(params.getTextDocument().getUri(), (IProgressMonitor)monitor);
        });
    }

    public CompletableFuture<CodeLens> resolveCodeLens(CodeLens unresolved) {
        JavaLanguageServerPlugin.debugTrace(">> codeLens/resolve");
        CodeLensHandler handler = new CodeLensHandler(this.preferenceManager);
        return this.computeAsync(monitor -> {
            this.waitForLifecycleJobs((IProgressMonitor)monitor);
            return handler.resolve(unresolved, (IProgressMonitor)monitor);
        });
    }

    public CompletableFuture<List<? extends TextEdit>> formatting(DocumentFormattingParams params) {
        JavaLanguageServerPlugin.debugTrace(">> document/formatting");
        FormatterHandler handler = new FormatterHandler(this.preferenceManager);
        return this.computeAsync(monitor -> handler.formatting(params, (IProgressMonitor)monitor));
    }

    public CompletableFuture<List<? extends TextEdit>> rangeFormatting(DocumentRangeFormattingParams params) {
        JavaLanguageServerPlugin.debugTrace(">> document/rangeFormatting");
        FormatterHandler handler = new FormatterHandler(this.preferenceManager);
        return this.computeAsync(monitor -> handler.rangeFormatting(params, (IProgressMonitor)monitor));
    }

    public CompletableFuture<List<? extends TextEdit>> onTypeFormatting(DocumentOnTypeFormattingParams params) {
        JavaLanguageServerPlugin.debugTrace(">> document/onTypeFormatting");
        FormatterHandler handler = new FormatterHandler(this.preferenceManager);
        return this.computeAsync(monitor -> handler.onTypeFormatting(params, (IProgressMonitor)monitor));
    }

    public CompletableFuture<Either3<Range, PrepareRenameResult, PrepareRenameDefaultBehavior>> prepareRename(PrepareRenameParams params) {
        JavaLanguageServerPlugin.debugTrace(">> document/prepareRename");
        PrepareRenameHandler handler = new PrepareRenameHandler(this.preferenceManager);
        return this.computeAsync(monitor -> {
            this.waitForLifecycleJobs((IProgressMonitor)monitor);
            return Either3.forLeft3((Object)handler.prepareRename((TextDocumentPositionParams)params, (IProgressMonitor)monitor));
        });
    }

    public CompletableFuture<WorkspaceEdit> rename(RenameParams params) {
        JavaLanguageServerPlugin.debugTrace(">> document/rename");
        RenameHandler handler = new RenameHandler(this.preferenceManager);
        return this.computeAsync(monitor -> {
            this.waitForLifecycleJobs((IProgressMonitor)monitor);
            return handler.rename(params, (IProgressMonitor)monitor);
        });
    }

    public void didOpen(DidOpenTextDocumentParams params) {
        JavaLanguageServerPlugin.debugTrace(">> document/didOpen");
        this.documentLifeCycleHandler.didOpen(params);
    }

    public void didChange(DidChangeTextDocumentParams params) {
        JavaLanguageServerPlugin.debugTrace(">> document/didChange");
        this.documentLifeCycleHandler.didChange(params);
    }

    public void didClose(DidCloseTextDocumentParams params) {
        JavaLanguageServerPlugin.debugTrace(">> document/didClose");
        this.documentLifeCycleHandler.didClose(params);
    }

    @Override
    public void validateDocument(ValidateDocumentParams params) {
        JavaLanguageServerPlugin.logInfo(">> java/validateDocument");
        this.computeAsync(monitor -> {
            try {
                this.documentLifeCycleHandler.validateDocument(params.getTextDocument().getUri(), true, (IProgressMonitor)monitor);
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
            return null;
        });
    }

    public CompletableFuture<List<TextEdit>> willSaveWaitUntil(WillSaveTextDocumentParams params) {
        JavaLanguageServerPlugin.debugTrace(">> document/willSaveWaitUntil");
        SaveActionHandler handler = new SaveActionHandler(this.preferenceManager);
        return this.computeAsync(monitor -> handler.willSaveWaitUntil(params, (IProgressMonitor)monitor));
    }

    public void didSave(DidSaveTextDocumentParams params) {
        JavaLanguageServerPlugin.debugTrace(">> document/didSave");
        this.documentLifeCycleHandler.didSave(params);
    }

    public CompletableFuture<WorkspaceEdit> willRenameFiles(RenameFilesParams params) {
        JavaLanguageServerPlugin.debugTrace(">> workspace/willRenameFiles");
        return this.computeAsyncWithClientProgress(monitor -> {
            this.waitForLifecycleJobs((IProgressMonitor)monitor);
            return FileEventHandler.handleWillRenameFiles(params, monitor);
        });
    }

    @Override
    public CompletableFuture<String> classFileContents(TextDocumentIdentifier param) {
        JavaLanguageServerPlugin.debugTrace(">> java/classFileContents");
        ContentProviderManager handler = JavaLanguageServerPlugin.getContentProviderManager();
        URI uri = JDTUtils.toURI(param.getUri());
        return this.computeAsync(monitor -> handler.getContent(uri, (IProgressMonitor)monitor));
    }

    @Override
    public void projectConfigurationUpdate(TextDocumentIdentifier param) {
        JavaLanguageServerPlugin.debugTrace(">> java/projectConfigurationUpdate");
        ProjectConfigurationUpdateHandler handler = new ProjectConfigurationUpdateHandler(this.pm);
        handler.updateConfiguration(param);
    }

    @Override
    public void projectConfigurationsUpdate(ProjectConfigurationsUpdateParam param) {
        JavaLanguageServerPlugin.debugTrace(">> java/projectConfigurationsUpdate");
        ProjectConfigurationUpdateHandler handler = new ProjectConfigurationUpdateHandler(this.pm);
        handler.updateConfigurations(param.getIdentifiers());
    }

    @Override
    public CompletableFuture<BuildWorkspaceStatus> buildWorkspace(Either<Boolean, boolean[]> forceRebuild) {
        boolean rebuild = forceRebuild.isLeft() ? (Boolean)forceRebuild.getLeft() : ((boolean[])forceRebuild.getRight())[0];
        JavaLanguageServerPlugin.debugTrace(">> java/buildWorkspace (" + (rebuild ? "full)" : "incremental)"));
        BuildWorkspaceHandler handler = new BuildWorkspaceHandler(this.pm);
        return this.computeAsyncWithClientProgress(monitor -> handler.buildWorkspace(rebuild, (IProgressMonitor)monitor));
    }

    @Override
    public CompletableFuture<BuildWorkspaceStatus> buildProjects(ProjectBuildParams params) {
        JavaLanguageServerPlugin.debugTrace(">> java/buildProjects");
        BuildWorkspaceHandler handler = new BuildWorkspaceHandler(this.pm);
        return this.computeAsyncWithClientProgress(monitor -> handler.buildProjects(params, (IProgressMonitor)monitor));
    }

    public void didChangeWorkspaceFolders(DidChangeWorkspaceFoldersParams params) {
        JavaLanguageServerPlugin.debugTrace(">> java/didChangeWorkspaceFolders");
        if (!this.preferenceManager.getClientPreferences().skipProjectConfiguration()) {
            WorkspaceFolderChangeHandler handler = new WorkspaceFolderChangeHandler(this.pm, this.preferenceManager);
            handler.update(params);
        }
    }

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> implementation(ImplementationParams position) {
        JavaLanguageServerPlugin.debugTrace(">> document/implementation");
        return this.computeAsyncWithClientProgress(monitor -> {
            ImplementationsHandler handler = new ImplementationsHandler(this.preferenceManager);
            return Either.forLeft(handler.findImplementations((TextDocumentPositionParams)position, (IProgressMonitor)monitor));
        });
    }

    public CompletableFuture<List<FoldingRange>> foldingRange(FoldingRangeRequestParams params) {
        JavaLanguageServerPlugin.debugTrace(">> document/foldingRange");
        return this.computeAsyncWithClientProgress(monitor -> {
            this.waitForLifecycleJobs((IProgressMonitor)monitor);
            return new FoldingRangeHandler().foldingRange(params, (IProgressMonitor)monitor);
        });
    }

    public CompletableFuture<List<SelectionRange>> selectionRange(SelectionRangeParams params) {
        JavaLanguageServerPlugin.debugTrace(">> document/selectionRange");
        return this.computeAsyncWithClientProgress(monitor -> {
            this.waitForLifecycleJobs((IProgressMonitor)monitor);
            return new SelectionRangeHandler().selectionRange(params, (IProgressMonitor)monitor);
        });
    }

    @Override
    public CompletableFuture<OverrideMethodsHandler.OverridableMethodsResponse> listOverridableMethods(CodeActionParams params) {
        JavaLanguageServerPlugin.debugTrace(">> java/listOverridableMethods");
        return this.computeAsync(monitor -> OverrideMethodsHandler.listOverridableMethods(params, monitor));
    }

    @Override
    public CompletableFuture<WorkspaceEdit> addOverridableMethods(OverrideMethodsHandler.AddOverridableMethodParams params) {
        JavaLanguageServerPlugin.debugTrace(">> java/addOverridableMethods");
        return this.computeAsync(monitor -> OverrideMethodsHandler.addOverridableMethods(params, monitor));
    }

    @Override
    public CompletableFuture<HashCodeEqualsHandler.CheckHashCodeEqualsResponse> checkHashCodeEqualsStatus(CodeActionParams params) {
        JavaLanguageServerPlugin.debugTrace(">> java/checkHashCodeEqualsStatus");
        return this.computeAsync(monitor -> HashCodeEqualsHandler.checkHashCodeEqualsStatus(params, monitor));
    }

    @Override
    public CompletableFuture<WorkspaceEdit> generateHashCodeEquals(HashCodeEqualsHandler.GenerateHashCodeEqualsParams params) {
        JavaLanguageServerPlugin.debugTrace(">> java/generateHashCodeEquals");
        return this.computeAsync(monitor -> HashCodeEqualsHandler.generateHashCodeEquals(params, monitor));
    }

    @Override
    public CompletableFuture<GenerateToStringHandler.CheckToStringResponse> checkToStringStatus(CodeActionParams params) {
        JavaLanguageServerPlugin.debugTrace(">> java/checkToStringStatus");
        return this.computeAsync(monitor -> GenerateToStringHandler.checkToStringStatus(params, monitor));
    }

    @Override
    public CompletableFuture<WorkspaceEdit> generateToString(GenerateToStringHandler.GenerateToStringParams params) {
        JavaLanguageServerPlugin.debugTrace(">> java/generateToString");
        return this.computeAsync(monitor -> GenerateToStringHandler.generateToString(params, monitor));
    }

    @Override
    public CompletableFuture<WorkspaceEdit> organizeImports(CodeActionParams params) {
        JavaLanguageServerPlugin.debugTrace(">> java/organizeImports");
        return this.computeAsync(monitor -> OrganizeImportsHandler.organizeImports(this.client, params, monitor));
    }

    @Override
    public CompletableFuture<GenerateGetterSetterOperation.AccessorField[]> resolveUnimplementedAccessors(GenerateAccessorsHandler.AccessorCodeActionParams params) {
        JavaLanguageServerPlugin.debugTrace(">> java/resolveUnimplementedAccessors");
        return this.computeAsync(monitor -> GenerateAccessorsHandler.getUnimplementedAccessors(params));
    }

    @Override
    public CompletableFuture<WorkspaceEdit> generateAccessors(GenerateAccessorsHandler.GenerateAccessorsParams params) {
        JavaLanguageServerPlugin.debugTrace(">> java/generateAccessors");
        return this.computeAsync(monitor -> GenerateAccessorsHandler.generateAccessors(params, monitor));
    }

    @Override
    public CompletableFuture<GenerateConstructorsHandler.CheckConstructorsResponse> checkConstructorsStatus(CodeActionParams params) {
        JavaLanguageServerPlugin.debugTrace(">> java/checkConstructorsStatus");
        return this.computeAsync(monitor -> GenerateConstructorsHandler.checkConstructorsStatus(params, monitor));
    }

    @Override
    public CompletableFuture<WorkspaceEdit> generateConstructors(GenerateConstructorsHandler.GenerateConstructorsParams params) {
        JavaLanguageServerPlugin.debugTrace(">> java/generateConstructors");
        return this.computeAsync(monitor -> GenerateConstructorsHandler.generateConstructors(params, monitor));
    }

    @Override
    public CompletableFuture<GenerateDelegateMethodsHandler.CheckDelegateMethodsResponse> checkDelegateMethodsStatus(CodeActionParams params) {
        JavaLanguageServerPlugin.debugTrace(">> java/checkDelegateMethodsStatus");
        return this.computeAsync(monitor -> GenerateDelegateMethodsHandler.checkDelegateMethodsStatus(params, monitor));
    }

    @Override
    public CompletableFuture<WorkspaceEdit> generateDelegateMethods(GenerateDelegateMethodsHandler.GenerateDelegateMethodsParams params) {
        JavaLanguageServerPlugin.debugTrace(">> java/generateDelegateMethods");
        return this.computeAsync(monitor -> GenerateDelegateMethodsHandler.generateDelegateMethods(params, monitor));
    }

    @Override
    public CompletableFuture<GetRefactorEditHandler.RefactorWorkspaceEdit> getRefactorEdit(GetRefactorEditHandler.GetRefactorEditParams params) {
        JavaLanguageServerPlugin.debugTrace(">> java/getRefactorEdit");
        return this.computeAsync(monitor -> GetRefactorEditHandler.getEditsForRefactor(params));
    }

    @Override
    public CompletableFuture<List<InferSelectionHandler.SelectionInfo>> inferSelection(InferSelectionHandler.InferSelectionParams params) {
        JavaLanguageServerPlugin.debugTrace(">> java/inferSelection");
        return this.computeAsync(monitor -> InferSelectionHandler.inferSelectionsForRefactor(params));
    }

    @Override
    public CompletableFuture<MoveHandler.MoveDestinationsResponse> getMoveDestinations(MoveHandler.MoveParams params) {
        JavaLanguageServerPlugin.debugTrace(">> java/getMoveDestinations");
        return this.computeAsync(monitor -> MoveHandler.getMoveDestinations(params));
    }

    @Override
    public CompletableFuture<GetRefactorEditHandler.RefactorWorkspaceEdit> move(MoveHandler.MoveParams params) {
        JavaLanguageServerPlugin.debugTrace(">> java/move");
        return this.computeAsyncWithClientProgress(monitor -> MoveHandler.move(params, monitor));
    }

    @Override
    public CompletableFuture<List<SymbolInformation>> searchSymbols(WorkspaceSymbolHandler.SearchSymbolParams params) {
        JavaLanguageServerPlugin.debugTrace(">> java/searchSymbols");
        return this.computeAsyncWithClientProgress(monitor -> WorkspaceSymbolHandler.search(params.getQuery(), searchSymbolParams.maxResults, searchSymbolParams.projectName, searchSymbolParams.sourceOnly, monitor));
    }

    public CompletableFuture<List<CallHierarchyItem>> prepareCallHierarchy(CallHierarchyPrepareParams params) {
        JavaLanguageServerPlugin.debugTrace(">> textDocument/prepareCallHierarchy");
        return this.computeAsyncWithClientProgress(monitor -> new CallHierarchyHandler().prepareCallHierarchy(params, (IProgressMonitor)monitor));
    }

    public CompletableFuture<List<CallHierarchyIncomingCall>> callHierarchyIncomingCalls(CallHierarchyIncomingCallsParams params) {
        JavaLanguageServerPlugin.debugTrace(">> callHierarchy/incomingCalls");
        return this.computeAsyncWithClientProgress(monitor -> new CallHierarchyHandler().callHierarchyIncomingCalls(params, (IProgressMonitor)monitor));
    }

    public CompletableFuture<List<CallHierarchyOutgoingCall>> callHierarchyOutgoingCalls(CallHierarchyOutgoingCallsParams params) {
        JavaLanguageServerPlugin.debugTrace(">> callHierarchy/outgoingCalls");
        return this.computeAsyncWithClientProgress(monitor -> new CallHierarchyHandler().callHierarchyOutgoingCalls(params, (IProgressMonitor)monitor));
    }

    public CompletableFuture<SemanticTokens> semanticTokensFull(SemanticTokensParams params) {
        JavaLanguageServerPlugin.debugTrace(">> textDocument/semanticTokens/full");
        return this.computeAsync(monitor -> {
            DocumentLifeCycleHandler documentLifeCycleHandler = this.documentLifeCycleHandler;
            documentLifeCycleHandler.getClass();
            return SemanticTokensHandler.full(monitor, params, documentLifeCycleHandler.new BaseDocumentLifeCycleHandler.DocumentMonitor(params.getTextDocument().getUri()));
        });
    }

    public CompletableFuture<List<InlayHint>> inlayHint(InlayHintParams params) {
        JavaLanguageServerPlugin.debugTrace(">> textDocument/inlayHint");
        return this.computeAsync(monitor -> new InlayHintsHandler(this.preferenceManager).inlayHint(params, (IProgressMonitor)monitor));
    }

    @Override
    public CompletableFuture<ExtractInterfaceHandler.CheckExtractInterfaceResponse> checkExtractInterfaceStatus(CodeActionParams params) {
        JavaLanguageServerPlugin.debugTrace(">> java/checkExtractInterfaceStatus");
        return this.computeAsync(monitor -> ExtractInterfaceHandler.checkExtractInterfaceStatus(params));
    }

    private <R> CompletableFuture<R> computeAsyncWithClientProgress(Function<IProgressMonitor, R> code) {
        return CompletableFutures.computeAsync(cc -> {
            IProgressMonitor monitor = this.progressReporterManager.getProgressReporter((CancelChecker)cc);
            return code.apply(monitor);
        });
    }

    private void waitForLifecycleJobs(IProgressMonitor monitor) {
        JobHelpers.waitForJobs("DocumentLifeCycleJobs", monitor);
    }

    public NotebookDocumentService getNotebookDocumentService() {
        return null;
    }
}

