/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corext.refactoring.code;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.refactoring.descriptors.ChangeMethodSignatureDescriptor;
import org.eclipse.jdt.core.refactoring.descriptors.IntroduceParameterDescriptor;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.core.refactoring.descriptors.RefactoringSignatureDescriptorFactory;
import org.eclipse.jdt.internal.corext.CorextCore;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.dom.fragments.ASTFragmentFactory;
import org.eclipse.jdt.internal.corext.dom.fragments.IASTFragment;
import org.eclipse.jdt.internal.corext.dom.fragments.IExpressionFragment;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalPositionGroupCore;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.code.CodeRefactoringUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.BodyUpdater;
import org.eclipse.jdt.internal.corext.refactoring.structure.ChangeSignatureProcessor;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IDelegateUpdating;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.ls.core.internal.handlers.FormatterHandler;
import org.eclipse.jdt.ls.core.internal.hover.JavaElementLabels;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringContribution;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.ltk.core.refactoring.participants.ProcessorBasedRefactoring;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;

public class IntroduceParameterRefactoring
extends Refactoring
implements IDelegateUpdating {
    private static final String ATTRIBUTE_ARGUMENT = "argument";
    private static final String[] KNOWN_METHOD_NAME_PREFIXES = new String[]{"get", "is"};
    private ICompilationUnit fSourceCU;
    private int fSelectionStart;
    private int fSelectionLength;
    private IMethod fMethod;
    private Refactoring fChangeSignatureRefactoring;
    private ChangeSignatureProcessor fChangeSignatureProcessor;
    private ParameterInfo fParameter;
    private String fParameterName;
    private JavaRefactoringArguments fArguments;
    private Expression fSelectedExpression;
    private String[] fExcludedParameterNames;
    private LinkedProposalModelCore fLinkedProposalModel;

    public IntroduceParameterRefactoring(ICompilationUnit unit, int selectionStart, int selectionLength) {
        Assert.isTrue((selectionStart >= 0 ? 1 : 0) != 0);
        Assert.isTrue((selectionLength >= 0 ? 1 : 0) != 0);
        this.fSourceCU = unit;
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fLinkedProposalModel = null;
    }

    public IntroduceParameterRefactoring(JavaRefactoringArguments arguments, RefactoringStatus status) {
        this(null, 0, 0);
        RefactoringStatus initializeStatus = this.initialize(arguments);
        status.merge(initializeStatus);
    }

    public boolean canEnableDelegateUpdating() {
        return true;
    }

    public boolean getDelegateUpdating() {
        return this.fChangeSignatureProcessor != null ? this.fChangeSignatureProcessor.getDelegateUpdating() : false;
    }

    public void setDelegateUpdating(boolean updating) {
        if (this.fChangeSignatureProcessor != null) {
            this.fChangeSignatureProcessor.setDelegateUpdating(updating);
        }
    }

    public void setDeprecateDelegates(boolean deprecate) {
        if (this.fChangeSignatureProcessor != null) {
            this.fChangeSignatureProcessor.setDeprecateDelegates(deprecate);
        }
    }

    public boolean getDeprecateDelegates() {
        return this.fChangeSignatureProcessor != null ? this.fChangeSignatureProcessor.getDeprecateDelegates() : false;
    }

    public String getName() {
        return RefactoringCoreMessages.IntroduceParameterRefactoring_name;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        try {
            CompilationUnitRewrite cuRewrite;
            pm.beginTask("", 7);
            if (!this.fSourceCU.isStructureKnown()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceParameterRefactoring_syntax_error);
                return refactoringStatus;
            }
            IJavaElement enclosingElement = this.resolveEnclosingElement(this.fSourceCU, this.fSelectionStart, this.fSelectionLength);
            if (!(enclosingElement instanceof IMethod)) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceParameterRefactoring_expression_in_method);
                return refactoringStatus;
            }
            this.fMethod = (IMethod)enclosingElement;
            pm.worked(1);
            RefactoringStatus result = new RefactoringStatus();
            if (this.fArguments != null) {
                this.fChangeSignatureProcessor = new ChangeSignatureProcessor(this.fArguments, result);
                if (result.hasFatalError()) {
                    pm.worked(2);
                    RefactoringStatus refactoringStatus = result;
                    return refactoringStatus;
                }
                this.fChangeSignatureRefactoring = new ProcessorBasedRefactoring((RefactoringProcessor)this.fChangeSignatureProcessor);
                this.fChangeSignatureRefactoring.setValidationContext(this.getValidationContext());
                result.merge(this.fChangeSignatureProcessor.checkInitialConditions((IProgressMonitor)new SubProgressMonitor(pm, 2)));
                if (result.hasFatalError()) {
                    RefactoringStatus refactoringStatus = result;
                    return refactoringStatus;
                }
            } else {
                ChangeSignatureProcessor changeSignatureProcessor = this.fChangeSignatureProcessor = RefactoringAvailabilityTester.isChangeSignatureAvailable(this.fMethod) ? new ChangeSignatureProcessor(this.fMethod) : null;
                if (this.fChangeSignatureProcessor == null) {
                    RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceParameterRefactoring_expression_in_method);
                    return refactoringStatus;
                }
                this.fChangeSignatureRefactoring = new ProcessorBasedRefactoring((RefactoringProcessor)this.fChangeSignatureProcessor);
                this.fChangeSignatureRefactoring.setValidationContext(this.getValidationContext());
                result.merge(this.fChangeSignatureProcessor.checkInitialConditions((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                if (result.hasFatalError()) {
                    RefactoringStatusEntry entry = result.getEntryMatchingSeverity(4);
                    if (entry.getCode() != 1 && entry.getCode() != 2) {
                        RefactoringStatus refactoringStatus = result;
                        return refactoringStatus;
                    }
                    IMethod method = (IMethod)entry.getData();
                    ChangeSignatureProcessor changeSignatureProcessor2 = this.fChangeSignatureProcessor = RefactoringAvailabilityTester.isChangeSignatureAvailable(method) ? new ChangeSignatureProcessor(method) : null;
                    if (this.fChangeSignatureProcessor == null) {
                        String msg = Messages.format((String)RefactoringCoreMessages.IntroduceParameterRefactoring_cannot_introduce, (Object)entry.getMessage());
                        RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)msg);
                        return refactoringStatus;
                    }
                    this.fChangeSignatureRefactoring = new ProcessorBasedRefactoring((RefactoringProcessor)this.fChangeSignatureProcessor);
                    this.fChangeSignatureRefactoring.setValidationContext(this.getValidationContext());
                    result = this.fChangeSignatureProcessor.checkInitialConditions((IProgressMonitor)new SubProgressMonitor(pm, 1));
                    if (result.hasFatalError()) {
                        RefactoringStatus refactoringStatus = result;
                        return refactoringStatus;
                    }
                } else {
                    pm.worked(1);
                }
            }
            if (!(cuRewrite = this.fChangeSignatureProcessor.getBaseCuRewrite()).getCu().equals(this.fSourceCU)) {
                cuRewrite = new CompilationUnitRewrite(this.fSourceCU);
            }
            this.initializeSelectedExpression(cuRewrite);
            pm.worked(1);
            result.merge(this.checkSelection(cuRewrite, (IProgressMonitor)new SubProgressMonitor(pm, 3)));
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            this.initializeExcludedParameterNames(cuRewrite);
            this.addParameterInfo(cuRewrite);
            this.fChangeSignatureProcessor.setBodyUpdater(new BodyUpdater(){

                public void updateBody(MethodDeclaration methodDeclaration, CompilationUnitRewrite rewrite, RefactoringStatus updaterResult) {
                    IntroduceParameterRefactoring.this.replaceSelectedExpression(rewrite);
                }
            });
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
            if (this.fChangeSignatureRefactoring != null) {
                this.fChangeSignatureRefactoring.setValidationContext(null);
            }
        }
    }

    private IJavaElement resolveEnclosingElement(ICompilationUnit input, int offset, int length) throws JavaModelException {
        IJavaElement atOffset = null;
        if (input instanceof ICompilationUnit) {
            ICompilationUnit cunit = input;
            JavaModelUtil.reconcile((ICompilationUnit)cunit);
            atOffset = cunit.getElementAt(offset);
        } else if (input instanceof IClassFile) {
            IClassFile cfile = (IClassFile)input;
            atOffset = cfile.getElementAt(offset);
        } else {
            return null;
        }
        if (atOffset == null) {
            return input;
        }
        int selectionEnd = offset + length;
        IJavaElement result = atOffset;
        if (atOffset instanceof ISourceReference) {
            ISourceRange range = ((ISourceReference)atOffset).getSourceRange();
            while (range.getOffset() + range.getLength() < selectionEnd) {
                if (!((result = result.getParent()) instanceof ISourceReference)) {
                    result = input;
                    break;
                }
                range = ((ISourceReference)result).getSourceRange();
            }
        }
        return result;
    }

    private void addParameterInfo(CompilationUnitRewrite cuRewrite) throws JavaModelException {
        ClassInstanceCreation classInstanceCreation;
        Type cicType;
        ITypeBinding typeBinding = Bindings.normalizeForDeclarationUse((ITypeBinding)this.fSelectedExpression.resolveTypeBinding(), (AST)this.fSelectedExpression.getAST());
        String name = this.fParameterName != null ? this.fParameterName : this.guessedParameterName();
        Expression expression = ASTNodes.getUnparenthesedExpression((Expression)this.fSelectedExpression);
        ImportRewrite importRewrite = cuRewrite.getImportRewrite();
        ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext((ASTNode)this.fSelectedExpression, importRewrite);
        String typeName = importRewrite.addImport(typeBinding, (ImportRewrite.ImportRewriteContext)importRewriteContext);
        String defaultValue = null;
        if (expression instanceof ClassInstanceCreation && typeBinding.isParameterizedType() && (cicType = (classInstanceCreation = (ClassInstanceCreation)expression).getType()) instanceof ParameterizedType && ((ParameterizedType)cicType).typeArguments().size() == 0) {
            AST ast = cuRewrite.getAST();
            Type type = importRewrite.addImport(typeBinding, ast, (ImportRewrite.ImportRewriteContext)importRewriteContext);
            classInstanceCreation.setType(type);
            Map<String, String> settings = FormatterHandler.getCombinedDefaultFormatterSettings();
            defaultValue = ASTNodes.asFormattedString((ASTNode)classInstanceCreation, (int)0, (String)StubUtility.getLineDelimiterUsed((IJavaElement)cuRewrite.getCu()), settings);
            classInstanceCreation.setType(cicType);
        }
        if (defaultValue == null) {
            defaultValue = this.fSourceCU.getBuffer().getText(expression.getStartPosition(), expression.getLength());
        }
        this.fParameter = ParameterInfo.createInfoForAddedParameter((ITypeBinding)typeBinding, (String)typeName, (String)name, defaultValue);
        if (this.fArguments == null) {
            List parameterInfos = this.fChangeSignatureProcessor.getParameterInfos();
            int parametersCount = parameterInfos.size();
            if (parametersCount > 0 && ((ParameterInfo)parameterInfos.get(parametersCount - 1)).isOldVarargs()) {
                parameterInfos.add(parametersCount - 1, this.fParameter);
            } else {
                parameterInfos.add(this.fParameter);
            }
        }
    }

    private void replaceSelectedExpression(CompilationUnitRewrite cuRewrite) {
        if (!this.fSourceCU.equals(cuRewrite.getCu())) {
            return;
        }
        Expression expression = (Expression)NodeFinder.perform((ASTNode)cuRewrite.getRoot(), (int)this.fSelectedExpression.getStartPosition(), (int)this.fSelectedExpression.getLength());
        SimpleName newExpression = cuRewrite.getRoot().getAST().newSimpleName(this.fParameter.getNewName());
        String description = RefactoringCoreMessages.IntroduceParameterRefactoring_replace;
        cuRewrite.getASTRewrite().replace((ASTNode)(expression.getParent() instanceof ParenthesizedExpression ? expression.getParent() : expression), (ASTNode)newExpression, cuRewrite.createGroupDescription(description));
        if (this.fLinkedProposalModel != null) {
            LinkedProposalPositionGroupCore nameGroup = this.fLinkedProposalModel.getPositionGroup(this.fParameter.getNewName(), true);
            nameGroup.addPosition(cuRewrite.getASTRewrite().track((ASTNode)newExpression), false);
        }
    }

    private void initializeSelectedExpression(CompilationUnitRewrite cuRewrite) throws JavaModelException {
        IASTFragment fragment = ASTFragmentFactory.createFragmentForSourceRange((ISourceRange)new SourceRange(this.fSelectionStart, this.fSelectionLength), (ASTNode)cuRewrite.getRoot(), (ICompilationUnit)cuRewrite.getCu());
        if (!(fragment instanceof IExpressionFragment)) {
            return;
        }
        Expression expression = ((IExpressionFragment)fragment).getAssociatedExpression();
        if (fragment.getStartPosition() != expression.getStartPosition() || fragment.getLength() != expression.getLength()) {
            return;
        }
        if (Checks.isInsideJavadoc((ASTNode)expression)) {
            return;
        }
        if (Checks.isEnumCase((ASTNode)expression.getParent())) {
            return;
        }
        this.fSelectedExpression = expression;
    }

    private RefactoringStatus checkSelection(CompilationUnitRewrite cuRewrite, IProgressMonitor pm) {
        try {
            if (this.fSelectedExpression == null) {
                String message = RefactoringCoreMessages.IntroduceParameterRefactoring_select;
                RefactoringStatus refactoringStatus = CodeRefactoringUtil.checkMethodSyntaxErrors((int)this.fSelectionStart, (int)this.fSelectionLength, (CompilationUnit)cuRewrite.getRoot(), (String)message);
                return refactoringStatus;
            }
            MethodDeclaration methodDeclaration = (MethodDeclaration)ASTNodes.getParent((ASTNode)this.fSelectedExpression, MethodDeclaration.class);
            if (methodDeclaration == null || ASTNodes.getParent((ASTNode)this.fSelectedExpression, Annotation.class) != null) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceParameterRefactoring_expression_in_method);
                return refactoringStatus;
            }
            if (methodDeclaration.resolveBinding() == null) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceParameterRefactoring_no_binding);
                return refactoringStatus;
            }
            RefactoringStatus result = new RefactoringStatus();
            result.merge(this.checkExpression());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            result.merge(this.checkExpressionBinding());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            if (pm != null) {
                pm.done();
            }
        }
    }

    private RefactoringStatus checkExpression() {
        Expression selectedExpression = this.fSelectedExpression;
        if (selectedExpression instanceof Name && selectedExpression.getLocationInParent() == ClassInstanceCreation.TYPE_PROPERTY) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_name_in_new);
        }
        if (selectedExpression instanceof NullLiteral) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_null_literals);
        }
        if (selectedExpression instanceof ArrayInitializer) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_array_initializer);
        }
        if (selectedExpression instanceof Assignment) {
            if (selectedExpression.getParent() instanceof Expression) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_assignment);
            }
            return null;
        }
        if (selectedExpression instanceof SimpleName) {
            if (((SimpleName)selectedExpression).isDeclaration()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_names_in_declarations);
            }
            if (selectedExpression.getParent() instanceof QualifiedName && selectedExpression.getLocationInParent() == QualifiedName.NAME_PROPERTY || selectedExpression.getParent() instanceof FieldAccess && selectedExpression.getLocationInParent() == FieldAccess.NAME_PROPERTY) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_select_expression);
            }
        }
        return null;
    }

    private RefactoringStatus checkExpressionBinding() {
        return this.checkExpressionFragmentIsRValue();
    }

    private RefactoringStatus checkExpressionFragmentIsRValue() {
        switch (Checks.checkExpressionIsRValue((Expression)this.fSelectedExpression)) {
            case 1: 
            case 3: {
                return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.IntroduceParameterRefactoring_select, null, (String)CorextCore.getPluginId(), (int)64, null);
            }
            case 2: {
                return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.IntroduceParameterRefactoring_no_void, null, (String)CorextCore.getPluginId(), (int)65, null);
            }
            case 0: {
                return new RefactoringStatus();
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    public List<ParameterInfo> getParameterInfos() {
        return this.fChangeSignatureProcessor.getParameterInfos();
    }

    public ParameterInfo getAddedParameterInfo() {
        return this.fParameter;
    }

    public String getMethodSignaturePreview() throws JavaModelException {
        return this.fChangeSignatureProcessor.getNewMethodSignature();
    }

    public void setParameterName(String name) {
        Assert.isNotNull((Object)name);
        this.fParameter.setNewName(name);
    }

    public String guessedParameterName() {
        String[] proposals = this.guessParameterNames();
        if (proposals.length == 0) {
            return "";
        }
        return proposals[0];
    }

    public String[] guessParameterNames() {
        LinkedHashSet<String> proposals = new LinkedHashSet<String>();
        if (this.fSelectedExpression instanceof MethodInvocation) {
            proposals.addAll(this.guessTempNamesFromMethodInvocation((MethodInvocation)this.fSelectedExpression, this.fExcludedParameterNames));
        }
        proposals.addAll(this.guessTempNamesFromExpression(this.fSelectedExpression, this.fExcludedParameterNames));
        return proposals.toArray(new String[proposals.size()]);
    }

    private List<String> guessTempNamesFromMethodInvocation(MethodInvocation selectedMethodInvocation, String[] excludedVariableNames) {
        String methodName = selectedMethodInvocation.getName().getIdentifier();
        String[] stringArray = KNOWN_METHOD_NAME_PREFIXES;
        int n = KNOWN_METHOD_NAME_PREFIXES.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            if (methodName.startsWith(prefix)) {
                if (methodName.length() == prefix.length()) {
                    return Collections.emptyList();
                }
                char firstAfterPrefix = methodName.charAt(prefix.length());
                if (Character.isUpperCase(firstAfterPrefix)) {
                    String proposal;
                    methodName = proposal = String.valueOf(Character.toLowerCase(firstAfterPrefix)) + methodName.substring(prefix.length() + 1);
                    break;
                }
            }
            ++n2;
        }
        String[] proposals = StubUtility.getLocalNameSuggestions((IJavaProject)this.fSourceCU.getJavaProject(), (String)methodName, (int)0, (String[])excludedVariableNames);
        return Arrays.asList(proposals);
    }

    private List<String> guessTempNamesFromExpression(Expression selectedExpression, String[] excluded) {
        ITypeBinding expressionBinding = Bindings.normalizeForDeclarationUse((ITypeBinding)selectedExpression.resolveTypeBinding(), (AST)selectedExpression.getAST());
        String typeName = IntroduceParameterRefactoring.getQualifiedName(expressionBinding);
        if (typeName.length() == 0) {
            typeName = expressionBinding.getName();
        }
        if (typeName.length() == 0) {
            return Collections.emptyList();
        }
        int typeParamStart = typeName.indexOf(60);
        if (typeParamStart != -1) {
            typeName = typeName.substring(0, typeParamStart);
        }
        String[] proposals = StubUtility.getLocalNameSuggestions((IJavaProject)this.fSourceCU.getJavaProject(), (String)typeName, (int)expressionBinding.getDimensions(), (String[])excluded);
        return Arrays.asList(proposals);
    }

    private static String getQualifiedName(ITypeBinding typeBinding) {
        if (typeBinding.isAnonymous()) {
            return IntroduceParameterRefactoring.getQualifiedName(typeBinding.getSuperclass());
        }
        if (!typeBinding.isArray()) {
            return typeBinding.getQualifiedName();
        }
        return typeBinding.getElementType().getQualifiedName();
    }

    private void initializeExcludedParameterNames(CompilationUnitRewrite cuRewrite) {
        IBinding[] bindings = new ScopeAnalyzer(cuRewrite.getRoot()).getDeclarationsInScope(this.fSelectedExpression.getStartPosition(), 2);
        this.fExcludedParameterNames = new String[bindings.length];
        int i = 0;
        while (i < this.fExcludedParameterNames.length) {
            this.fExcludedParameterNames[i] = bindings[i].getName();
            ++i;
        }
    }

    public RefactoringStatus validateInput() {
        return this.fChangeSignatureProcessor.checkSignature();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        this.fChangeSignatureRefactoring.setValidationContext(this.getValidationContext());
        try {
            RefactoringStatus refactoringStatus = this.fChangeSignatureRefactoring.checkFinalConditions(pm);
            return refactoringStatus;
        }
        finally {
            this.fChangeSignatureRefactoring.setValidationContext(null);
        }
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        this.fChangeSignatureRefactoring.setValidationContext(this.getValidationContext());
        try {
            Change[] changes = this.fChangeSignatureProcessor.getAllChanges();
            if (changes.length < 1) {
                return null;
            }
            Change change = changes[0];
            return change;
        }
        finally {
            this.fChangeSignatureRefactoring.setValidationContext(null);
            pm.done();
        }
    }

    private IntroduceParameterDescriptor getRefactoringDescriptor() {
        ChangeMethodSignatureDescriptor extended = (ChangeMethodSignatureDescriptor)this.fChangeSignatureProcessor.createDescriptor();
        RefactoringContribution contribution = RefactoringCore.getRefactoringContribution((String)"org.eclipse.jdt.ls.change.method.signature");
        Map argumentsMap = contribution.retrieveArgumentMap((RefactoringDescriptor)extended);
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put(ATTRIBUTE_ARGUMENT, this.fParameter.getNewName());
        arguments.put("selection", String.valueOf(Integer.toString(this.fSelectionStart)) + " " + Integer.toString(this.fSelectionLength));
        arguments.putAll(argumentsMap);
        String signature = this.fChangeSignatureProcessor.getMethodName();
        try {
            signature = this.fChangeSignatureProcessor.getOldMethodSignature();
        }
        catch (JavaModelException exception) {
            JavaLanguageServerPlugin.log((CoreException)((Object)exception));
        }
        String description = Messages.format((String)RefactoringCoreMessages.IntroduceParameterRefactoring_descriptor_description_short, (Object)BasicElementLabels.getJavaElementName((String)this.fChangeSignatureProcessor.getMethod().getElementName()));
        String header = Messages.format((String)RefactoringCoreMessages.IntroduceParameterRefactoring_descriptor_description, (Object[])new String[]{BasicElementLabels.getJavaElementName((String)this.fParameter.getNewName()), signature, BasicElementLabels.getJavaCodeString((String)ASTNodes.asString((ASTNode)this.fSelectedExpression))});
        JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(extended.getProject(), (Object)this, header);
        comment.addSetting(Messages.format((String)RefactoringCoreMessages.IntroduceParameterRefactoring_original_pattern, (Object)JavaElementLabels.getTextLabel(this.fChangeSignatureProcessor.getMethod(), JavaElementLabels.ALL_FULLY_QUALIFIED)));
        comment.addSetting(Messages.format((String)RefactoringCoreMessages.IntroduceParameterRefactoring_expression_pattern, (Object)BasicElementLabels.getJavaCodeString((String)ASTNodes.asString((ASTNode)this.fSelectedExpression))));
        comment.addSetting(Messages.format((String)RefactoringCoreMessages.IntroduceParameterRefactoring_parameter_pattern, (Object)BasicElementLabels.getJavaElementName((String)this.getAddedParameterInfo().getNewName())));
        return RefactoringSignatureDescriptorFactory.createIntroduceParameterDescriptor((String)extended.getProject(), (String)description, (String)comment.asString(), arguments, (int)extended.getFlags());
    }

    private RefactoringStatus initialize(JavaRefactoringArguments arguments) {
        IJavaElement element;
        int length;
        int offset;
        this.fArguments = arguments;
        String selection = arguments.getAttribute("selection");
        if (selection != null) {
            offset = -1;
            length = -1;
            StringTokenizer tokenizer = new StringTokenizer(selection);
            if (tokenizer.hasMoreTokens()) {
                offset = Integer.parseInt(tokenizer.nextToken());
            }
            if (tokenizer.hasMoreTokens()) {
                length = Integer.parseInt(tokenizer.nextToken());
            }
            if (offset < 0 || length < 0) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format((String)RefactoringCoreMessages.InitializableRefactoring_illegal_argument, (Object[])new Object[]{selection, "selection"}));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)"selection"));
        }
        this.fSelectionStart = offset;
        this.fSelectionLength = length;
        String handle = arguments.getAttribute("input");
        if (handle != null) {
            element = JavaRefactoringDescriptorUtil.handleToElement((String)arguments.getProject(), (String)handle, (boolean)false);
            if (element == null || !element.exists() || element.getElementType() != 5) {
                return JavaRefactoringDescriptorUtil.createInputFatalStatus((Object)element, (String)this.getName(), (String)"org.eclipse.jdt.ui.introduce.parameter");
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)"input"));
        }
        this.fSourceCU = (ICompilationUnit)element;
        String name = arguments.getAttribute(ATTRIBUTE_ARGUMENT);
        if (name == null || "".equals(name)) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)ATTRIBUTE_ARGUMENT));
        }
        this.fParameterName = name;
        return new RefactoringStatus();
    }

    public String getDelegateUpdatingTitle(boolean plural) {
        if (plural) {
            return RefactoringCoreMessages.DelegateCreator_keep_original_changed_plural;
        }
        return RefactoringCoreMessages.DelegateCreator_keep_original_changed_singular;
    }

    public void setLinkedProposalModel(LinkedProposalModelCore linkedProposalModel) {
        this.fLinkedProposalModel = linkedProposalModel;
    }
}

