/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.contentassist;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.manipulation.SharedASTProviderCore;
import org.eclipse.jdt.internal.codeassist.CompletionEngine;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.dom.IASTSharedValues;
import org.eclipse.jdt.internal.corext.template.java.SignatureUtil;
import org.eclipse.jdt.ls.core.internal.ChangeUtil;
import org.eclipse.jdt.ls.core.internal.CompletionUtils;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.TextEditConverter;
import org.eclipse.jdt.ls.core.internal.contentassist.AnonymousTypeCompletionProposal;
import org.eclipse.jdt.ls.core.internal.contentassist.CompletionProposalUtils;
import org.eclipse.jdt.ls.core.internal.contentassist.GetterSetterCompletionProposal;
import org.eclipse.jdt.ls.core.internal.contentassist.OverrideCompletionProposal;
import org.eclipse.jdt.ls.core.internal.contentassist.ParameterGuesser;
import org.eclipse.jdt.ls.core.internal.contentassist.SnippetUtils;
import org.eclipse.jdt.ls.core.internal.contentassist.TypeProposalUtils;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.jdt.ls.core.internal.preferences.ClientPreferences;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.InsertReplaceEdit;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.InsertTextMode;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.text.edits.TextEdit;

public class CompletionProposalReplacementProvider {
    private static final String CURSOR_POSITION = "${0}";
    private static final char SPACE = ' ';
    private static final char LPAREN = '(';
    private static final char RPAREN = ')';
    private static final char SEMICOLON = ';';
    private static final char COMMA = ',';
    private static final char LESS = '<';
    private static final char GREATER = '>';
    private final ICompilationUnit compilationUnit;
    private final int offset;
    private final CompletionContext context;
    private ImportRewrite importRewrite;
    private final ClientPreferences client;
    private Preferences preferences;
    private String anonymousTypeNewBody;
    private boolean isResolvingRequest;
    final Map<String, IBinding> bindings = new HashMap<String, IBinding>();

    public CompletionProposalReplacementProvider(ICompilationUnit compilationUnit, CompletionContext context, int offset, Preferences preferences, ClientPreferences clientPrefs, boolean isResolvingRequest) {
        this.compilationUnit = compilationUnit;
        this.context = context;
        this.offset = offset;
        this.preferences = preferences == null ? new Preferences() : preferences;
        this.client = clientPrefs;
        this.isResolvingRequest = isResolvingRequest;
    }

    /*
     * WARNING - void declaration
     */
    public void updateReplacement(CompletionProposal proposal, CompletionItem item, char trigger) {
        Object requiredProposals;
        this.importRewrite = TypeProposalUtils.createImportRewrite(this.compilationUnit);
        ArrayList<org.eclipse.lsp4j.TextEdit> additionalTextEdits = new ArrayList<org.eclipse.lsp4j.TextEdit>();
        StringBuilder completionBuffer = new StringBuilder();
        InsertReplaceEdit insertReplaceEdit = new InsertReplaceEdit();
        if (this.isSupportingRequiredProposals(proposal) && (requiredProposals = proposal.getRequiredProposals()) != null) {
            CompletionProposal[] completionProposalArray = requiredProposals;
            int n = ((CompletionProposal[])requiredProposals).length;
            int n2 = 0;
            while (n2 < n) {
                CompletionProposal requiredProposal = completionProposalArray[n2];
                switch (requiredProposal.getKind()) {
                    case 21: 
                    case 22: 
                    case 23: {
                        this.appendImportProposal(completionBuffer, requiredProposal, proposal.getKind());
                        break;
                    }
                    case 9: {
                        org.eclipse.lsp4j.TextEdit edit = this.toRequiredTypeEdit(requiredProposal, trigger, proposal.canUseDiamond(this.context));
                        if (proposal.getKind() == 26 || proposal.getKind() == 27 || proposal.getKind() == 1) {
                            completionBuffer.append(edit.getNewText());
                            this.setInsertReplaceRange(requiredProposal, insertReplaceEdit);
                            break;
                        }
                        additionalTextEdits.add(edit);
                        break;
                    }
                    default: {
                        Assert.isTrue((boolean)false);
                    }
                }
                ++n2;
            }
        }
        this.setInsertReplaceRange(proposal, insertReplaceEdit);
        if (this.preferences.isCompletionLazyResolveTextEditEnabled() && !this.isResolvingRequest) {
            if (completionBuffer.isEmpty()) {
                completionBuffer.append(this.getDefaultTextEditText(item));
            }
        } else {
            switch (proposal.getKind()) {
                case 7: {
                    this.appendMethodOverrideReplacement(completionBuffer, proposal);
                    break;
                }
                case 11: {
                    CompletionProposal completionProposal = proposal;
                    if (completionProposal instanceof GetterSetterCompletionProposal) {
                        void getterSetterProposal;
                        requiredProposals = (GetterSetterCompletionProposal)completionProposal;
                        GetterSetterCompletionProposal cfr_ignored_0 = (GetterSetterCompletionProposal)completionProposal;
                        this.appendMethodPotentialReplacement(completionBuffer, (GetterSetterCompletionProposal)getterSetterProposal);
                        break;
                    }
                    this.appendReplacementString(completionBuffer, proposal);
                    break;
                }
                case 1: 
                case 27: {
                    this.appendAnonymousClass(completionBuffer, proposal, insertReplaceEdit);
                    break;
                }
                case 30: {
                    this.appendLambdaExpressionReplacement(completionBuffer, proposal);
                    break;
                }
                default: {
                    this.appendReplacementString(completionBuffer, proposal);
                }
            }
        }
        if (this.client.isCompletionSnippetsSupported()) {
            item.setInsertTextFormat(InsertTextFormat.Snippet);
        } else {
            item.setInsertTextFormat(InsertTextFormat.PlainText);
        }
        if (this.isResolvingRequest || !JavaLanguageServerPlugin.getPreferencesManager().getClientPreferences().isCompletionListItemDefaultsPropertySupport("insertTextMode") && JavaLanguageServerPlugin.getPreferencesManager().getClientPreferences().getCompletionItemInsertTextModeDefault() != InsertTextMode.AdjustIndentation) {
            item.setInsertTextMode(InsertTextMode.AdjustIndentation);
        }
        String text = completionBuffer.toString();
        if (insertReplaceEdit.getReplace() == null || insertReplaceEdit.getInsert() == null) {
            item.setInsertText(text);
            if (this.client.isCompletionListItemDefaultsSupport()) {
                item.setTextEditText(SnippetUtils.templateToSnippet(text));
            }
        } else if (this.client.isCompletionInsertReplaceSupport()) {
            insertReplaceEdit.setNewText(text);
            item.setTextEdit(Either.forRight((Object)insertReplaceEdit));
        } else if (this.preferences.isCompletionOverwrite()) {
            item.setTextEdit(Either.forLeft((Object)new org.eclipse.lsp4j.TextEdit(insertReplaceEdit.getReplace(), text)));
        } else {
            item.setTextEdit(Either.forLeft((Object)new org.eclipse.lsp4j.TextEdit(insertReplaceEdit.getInsert(), text)));
        }
        if (!(CompletionProposalUtils.isImportCompletion(proposal) || this.client.isResolveAdditionalTextEditsSupport() && !this.isResolvingRequest)) {
            this.addImports(additionalTextEdits);
            if (!additionalTextEdits.isEmpty()) {
                item.setAdditionalTextEdits(additionalTextEdits);
            }
        }
    }

    private String getDefaultTextEditText(CompletionItem item) {
        if (StringUtils.isNotBlank((CharSequence)item.getInsertText())) {
            return item.getInsertText();
        }
        if (StringUtils.isNotBlank((CharSequence)item.getLabel())) {
            return item.getLabel();
        }
        return "";
    }

    private void appendLambdaExpressionReplacement(StringBuilder completionBuffer, CompletionProposal proposal) {
        boolean needParens;
        StringBuilder paramBuffer = new StringBuilder();
        this.appendGuessingCompletion(paramBuffer, proposal);
        boolean bl = needParens = paramBuffer.indexOf(",") > -1 || paramBuffer.length() == 0;
        if (needParens) {
            completionBuffer.append('(');
        }
        completionBuffer.append((CharSequence)paramBuffer);
        if (needParens) {
            completionBuffer.append(')');
        }
        completionBuffer.append(" -> ");
        if (this.client.isCompletionSnippetsSupported()) {
            completionBuffer.append(CURSOR_POSITION);
        }
    }

    private void appendAnonymousClass(StringBuilder completionBuffer, CompletionProposal proposal, InsertReplaceEdit edit) {
        try {
            IBuffer buffer = this.compilationUnit.getBuffer();
            IDocument document = JsonRpcHelpers.toDocument(buffer);
            char[] declarationKey = proposal.getDeclarationKey();
            if (declarationKey == null) {
                return;
            }
            IJavaProject javaProject = this.compilationUnit.getJavaProject();
            IJavaElement element = javaProject.findElement(new String(declarationKey), null);
            if (!(element instanceof IType)) {
                return;
            }
            int offset = proposal.getReplaceStart();
            if (this.anonymousTypeNewBody == null) {
                AnonymousTypeCompletionProposal overrider = new AnonymousTypeCompletionProposal(this.compilationUnit, offset, this.client.isCompletionSnippetsSupported());
                this.anonymousTypeNewBody = overrider.updateReplacementString(document, offset);
            }
            String replacement = this.anonymousTypeNewBody;
            if (document.getLength() > offset) {
                if (proposal.getKind() == 1) {
                    int length = 0;
                    IRegion lineInfo = document.getLineInformationOfOffset(offset);
                    int lineEnd = lineInfo.getOffset() + lineInfo.getLength();
                    int pos = offset;
                    char ch = document.getChar(pos);
                    while (pos < lineEnd && pos < document.getLength() - 1 && ch != ';' && ch != ',') {
                        ++length;
                        ch = document.getChar(++pos);
                    }
                    if (edit.getReplace() != null) {
                        edit.getReplace().getEnd().setCharacter(edit.getReplace().getEnd().getCharacter() + length);
                    }
                    if (edit.getInsert() != null) {
                        edit.getInsert().getEnd().setCharacter(edit.getInsert().getEnd().getCharacter() + length);
                    }
                    length = 1;
                    pos = offset - 1;
                    if (pos < document.getLength()) {
                        int lineStart = lineInfo.getOffset();
                        ch = document.getChar(pos);
                        while (pos > lineStart && ch != '(' && ch != ';' && ch != ',') {
                            ++length;
                            ch = document.getChar(--pos);
                        }
                    }
                    if (edit.getReplace() != null) {
                        edit.getReplace().getStart().setCharacter(edit.getReplace().getStart().getCharacter() - length);
                    }
                    if (edit.getInsert() != null) {
                        edit.getInsert().getStart().setCharacter(edit.getInsert().getStart().getCharacter() - length);
                    }
                    replacement = this.checkReplacementEnd(document, replacement, offset);
                } else if (proposal.getKind() == 27) {
                    int pos = -1;
                    if (document.getChar(offset) == '(') {
                        pos = offset;
                    } else if (offset + 1 < document.getLength() && document.getChar(offset + 1) == '(') {
                        pos = offset + 1;
                    }
                    if (pos > 0 && pos < document.getLength() - 1) {
                        IRegion lineInfo = document.getLineInformationOfOffset(offset);
                        int length = 1;
                        int lineEnd = lineInfo.getOffset() + lineInfo.getLength();
                        char ch = document.getChar(pos);
                        boolean hasClosed = false;
                        while (pos < lineEnd && ch != ')' && ch != ';' && ch != ',') {
                            ++length;
                            if ((ch = document.getChar(++pos)) != ')') continue;
                            hasClosed = true;
                            break;
                        }
                        if (!hasClosed) {
                            length = 0;
                            --pos;
                        }
                        if (length > 0) {
                            if (edit.getReplace() != null) {
                                edit.getReplace().getEnd().setCharacter(edit.getReplace().getEnd().getCharacter() + length);
                            }
                            if (edit.getInsert() != null) {
                                edit.getInsert().getEnd().setCharacter(edit.getInsert().getEnd().getCharacter() + length);
                            }
                        }
                    }
                    int next = pos > 0 ? pos + 1 : offset;
                    replacement = this.checkReplacementEnd(document, replacement, next);
                }
            }
            completionBuffer.append(replacement);
        }
        catch (CoreException | BadLocationException e) {
            JavaLanguageServerPlugin.logException("Failed to compute anonymous class replacement", e);
        }
    }

    private String checkReplacementEnd(IDocument document, String replacement, int pos) throws BadLocationException {
        if (pos > 0 && pos < document.getLength()) {
            char nextChar = document.getChar(pos);
            while (pos > 0 && pos < document.getLength() - 1 && nextChar != '(' && nextChar != ')' && nextChar != ';' && nextChar != ',' && !Character.isJavaIdentifierStart((int)nextChar)) {
                nextChar = document.getChar(++pos);
            }
            if ((nextChar == ',' || nextChar == ';' || nextChar == '(') && replacement.endsWith(";")) {
                replacement = replacement.substring(0, replacement.length() - 1);
            }
        }
        return replacement;
    }

    private void appendMethodOverrideReplacement(StringBuilder completionBuffer, CompletionProposal proposal) {
        try {
            IDocument document = JsonRpcHelpers.toDocument(this.compilationUnit.getBuffer());
            String signature = String.valueOf(proposal.getSignature());
            String[] types = (String[])Stream.of(Signature.getParameterTypes((String)signature)).map(t -> Signature.toString((String)t)).toArray(String[]::new);
            String methodName = String.valueOf(proposal.getName());
            int offset = proposal.getReplaceStart();
            String completion = new String(proposal.getCompletion());
            OverrideCompletionProposal overrider = new OverrideCompletionProposal(this.compilationUnit, methodName, types, completion);
            String replacement = overrider.updateReplacementString(document, offset, this.importRewrite, this.client.isCompletionSnippetsSupported());
            if (replacement != null) {
                completionBuffer.append(replacement);
            }
        }
        catch (CoreException | BadLocationException e) {
            JavaLanguageServerPlugin.logException("Failed to compute override replacement", e);
        }
    }

    private void appendMethodPotentialReplacement(StringBuilder completionBuffer, GetterSetterCompletionProposal proposal) {
        try {
            IDocument document = JsonRpcHelpers.toDocument(this.compilationUnit.getBuffer());
            int offset = proposal.getReplaceStart();
            String replacement = proposal.updateReplacementString(document, offset, this.importRewrite, this.client.isCompletionSnippetsSupported(), this.preferences.isCodeGenerationTemplateGenerateComments());
            completionBuffer.append(replacement);
        }
        catch (CoreException | BadLocationException e) {
            JavaLanguageServerPlugin.logException("Failed to compute potential replacement", e);
        }
    }

    private void appendBody(StringBuilder completionBuffer) {
        if (this.client.isCompletionSnippetsSupported()) {
            String replace = CompletionUtils.sanitizeCompletion(completionBuffer.toString());
            completionBuffer.replace(0, completionBuffer.toString().length(), replace);
        }
        completionBuffer.append(" {\n\t");
        if (this.client.isCompletionSnippetsSupported()) {
            completionBuffer.append(CURSOR_POSITION);
            completionBuffer.append("\n}");
        }
    }

    private Range toReplacementRange(CompletionProposal proposal) {
        try {
            return JDTUtils.toRange((IOpenable)this.compilationUnit, proposal.getReplaceStart(), proposal.getReplaceEnd() - proposal.getReplaceStart());
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
            return null;
        }
    }

    private void setInsertReplaceRange(CompletionProposal proposal, InsertReplaceEdit edit) {
        try {
            int start = proposal.getReplaceStart();
            int end = proposal.getReplaceEnd();
            if (edit.getReplace() == null) {
                Range replaceRange = JDTUtils.toRange((IOpenable)this.compilationUnit, start, end - start);
                edit.setReplace(replaceRange);
            }
            if (edit.getInsert() == null) {
                end = Math.min(end, this.offset);
                Range insertRange = JDTUtils.toRange((IOpenable)this.compilationUnit, start, end - start);
                edit.setInsert(insertRange);
            }
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
        }
    }

    private void addImports(List<org.eclipse.lsp4j.TextEdit> additionalEdits) {
        if (this.importRewrite != null) {
            try {
                TextEdit edit = this.importRewrite.rewriteImports((IProgressMonitor)new NullProgressMonitor());
                TextEditConverter converter = new TextEditConverter(this.compilationUnit, edit);
                List<org.eclipse.lsp4j.TextEdit> edits = converter.convert();
                if (ChangeUtil.hasChanges(edits)) {
                    additionalEdits.addAll(edits);
                }
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException("Error adding imports", e);
            }
        }
    }

    private boolean isSupportingRequiredProposals(CompletionProposal proposal) {
        return proposal != null && (proposal.getKind() == 6 || proposal.getKind() == 2 || proposal.getKind() == 9 || proposal.getKind() == 26 || proposal.getKind() == 27 || proposal.getKind() == 1);
    }

    protected boolean hasArgumentList(CompletionProposal proposal) {
        if (12 == proposal.getKind()) {
            return false;
        }
        if (30 == proposal.getKind()) {
            return true;
        }
        char[] completion = proposal.getCompletion();
        return !this.isInJavadoc() && completion.length > 0 && completion[completion.length - 1] == ')';
    }

    private boolean isInJavadoc() {
        return this.context.isInJavadoc();
    }

    private void appendReplacementString(StringBuilder buffer, CompletionProposal proposal) {
        boolean completionSnippetsSupported = this.client.isCompletionSnippetsSupported();
        if (!this.hasArgumentList(proposal)) {
            String str = null;
            if (proposal.getKind() == 9) {
                str = this.computeJavaTypeReplacementString(proposal);
                if (completionSnippetsSupported) {
                    str = CompletionUtils.sanitizeCompletion(str);
                }
                if (proposal.getArrayDimensions() > 0) {
                    StringBuilder arrayString = new StringBuilder(str);
                    int i = 0;
                    while (i < proposal.getArrayDimensions()) {
                        arrayString.append("[");
                        if (completionSnippetsSupported) {
                            arrayString.append("$").append(i + 1);
                        }
                        arrayString.append("]");
                        ++i;
                    }
                    if (completionSnippetsSupported) {
                        arrayString.append("$0");
                    }
                    str = arrayString.toString();
                }
            } else {
                str = String.valueOf(proposal.getCompletion());
                if (completionSnippetsSupported) {
                    str = CompletionUtils.sanitizeCompletion(str);
                    if (proposal.getKind() == 8 && str != null && str.endsWith(".*;")) {
                        str = str.replace(".*;", ".${0:*};");
                    }
                }
            }
            buffer.append(str);
            return;
        }
        this.appendMethodNameReplacement(buffer, proposal);
        boolean addParen = completionSnippetsSupported;
        if (addParen) {
            buffer.append('(');
        }
        if (this.hasParameters(proposal)) {
            this.appendGuessingCompletion(buffer, proposal);
        }
        if (addParen) {
            buffer.append(')');
            if (this.canAutomaticallyAppendSemicolon(proposal)) {
                buffer.append(';');
            }
        }
        if (proposal.getKind() == 7) {
            this.appendBody(buffer);
        }
    }

    private boolean hasParameters(CompletionProposal proposal) throws IllegalArgumentException {
        return this.hasArgumentList(proposal) && Signature.getParameterCount((char[])proposal.getSignature()) > 0;
    }

    private void appendMethodNameReplacement(StringBuilder buffer, CompletionProposal proposal) {
        if (proposal.getKind() == 24) {
            String coreCompletion = String.valueOf(proposal.getCompletion());
            if (this.client.isCompletionSnippetsSupported()) {
                coreCompletion = CompletionUtils.sanitizeCompletion(coreCompletion);
            }
            buffer.append(coreCompletion);
        }
        if (proposal.getKind() != 26) {
            String str = new String(proposal.getName());
            if (this.client.isCompletionSnippetsSupported()) {
                str = CompletionUtils.sanitizeCompletion(str);
            }
            buffer.append(str);
        }
    }

    private void appendGuessingCompletion(StringBuilder buffer, CompletionProposal proposal) {
        char[][] parameterNames;
        try {
            parameterNames = proposal.findParameterNames(null);
        }
        catch (Exception e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
            char[] signature = SignatureUtil.fix83600((char[])proposal.getSignature());
            parameterNames = CompletionEngine.createDefaultParameterNames((int)Signature.getParameterCount((char[])signature));
            proposal.setParameterNames(parameterNames);
        }
        int count = parameterNames.length;
        if (this.client.isCompletionSnippetsSupported()) {
            boolean guessMethodArguments;
            String[] choices = null;
            boolean bl = guessMethodArguments = JavaLanguageServerPlugin.getPreferencesManager() != null && JavaLanguageServerPlugin.getPreferencesManager().getPreferences().isGuessMethodArguments();
            if (guessMethodArguments && (proposal.getKind() == 6 || proposal.getKind() == 26 || proposal.getKind() == 24)) {
                try {
                    choices = this.guessParameters(parameterNames, proposal);
                }
                catch (JavaModelException e) {
                    JavaLanguageServerPlugin.logException(e.getMessage(), e);
                }
            }
            int i = 0;
            while (i < count) {
                if (i != 0) {
                    buffer.append(',');
                    buffer.append(' ');
                }
                char[] argument = choices != null ? choices[i].toCharArray() : parameterNames[i];
                if (this.client.isCompletionSnippetsSupported()) {
                    String replace = new String(argument);
                    replace = CompletionUtils.sanitizeCompletion(replace);
                    argument = replace.toCharArray();
                }
                buffer.append("${");
                buffer.append(Integer.toString(i + 1));
                buffer.append(":");
                buffer.append(argument);
                buffer.append("}");
                ++i;
            }
        }
    }

    private String[] guessParameters(char[][] parameterNames, CompletionProposal proposal) throws JavaModelException {
        int count = parameterNames.length;
        String[] result = new String[count];
        String[] parameterTypes = this.getParameterTypes(proposal);
        IJavaElement[][] assignableElements = this.getAssignableElements(proposal);
        ParameterGuesser guesser = new ParameterGuesser((IJavaElement)this.compilationUnit);
        int i = count - 1;
        while (i >= 0) {
            String paramName = new String(parameterNames[i]);
            String argumentProposal = guesser.parameterProposals(parameterTypes[i], paramName, assignableElements[i]);
            result[i] = argumentProposal != null ? argumentProposal : paramName;
            --i;
        }
        return result;
    }

    private String[] getParameterTypes(CompletionProposal proposal) {
        char[] signature = SignatureUtil.fix83600((char[])proposal.getSignature());
        char[][] types = Signature.getParameterTypes((char[])signature);
        String[] ret = new String[types.length];
        int i = 0;
        while (i < types.length) {
            ret[i] = new String(Signature.toCharArray((char[])types[i]));
            ++i;
        }
        return ret;
    }

    private IJavaElement[][] getAssignableElements(CompletionProposal proposal) {
        char[] signature = SignatureUtil.fix83600((char[])proposal.getSignature());
        char[][] types = Signature.getParameterTypes((char[])signature);
        IJavaElement[][] assignableElements = new IJavaElement[types.length][];
        int i = 0;
        while (i < types.length) {
            assignableElements[i] = this.context.getVisibleElements(new String(types[i]));
            ++i;
        }
        return assignableElements;
    }

    private final boolean canAutomaticallyAppendSemicolon(CompletionProposal proposal) {
        return !proposal.isConstructor() && CharOperation.equals((char[])new char[]{'V'}, (char[])Signature.getReturnType((char[])proposal.getSignature()));
    }

    private org.eclipse.lsp4j.TextEdit toRequiredTypeEdit(CompletionProposal typeProposal, char trigger, boolean canUseDiamond) {
        String[] typeArguments;
        boolean onlyAppendArguments;
        StringBuilder buffer = new StringBuilder();
        this.appendReplacementString(buffer, typeProposal);
        if (this.compilationUnit == null) {
            Range range = this.toReplacementRange(typeProposal);
            return new org.eclipse.lsp4j.TextEdit(range, buffer.toString());
        }
        IJavaProject project = this.compilationUnit.getJavaProject();
        if (!this.shouldProposeGenerics(project)) {
            Range range = this.toReplacementRange(typeProposal);
            return new org.eclipse.lsp4j.TextEdit(range, buffer.toString());
        }
        char[] completion = typeProposal.getCompletion();
        if (completion.length > 0 && (completion[completion.length - 1] == ';' || completion[completion.length - 1] == '.')) {
            Range range = this.toReplacementRange(typeProposal);
            return new org.eclipse.lsp4j.TextEdit(range, buffer.toString());
        }
        try {
            onlyAppendArguments = typeProposal.getCompletion().length == 0 && this.offset > 0 && this.compilationUnit.getBuffer().getChar(this.offset - 1) == '<';
        }
        catch (JavaModelException e) {
            onlyAppendArguments = false;
        }
        if ((onlyAppendArguments || this.shouldAppendArguments(typeProposal, trigger)) && (typeArguments = this.computeTypeArgumentProposals(typeProposal)).length > 0) {
            if (canUseDiamond) {
                buffer.append("<>");
            } else {
                this.appendParameterList(buffer, typeArguments, onlyAppendArguments);
            }
        }
        Range range = this.toReplacementRange(typeProposal);
        return new org.eclipse.lsp4j.TextEdit(range, buffer.toString());
    }

    private final boolean shouldProposeGenerics(IJavaProject project) {
        String sourceVersion = project != null ? project.getOption("org.eclipse.jdt.core.compiler.source", true) : JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.source");
        return !CompletionProposalReplacementProvider.isVersionLessThan(sourceVersion, "1.5");
    }

    public static boolean isVersionLessThan(String version1, String version2) {
        if ("cldc1.1".equals(version1)) {
            version1 = "1.1a";
        }
        if ("cldc1.1".equals(version2)) {
            version2 = "1.1a";
        }
        return version1.compareTo(version2) < 0;
    }

    private IJavaElement resolveJavaElement(IJavaProject project, CompletionProposal proposal) throws JavaModelException {
        char[] signature = proposal.getSignature();
        String typeName = SignatureUtil.stripSignatureToFQN((String)String.valueOf(signature));
        return project.findType(typeName);
    }

    private String[] computeTypeArgumentProposals(CompletionProposal proposal) {
        try {
            IType type = (IType)this.resolveJavaElement(this.compilationUnit.getJavaProject(), proposal);
            if (type == null) {
                return new String[0];
            }
            ITypeParameter[] parameters = type.getTypeParameters();
            if (parameters.length == 0) {
                return new String[0];
            }
            String[] arguments = new String[parameters.length];
            ITypeBinding expectedTypeBinding = this.getExpectedTypeForGenericParameters();
            if (expectedTypeBinding != null && expectedTypeBinding.isParameterizedType()) {
                IType expectedType = (IType)expectedTypeBinding.getJavaElement();
                IType[] path = TypeProposalUtils.computeInheritancePath(type, expectedType);
                if (path == null) {
                    return new String[0];
                }
                int[] indices = new int[parameters.length];
                int paramIdx = 0;
                while (paramIdx < parameters.length) {
                    indices[paramIdx] = TypeProposalUtils.mapTypeParameterIndex(path, path.length - 1, paramIdx);
                    ++paramIdx;
                }
                ITypeBinding[] typeArguments = expectedTypeBinding.getTypeArguments();
                int paramIdx2 = 0;
                while (paramIdx2 < parameters.length) {
                    if (indices[paramIdx2] != -1) {
                        ITypeBinding binding = typeArguments[indices[paramIdx2]];
                        arguments[paramIdx2] = this.computeTypeProposal(binding, parameters[paramIdx2]);
                    }
                    ++paramIdx2;
                }
            }
            int i = 0;
            while (i < arguments.length) {
                if (arguments[i] == null) {
                    arguments[i] = this.computeTypeProposal(parameters[i]);
                }
                ++i;
            }
            return arguments;
        }
        catch (JavaModelException e) {
            return new String[0];
        }
    }

    private String computeTypeProposal(ITypeParameter parameter) throws JavaModelException {
        String[] bounds = parameter.getBounds();
        String elementName = parameter.getElementName();
        if (bounds.length == 1 && !"java.lang.Object".equals(bounds[0])) {
            return Signature.getSimpleName((String)bounds[0]);
        }
        return elementName;
    }

    private String computeTypeProposal(ITypeBinding binding, ITypeParameter parameter) throws JavaModelException {
        String name = TypeProposalUtils.getTypeQualifiedName(binding);
        if (binding.isWildcardType()) {
            if (binding.isUpperbound()) {
                return binding.getBound().getName();
            }
            return this.computeTypeProposal(parameter);
        }
        return name;
    }

    private StringBuilder appendParameterList(StringBuilder buffer, String[] typeArguments, boolean onlyAppendArguments) {
        if (typeArguments != null && typeArguments.length > 0) {
            if (!onlyAppendArguments) {
                buffer.append('<');
            }
            StringBuilder separator = new StringBuilder(3);
            separator.append(',');
            int i = 0;
            while (i != typeArguments.length) {
                if (i != 0) {
                    buffer.append((CharSequence)separator);
                }
                buffer.append(typeArguments[i]);
                ++i;
            }
            if (!onlyAppendArguments) {
                buffer.append('>');
            }
        }
        return buffer;
    }

    private boolean shouldAppendArguments(CompletionProposal proposal, char trigger) {
        int index;
        String line;
        block6: {
            if (trigger != '\u0000' && trigger != '<' && trigger != '(') {
                return false;
            }
            char[] completion = proposal.getCompletion();
            if (completion.length == 0) {
                return false;
            }
            IDocument document = JsonRpcHelpers.toDocument(this.compilationUnit.getBuffer());
            IRegion region = document.getLineInformationOfOffset(proposal.getReplaceEnd());
            line = document.get(region.getOffset(), region.getLength());
            index = proposal.getReplaceEnd() - region.getOffset();
            while (index != line.length() && Character.isUnicodeIdentifierPart(line.charAt(index))) {
                ++index;
            }
            if (index != line.length()) break block6;
            return true;
        }
        try {
            char ch = line.charAt(index);
            return ch != '<';
        }
        catch (JavaModelException | BadLocationException e) {
            return true;
        }
    }

    private StringBuilder appendImportProposal(StringBuilder buffer, CompletionProposal proposal, int coreKind) {
        int proposalKind = proposal.getKind();
        String qualifiedTypeName = null;
        char[] qualifiedType = null;
        if (proposalKind == 23) {
            qualifiedType = proposal.getSignature();
            qualifiedTypeName = String.valueOf(Signature.toCharArray((char[])qualifiedType));
        } else if (proposalKind == 22 || proposalKind == 21) {
            qualifiedType = Signature.getTypeErasure((char[])proposal.getDeclarationSignature());
            qualifiedTypeName = String.valueOf(Signature.toCharArray((char[])qualifiedType));
        } else {
            Assert.isTrue((boolean)false);
        }
        if (this.importRewrite != null) {
            if (proposalKind == 23) {
                String simpleType = this.importRewrite.addImport(qualifiedTypeName, null);
                if (coreKind == 6) {
                    buffer.append(simpleType);
                    buffer.append(',');
                    return buffer;
                }
            } else {
                String res = this.importRewrite.addStaticImport(qualifiedTypeName, String.valueOf(proposal.getName()), proposalKind == 21, null);
                int dot = res.lastIndexOf(46);
                if (dot != -1) {
                    buffer.append(this.importRewrite.addImport(res.substring(0, dot), null));
                    buffer.append('.');
                    return buffer;
                }
            }
            return buffer;
        }
        if (this.compilationUnit != null && TypeProposalUtils.isImplicitImport(Signature.getQualifier((String)qualifiedTypeName), this.compilationUnit)) {
            if (proposal.getKind() == 23 && coreKind == 2) {
                return buffer;
            }
            qualifiedTypeName = String.valueOf(Signature.getSignatureSimpleName((char[])qualifiedType));
        }
        buffer.append(qualifiedTypeName);
        buffer.append('.');
        return buffer;
    }

    private ITypeBinding getExpectedTypeForGenericParameters() {
        char[][] chKeys = this.context.getExpectedTypesKeys();
        if (chKeys == null || chKeys.length == 0) {
            return null;
        }
        String[] keys = new String[chKeys.length];
        int i = 0;
        while (i < keys.length) {
            keys[i] = String.valueOf(chKeys[0]);
            ++i;
        }
        if (this.bindings.size() > 0) {
            return (ITypeBinding)this.bindings.get(keys[0]);
        }
        ASTParser parser = ASTParser.newParser((int)IASTSharedValues.SHARED_AST_LEVEL);
        parser.setProject(this.compilationUnit.getJavaProject());
        parser.setResolveBindings(true);
        parser.setStatementsRecovery(true);
        ASTRequestor requestor = new ASTRequestor(){

            public void acceptBinding(String bindingKey, IBinding binding) {
                CompletionProposalReplacementProvider.this.bindings.put(bindingKey, binding);
            }
        };
        parser.createASTs(new ICompilationUnit[0], keys, requestor, null);
        if (this.bindings.size() > 0) {
            return (ITypeBinding)this.bindings.get(keys[0]);
        }
        return null;
    }

    private String computeJavaTypeReplacementString(CompletionProposal proposal) {
        String replacement = String.valueOf(proposal.getCompletion());
        if (CompletionProposalUtils.isImportCompletion(proposal)) {
            return replacement;
        }
        if (proposal.getKind() == 9 && this.context.isInJavadocText()) {
            return SignatureUtil.getSimpleTypeName((CompletionProposal)proposal);
        }
        String qualifiedTypeName = SignatureUtil.getQualifiedTypeName((CompletionProposal)proposal);
        if (this.compilationUnit != null && TypeProposalUtils.isPackageInfo(this.compilationUnit)) {
            return qualifiedTypeName;
        }
        if (qualifiedTypeName.indexOf(46) == -1 && replacement.length() > 0) {
            return qualifiedTypeName;
        }
        String prefix = "";
        try {
            IDocument document = JsonRpcHelpers.toDocument(this.compilationUnit.getBuffer());
            prefix = document.get(proposal.getReplaceStart(), proposal.getReplaceEnd() - proposal.getReplaceStart());
        }
        catch (JavaModelException | BadLocationException document) {
            // empty catch block
        }
        int dotIndex = prefix.lastIndexOf(46);
        if (dotIndex != -1 && qualifiedTypeName.toLowerCase().startsWith(prefix.substring(0, dotIndex + 1).toLowerCase())) {
            return qualifiedTypeName;
        }
        if (replacement.indexOf(46) == -1) {
            if (this.isInJavadoc()) {
                return SignatureUtil.getSimpleTypeName((CompletionProposal)proposal);
            }
            return replacement;
        }
        if (this.importRewrite != null) {
            CompilationUnit cu;
            ContextSensitiveImportRewriteContext context = null;
            if (this.isResolvingRequest && (cu = SharedASTProviderCore.getAST((ITypeRoot)this.compilationUnit, (SharedASTProviderCore.WAIT_FLAG)SharedASTProviderCore.WAIT_NO, (IProgressMonitor)new NullProgressMonitor())) != null) {
                context = new ContextSensitiveImportRewriteContext(cu, this.offset, this.importRewrite);
            }
            return this.importRewrite.addImport(qualifiedTypeName, context);
        }
        if (this.compilationUnit != null && TypeProposalUtils.isImplicitImport(Signature.getQualifier((String)qualifiedTypeName), this.compilationUnit)) {
            return Signature.getSimpleName((String)qualifiedTypeName);
        }
        return qualifiedTypeName;
    }
}

