/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.contentassist;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;

public class AnonymousTypeCompletionProposal {
    private ICompilationUnit fCompilationUnit;
    private int fReplacementOffset;
    private boolean fSnippetSupport;

    public AnonymousTypeCompletionProposal(ICompilationUnit cu, int replacementOffset, boolean snippetSupport) {
        this.fCompilationUnit = cu;
        this.fReplacementOffset = replacementOffset;
        this.fSnippetSupport = snippetSupport;
    }

    public String updateReplacementString(IDocument document, int offset) throws CoreException, BadLocationException {
        String newBody = this.fSnippetSupport ? "{\n\t${0}\n}" : "{\n\n}";
        StringBuilder buf = new StringBuilder("new A() ");
        buf.append(newBody);
        String lineDelim = TextUtilities.getDefaultLineDelimiter((IDocument)document);
        IRegion lineInfo = document.getLineInformationOfOffset(this.fReplacementOffset);
        Map options = this.fCompilationUnit.getOptions(true);
        String replacementString = CodeFormatterUtil.format((int)1, (String)buf.toString(), (int)0, (String)lineDelim, (Map)options);
        int lineEndOffset = lineInfo.getOffset() + lineInfo.getLength();
        int p = offset;
        if (p < document.getLength()) {
            char ch = document.getChar(p);
            while (p < lineEndOffset) {
                if (ch == '(' || ch == ')' || ch == ';' || ch == ',') break;
                ch = document.getChar(++p);
            }
            if (ch != ';' && ch != ',' && ch != ')') {
                replacementString = String.valueOf(replacementString) + ';';
            }
        }
        int beginIndex = replacementString.indexOf(40);
        replacementString = replacementString.substring(beginIndex);
        return replacementString;
    }
}

