/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.channels.MembershipKey;
import java.nio.channels.MulticastChannel;
import java.util.HashSet;
import sun.nio.ch.DatagramChannelImpl;

class MembershipKeyImpl
extends MembershipKey {
    private final MulticastChannel ch;
    private final InetAddress group;
    private final NetworkInterface interf;
    private final InetAddress source;
    private volatile boolean valid = true;
    private Object stateLock = new Object();
    private HashSet<InetAddress> blockedSet;

    private MembershipKeyImpl(MulticastChannel multicastChannel, InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2) {
        this.ch = multicastChannel;
        this.group = inetAddress;
        this.interf = networkInterface;
        this.source = inetAddress2;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    void invalidate() {
        this.valid = false;
    }

    @Override
    public void drop() {
        ((DatagramChannelImpl)this.ch).drop(this);
    }

    @Override
    public MulticastChannel channel() {
        return this.ch;
    }

    @Override
    public InetAddress group() {
        return this.group;
    }

    @Override
    public NetworkInterface networkInterface() {
        return this.interf;
    }

    @Override
    public InetAddress sourceAddress() {
        return this.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MembershipKey block(InetAddress inetAddress) throws IOException {
        if (this.source != null) {
            throw new IllegalStateException("key is source-specific");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (this.blockedSet != null && this.blockedSet.contains(inetAddress)) {
                return this;
            }
            ((DatagramChannelImpl)this.ch).block(this, inetAddress);
            if (this.blockedSet == null) {
                this.blockedSet = new HashSet();
            }
            this.blockedSet.add(inetAddress);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MembershipKey unblock(InetAddress inetAddress) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.blockedSet == null || !this.blockedSet.contains(inetAddress)) {
                throw new IllegalStateException("not blocked");
            }
            ((DatagramChannelImpl)this.ch).unblock(this, inetAddress);
            this.blockedSet.remove(inetAddress);
        }
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append('<');
        stringBuilder.append(this.group.getHostAddress());
        stringBuilder.append(',');
        stringBuilder.append(this.interf.getName());
        if (this.source != null) {
            stringBuilder.append(',');
            stringBuilder.append(this.source.getHostAddress());
        }
        stringBuilder.append('>');
        return stringBuilder.toString();
    }

    static class Type6
    extends MembershipKeyImpl {
        private final byte[] groupAddress;
        private final int index;
        private final byte[] sourceAddress;

        Type6(MulticastChannel multicastChannel, InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2, byte[] byArray, int n, byte[] byArray2) {
            super(multicastChannel, inetAddress, networkInterface, inetAddress2);
            this.groupAddress = byArray;
            this.index = n;
            this.sourceAddress = byArray2;
        }

        byte[] groupAddress() {
            return this.groupAddress;
        }

        int index() {
            return this.index;
        }

        byte[] source() {
            return this.sourceAddress;
        }
    }

    static class Type4
    extends MembershipKeyImpl {
        private final int groupAddress;
        private final int interfAddress;
        private final int sourceAddress;

        Type4(MulticastChannel multicastChannel, InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2, int n, int n2, int n3) {
            super(multicastChannel, inetAddress, networkInterface, inetAddress2);
            this.groupAddress = n;
            this.interfAddress = n2;
            this.sourceAddress = n3;
        }

        int groupAddress() {
            return this.groupAddress;
        }

        int interfaceAddress() {
            return this.interfAddress;
        }

        int source() {
            return this.sourceAddress;
        }
    }
}

