/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.GCMParameterSpec;
import sun.misc.HexDumpEncoder;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public final class GCMParameters
extends AlgorithmParametersSpi {
    private byte[] iv;
    private int tLen;

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof GCMParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        GCMParameterSpec gCMParameterSpec = (GCMParameterSpec)algorithmParameterSpec;
        this.tLen = gCMParameterSpec.getTLen() / 8;
        this.iv = gCMParameterSpec.getIV();
    }

    @Override
    protected void engineInit(byte[] byArray) throws IOException {
        int n;
        byte[] byArray2;
        DerValue derValue = new DerValue(byArray);
        if (derValue.tag == 48) {
            byArray2 = derValue.data.getOctetString();
            if (derValue.data.available() != 0) {
                n = derValue.data.getInteger();
                if (n < 12 || n > 16) {
                    throw new IOException("GCM parameter parsing error: unsupported tag len: " + n);
                }
                if (derValue.data.available() != 0) {
                    throw new IOException("GCM parameter parsing error: extra data");
                }
            } else {
                n = 12;
            }
        } else {
            throw new IOException("GCM parameter parsing error: no SEQ tag");
        }
        this.iv = (byte[])byArray2.clone();
        this.tLen = n;
    }

    @Override
    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> clazz) throws InvalidParameterSpecException {
        if (GCMParameterSpec.class.isAssignableFrom(clazz)) {
            return (T)((AlgorithmParameterSpec)clazz.cast(new GCMParameterSpec(this.tLen * 8, this.iv)));
        }
        throw new InvalidParameterSpecException("Inappropriate parameter specification");
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOctetString(this.iv);
        derOutputStream2.putInteger(this.tLen);
        derOutputStream.write((byte)48, derOutputStream2);
        return derOutputStream.toByteArray();
    }

    @Override
    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    @Override
    protected String engineToString() {
        String string = System.getProperty("line.separator");
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        StringBuilder stringBuilder = new StringBuilder(string + "    iv:" + string + "[" + hexDumpEncoder.encodeBuffer(this.iv) + "]");
        stringBuilder.append(string + "tLen(bits):" + string + this.tLen * 8 + string);
        return stringBuilder.toString();
    }
}

