/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.security.ProviderException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import sun.security.pkcs11.NativeKeyHolder;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.PKCS11Exception;

final class SessionKeyRef
extends PhantomReference<P11Key> {
    private static ReferenceQueue<P11Key> refQueue = new ReferenceQueue();
    private static Set<SessionKeyRef> refSet = Collections.synchronizedSet(new HashSet());
    private long keyID;
    private Session session;
    private boolean wrapperKeyUsed;

    static ReferenceQueue<P11Key> referenceQueue() {
        return refQueue;
    }

    private static void drainRefQueueBounded() {
        SessionKeyRef sessionKeyRef;
        while ((sessionKeyRef = (SessionKeyRef)refQueue.poll()) != null) {
            sessionKeyRef.dispose();
        }
    }

    SessionKeyRef(P11Key p11Key, long l, boolean bl, Session session) {
        super(p11Key, refQueue);
        if (session == null) {
            throw new ProviderException("key must be associated with a session");
        }
        this.registerNativeKey(l, session);
        this.wrapperKeyUsed = bl;
        refSet.add(this);
        SessionKeyRef.drainRefQueueBounded();
    }

    void registerNativeKey(long l, Session session) {
        assert (l != 0L);
        assert (session != null);
        this.updateNativeKey(l, session);
    }

    void removeNativeKey() {
        assert (this.session != null);
        this.updateNativeKey(0L, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNativeKey(long l, Session session) {
        if (l == 0L) {
            assert (session == null);
            Token token = this.session.token;
            if (token.isValid()) {
                Session session2 = null;
                try {
                    session2 = token.getOpSession();
                    token.p11.C_DestroyObject(session2.id(), this.keyID);
                }
                catch (PKCS11Exception pKCS11Exception) {
                }
                finally {
                    token.releaseSession(session2);
                }
            }
            this.session.removeObject();
        } else {
            session.addObject();
        }
        this.keyID = l;
        this.session = session;
    }

    void dispose() {
        if (this.wrapperKeyUsed) {
            NativeKeyHolder.decWrapperKeyRef();
        }
        if (this.keyID != 0L) {
            this.removeNativeKey();
        }
        refSet.remove(this);
        this.clear();
    }
}

