/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import sun.awt.datatransfer.DataTransferer;
import sun.awt.datatransfer.ToolkitThreadBlockedHandler;
import sun.lwawt.macosx.CImage;
import sun.lwawt.macosx.CToolkitThreadBlockedHandler;

public class CDataTransferer
extends DataTransferer {
    private static final Map<String, Long> predefinedClipboardNameMap;
    private static final Map<Long, String> predefinedClipboardFormatMap;
    private static final String[] predefinedClipboardNames;
    public static final int CF_UNSUPPORTED = 0;
    public static final int CF_STRING = 1;
    public static final int CF_FILE = 2;
    public static final int CF_TIFF = 3;
    public static final int CF_RICH_TEXT = 4;
    public static final int CF_HTML = 5;
    public static final int CF_PDF = 6;
    public static final int CF_URL = 7;
    public static final int CF_PNG = 8;
    public static final int CF_JPEG = 9;
    public static final int CF_XPICT = 10;
    private static CDataTransferer fTransferer;
    private final ToolkitThreadBlockedHandler handler = new CToolkitThreadBlockedHandler();

    private CDataTransferer() {
    }

    static synchronized CDataTransferer getInstanceImpl() {
        if (fTransferer == null) {
            fTransferer = new CDataTransferer();
        }
        return fTransferer;
    }

    @Override
    public String getDefaultUnicodeEncoding() {
        return "utf-16le";
    }

    @Override
    public boolean isLocaleDependentTextFormat(long l) {
        return l == 1L;
    }

    @Override
    public boolean isFileFormat(long l) {
        return l == 2L;
    }

    @Override
    public boolean isImageFormat(long l) {
        int n = (int)l;
        switch (n) {
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object translateBytes(byte[] byArray, DataFlavor dataFlavor, long l, Transferable transferable) throws IOException {
        if (l == 7L && URL.class.equals(dataFlavor.getRepresentationClass())) {
            String[] stringArray = this.dragQueryFile(byArray);
            if (stringArray == null || stringArray.length == 0) {
                return null;
            }
            return new URL(stringArray[0]);
        }
        if (this.isUriListFlavor(dataFlavor)) {
            String[] stringArray = this.dragQueryFile(byArray);
            if (stringArray == null) {
                return null;
            }
            String string = System.getProperty("line.separator");
            StringBuilder stringBuilder = new StringBuilder();
            if (stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuilder.append(stringArray[i]);
                    stringBuilder.append(string);
                }
            }
            byArray = stringBuilder.toString().getBytes();
            l = 1L;
        } else if (l == 1L) {
            byArray = Normalizer.normalize(new String(byArray, "UTF8"), Normalizer.Form.NFC).getBytes("UTF8");
        }
        return super.translateBytes(byArray, dataFlavor, l, transferable);
    }

    @Override
    protected synchronized Long getFormatForNativeAsLong(String string) {
        Long l = predefinedClipboardNameMap.get(string);
        if (l == null) {
            if (GraphicsEnvironment.getLocalGraphicsEnvironment().isHeadlessInstance()) {
                return -1L;
            }
            l = this.registerFormatWithPasteboard(string);
            predefinedClipboardNameMap.put(string, l);
            predefinedClipboardFormatMap.put(l, string);
        }
        return l;
    }

    private native long registerFormatWithPasteboard(String var1);

    private native String formatForIndex(long var1);

    @Override
    protected String getNativeForFormat(long l) {
        String string = null;
        if (l >= 0L && l < (long)predefinedClipboardNames.length) {
            string = predefinedClipboardNames[(int)l];
        } else {
            Long l2 = l;
            string = predefinedClipboardFormatMap.get(l2);
            if (string == null && (string = this.formatForIndex(l)) != null) {
                predefinedClipboardNameMap.put(string, l2);
                predefinedClipboardFormatMap.put(l2, string);
            }
        }
        if (string == null) {
            string = predefinedClipboardNames[0];
        }
        return string;
    }

    @Override
    public ToolkitThreadBlockedHandler getToolkitThreadBlockedHandler() {
        return this.handler;
    }

    @Override
    protected byte[] imageToPlatformBytes(Image image, long l) {
        return CImage.getCreator().getPlatformImageBytes(image);
    }

    private static native String[] nativeDragQueryFile(byte[] var0);

    @Override
    protected String[] dragQueryFile(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        if (new String(byArray).startsWith("Unsupported type")) {
            return null;
        }
        return CDataTransferer.nativeDragQueryFile(byArray);
    }

    @Override
    protected Image platformImageBytesToImage(byte[] byArray, long l) throws IOException {
        return CImage.getCreator().createImageFromPlatformImageBytes(byArray);
    }

    @Override
    protected ByteArrayOutputStream convertFileListToBytes(ArrayList<String> arrayList) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (String string : arrayList) {
            byte[] byArray = string.getBytes();
            byteArrayOutputStream.write(byArray, 0, byArray.length);
            byteArrayOutputStream.write(0);
        }
        return byteArrayOutputStream;
    }

    @Override
    protected boolean isURIListFormat(long l) {
        String string = this.getNativeForFormat(l);
        if (string == null) {
            return false;
        }
        try {
            DataFlavor dataFlavor = new DataFlavor(string);
            if (this.isUriListFlavor(dataFlavor)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean isUriListFlavor(DataFlavor dataFlavor) {
        return dataFlavor.getPrimaryType().equals("text") && dataFlavor.getSubType().equals("uri-list");
    }

    static {
        predefinedClipboardNames = new String[]{"", "STRING", "FILE_NAME", "TIFF", "RICH_TEXT", "HTML", "PDF", "URL", "PNG", "JFIF", "XPICT"};
        HashMap<String, Long> hashMap = new HashMap<String, Long>(predefinedClipboardNames.length, 1.0f);
        HashMap<Long, String> hashMap2 = new HashMap<Long, String>(predefinedClipboardNames.length, 1.0f);
        for (int i = 1; i < predefinedClipboardNames.length; ++i) {
            hashMap.put(predefinedClipboardNames[i], Long.valueOf(i));
            hashMap2.put(Long.valueOf(i), predefinedClipboardNames[i]);
        }
        predefinedClipboardNameMap = Collections.synchronizedMap(hashMap);
        predefinedClipboardFormatMap = Collections.synchronizedMap(hashMap2);
    }
}

