/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaMnemonicHandler;
import com.apple.laf.AquaUtilControlSize;
import com.apple.laf.AquaUtils;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicLabelUI;
import sun.swing.SwingUtilities2;

public class AquaLabelUI
extends BasicLabelUI {
    protected static final AquaUtils.RecyclableSingleton<AquaLabelUI> aquaLabelUI = new AquaUtils.RecyclableSingletonFromDefaultConstructor<AquaLabelUI>(AquaLabelUI.class);
    static final String DISABLED_COLOR_KEY = "Label.disabledForegroundColor";

    public static ComponentUI createUI(JComponent jComponent) {
        return aquaLabelUI.get();
    }

    @Override
    protected void installListeners(JLabel jLabel) {
        super.installListeners(jLabel);
        AquaUtilControlSize.addSizePropertyListener(jLabel);
    }

    @Override
    protected void uninstallListeners(JLabel jLabel) {
        AquaUtilControlSize.removeSizePropertyListener(jLabel);
        super.uninstallListeners(jLabel);
    }

    @Override
    protected void paintEnabledText(JLabel jLabel, Graphics graphics, String string, int n, int n2) {
        int n3 = jLabel.getDisplayedMnemonicIndex();
        if (AquaMnemonicHandler.isMnemonicHidden()) {
            n3 = -1;
        }
        graphics.setColor(jLabel.getForeground());
        SwingUtilities2.drawStringUnderlineCharAt(jLabel, graphics, string, n3, n, n2);
    }

    @Override
    protected void paintDisabledText(JLabel jLabel, Graphics graphics, String string, int n, int n2) {
        Color color;
        int n3 = jLabel.getDisplayedMnemonicIndex();
        if (AquaMnemonicHandler.isMnemonicHidden()) {
            n3 = -1;
        }
        if ((color = jLabel.getBackground()) instanceof UIResource) {
            graphics.setColor(this.getDisabledLabelColor(jLabel));
            SwingUtilities2.drawStringUnderlineCharAt(jLabel, graphics, string, n3, n, n2);
        } else {
            super.paintDisabledText(jLabel, graphics, string, n, n2);
        }
    }

    protected Color getDisabledLabelColor(JLabel jLabel) {
        Color color;
        Color color2 = jLabel.getForeground();
        Object object = jLabel.getClientProperty(DISABLED_COLOR_KEY);
        if (object instanceof Color) {
            color = (Color)object;
            if (color2.getRGB() << 8 == color.getRGB() << 8) {
                return color;
            }
        }
        color = new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), color2.getAlpha() / 2);
        jLabel.putClientProperty(DISABLED_COLOR_KEY, color);
        return color;
    }
}

