/*
 * Decompiled with CFR 0.152.
 */
package apple.laf;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIControl;

public class JRSUIState {
    final long encodedState;
    long derivedEncodedState;
    static JRSUIState prototype = new JRSUIState(0L);

    public static JRSUIState getInstance() {
        return prototype.derive();
    }

    JRSUIState(JRSUIConstants.Widget widget) {
        this(widget.apply(0L));
    }

    JRSUIState(long l) {
        this.encodedState = this.derivedEncodedState = l;
    }

    boolean isDerivationSame() {
        return this.encodedState == this.derivedEncodedState;
    }

    public <T extends JRSUIState> T derive() {
        if (this.isDerivationSame()) {
            return (T)this;
        }
        T t = this.createDerivation();
        return t;
    }

    public <T extends JRSUIState> T createDerivation() {
        return (T)new JRSUIState(this.derivedEncodedState);
    }

    public void reset() {
        this.derivedEncodedState = this.encodedState;
    }

    public void set(JRSUIConstants.Property property) {
        this.derivedEncodedState = property.apply(this.derivedEncodedState);
    }

    public void apply(JRSUIControl jRSUIControl) {
        jRSUIControl.setEncodedState(this.encodedState);
    }

    public boolean equals(Object object) {
        if (!(object instanceof JRSUIState)) {
            return false;
        }
        return this.encodedState == ((JRSUIState)object).encodedState && this.getClass().equals(object.getClass());
    }

    public boolean is(JRSUIConstants.Property property) {
        return (byte)((this.derivedEncodedState & property.encoding.mask) >> property.encoding.shift) == property.ordinal;
    }

    public int hashCode() {
        return (int)(this.encodedState ^ this.encodedState >>> 32) ^ this.getClass().hashCode();
    }

    public static class ScrollBarState
    extends ValueState {
        final double thumbProportion;
        double derivedThumbProportion;
        final double thumbStart;
        double derivedThumbStart;

        ScrollBarState(long l, double d, double d2, double d3) {
            super(l, d);
            this.thumbProportion = this.derivedThumbProportion = d2;
            this.thumbStart = this.derivedThumbStart = d3;
        }

        @Override
        boolean isDerivationSame() {
            return super.isDerivationSame() && this.thumbProportion == this.derivedThumbProportion && this.thumbStart == this.derivedThumbStart;
        }

        @Override
        public <T extends JRSUIState> T createDerivation() {
            return (T)new ScrollBarState(this.derivedEncodedState, this.derivedValue, this.derivedThumbProportion, this.derivedThumbStart);
        }

        @Override
        public void reset() {
            super.reset();
            this.derivedThumbProportion = this.thumbProportion;
            this.derivedThumbStart = this.thumbStart;
        }

        public void setThumbPercent(double d) {
            this.derivedThumbProportion = d;
        }

        public void setThumbStart(double d) {
            this.derivedThumbStart = d;
        }

        @Override
        public void apply(JRSUIControl jRSUIControl) {
            super.apply(jRSUIControl);
            jRSUIControl.set(JRSUIConstants.Key.THUMB_PROPORTION, this.thumbProportion);
            jRSUIControl.set(JRSUIConstants.Key.THUMB_START, this.thumbStart);
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof ScrollBarState)) {
                return false;
            }
            return this.thumbProportion == ((ScrollBarState)object).thumbProportion && this.thumbStart == ((ScrollBarState)object).thumbStart && super.equals(object);
        }

        @Override
        public int hashCode() {
            long l = Double.doubleToRawLongBits(this.thumbProportion) ^ Double.doubleToRawLongBits(this.thumbStart);
            return super.hashCode() ^ (int)l ^ (int)(l >>> 32);
        }
    }

    public static class TitleBarHeightState
    extends ValueState {
        TitleBarHeightState(long l, double d) {
            super(l, d);
        }

        @Override
        public <T extends JRSUIState> T createDerivation() {
            return (T)new TitleBarHeightState(this.derivedEncodedState, this.derivedValue);
        }

        @Override
        public void apply(JRSUIControl jRSUIControl) {
            super.apply(jRSUIControl);
            jRSUIControl.set(JRSUIConstants.Key.WINDOW_TITLE_BAR_HEIGHT, this.value);
        }
    }

    public static class ValueState
    extends JRSUIState {
        final double value;
        double derivedValue;

        ValueState(long l, double d) {
            super(l);
            this.value = this.derivedValue = d;
        }

        @Override
        boolean isDerivationSame() {
            return super.isDerivationSame() && this.value == this.derivedValue;
        }

        @Override
        public <T extends JRSUIState> T createDerivation() {
            return (T)new ValueState(this.derivedEncodedState, this.derivedValue);
        }

        @Override
        public void reset() {
            super.reset();
            this.derivedValue = this.value;
        }

        public void setValue(double d) {
            this.derivedValue = d;
        }

        @Override
        public void apply(JRSUIControl jRSUIControl) {
            super.apply(jRSUIControl);
            jRSUIControl.set(JRSUIConstants.Key.VALUE, this.value);
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof ValueState)) {
                return false;
            }
            return this.value == ((ValueState)object).value && super.equals(object);
        }

        @Override
        public int hashCode() {
            long l = Double.doubleToRawLongBits(this.value);
            return super.hashCode() ^ (int)l ^ (int)(l >>> 32);
        }
    }

    public static class AnimationFrameState
    extends JRSUIState {
        final int animationFrame;
        int derivedAnimationFrame;

        AnimationFrameState(long l, int n) {
            super(l);
            this.animationFrame = this.derivedAnimationFrame = n;
        }

        @Override
        boolean isDerivationSame() {
            return super.isDerivationSame() && this.animationFrame == this.derivedAnimationFrame;
        }

        @Override
        public <T extends JRSUIState> T createDerivation() {
            return (T)new AnimationFrameState(this.derivedEncodedState, this.derivedAnimationFrame);
        }

        @Override
        public void reset() {
            super.reset();
            this.derivedAnimationFrame = this.animationFrame;
        }

        public void setAnimationFrame(int n) {
            this.derivedAnimationFrame = n;
        }

        @Override
        public void apply(JRSUIControl jRSUIControl) {
            super.apply(jRSUIControl);
            jRSUIControl.set(JRSUIConstants.Key.ANIMATION_FRAME, this.animationFrame);
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof AnimationFrameState)) {
                return false;
            }
            return this.animationFrame == ((AnimationFrameState)object).animationFrame && super.equals(object);
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ this.animationFrame;
        }
    }
}

