/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.tool;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import jdk.jfr.EventType;
import jdk.jfr.internal.MetadataDescriptor;
import jdk.jfr.internal.consumer.ChunkHeader;
import jdk.jfr.internal.consumer.RecordingInput;
import jdk.jfr.internal.tool.Command;
import jdk.jfr.internal.tool.UserDataException;
import jdk.jfr.internal.tool.UserSyntaxException;

final class Summary
extends Command {
    private final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withLocale(Locale.UK).withZone(ZoneOffset.UTC);

    Summary() {
    }

    @Override
    public String getName() {
        return "summary";
    }

    @Override
    public List<String> getOptionSyntax() {
        return Collections.singletonList("<file>");
    }

    @Override
    public void displayOptionUsage(PrintStream printStream) {
        printStream.println("  <file>   Location of the recording file (.jfr) to display information about");
    }

    @Override
    public String getDescription() {
        return "Display general information about a recording file (.jfr)";
    }

    @Override
    public void execute(Deque<String> deque) throws UserSyntaxException, UserDataException {
        this.ensureMaxArgumentCount(deque, 1);
        Path path = this.getJFRInputFile(deque);
        try {
            this.printInformation(path);
        }
        catch (IOException iOException) {
            this.couldNotReadError(path, iOException);
        }
    }

    private void printInformation(Path path) throws IOException {
        long l2 = 0L;
        long l22 = 0L;
        try (RecordingInput recordingInput = new RecordingInput(path.toFile());){
            long l3;
            ChunkHeader chunkHeader;
            ChunkHeader chunkHeader2 = chunkHeader = new ChunkHeader(recordingInput);
            String string = "jdk.";
            if (chunkHeader.getMajor() == 1) {
                string = "com.oracle.jdk.";
            }
            HashMap<Long, Statistics> hashMap = new HashMap<Long, Statistics>();
            hashMap.put(0L, new Statistics(string + "Metadata"));
            hashMap.put(1L, new Statistics(string + "CheckPoint"));
            int n = 0;
            while (true) {
                l3 = chunkHeader2.getEnd();
                MetadataDescriptor metadataDescriptor = chunkHeader2.readMetadata();
                for (EventType object2 : metadataDescriptor.getEventTypes()) {
                    hashMap.computeIfAbsent(object2.getId(), l -> new Statistics(object2.getName()));
                    n = Math.max(n, object2.getName().length());
                }
                l2 += chunkHeader2.getDurationNanos();
                ++l22;
                recordingInput.position(chunkHeader2.getEventStart());
                while (recordingInput.position() < l3) {
                    long l4 = recordingInput.position();
                    int string2 = recordingInput.readInt();
                    long string3 = recordingInput.readLong();
                    Statistics statistics3 = (Statistics)hashMap.get(string3);
                    if (statistics3 != null) {
                        ++statistics3.count;
                        statistics3.size += (long)string2;
                    }
                    recordingInput.position(l4 + (long)string2);
                }
                if (chunkHeader2.isLastChunk()) break;
                chunkHeader2 = chunkHeader2.nextHeader();
            }
            this.println();
            l3 = chunkHeader.getStartNanos() / 1000000000L;
            long l6 = chunkHeader.getStartNanos() - l3 * 1000000000L;
            this.println(" Version: " + chunkHeader.getMajor() + "." + chunkHeader.getMinor());
            this.println(" Chunks: " + l22);
            this.println(" Start: " + this.DATE_FORMAT.format(Instant.ofEpochSecond(l3, l6)) + " (UTC)");
            this.println(" Duration: " + (l2 + 500000000L) / 1000000000L + " s");
            ArrayList arrayList = new ArrayList(hashMap.values());
            Collections.sort(arrayList, (statistics, statistics2) -> Long.compare(statistics2.count, statistics.count));
            this.println();
            String string2 = "      Count  Size (bytes) ";
            String string3 = " Event Type";
            n = Math.max(n, string3.length());
            this.println(string3 + this.pad(n - string3.length(), ' ') + string2);
            this.println(this.pad(n + string2.length(), '='));
            for (Statistics statistics3 : arrayList) {
                System.out.printf(" %-" + n + "s%10d  %12d\n", statistics3.name, statistics3.count, statistics3.size);
            }
        }
    }

    private String pad(int n, char c) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private static class Statistics {
        String name;
        long count;
        long size;

        Statistics(String string) {
            this.name = string;
        }
    }
}

