/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.jfr;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;

final class Stream
implements Closeable {
    private final long identifier;
    private final BufferedInputStream inputStream;
    private final byte[] buffer;
    private volatile long time;

    Stream(InputStream inputStream, long l, int n) {
        this.inputStream = new BufferedInputStream(inputStream, 50000);
        this.identifier = l;
        this.buffer = new byte[n];
    }

    private void touch() {
        this.time = System.currentTimeMillis();
    }

    public long getLastTouched() {
        return this.time;
    }

    public byte[] read() throws IOException {
        this.touch();
        int n = this.inputStream.read(this.buffer);
        if (n == -1) {
            return null;
        }
        if (n != this.buffer.length) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.buffer, 0, byArray, 0, n);
            return byArray;
        }
        return this.buffer;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    public long getId() {
        return this.identifier;
    }
}

