/*
 * Decompiled with CFR 0.152.
 */
package sun.security.rsa;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.MGF1ParameterSpec;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import sun.security.jca.JCAUtil;
import sun.security.rsa.MGF1;
import sun.security.rsa.RSACore;

public final class RSAPadding {
    public static final int PAD_BLOCKTYPE_1 = 1;
    public static final int PAD_BLOCKTYPE_2 = 2;
    public static final int PAD_NONE = 3;
    public static final int PAD_OAEP_MGF1 = 4;
    private final int type;
    private final int paddedSize;
    private SecureRandom random;
    private final int maxDataSize;
    private MessageDigest md;
    private MGF1 mgf;
    private byte[] lHash;
    private static final Map<String, byte[]> emptyHashes = Collections.synchronizedMap(new HashMap());

    public static RSAPadding getInstance(int n, int n2) throws InvalidKeyException, InvalidAlgorithmParameterException {
        return new RSAPadding(n, n2, null, null);
    }

    public static RSAPadding getInstance(int n, int n2, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        return new RSAPadding(n, n2, secureRandom, null);
    }

    public static RSAPadding getInstance(int n, int n2, SecureRandom secureRandom, OAEPParameterSpec oAEPParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        return new RSAPadding(n, n2, secureRandom, oAEPParameterSpec);
    }

    private RSAPadding(int n, int n2, SecureRandom secureRandom, OAEPParameterSpec oAEPParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.type = n;
        this.paddedSize = n2;
        this.random = secureRandom;
        if (n2 < 64) {
            throw new InvalidKeyException("Padded size must be at least 64");
        }
        switch (n) {
            case 1: 
            case 2: {
                this.maxDataSize = n2 - 11;
                break;
            }
            case 3: {
                this.maxDataSize = n2;
                break;
            }
            case 4: {
                String string;
                String string2 = string = "SHA-1";
                byte[] byArray = null;
                try {
                    if (oAEPParameterSpec != null) {
                        string = oAEPParameterSpec.getDigestAlgorithm();
                        String string3 = oAEPParameterSpec.getMGFAlgorithm();
                        if (!string3.equalsIgnoreCase("MGF1")) {
                            throw new InvalidAlgorithmParameterException("Unsupported MGF algo: " + string3);
                        }
                        string2 = ((MGF1ParameterSpec)oAEPParameterSpec.getMGFParameters()).getDigestAlgorithm();
                        PSource pSource = oAEPParameterSpec.getPSource();
                        String string4 = pSource.getAlgorithm();
                        if (!string4.equalsIgnoreCase("PSpecified")) {
                            throw new InvalidAlgorithmParameterException("Unsupported pSource algo: " + string4);
                        }
                        byArray = ((PSource.PSpecified)pSource).getValue();
                    }
                    this.md = MessageDigest.getInstance(string);
                    this.mgf = new MGF1(string2);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new InvalidKeyException("Digest not available", noSuchAlgorithmException);
                }
                this.lHash = RSAPadding.getInitialHash(this.md, byArray);
                int n3 = this.lHash.length;
                this.maxDataSize = n2 - 2 - 2 * n3;
                if (this.maxDataSize > 0) break;
                throw new InvalidKeyException("Key is too short for encryption using OAEPPadding with " + string + " and " + this.mgf.getName());
            }
            default: {
                throw new InvalidKeyException("Invalid padding: " + n);
            }
        }
    }

    private static byte[] getInitialHash(MessageDigest messageDigest, byte[] byArray) {
        byte[] byArray2;
        if (byArray == null || byArray.length == 0) {
            String string = messageDigest.getAlgorithm();
            byArray2 = emptyHashes.get(string);
            if (byArray2 == null) {
                byArray2 = messageDigest.digest();
                emptyHashes.put(string, byArray2);
            }
        } else {
            byArray2 = messageDigest.digest(byArray);
        }
        return byArray2;
    }

    public int getMaxDataSize() {
        return this.maxDataSize;
    }

    public byte[] pad(byte[] byArray) {
        return this.pad(byArray, 0, byArray.length);
    }

    public byte[] pad(byte[] byArray, int n, int n2) {
        if (n2 > this.maxDataSize) {
            return null;
        }
        switch (this.type) {
            case 3: {
                return RSACore.convert(byArray, n, n2);
            }
            case 1: 
            case 2: {
                return this.padV15(byArray, n, n2);
            }
            case 4: {
                return this.padOAEP(byArray, n, n2);
            }
        }
        throw new AssertionError();
    }

    public byte[] unpad(byte[] byArray) {
        if (byArray.length == this.paddedSize) {
            switch (this.type) {
                case 3: {
                    return byArray;
                }
                case 1: 
                case 2: {
                    return this.unpadV15(byArray);
                }
                case 4: {
                    return this.unpadOAEP(byArray);
                }
            }
            throw new AssertionError();
        }
        return null;
    }

    private byte[] padV15(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[this.paddedSize];
        System.arraycopy(byArray, n, byArray2, this.paddedSize - n2, n2);
        int n3 = this.paddedSize - 3 - n2;
        int n4 = 0;
        byArray2[n4++] = 0;
        byArray2[n4++] = (byte)this.type;
        if (this.type == 1) {
            while (n3-- > 0) {
                byArray2[n4++] = -1;
            }
        } else {
            if (this.random == null) {
                this.random = JCAUtil.getSecureRandom();
            }
            byte[] byArray3 = new byte[64];
            int n5 = -1;
            while (n3-- > 0) {
                int n6;
                do {
                    if (n5 >= 0) continue;
                    this.random.nextBytes(byArray3);
                    n5 = byArray3.length - 1;
                } while ((n6 = byArray3[n5--] & 0xFF) == 0);
                byArray2[n4++] = (byte)n6;
            }
        }
        return byArray2;
    }

    private byte[] unpadV15(byte[] byArray) {
        int n;
        int n2 = byArray.length;
        if (n2 < 2) {
            return null;
        }
        byte by = byArray[0];
        byte by2 = byArray[1];
        int n3 = (-(by & 0xFF) | (by2 - this.type | this.type - by2)) >>> 31;
        int n4 = 0;
        int n5 = 2;
        while (n5 < n2) {
            n = byArray[n5++] & 0xFF;
            n4 += n5 * (1 - (-(n | n4) >>> 31));
            if (n5 == n2) {
                n3 |= 1 - (-n4 >>> 31);
            }
            n3 |= 1 - (-(this.type - 1 & 0xFF | n4 | 1 - (n - 255 >>> 31)) >>> 31);
        }
        n = n2 - n4;
        n3 |= this.maxDataSize - n >>> 31;
        byte[] byArray2 = new byte[n4 + 2];
        for (int i = 0; i < n4; ++i) {
            byArray2[i] = byArray[i];
        }
        byte[] byArray3 = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray3[i] = byArray[n4 + i];
        }
        if ((n3 | byArray2[n3]) != 0) {
            return null;
        }
        return byArray3;
    }

    public byte[] unpadForTls(byte[] byArray, int n, int n2) {
        int n3;
        int n4 = byArray.length;
        int n5 = (byArray[0] | byArray[1] - 2) & 0xFFF;
        int n6 = 2;
        while (n6 < n4 - 49) {
            n3 = byArray[n6++] & 0xFF;
            n5 |= 1 - (-n3 >>> 31);
        }
        n5 |= byArray[n6++] & 0xFF;
        n3 = (byArray[n6] & 0xFF) << 8 | byArray[n6 + 1] & 0xFF;
        int n7 = n - n3;
        n7 |= -n7;
        int n8 = n2 - n3;
        n8 |= -n8;
        int n9 = 769 - n;
        n5 |= (n7 & (n9 | n8)) >>> 28;
        byte[] byArray2 = Arrays.copyOfRange(byArray, n4 - 48, n4);
        if (this.random == null) {
            this.random = JCAUtil.getSecureRandom();
        }
        byte[] byArray3 = new byte[48];
        this.random.nextBytes(byArray3);
        n5 = -n5 >> 24;
        for (int i = 0; i < 48; ++i) {
            byArray2[i] = (byte)(~n5 & byArray2[i] | n5 & byArray3[i]);
        }
        return byArray2;
    }

    private byte[] padOAEP(byte[] byArray, int n, int n2) {
        if (this.random == null) {
            this.random = JCAUtil.getSecureRandom();
        }
        int n3 = this.lHash.length;
        byte[] byArray2 = new byte[n3];
        this.random.nextBytes(byArray2);
        byte[] byArray3 = new byte[this.paddedSize];
        int n4 = 1;
        int n5 = n3;
        System.arraycopy(byArray2, 0, byArray3, n4, n5);
        int n6 = n3 + 1;
        int n7 = byArray3.length - n6;
        int n8 = this.paddedSize - n2;
        System.arraycopy(this.lHash, 0, byArray3, n6, n3);
        byArray3[n8 - 1] = 1;
        System.arraycopy(byArray, n, byArray3, n8, n2);
        this.mgf.generateAndXor(byArray3, n4, n5, n7, byArray3, n6);
        this.mgf.generateAndXor(byArray3, n6, n7, n5, byArray3, n4);
        return byArray3;
    }

    private byte[] unpadOAEP(byte[] byArray) {
        int n;
        int n2;
        byte[] byArray2 = byArray;
        boolean bl = false;
        int n3 = this.lHash.length;
        if (byArray2[0] != 0) {
            bl = true;
        }
        int n4 = 1;
        int n5 = n3;
        int n6 = n3 + 1;
        int n7 = byArray2.length - n6;
        this.mgf.generateAndXor(byArray2, n6, n7, n5, byArray2, n4);
        this.mgf.generateAndXor(byArray2, n4, n5, n7, byArray2, n6);
        for (n2 = 0; n2 < n3; ++n2) {
            if (this.lHash[n2] == byArray2[n6 + n2]) continue;
            bl = true;
        }
        n2 = n6 + n3;
        int n8 = -1;
        for (n = n2; n < byArray2.length; ++n) {
            byte by = byArray2[n];
            if (n8 != -1 || by == 0) continue;
            if (by == 1) {
                n8 = n;
                continue;
            }
            bl = true;
        }
        if (n8 == -1) {
            bl = true;
            n8 = byArray2.length - 1;
        }
        n = n8 + 1;
        byte[] byArray3 = new byte[n - n2];
        System.arraycopy(byArray2, n2, byArray3, 0, byArray3.length);
        byte[] byArray4 = new byte[byArray2.length - n];
        System.arraycopy(byArray2, n, byArray4, 0, byArray4.length);
        return bl ? null : byArray4;
    }
}

