/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.utilities;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.AddressException;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.oops.Metadata;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class RobustOopDeterminator {
    private static AddressField klassField;

    private static void initialize(TypeDataBase db) {
        Type type = db.lookupType("oopDesc");
        klassField = VM.getVM().isCompressedKlassPointersEnabled() ? type.getAddressField("_metadata._compressed_klass") : type.getAddressField("_metadata._klass");
    }

    public static boolean oopLooksValid(OopHandle oop) {
        if (oop == null) {
            return false;
        }
        if (!VM.getVM().getUniverse().isIn(oop)) {
            return false;
        }
        try {
            if (VM.getVM().isCompressedKlassPointersEnabled()) {
                Metadata.instantiateWrapperFor(oop.getCompKlassAddressAt(klassField.getOffset()));
            } else {
                Metadata.instantiateWrapperFor(klassField.getValue(oop));
            }
            return true;
        }
        catch (AddressException e) {
            return false;
        }
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                RobustOopDeterminator.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

