/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.ArrayDecoder;
import sun.nio.cs.ArrayEncoder;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.StandardCharsets;
import sun.nio.cs.Surrogate;
import sun.nio.cs.US_ASCII;

class ISO_8859_1
extends Charset
implements HistoricallyNamedCharset {
    public ISO_8859_1() {
        super("ISO-8859-1", StandardCharsets.aliases_ISO_8859_1);
    }

    @Override
    public String historicalName() {
        return "ISO8859_1";
    }

    @Override
    public boolean contains(Charset charset) {
        return charset instanceof US_ASCII || charset instanceof ISO_8859_1;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static class Encoder
    extends CharsetEncoder
    implements ArrayEncoder {
        private final Surrogate.Parser sgp = new Surrogate.Parser();
        private byte repl = (byte)63;

        private Encoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }

        @Override
        public boolean canEncode(char c) {
            return c <= '\u00ff';
        }

        @Override
        public boolean isLegalReplacement(byte[] byArray) {
            return true;
        }

        private static int encodeISOArray(char[] cArray, int n, byte[] byArray, int n2, int n3) {
            char c;
            int n4;
            for (n4 = 0; n4 < n3 && (c = cArray[n++]) <= '\u00ff'; ++n4) {
                byArray[n2++] = (byte)c;
            }
            return n4;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            char[] cArray = charBuffer.array();
            int n = charBuffer.arrayOffset();
            int n2 = n + charBuffer.position();
            int n3 = n + charBuffer.limit();
            assert (n2 <= n3);
            n2 = n2 <= n3 ? n2 : n3;
            byte[] byArray = byteBuffer.array();
            int n4 = byteBuffer.arrayOffset();
            int n5 = n4 + byteBuffer.position();
            int n6 = n4 + byteBuffer.limit();
            assert (n5 <= n6);
            n5 = n5 <= n6 ? n5 : n6;
            int n7 = n6 - n5;
            int n8 = n3 - n2;
            int n9 = n7 < n8 ? n7 : n8;
            try {
                int n10 = n9 <= 0 ? 0 : Encoder.encodeISOArray(cArray, n2, byArray, n5, n9);
                n2 += n10;
                n5 += n10;
                if (n10 != n9) {
                    if (this.sgp.parse(cArray[n2], cArray, n2, n3) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                if (n9 < n8) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n2 - n);
                byteBuffer.position(n5 - n4);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            int n = charBuffer.position();
            try {
                while (charBuffer.hasRemaining()) {
                    char c = charBuffer.get();
                    if (c <= '\u00ff') {
                        if (!byteBuffer.hasRemaining()) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byteBuffer.put((byte)c);
                        ++n;
                        continue;
                    }
                    if (this.sgp.parse(c, charBuffer) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n);
            }
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            if (charBuffer.hasArray() && byteBuffer.hasArray()) {
                return this.encodeArrayLoop(charBuffer, byteBuffer);
            }
            return this.encodeBufferLoop(charBuffer, byteBuffer);
        }

        @Override
        protected void implReplaceWith(byte[] byArray) {
            this.repl = byArray[0];
        }

        @Override
        public int encode(char[] cArray, int n, int n2, byte[] byArray) {
            int n3 = 0;
            int n4 = Math.min(n2, byArray.length);
            int n5 = n + n4;
            while (n < n5) {
                char c;
                int n6 = n4 <= 0 ? 0 : Encoder.encodeISOArray(cArray, n, byArray, n3, n4);
                n += n6;
                n3 += n6;
                if (n6 == n4) continue;
                if (Character.isHighSurrogate(c = cArray[n++]) && n < n5 && Character.isLowSurrogate(cArray[n])) {
                    if (n2 > byArray.length) {
                        ++n5;
                        --n2;
                    }
                    ++n;
                }
                byArray[n3++] = this.repl;
                n4 = Math.min(n5 - n, byArray.length - n3);
            }
            return n3;
        }
    }

    private static class Decoder
    extends CharsetDecoder
    implements ArrayDecoder {
        private Decoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            byte[] byArray = byteBuffer.array();
            int n = byteBuffer.arrayOffset() + byteBuffer.position();
            int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
            assert (n <= n2);
            char[] cArray = charBuffer.array();
            int n3 = charBuffer.arrayOffset() + charBuffer.position();
            int n4 = charBuffer.arrayOffset() + charBuffer.limit();
            assert (n3 <= n4);
            n3 = n3 <= n4 ? n3 : n4;
            try {
                for (n = n <= n2 ? n : n2; n < n2; ++n) {
                    byte by = byArray[n];
                    if (n3 >= n4) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    cArray[n3++] = (char)(by & 0xFF);
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n - byteBuffer.arrayOffset());
                charBuffer.position(n3 - charBuffer.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            int n = byteBuffer.position();
            try {
                while (byteBuffer.hasRemaining()) {
                    byte by = byteBuffer.get();
                    if (!charBuffer.hasRemaining()) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    charBuffer.put((char)(by & 0xFF));
                    ++n;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n);
            }
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            if (byteBuffer.hasArray() && charBuffer.hasArray()) {
                return this.decodeArrayLoop(byteBuffer, charBuffer);
            }
            return this.decodeBufferLoop(byteBuffer, charBuffer);
        }

        @Override
        public int decode(byte[] byArray, int n, int n2, char[] cArray) {
            if (n2 > cArray.length) {
                n2 = cArray.length;
            }
            int n3 = 0;
            while (n3 < n2) {
                cArray[n3++] = (char)(byArray[n++] & 0xFF);
            }
            return n3;
        }
    }
}

