/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import jdk.internal.misc.TerminatingThreadLocal;
import sun.misc.Unsafe;
import sun.nio.fs.NativeBuffer;

class NativeBuffers {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final int TEMP_BUF_POOL_SIZE = 3;
    private static ThreadLocal<NativeBuffer[]> threadLocal = new TerminatingThreadLocal<NativeBuffer[]>(){

        @Override
        protected void threadTerminated(NativeBuffer[] nativeBufferArray) {
            if (nativeBufferArray != null) {
                for (int i = 0; i < 3; ++i) {
                    NativeBuffer nativeBuffer = nativeBufferArray[i];
                    if (nativeBuffer == null) continue;
                    nativeBuffer.cleaner().clean();
                    nativeBufferArray[i] = null;
                }
            }
        }
    };

    private NativeBuffers() {
    }

    static NativeBuffer allocNativeBuffer(int n) {
        if (n < 2048) {
            n = 2048;
        }
        return new NativeBuffer(n);
    }

    static NativeBuffer getNativeBufferFromCache(int n) {
        NativeBuffer[] nativeBufferArray = threadLocal.get();
        if (nativeBufferArray != null) {
            for (int i = 0; i < 3; ++i) {
                NativeBuffer nativeBuffer = nativeBufferArray[i];
                if (nativeBuffer == null || nativeBuffer.size() < n) continue;
                nativeBufferArray[i] = null;
                return nativeBuffer;
            }
        }
        return null;
    }

    static NativeBuffer getNativeBuffer(int n) {
        NativeBuffer nativeBuffer = NativeBuffers.getNativeBufferFromCache(n);
        if (nativeBuffer != null) {
            nativeBuffer.setOwner(null);
            return nativeBuffer;
        }
        return NativeBuffers.allocNativeBuffer(n);
    }

    static void releaseNativeBuffer(NativeBuffer nativeBuffer) {
        int n;
        NativeBuffer[] nativeBufferArray = threadLocal.get();
        if (nativeBufferArray == null) {
            nativeBufferArray = new NativeBuffer[3];
            nativeBufferArray[0] = nativeBuffer;
            threadLocal.set(nativeBufferArray);
            return;
        }
        for (n = 0; n < 3; ++n) {
            if (nativeBufferArray[n] != null) continue;
            nativeBufferArray[n] = nativeBuffer;
            return;
        }
        for (n = 0; n < 3; ++n) {
            NativeBuffer nativeBuffer2 = nativeBufferArray[n];
            if (nativeBuffer2.size() >= nativeBuffer.size()) continue;
            nativeBuffer2.cleaner().clean();
            nativeBufferArray[n] = nativeBuffer;
            return;
        }
        nativeBuffer.cleaner().clean();
    }

    static void copyCStringToNativeBuffer(byte[] byArray, NativeBuffer nativeBuffer) {
        long l = Unsafe.ARRAY_BYTE_BASE_OFFSET;
        long l2 = byArray.length;
        assert ((long)nativeBuffer.size() >= l2 + 1L);
        unsafe.copyMemory(byArray, l, null, nativeBuffer.address(), l2);
        unsafe.putByte(nativeBuffer.address() + l2, (byte)0);
    }

    static NativeBuffer asNativeBuffer(byte[] byArray) {
        NativeBuffer nativeBuffer = NativeBuffers.getNativeBuffer(byArray.length + 1);
        NativeBuffers.copyCStringToNativeBuffer(byArray, nativeBuffer);
        return nativeBuffer;
    }
}

