/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.url.rmi;

import com.sun.jndi.rmi.registry.RegistryContext;
import com.sun.jndi.toolkit.url.GenericURLContext;
import com.sun.jndi.toolkit.url.Uri;
import java.net.URI;
import java.security.AccessController;
import java.util.Hashtable;
import java.util.Locale;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.naming.spi.ResolveResult;
import sun.security.action.GetPropertyAction;

public class rmiURLContext
extends GenericURLContext {
    private static final String PARSE_MODE_PROP = "com.sun.jndi.rmiURLParsing";
    private static final Uri.ParseMode DEFAULT_PARSE_MODE = Uri.ParseMode.COMPAT;
    public static final Uri.ParseMode PARSE_MODE;

    public rmiURLContext(Hashtable<?, ?> hashtable) {
        super(hashtable);
    }

    @Override
    protected ResolveResult getRootURLContext(String string, Hashtable<?, ?> hashtable) throws NamingException {
        Parser parser = new Parser(string);
        parser.parse();
        String string2 = parser.host;
        int n = parser.port;
        String string3 = parser.objName;
        CompositeName compositeName = new CompositeName();
        if (string3 != null) {
            compositeName.add(string3);
        }
        RegistryContext registryContext = new RegistryContext(string2, n, hashtable);
        return new ResolveResult((Object)registryContext, compositeName);
    }

    static {
        GetPropertyAction getPropertyAction = new GetPropertyAction(PARSE_MODE_PROP, DEFAULT_PARSE_MODE.toString());
        Uri.ParseMode parseMode = DEFAULT_PARSE_MODE;
        try {
            String string = AccessController.doPrivileged(getPropertyAction);
            parseMode = Uri.ParseMode.valueOf(string.toUpperCase(Locale.ROOT));
        }
        catch (Throwable throwable) {
            parseMode = DEFAULT_PARSE_MODE;
        }
        finally {
            PARSE_MODE = parseMode;
        }
    }

    public static class Parser {
        final String url;
        final Uri.ParseMode mode;
        String host = null;
        int port = -1;
        String objName = null;

        public Parser(String string) {
            this(string, PARSE_MODE);
        }

        public Parser(String string, Uri.ParseMode parseMode) {
            this.url = string;
            this.mode = parseMode;
        }

        public String url() {
            return this.url;
        }

        public String host() {
            return this.host;
        }

        public int port() {
            return this.port;
        }

        public String objName() {
            return this.objName;
        }

        public Uri.ParseMode mode() {
            return this.mode;
        }

        public void parse() throws NamingException {
            if (!this.url.startsWith("rmi:")) {
                throw new IllegalArgumentException("rmiURLContext: name is not an RMI URL: " + this.url);
            }
            switch (this.mode) {
                case STRICT: {
                    this.parseStrict();
                    break;
                }
                case COMPAT: {
                    this.parseCompat();
                    break;
                }
                case LEGACY: {
                    this.parseLegacy();
                }
            }
        }

        private void parseStrict() throws NamingException {
            int n;
            assert (this.url.startsWith("rmi:"));
            if (this.url.equals("rmi:") || this.url.equals("rmi://")) {
                return;
            }
            int n2 = 4;
            if (this.url.startsWith("//", n2)) {
                n2 += 2;
                try {
                    URI uRI = URI.create(this.url);
                    this.host = uRI.getHost();
                    this.port = uRI.getPort();
                    String string = uRI.getRawAuthority();
                    String string2 = (this.host == null ? "" : this.host) + (this.port == -1 ? "" : ":" + this.port);
                    if (!string2.equals(string)) {
                        boolean bl = true;
                        if (string2.equals("") && string.startsWith(":")) {
                            try {
                                this.port = Integer.parseInt(string.substring(1));
                                bl = false;
                            }
                            catch (NumberFormatException numberFormatException) {
                                bl = true;
                            }
                        }
                        if (bl) {
                            throw this.newNamingException(new IllegalArgumentException("invalid authority: " + string));
                        }
                    }
                    n2 += string.length();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw this.newNamingException(illegalArgumentException);
                }
            }
            if ((n = this.url.indexOf(35, n2)) > -1 && !this.acceptsFragment()) {
                throw this.newNamingException(new IllegalArgumentException("URI fragments not supported: " + this.url));
            }
            if ("".equals(this.host)) {
                this.host = null;
            }
            if (this.url.startsWith("/", n2)) {
                ++n2;
            }
            if (n2 < this.url.length()) {
                this.objName = this.url.substring(n2);
            }
        }

        private void parseCompat() throws NamingException {
            int n;
            assert (this.url.startsWith("rmi:"));
            int n2 = 4;
            boolean bl = this.url.startsWith("//", n2);
            if (bl) {
                n2 += 2;
            }
            int n3 = this.url.indexOf(47, n2);
            int n4 = this.url.indexOf(63, n2);
            int n5 = this.url.indexOf(35, n2);
            if (n5 > -1 && n4 > n5) {
                n4 = -1;
            }
            if (n5 > -1 && n3 > n5) {
                n3 = -1;
            }
            if (n4 > -1 && n3 > n4) {
                n3 = -1;
            }
            int n6 = n3 > -1 ? n3 : (n4 > -1 ? n4 : (n = n5 > -1 ? n5 : this.url.length()));
            if (n5 > -1 && !this.acceptsFragment()) {
                throw this.newNamingException(new IllegalArgumentException("URI fragments not supported: " + this.url));
            }
            if (bl && n > n2) {
                if (this.url.startsWith(":", n2)) {
                    this.host = "";
                    if (n > ++n2) {
                        this.port = Integer.parseInt(this.url.substring(n2, n));
                    }
                } else {
                    try {
                        URI uRI = URI.create(this.url.substring(0, n));
                        this.host = uRI.getHost();
                        this.port = uRI.getPort();
                        String string = (this.host == null ? "" : this.host) + (this.port == -1 ? "" : ":" + this.port);
                        if (!string.equals(uRI.getRawAuthority())) {
                            throw this.newNamingException(new IllegalArgumentException("invalid authority: " + uRI.getRawAuthority()));
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw this.newNamingException(illegalArgumentException);
                    }
                }
                n2 = n;
            }
            if ("".equals(this.host)) {
                this.host = null;
            }
            if (this.url.startsWith("/", n2)) {
                ++n2;
            }
            if (n2 < this.url.length()) {
                this.objName = this.url.substring(n2);
            }
        }

        private void parseLegacy() {
            assert (this.url.startsWith("rmi:"));
            int n = 4;
            if (this.url.startsWith("//", n)) {
                int n2 = this.url.indexOf(47, n += 2);
                if (n2 < 0) {
                    n2 = this.url.length();
                }
                if (this.url.startsWith("[", n)) {
                    int n3 = this.url.indexOf(93, n + 1);
                    if (n3 < 0 || n3 > n2) {
                        throw new IllegalArgumentException("rmiURLContext: name is an Invalid URL: " + this.url);
                    }
                    this.host = this.url.substring(n, n3 + 1);
                    n = n3 + 1;
                } else {
                    int n4;
                    int n5 = this.url.indexOf(58, n);
                    int n6 = n4 = n5 < 0 || n5 > n2 ? n2 : n5;
                    if (n < n4) {
                        this.host = this.url.substring(n, n4);
                    }
                    n = n4;
                }
                if (n + 1 < n2) {
                    if (this.url.startsWith(":", n)) {
                        this.port = Integer.parseInt(this.url.substring(++n, n2));
                    } else {
                        throw new IllegalArgumentException("rmiURLContext: name is an Invalid URL: " + this.url);
                    }
                }
                n = n2;
            }
            if ("".equals(this.host)) {
                this.host = null;
            }
            if (this.url.startsWith("/", n)) {
                ++n;
            }
            if (n < this.url.length()) {
                this.objName = this.url.substring(n);
            }
        }

        NamingException newNamingException(Throwable throwable) {
            InvalidNameException invalidNameException = new InvalidNameException(throwable.getMessage());
            invalidNameException.initCause(throwable);
            return invalidNameException;
        }

        protected boolean acceptsFragment() {
            return true;
        }
    }
}

