/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.utilities.soql;

import sun.jvm.hotspot.oops.Instance;
import sun.jvm.hotspot.utilities.soql.JSJavaClass;
import sun.jvm.hotspot.utilities.soql.JSJavaFactory;
import sun.jvm.hotspot.utilities.soql.JSJavaInstanceKlass;
import sun.jvm.hotspot.utilities.soql.JSJavaObject;

public class JSJavaInstance
extends JSJavaObject {
    protected final JSJavaInstanceKlass type;

    public JSJavaInstance(Instance instance, JSJavaFactory fac) {
        super(instance, fac);
        this.type = (JSJavaInstanceKlass)fac.newJSJavaKlass(instance.getKlass());
    }

    public final Instance getInstance() {
        return (Instance)this.getOop();
    }

    public final JSJavaClass getJSJavaClass() {
        return this.type.getJSJavaClass();
    }

    @Override
    public Object get(String name) {
        if (this.hasField(name)) {
            return this.getFieldValue(name);
        }
        return super.get(name);
    }

    @Override
    public Object[] getIds() {
        String[] fieldNames = this.getFieldNames();
        Object[] superFields = super.getIds();
        Object[] res = new Object[fieldNames.length + superFields.length];
        System.arraycopy(fieldNames, 0, res, 0, fieldNames.length);
        System.arraycopy(superFields, 0, res, fieldNames.length, superFields.length);
        return res;
    }

    @Override
    public boolean has(String name) {
        if (this.hasField(name)) {
            return true;
        }
        return super.has(name);
    }

    @Override
    public void put(String name, Object value) {
        if (!this.hasField(name)) {
            super.put(name, value);
        }
    }

    protected Object getFieldValue(String name) {
        try {
            return this.type.getInstanceFieldValue(name, this.getInstance());
        }
        catch (NoSuchFieldException exp) {
            return UNDEFINED;
        }
    }

    protected String[] getFieldNames() {
        return this.type.getInstanceFieldNames();
    }

    protected boolean hasField(String name) {
        return this.type.hasInstanceField(name);
    }
}

