/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringBufferInputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import sun.awt.NativeLibLoader;
import sun.util.logging.PlatformLogger;

final class DebugSettings {
    private static final PlatformLogger log = PlatformLogger.getLogger("sun.awt.debug.DebugSettings");
    static final String PREFIX = "awtdebug";
    static final String PROP_FILE = "properties";
    private static final String[] DEFAULT_PROPS = new String[]{"awtdebug.assert=true", "awtdebug.trace=false", "awtdebug.on=true", "awtdebug.ctrace=false"};
    private static DebugSettings instance = null;
    private Properties props = new Properties();
    private static final String PROP_CTRACE = "ctrace";
    private static final int PROP_CTRACE_LEN = "ctrace".length();

    static void init() {
        if (instance != null) {
            return;
        }
        NativeLibLoader.loadLibraries();
        instance = new DebugSettings();
        instance.loadNativeSettings();
    }

    private DebugSettings() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                DebugSettings.this.loadProperties();
                return null;
            }
        });
    }

    private synchronized void loadProperties() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                DebugSettings.this.loadDefaultProperties();
                DebugSettings.this.loadFileProperties();
                DebugSettings.this.loadSystemProperties();
                return null;
            }
        });
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("DebugSettings:\n{0}", this);
        }
    }

    public String toString() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        for (String string : this.props.stringPropertyNames()) {
            String string2 = this.props.getProperty(string, "");
            printStream.println(string + " = " + string2);
        }
        return new String(byteArrayOutputStream.toByteArray());
    }

    private void loadDefaultProperties() {
        try {
            for (int i = 0; i < DEFAULT_PROPS.length; ++i) {
                StringBufferInputStream stringBufferInputStream = new StringBufferInputStream(DEFAULT_PROPS[i]);
                this.props.load(stringBufferInputStream);
                stringBufferInputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void loadFileProperties() {
        String string = System.getProperty("awtdebug.properties", "");
        if (string.equals("")) {
            string = System.getProperty("user.home", "") + File.separator + PREFIX + "." + PROP_FILE;
        }
        File file = new File(string);
        try {
            this.println("Reading debug settings from '" + file.getCanonicalPath() + "'...");
            FileInputStream fileInputStream = new FileInputStream(file);
            this.props.load(fileInputStream);
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.println("Did not find settings file.");
        }
        catch (IOException iOException) {
            this.println("Problem reading settings, IOException: " + iOException.getMessage());
        }
    }

    private void loadSystemProperties() {
        Properties properties = System.getProperties();
        for (String string : properties.stringPropertyNames()) {
            String string2 = properties.getProperty(string, "");
            if (!string.startsWith(PREFIX)) continue;
            this.props.setProperty(string, string2);
        }
    }

    public synchronized boolean getBoolean(String string, boolean bl) {
        String string2 = this.getString(string, String.valueOf(bl));
        return string2.equalsIgnoreCase("true");
    }

    public synchronized int getInt(String string, int n) {
        String string2 = this.getString(string, String.valueOf(n));
        return Integer.parseInt(string2);
    }

    public synchronized String getString(String string, String string2) {
        String string3 = "awtdebug." + string;
        String string4 = this.props.getProperty(string3, string2);
        return string4;
    }

    private synchronized List<String> getPropertyNames() {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String string : this.props.stringPropertyNames()) {
            string = string.substring(PREFIX.length() + 1);
            linkedList.add(string);
        }
        return linkedList;
    }

    private void println(Object object) {
        if (log.isLoggable(PlatformLogger.Level.FINER)) {
            log.finer(object.toString());
        }
    }

    private synchronized native void setCTracingOn(boolean var1);

    private synchronized native void setCTracingOn(boolean var1, String var2);

    private synchronized native void setCTracingOn(boolean var1, String var2, int var3);

    private void loadNativeSettings() {
        boolean bl = this.getBoolean(PROP_CTRACE, false);
        this.setCTracingOn(bl);
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String string : this.getPropertyNames()) {
            if (!string.startsWith(PROP_CTRACE) || string.length() <= PROP_CTRACE_LEN) continue;
            linkedList.add(string);
        }
        Collections.sort(linkedList);
        for (String string : linkedList) {
            String string2 = string.substring(PROP_CTRACE_LEN + 1);
            int n = string2.indexOf(64);
            String string3 = n != -1 ? string2.substring(0, n) : string2;
            String string4 = n != -1 ? string2.substring(n + 1) : "";
            boolean bl2 = this.getBoolean(string, false);
            if (string4.length() == 0) {
                this.setCTracingOn(bl2, string3);
                continue;
            }
            int n2 = Integer.parseInt(string4, 10);
            this.setCTracingOn(bl2, string3, n2);
        }
    }
}

