/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.jules;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.awt.X11GraphicsEnvironment;
import sun.java2d.jules.TrapezoidList;
import sun.java2d.pipe.Region;
import sun.java2d.xr.GrowableByteArray;
import sun.java2d.xr.GrowablePointArray;

public class JulesPathBuf {
    static final double[] emptyDash = new double[0];
    private static final byte CAIRO_PATH_OP_MOVE_TO = 0;
    private static final byte CAIRO_PATH_OP_LINE_TO = 1;
    private static final byte CAIRO_PATH_OP_CURVE_TO = 2;
    private static final byte CAIRO_PATH_OP_CLOSE_PATH = 3;
    private static final int CAIRO_FILL_RULE_WINDING = 0;
    private static final int CAIRO_FILL_RULE_EVEN_ODD = 1;
    GrowablePointArray points = new GrowablePointArray(128);
    GrowableByteArray ops = new GrowableByteArray(1, 128);
    int[] xTrapArray = new int[512];
    private static final boolean isCairoAvailable = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            boolean bl;
            block4: {
                bl = false;
                if (X11GraphicsEnvironment.isXRenderAvailable()) {
                    try {
                        System.loadLibrary("jules");
                        bl = true;
                        if (X11GraphicsEnvironment.isXRenderVerbose()) {
                            System.out.println("Xrender: INFO: Jules library loaded");
                        }
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        bl = false;
                        if (!X11GraphicsEnvironment.isXRenderVerbose()) break block4;
                        System.out.println("Xrender: INFO: Jules library not installed.");
                    }
                }
            }
            return bl;
        }
    });

    public static boolean isCairoAvailable() {
        return isCairoAvailable;
    }

    public TrapezoidList tesselateFill(Shape shape, AffineTransform affineTransform, Region region) {
        int n = this.convertPathData(shape, affineTransform);
        this.xTrapArray[0] = 0;
        this.xTrapArray = JulesPathBuf.tesselateFillNative(this.points.getArray(), this.ops.getArray(), this.points.getSize(), this.ops.getSize(), this.xTrapArray, this.xTrapArray.length, JulesPathBuf.getCairoWindingRule(n), region.getLoX(), region.getLoY(), region.getHiX(), region.getHiY());
        return new TrapezoidList(this.xTrapArray);
    }

    public TrapezoidList tesselateStroke(Shape shape, BasicStroke basicStroke, boolean bl, boolean bl2, boolean bl3, AffineTransform affineTransform, Region region) {
        float f = bl ? (bl3 ? 0.5f : 1.0f) : basicStroke.getLineWidth();
        this.convertPathData(shape, affineTransform);
        double[] dArray = this.floatToDoubleArray(basicStroke.getDashArray());
        this.xTrapArray[0] = 0;
        this.xTrapArray = JulesPathBuf.tesselateStrokeNative(this.points.getArray(), this.ops.getArray(), this.points.getSize(), this.ops.getSize(), this.xTrapArray, this.xTrapArray.length, f, basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), dArray, dArray.length, basicStroke.getDashPhase(), 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, region.getLoX(), region.getLoY(), region.getHiX(), region.getHiY());
        return new TrapezoidList(this.xTrapArray);
    }

    protected double[] floatToDoubleArray(float[] fArray) {
        double[] dArray = emptyDash;
        if (fArray != null) {
            dArray = new double[fArray.length];
            for (int i = 0; i < fArray.length; ++i) {
                dArray[i] = fArray[i];
            }
        }
        return dArray;
    }

    protected int convertPathData(Shape shape, AffineTransform affineTransform) {
        PathIterator pathIterator = shape.getPathIterator(affineTransform);
        double[] dArray = new double[6];
        double d = 0.0;
        double d2 = 0.0;
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            switch (n) {
                case 0: {
                    this.ops.addByte((byte)0);
                    int n2 = this.points.getNextIndex();
                    this.points.setX(n2, JulesPathBuf.DoubleToCairoFixed(dArray[0]));
                    this.points.setY(n2, JulesPathBuf.DoubleToCairoFixed(dArray[1]));
                    d = dArray[0];
                    d2 = dArray[1];
                    break;
                }
                case 1: {
                    this.ops.addByte((byte)1);
                    int n2 = this.points.getNextIndex();
                    this.points.setX(n2, JulesPathBuf.DoubleToCairoFixed(dArray[0]));
                    this.points.setY(n2, JulesPathBuf.DoubleToCairoFixed(dArray[1]));
                    d = dArray[0];
                    d2 = dArray[1];
                    break;
                }
                case 2: {
                    double d3 = dArray[0];
                    double d4 = dArray[1];
                    double d5 = dArray[2];
                    double d6 = dArray[3];
                    double d7 = d3 + (d5 - d3) / 3.0;
                    double d8 = d4 + (d6 - d4) / 3.0;
                    d3 = d + 2.0 * (d3 - d) / 3.0;
                    d4 = d2 + 2.0 * (d4 - d2) / 3.0;
                    this.ops.addByte((byte)2);
                    int n2 = this.points.getNextIndex();
                    this.points.setX(n2, JulesPathBuf.DoubleToCairoFixed(d3));
                    this.points.setY(n2, JulesPathBuf.DoubleToCairoFixed(d4));
                    n2 = this.points.getNextIndex();
                    this.points.setX(n2, JulesPathBuf.DoubleToCairoFixed(d7));
                    this.points.setY(n2, JulesPathBuf.DoubleToCairoFixed(d8));
                    n2 = this.points.getNextIndex();
                    this.points.setX(n2, JulesPathBuf.DoubleToCairoFixed(d5));
                    this.points.setY(n2, JulesPathBuf.DoubleToCairoFixed(d6));
                    d = d5;
                    d2 = d6;
                    break;
                }
                case 3: {
                    this.ops.addByte((byte)2);
                    int n2 = this.points.getNextIndex();
                    this.points.setX(n2, JulesPathBuf.DoubleToCairoFixed(dArray[0]));
                    this.points.setY(n2, JulesPathBuf.DoubleToCairoFixed(dArray[1]));
                    n2 = this.points.getNextIndex();
                    this.points.setX(n2, JulesPathBuf.DoubleToCairoFixed(dArray[2]));
                    this.points.setY(n2, JulesPathBuf.DoubleToCairoFixed(dArray[3]));
                    n2 = this.points.getNextIndex();
                    this.points.setX(n2, JulesPathBuf.DoubleToCairoFixed(dArray[4]));
                    this.points.setY(n2, JulesPathBuf.DoubleToCairoFixed(dArray[5]));
                    d = dArray[4];
                    d2 = dArray[5];
                    break;
                }
                case 4: {
                    this.ops.addByte((byte)3);
                }
            }
            pathIterator.next();
        }
        return pathIterator.getWindingRule();
    }

    private static native int[] tesselateStrokeNative(int[] var0, byte[] var1, int var2, int var3, int[] var4, int var5, double var6, int var8, int var9, double var10, double[] var12, int var13, double var14, double var16, double var18, double var20, double var22, double var24, double var26, int var28, int var29, int var30, int var31);

    private static native int[] tesselateFillNative(int[] var0, byte[] var1, int var2, int var3, int[] var4, int var5, int var6, int var7, int var8, int var9, int var10);

    public void clear() {
        this.points.clear();
        this.ops.clear();
        this.xTrapArray[0] = 0;
    }

    private static int DoubleToCairoFixed(double d) {
        return (int)(d * 256.0);
    }

    private static int getCairoWindingRule(int n) {
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return 0;
            }
        }
        throw new IllegalArgumentException("Illegal Java2D winding rule specified");
    }
}

