/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.code;

import sun.jvm.hotspot.code.CompressedStream;
import sun.jvm.hotspot.debugger.Address;

public class CompressedReadStream
extends CompressedStream {
    public CompressedReadStream(Address buffer) {
        this(buffer, 0);
    }

    public CompressedReadStream(Address buffer, int position) {
        super(buffer, position);
    }

    public boolean readBoolean() {
        return this.read() != 0;
    }

    public byte readByte() {
        return (byte)this.read();
    }

    public char readChar() {
        return (char)this.readInt();
    }

    public short readShort() {
        return (short)this.readSignedInt();
    }

    public int readSignedInt() {
        return this.decodeSign(this.readInt());
    }

    public int readInt() {
        short b0 = this.read();
        if (b0 < 192) {
            return b0;
        }
        return this.readIntMb(b0);
    }

    public float readFloat() {
        return Float.intBitsToFloat(this.reverseInt(this.readInt()));
    }

    public double readDouble() {
        int rh = this.readInt();
        int rl = this.readInt();
        int h = this.reverseInt(rh);
        int l = this.reverseInt(rl);
        return Double.longBitsToDouble((long)h << 32 | (long)l & 0xFFFFFFFFL);
    }

    public long readLong() {
        long low = (long)this.readSignedInt() & 0xFFFFFFFFL;
        long high = this.readSignedInt();
        return high << 32 | low;
    }

    private int readIntMb(int b0) {
        int pos = this.position - 1;
        int sum = b0;
        int lg_H_i = 6;
        int i = 0;
        while (true) {
            short b_i = this.read(pos + ++i);
            sum += b_i << lg_H_i;
            if (b_i < 192 || i == 4) {
                this.setPosition(pos + i + 1);
                return sum;
            }
            lg_H_i += 6;
        }
    }

    private short read(int index) {
        return (short)this.buffer.getCIntegerAt(index, 1L, true);
    }

    private short read() {
        short retval = (short)this.buffer.getCIntegerAt(this.position, 1L, true);
        ++this.position;
        return retval;
    }
}

