/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.management.remote.TargetedNotification;

public class NotificationResult
implements Serializable {
    private static final long serialVersionUID = 1191800228721395279L;
    private long earliestSequenceNumber;
    private long nextSequenceNumber;
    private TargetedNotification[] targetedNotifications;

    public NotificationResult(long l, long l2, TargetedNotification[] targetedNotificationArray) {
        NotificationResult.validate(targetedNotificationArray, l, l2);
        this.earliestSequenceNumber = l;
        this.nextSequenceNumber = l2;
        this.targetedNotifications = targetedNotificationArray.length == 0 ? targetedNotificationArray : (TargetedNotification[])targetedNotificationArray.clone();
    }

    public long getEarliestSequenceNumber() {
        return this.earliestSequenceNumber;
    }

    public long getNextSequenceNumber() {
        return this.nextSequenceNumber;
    }

    public TargetedNotification[] getTargetedNotifications() {
        return this.targetedNotifications.length == 0 ? this.targetedNotifications : (TargetedNotification[])this.targetedNotifications.clone();
    }

    public String toString() {
        return "NotificationResult: earliest=" + this.getEarliestSequenceNumber() + "; next=" + this.getNextSequenceNumber() + "; nnotifs=" + this.getTargetedNotifications().length;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        try {
            NotificationResult.validate(this.targetedNotifications, this.earliestSequenceNumber, this.nextSequenceNumber);
            this.targetedNotifications = this.targetedNotifications.length == 0 ? this.targetedNotifications : (TargetedNotification[])this.targetedNotifications.clone();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidObjectException(illegalArgumentException.getMessage());
        }
    }

    private static void validate(TargetedNotification[] targetedNotificationArray, long l, long l2) throws IllegalArgumentException {
        if (targetedNotificationArray == null) {
            throw new IllegalArgumentException("Notifications null");
        }
        if (l < 0L || l2 < 0L) {
            throw new IllegalArgumentException("Bad sequence numbers");
        }
    }
}

