/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.border.EmptyBorder;

public class MatteBorder
extends EmptyBorder {
    protected Color color;
    protected Icon tileIcon;

    public MatteBorder(int n, int n2, int n3, int n4, Color color) {
        super(n, n2, n3, n4);
        this.color = color;
    }

    public MatteBorder(Insets insets, Color color) {
        super(insets);
        this.color = color;
    }

    public MatteBorder(int n, int n2, int n3, int n4, Icon icon) {
        super(n, n2, n3, n4);
        this.tileIcon = icon;
    }

    public MatteBorder(Insets insets, Icon icon) {
        super(insets);
        this.tileIcon = icon;
    }

    public MatteBorder(Icon icon) {
        this(-1, -1, -1, -1, icon);
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Insets insets = this.getBorderInsets(component);
        Color color = graphics.getColor();
        graphics.translate(n, n2);
        if (this.tileIcon != null) {
            Color color2 = this.color = this.tileIcon.getIconWidth() == -1 ? Color.gray : null;
        }
        if (this.color != null) {
            graphics.setColor(this.color);
            graphics.fillRect(0, 0, n3 - insets.right, insets.top);
            graphics.fillRect(0, insets.top, insets.left, n4 - insets.top);
            graphics.fillRect(insets.left, n4 - insets.bottom, n3 - insets.left, insets.bottom);
            graphics.fillRect(n3 - insets.right, 0, insets.right, n4 - insets.bottom);
        } else if (this.tileIcon != null) {
            int n5 = this.tileIcon.getIconWidth();
            int n6 = this.tileIcon.getIconHeight();
            this.paintEdge(component, graphics, 0, 0, n3 - insets.right, insets.top, n5, n6);
            this.paintEdge(component, graphics, 0, insets.top, insets.left, n4 - insets.top, n5, n6);
            this.paintEdge(component, graphics, insets.left, n4 - insets.bottom, n3 - insets.left, insets.bottom, n5, n6);
            this.paintEdge(component, graphics, n3 - insets.right, 0, insets.right, n4 - insets.bottom, n5, n6);
        }
        graphics.translate(-n, -n2);
        graphics.setColor(color);
    }

    private void paintEdge(Component component, Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics = graphics.create(n, n2, n3, n4);
        int n7 = -(n2 % n6);
        for (n = -(n % n5); n < n3; n += n5) {
            for (n2 = n7; n2 < n4; n2 += n6) {
                this.tileIcon.paintIcon(component, graphics, n, n2);
            }
        }
        graphics.dispose();
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        return this.computeInsets(insets);
    }

    @Override
    public Insets getBorderInsets() {
        return this.computeInsets(new Insets(0, 0, 0, 0));
    }

    private Insets computeInsets(Insets insets) {
        if (this.tileIcon != null && this.top == -1 && this.bottom == -1 && this.left == -1 && this.right == -1) {
            int n;
            int n2 = this.tileIcon.getIconWidth();
            insets.top = n = this.tileIcon.getIconHeight();
            insets.right = n2;
            insets.bottom = n;
            insets.left = n2;
        } else {
            insets.left = this.left;
            insets.top = this.top;
            insets.right = this.right;
            insets.bottom = this.bottom;
        }
        return insets;
    }

    public Color getMatteColor() {
        return this.color;
    }

    public Icon getTileIcon() {
        return this.tileIcon;
    }

    @Override
    public boolean isBorderOpaque() {
        return this.color != null;
    }
}

