/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.spi;

import java.io.Serializable;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.Name;

public class ResolveResult
implements Serializable {
    protected Object resolvedObj;
    protected Name remainingName;
    private static final long serialVersionUID = -4552108072002407559L;

    protected ResolveResult() {
        this.resolvedObj = null;
        this.remainingName = null;
    }

    public ResolveResult(Object object, String string) {
        this.resolvedObj = object;
        try {
            this.remainingName = new CompositeName(string);
        }
        catch (InvalidNameException invalidNameException) {
            // empty catch block
        }
    }

    public ResolveResult(Object object, Name name) {
        this.resolvedObj = object;
        this.setRemainingName(name);
    }

    public Name getRemainingName() {
        return this.remainingName;
    }

    public Object getResolvedObj() {
        return this.resolvedObj;
    }

    public void setRemainingName(Name name) {
        this.remainingName = name != null ? (Name)name.clone() : null;
    }

    public void appendRemainingName(Name name) {
        if (name != null) {
            if (this.remainingName != null) {
                try {
                    this.remainingName.addAll(name);
                }
                catch (InvalidNameException invalidNameException) {}
            } else {
                this.remainingName = (Name)name.clone();
            }
        }
    }

    public void appendRemainingComponent(String string) {
        if (string != null) {
            CompositeName compositeName = new CompositeName();
            try {
                compositeName.add(string);
            }
            catch (InvalidNameException invalidNameException) {
                // empty catch block
            }
            this.appendRemainingName(compositeName);
        }
    }

    public void setResolvedObj(Object object) {
        this.resolvedObj = object;
    }
}

