/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import sun.misc.HexDumpEncoder;
import sun.security.ssl.Alert;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.JsseJce;
import sun.security.ssl.Record;
import sun.security.ssl.SSLConsumer;
import sun.security.ssl.SSLCredentials;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLPossession;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.ssl.SignatureScheme;
import sun.security.ssl.Utilities;
import sun.security.ssl.X509Authentication;

final class CertificateVerify {
    static final SSLConsumer s30HandshakeConsumer = new S30CertificateVerifyConsumer();
    static final HandshakeProducer s30HandshakeProducer = new S30CertificateVerifyProducer();
    static final SSLConsumer t10HandshakeConsumer = new T10CertificateVerifyConsumer();
    static final HandshakeProducer t10HandshakeProducer = new T10CertificateVerifyProducer();
    static final SSLConsumer t12HandshakeConsumer = new T12CertificateVerifyConsumer();
    static final HandshakeProducer t12HandshakeProducer = new T12CertificateVerifyProducer();
    static final SSLConsumer t13HandshakeConsumer = new T13CertificateVerifyConsumer();
    static final HandshakeProducer t13HandshakeProducer = new T13CertificateVerifyProducer();

    CertificateVerify() {
    }

    private static final class T13CertificateVerifyConsumer
    implements SSLConsumer {
        private T13CertificateVerifyConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, ByteBuffer byteBuffer) throws IOException {
            HandshakeContext handshakeContext = (HandshakeContext)connectionContext;
            handshakeContext.handshakeConsumers.remove(SSLHandshake.CERTIFICATE_VERIFY.id);
            if (handshakeContext.handshakeConsumers.containsKey(SSLHandshake.CERTIFICATE.id)) {
                throw handshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Unexpected Certificate Verify handshake message");
            }
            T13CertificateVerifyMessage t13CertificateVerifyMessage = new T13CertificateVerifyMessage(handshakeContext, byteBuffer);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming CertificateVerify handshake message", t13CertificateVerifyMessage);
            }
        }
    }

    private static final class T13CertificateVerifyProducer
    implements HandshakeProducer {
        private T13CertificateVerifyProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            HandshakeContext handshakeContext = (HandshakeContext)connectionContext;
            X509Authentication.X509Possession x509Possession = null;
            for (SSLPossession sSLPossession : handshakeContext.handshakePossessions) {
                if (!(sSLPossession instanceof X509Authentication.X509Possession)) continue;
                x509Possession = (X509Authentication.X509Possession)sSLPossession;
                break;
            }
            if (x509Possession == null || x509Possession.popPrivateKey == null) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("No X.509 credentials negotiated for CertificateVerify", new Object[0]);
                }
                return null;
            }
            if (handshakeContext.sslConfig.isClientMode) {
                return this.onProduceCertificateVerify((ClientHandshakeContext)connectionContext, x509Possession);
            }
            return this.onProduceCertificateVerify((ServerHandshakeContext)connectionContext, x509Possession);
        }

        private byte[] onProduceCertificateVerify(ServerHandshakeContext serverHandshakeContext, X509Authentication.X509Possession x509Possession) throws IOException {
            T13CertificateVerifyMessage t13CertificateVerifyMessage = new T13CertificateVerifyMessage((HandshakeContext)serverHandshakeContext, x509Possession);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced server CertificateVerify handshake message", t13CertificateVerifyMessage);
            }
            t13CertificateVerifyMessage.write(serverHandshakeContext.handshakeOutput);
            serverHandshakeContext.handshakeOutput.flush();
            return null;
        }

        private byte[] onProduceCertificateVerify(ClientHandshakeContext clientHandshakeContext, X509Authentication.X509Possession x509Possession) throws IOException {
            T13CertificateVerifyMessage t13CertificateVerifyMessage = new T13CertificateVerifyMessage((HandshakeContext)clientHandshakeContext, x509Possession);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced client CertificateVerify handshake message", t13CertificateVerifyMessage);
            }
            t13CertificateVerifyMessage.write(clientHandshakeContext.handshakeOutput);
            clientHandshakeContext.handshakeOutput.flush();
            return null;
        }
    }

    static final class T13CertificateVerifyMessage
    extends SSLHandshake.HandshakeMessage {
        private static final byte[] serverSignHead = new byte[]{32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 76, 83, 32, 49, 46, 51, 44, 32, 115, 101, 114, 118, 101, 114, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 101, 86, 101, 114, 105, 102, 121, 0};
        private static final byte[] clientSignHead = new byte[]{32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 76, 83, 32, 49, 46, 51, 44, 32, 99, 108, 105, 101, 110, 116, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 101, 86, 101, 114, 105, 102, 121, 0};
        private final SignatureScheme signatureScheme;
        private final byte[] signature;

        T13CertificateVerifyMessage(HandshakeContext handshakeContext, X509Authentication.X509Possession x509Possession) throws IOException {
            super(handshakeContext);
            byte[] byArray;
            Map.Entry<SignatureScheme, Signature> entry = SignatureScheme.getSignerOfPreferableAlgorithm(handshakeContext.peerRequestedSignatureSchemes, x509Possession, handshakeContext.negotiatedProtocol);
            if (entry == null) {
                throw handshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "No supported CertificateVerify signature algorithm for " + x509Possession.popPrivateKey.getAlgorithm() + "  key");
            }
            this.signatureScheme = entry.getKey();
            byte[] byArray2 = handshakeContext.handshakeHash.digest();
            if (handshakeContext.sslConfig.isClientMode) {
                byArray = Arrays.copyOf(clientSignHead, clientSignHead.length + byArray2.length);
                System.arraycopy(byArray2, 0, byArray, clientSignHead.length, byArray2.length);
            } else {
                byArray = Arrays.copyOf(serverSignHead, serverSignHead.length + byArray2.length);
                System.arraycopy(byArray2, 0, byArray, serverSignHead.length, byArray2.length);
            }
            byte[] byArray3 = null;
            try {
                Signature signature = entry.getValue();
                signature.update(byArray);
                byArray3 = signature.sign();
            }
            catch (SignatureException signatureException) {
                throw handshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Cannot produce CertificateVerify signature", signatureException);
            }
            this.signature = byArray3;
        }

        /*
         * WARNING - void declaration
         */
        T13CertificateVerifyMessage(HandshakeContext handshakeContext, ByteBuffer byteBuffer) throws IOException {
            super(handshakeContext);
            if (byteBuffer.remaining() < 4) {
                throw handshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Invalid CertificateVerify message: no sufficient data");
            }
            int n = Record.getInt16(byteBuffer);
            this.signatureScheme = SignatureScheme.valueOf(n);
            if (this.signatureScheme == null) {
                throw handshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid signature algorithm (" + n + ") used in CertificateVerify handshake message");
            }
            if (!handshakeContext.localSupportedSignAlgs.contains((Object)this.signatureScheme)) {
                throw handshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Unsupported signature algorithm (" + this.signatureScheme.name + ") used in CertificateVerify handshake message");
            }
            X509Authentication.X509Credentials x509Credentials = null;
            for (SSLCredentials object2 : handshakeContext.handshakeCredentials) {
                if (!(object2 instanceof X509Authentication.X509Credentials)) continue;
                x509Credentials = (X509Authentication.X509Credentials)object2;
                break;
            }
            if (x509Credentials == null || x509Credentials.popPublicKey == null) {
                throw handshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "No X509 credentials negotiated for CertificateVerify");
            }
            this.signature = Record.getBytes16(byteBuffer);
            Object object3 = handshakeContext.handshakeHash.digest();
            if (handshakeContext.sslConfig.isClientMode) {
                byte[] byArray = Arrays.copyOf(serverSignHead, serverSignHead.length + ((Object)object3).length);
                System.arraycopy(object3, 0, byArray, serverSignHead.length, ((Object)object3).length);
            } else {
                byte[] byArray = Arrays.copyOf(clientSignHead, clientSignHead.length + ((Object)object3).length);
                System.arraycopy(object3, 0, byArray, clientSignHead.length, ((Object)object3).length);
            }
            try {
                void var6_9;
                Signature signature = this.signatureScheme.getVerifier(x509Credentials.popPublicKey);
                signature.update((byte[])var6_9);
                if (!signature.verify(this.signature)) {
                    throw handshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid CertificateVerify signature");
                }
            }
            catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException generalSecurityException) {
                throw handshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Unsupported signature algorithm (" + this.signatureScheme.name + ") used in CertificateVerify handshake message", generalSecurityException);
            }
            catch (InvalidKeyException | SignatureException generalSecurityException) {
                throw handshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Cannot verify CertificateVerify signature", generalSecurityException);
            }
        }

        @Override
        public SSLHandshake handshakeType() {
            return SSLHandshake.CERTIFICATE_VERIFY;
        }

        @Override
        public int messageLength() {
            return 4 + this.signature.length;
        }

        @Override
        public void send(HandshakeOutStream handshakeOutStream) throws IOException {
            handshakeOutStream.putInt16(this.signatureScheme.id);
            handshakeOutStream.putBytes16(this.signature);
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"CertificateVerify\": '{'\n  \"signature algorithm\": {0}\n  \"signature\": '{'\n{1}\n  '}'\n'}'", Locale.ENGLISH);
            HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
            Object[] objectArray = new Object[]{this.signatureScheme.name, Utilities.indent(hexDumpEncoder.encodeBuffer(this.signature), "    ")};
            return messageFormat.format(objectArray);
        }
    }

    private static final class T12CertificateVerifyConsumer
    implements SSLConsumer {
        private T12CertificateVerifyConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, ByteBuffer byteBuffer) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            serverHandshakeContext.handshakeConsumers.remove(SSLHandshake.CERTIFICATE_VERIFY.id);
            if (serverHandshakeContext.handshakeConsumers.containsKey(SSLHandshake.CLIENT_KEY_EXCHANGE.id)) {
                throw serverHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Unexpected CertificateVerify handshake message");
            }
            T12CertificateVerifyMessage t12CertificateVerifyMessage = new T12CertificateVerifyMessage((HandshakeContext)serverHandshakeContext, byteBuffer);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming CertificateVerify handshake message", t12CertificateVerifyMessage);
            }
        }
    }

    private static final class T12CertificateVerifyProducer
    implements HandshakeProducer {
        private T12CertificateVerifyProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            X509Authentication.X509Possession x509Possession = null;
            for (SSLPossession sSLPossession : clientHandshakeContext.handshakePossessions) {
                if (!(sSLPossession instanceof X509Authentication.X509Possession)) continue;
                x509Possession = (X509Authentication.X509Possession)sSLPossession;
                break;
            }
            if (x509Possession == null || x509Possession.popPrivateKey == null) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("No X.509 credentials negotiated for CertificateVerify", new Object[0]);
                }
                return null;
            }
            T12CertificateVerifyMessage t12CertificateVerifyMessage = new T12CertificateVerifyMessage((HandshakeContext)clientHandshakeContext, x509Possession);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced CertificateVerify handshake message", t12CertificateVerifyMessage);
            }
            t12CertificateVerifyMessage.write(clientHandshakeContext.handshakeOutput);
            clientHandshakeContext.handshakeOutput.flush();
            return null;
        }
    }

    static final class T12CertificateVerifyMessage
    extends SSLHandshake.HandshakeMessage {
        private final SignatureScheme signatureScheme;
        private final byte[] signature;

        T12CertificateVerifyMessage(HandshakeContext handshakeContext, X509Authentication.X509Possession x509Possession) throws IOException {
            super(handshakeContext);
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)handshakeContext;
            Map.Entry<SignatureScheme, Signature> entry = SignatureScheme.getSignerOfPreferableAlgorithm(clientHandshakeContext.peerRequestedSignatureSchemes, x509Possession, clientHandshakeContext.negotiatedProtocol);
            if (entry == null) {
                throw clientHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "No supported CertificateVerify signature algorithm for " + x509Possession.popPrivateKey.getAlgorithm() + "  key");
            }
            this.signatureScheme = entry.getKey();
            byte[] byArray = null;
            try {
                Signature signature = entry.getValue();
                signature.update(clientHandshakeContext.handshakeHash.archived());
                byArray = signature.sign();
            }
            catch (SignatureException signatureException) {
                throw clientHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Cannot produce CertificateVerify signature", signatureException);
            }
            this.signature = byArray;
        }

        T12CertificateVerifyMessage(HandshakeContext handshakeContext, ByteBuffer byteBuffer) throws IOException {
            super(handshakeContext);
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)handshakeContext;
            if (byteBuffer.remaining() < 4) {
                throw serverHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Invalid CertificateVerify message: no sufficient data");
            }
            int n = Record.getInt16(byteBuffer);
            this.signatureScheme = SignatureScheme.valueOf(n);
            if (this.signatureScheme == null) {
                throw serverHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid signature algorithm (" + n + ") used in CertificateVerify handshake message");
            }
            if (!serverHandshakeContext.localSupportedSignAlgs.contains((Object)this.signatureScheme)) {
                throw serverHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Unsupported signature algorithm (" + this.signatureScheme.name + ") used in CertificateVerify handshake message");
            }
            X509Authentication.X509Credentials x509Credentials = null;
            for (SSLCredentials sSLCredentials : serverHandshakeContext.handshakeCredentials) {
                if (!(sSLCredentials instanceof X509Authentication.X509Credentials)) continue;
                x509Credentials = (X509Authentication.X509Credentials)sSLCredentials;
                break;
            }
            if (x509Credentials == null || x509Credentials.popPublicKey == null) {
                throw serverHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "No X509 credentials negotiated for CertificateVerify");
            }
            this.signature = Record.getBytes16(byteBuffer);
            try {
                Signature signature = this.signatureScheme.getVerifier(x509Credentials.popPublicKey);
                signature.update(serverHandshakeContext.handshakeHash.archived());
                if (!signature.verify(this.signature)) {
                    throw serverHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid CertificateVerify signature");
                }
            }
            catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException generalSecurityException) {
                throw serverHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Unsupported signature algorithm (" + this.signatureScheme.name + ") used in CertificateVerify handshake message", generalSecurityException);
            }
            catch (InvalidKeyException | SignatureException generalSecurityException) {
                throw serverHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Cannot verify CertificateVerify signature", generalSecurityException);
            }
        }

        @Override
        public SSLHandshake handshakeType() {
            return SSLHandshake.CERTIFICATE_VERIFY;
        }

        @Override
        public int messageLength() {
            return 4 + this.signature.length;
        }

        @Override
        public void send(HandshakeOutStream handshakeOutStream) throws IOException {
            handshakeOutStream.putInt16(this.signatureScheme.id);
            handshakeOutStream.putBytes16(this.signature);
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"CertificateVerify\": '{'\n  \"signature algorithm\": {0}\n  \"signature\": '{'\n{1}\n  '}'\n'}'", Locale.ENGLISH);
            HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
            Object[] objectArray = new Object[]{this.signatureScheme.name, Utilities.indent(hexDumpEncoder.encodeBuffer(this.signature), "    ")};
            return messageFormat.format(objectArray);
        }
    }

    private static final class T10CertificateVerifyConsumer
    implements SSLConsumer {
        private T10CertificateVerifyConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, ByteBuffer byteBuffer) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            serverHandshakeContext.handshakeConsumers.remove(SSLHandshake.CERTIFICATE_VERIFY.id);
            if (serverHandshakeContext.handshakeConsumers.containsKey(SSLHandshake.CLIENT_KEY_EXCHANGE.id)) {
                throw serverHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Unexpected CertificateVerify handshake message");
            }
            T10CertificateVerifyMessage t10CertificateVerifyMessage = new T10CertificateVerifyMessage((HandshakeContext)serverHandshakeContext, byteBuffer);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming CertificateVerify handshake message", t10CertificateVerifyMessage);
            }
        }
    }

    private static final class T10CertificateVerifyProducer
    implements HandshakeProducer {
        private T10CertificateVerifyProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            X509Authentication.X509Possession x509Possession = null;
            for (SSLPossession sSLPossession : clientHandshakeContext.handshakePossessions) {
                if (!(sSLPossession instanceof X509Authentication.X509Possession)) continue;
                x509Possession = (X509Authentication.X509Possession)sSLPossession;
                break;
            }
            if (x509Possession == null || x509Possession.popPrivateKey == null) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("No X.509 credentials negotiated for CertificateVerify", new Object[0]);
                }
                return null;
            }
            T10CertificateVerifyMessage t10CertificateVerifyMessage = new T10CertificateVerifyMessage((HandshakeContext)clientHandshakeContext, x509Possession);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced CertificateVerify handshake message", t10CertificateVerifyMessage);
            }
            t10CertificateVerifyMessage.write(clientHandshakeContext.handshakeOutput);
            clientHandshakeContext.handshakeOutput.flush();
            return null;
        }
    }

    static final class T10CertificateVerifyMessage
    extends SSLHandshake.HandshakeMessage {
        private final byte[] signature;

        T10CertificateVerifyMessage(HandshakeContext handshakeContext, X509Authentication.X509Possession x509Possession) throws IOException {
            super(handshakeContext);
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)handshakeContext;
            byte[] byArray = null;
            String string = x509Possession.popPrivateKey.getAlgorithm();
            try {
                Signature signature = T10CertificateVerifyMessage.getSignature(string, x509Possession.popPrivateKey);
                byte[] byArray2 = clientHandshakeContext.handshakeHash.digest(string);
                signature.update(byArray2);
                byArray = signature.sign();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw clientHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Unsupported signature algorithm (" + string + ") used in CertificateVerify handshake message", noSuchAlgorithmException);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw clientHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Cannot produce CertificateVerify signature", generalSecurityException);
            }
            this.signature = byArray;
        }

        T10CertificateVerifyMessage(HandshakeContext handshakeContext, ByteBuffer byteBuffer) throws IOException {
            super(handshakeContext);
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)handshakeContext;
            if (byteBuffer.remaining() < 2) {
                throw serverHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Invalid CertificateVerify message: no sufficient data");
            }
            this.signature = Record.getBytes16(byteBuffer);
            X509Authentication.X509Credentials x509Credentials = null;
            for (Object object : serverHandshakeContext.handshakeCredentials) {
                if (!(object instanceof X509Authentication.X509Credentials)) continue;
                x509Credentials = (X509Authentication.X509Credentials)object;
                break;
            }
            if (x509Credentials == null || x509Credentials.popPublicKey == null) {
                throw serverHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "No X509 credentials negotiated for CertificateVerify");
            }
            String string = x509Credentials.popPublicKey.getAlgorithm();
            try {
                Object object;
                object = T10CertificateVerifyMessage.getSignature(string, x509Credentials.popPublicKey);
                byte[] byArray = serverHandshakeContext.handshakeHash.digest(string);
                ((Signature)object).update(byArray);
                if (!((Signature)object).verify(this.signature)) {
                    throw serverHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid CertificateVerify message: invalid signature");
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw serverHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Unsupported signature algorithm (" + (String)string + ") used in CertificateVerify handshake message", noSuchAlgorithmException);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw serverHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Cannot verify CertificateVerify signature", generalSecurityException);
            }
        }

        @Override
        public SSLHandshake handshakeType() {
            return SSLHandshake.CERTIFICATE_VERIFY;
        }

        @Override
        public int messageLength() {
            return 2 + this.signature.length;
        }

        @Override
        public void send(HandshakeOutStream handshakeOutStream) throws IOException {
            handshakeOutStream.putBytes16(this.signature);
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"CertificateVerify\": '{'\n  \"signature\": '{'\n{0}\n  '}'\n'}'", Locale.ENGLISH);
            HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
            Object[] objectArray = new Object[]{Utilities.indent(hexDumpEncoder.encodeBuffer(this.signature), "    ")};
            return messageFormat.format(objectArray);
        }

        private static Signature getSignature(String string, Key key) throws GeneralSecurityException {
            Signature signature = null;
            switch (string) {
                case "RSA": {
                    signature = JsseJce.getSignature("NONEwithRSA");
                    break;
                }
                case "DSA": {
                    signature = JsseJce.getSignature("RawDSA");
                    break;
                }
                case "EC": {
                    signature = JsseJce.getSignature("NONEwithECDSA");
                    break;
                }
                default: {
                    throw new SignatureException("Unrecognized algorithm: " + string);
                }
            }
            if (signature != null) {
                if (key instanceof PublicKey) {
                    signature.initVerify((PublicKey)key);
                } else {
                    signature.initSign((PrivateKey)key);
                }
            }
            return signature;
        }
    }

    private static final class S30CertificateVerifyConsumer
    implements SSLConsumer {
        private S30CertificateVerifyConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, ByteBuffer byteBuffer) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            serverHandshakeContext.handshakeConsumers.remove(SSLHandshake.CERTIFICATE_VERIFY.id);
            if (serverHandshakeContext.handshakeConsumers.containsKey(SSLHandshake.CLIENT_KEY_EXCHANGE.id)) {
                throw serverHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Unexpected CertificateVerify handshake message");
            }
            S30CertificateVerifyMessage s30CertificateVerifyMessage = new S30CertificateVerifyMessage((HandshakeContext)serverHandshakeContext, byteBuffer);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming CertificateVerify handshake message", s30CertificateVerifyMessage);
            }
        }
    }

    private static final class S30CertificateVerifyProducer
    implements HandshakeProducer {
        private S30CertificateVerifyProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            X509Authentication.X509Possession x509Possession = null;
            for (SSLPossession sSLPossession : clientHandshakeContext.handshakePossessions) {
                if (!(sSLPossession instanceof X509Authentication.X509Possession)) continue;
                x509Possession = (X509Authentication.X509Possession)sSLPossession;
                break;
            }
            if (x509Possession == null || x509Possession.popPrivateKey == null) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("No X.509 credentials negotiated for CertificateVerify", new Object[0]);
                }
                return null;
            }
            S30CertificateVerifyMessage s30CertificateVerifyMessage = new S30CertificateVerifyMessage((HandshakeContext)clientHandshakeContext, x509Possession);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced CertificateVerify handshake message", s30CertificateVerifyMessage);
            }
            s30CertificateVerifyMessage.write(clientHandshakeContext.handshakeOutput);
            clientHandshakeContext.handshakeOutput.flush();
            return null;
        }
    }

    static final class S30CertificateVerifyMessage
    extends SSLHandshake.HandshakeMessage {
        private final byte[] signature;

        S30CertificateVerifyMessage(HandshakeContext handshakeContext, X509Authentication.X509Possession x509Possession) throws IOException {
            super(handshakeContext);
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)handshakeContext;
            byte[] byArray = null;
            String string = x509Possession.popPrivateKey.getAlgorithm();
            try {
                Signature signature = S30CertificateVerifyMessage.getSignature(string, x509Possession.popPrivateKey);
                byte[] byArray2 = clientHandshakeContext.handshakeHash.digest(string, clientHandshakeContext.handshakeSession.getMasterSecret());
                signature.update(byArray2);
                byArray = signature.sign();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw clientHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Unsupported signature algorithm (" + string + ") used in CertificateVerify handshake message", noSuchAlgorithmException);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw clientHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Cannot produce CertificateVerify signature", generalSecurityException);
            }
            this.signature = byArray;
        }

        S30CertificateVerifyMessage(HandshakeContext handshakeContext, ByteBuffer byteBuffer) throws IOException {
            super(handshakeContext);
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)handshakeContext;
            if (byteBuffer.remaining() < 2) {
                throw serverHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Invalid CertificateVerify message: no sufficient data");
            }
            this.signature = Record.getBytes16(byteBuffer);
            X509Authentication.X509Credentials x509Credentials = null;
            for (Object object : serverHandshakeContext.handshakeCredentials) {
                if (!(object instanceof X509Authentication.X509Credentials)) continue;
                x509Credentials = (X509Authentication.X509Credentials)object;
                break;
            }
            if (x509Credentials == null || x509Credentials.popPublicKey == null) {
                throw serverHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "No X509 credentials negotiated for CertificateVerify");
            }
            String string = x509Credentials.popPublicKey.getAlgorithm();
            try {
                Object object;
                object = S30CertificateVerifyMessage.getSignature(string, x509Credentials.popPublicKey);
                byte[] byArray = serverHandshakeContext.handshakeHash.digest(string, serverHandshakeContext.handshakeSession.getMasterSecret());
                ((Signature)object).update(byArray);
                if (!((Signature)object).verify(this.signature)) {
                    throw serverHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid CertificateVerify message: invalid signature");
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw serverHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Unsupported signature algorithm (" + (String)string + ") used in CertificateVerify handshake message", noSuchAlgorithmException);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw serverHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Cannot verify CertificateVerify signature", generalSecurityException);
            }
        }

        @Override
        public SSLHandshake handshakeType() {
            return SSLHandshake.CERTIFICATE_VERIFY;
        }

        @Override
        public int messageLength() {
            return 2 + this.signature.length;
        }

        @Override
        public void send(HandshakeOutStream handshakeOutStream) throws IOException {
            handshakeOutStream.putBytes16(this.signature);
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"CertificateVerify\": '{'\n  \"signature\": '{'\n{0}\n  '}'\n'}'", Locale.ENGLISH);
            HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
            Object[] objectArray = new Object[]{Utilities.indent(hexDumpEncoder.encodeBuffer(this.signature), "    ")};
            return messageFormat.format(objectArray);
        }

        private static Signature getSignature(String string, Key key) throws GeneralSecurityException {
            Signature signature = null;
            switch (string) {
                case "RSA": {
                    signature = JsseJce.getSignature("NONEwithRSA");
                    break;
                }
                case "DSA": {
                    signature = JsseJce.getSignature("RawDSA");
                    break;
                }
                case "EC": {
                    signature = JsseJce.getSignature("NONEwithECDSA");
                    break;
                }
                default: {
                    throw new SignatureException("Unrecognized algorithm: " + string);
                }
            }
            if (signature != null) {
                if (key instanceof PublicKey) {
                    signature.initVerify((PublicKey)key);
                } else {
                    signature.initSign((PrivateKey)key);
                }
            }
            return signature;
        }
    }
}

