/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.utilities;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import sun.jvm.hotspot.debugger.Address;

public class CStringUtilities {
    private static String encoding = System.getProperty("file.encoding", "US-ASCII");

    public static int getStringLength(Address addr) {
        int i = 0;
        while (addr.getCIntegerAt(i, 1L, false) != 0L) {
            ++i;
        }
        return i;
    }

    public static String getString(Address addr) {
        if (addr == null) {
            return null;
        }
        ArrayList<Byte> data = new ArrayList<Byte>();
        byte val = 0;
        long i = 0L;
        do {
            if ((val = (byte)addr.getCIntegerAt(i, 1L, false)) != 0) {
                data.add(new Byte(val));
            }
            ++i;
        } while (val != 0);
        byte[] bytes = new byte[data.size()];
        for (i = 0L; i < (long)data.size(); ++i) {
            bytes[(int)i] = (Byte)data.get((int)i);
        }
        try {
            return new String(bytes, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Error converting bytes to String using " + encoding + " encoding", e);
        }
    }
}

