/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import com.sun.security.jgss.AuthorizationDataEntry;
import com.sun.security.jgss.InquireType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Key;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.kerberos.ServicePermission;
import org.ietf.jgss.ChannelBinding;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;
import sun.misc.HexDumpEncoder;
import sun.security.jgss.GSSCaller;
import sun.security.jgss.GSSUtil;
import sun.security.jgss.TokenTracker;
import sun.security.jgss.krb5.AcceptSecContextToken;
import sun.security.jgss.krb5.CipherHelper;
import sun.security.jgss.krb5.InitSecContextToken;
import sun.security.jgss.krb5.InitialToken;
import sun.security.jgss.krb5.Krb5AcceptCredential;
import sun.security.jgss.krb5.Krb5CredElement;
import sun.security.jgss.krb5.Krb5InitCredential;
import sun.security.jgss.krb5.Krb5MechFactory;
import sun.security.jgss.krb5.Krb5NameElement;
import sun.security.jgss.krb5.Krb5ProxyCredential;
import sun.security.jgss.krb5.Krb5Token;
import sun.security.jgss.krb5.Krb5Util;
import sun.security.jgss.krb5.MessageToken;
import sun.security.jgss.krb5.MessageToken_v2;
import sun.security.jgss.krb5.MicToken;
import sun.security.jgss.krb5.MicToken_v2;
import sun.security.jgss.krb5.WrapToken;
import sun.security.jgss.krb5.WrapToken_v2;
import sun.security.jgss.spi.GSSContextSpi;
import sun.security.jgss.spi.GSSCredentialSpi;
import sun.security.jgss.spi.GSSNameSpi;
import sun.security.krb5.Credentials;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbApReq;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.internal.Ticket;

class Krb5Context
implements GSSContextSpi {
    private static final int STATE_NEW = 1;
    private static final int STATE_IN_PROCESS = 2;
    private static final int STATE_DONE = 3;
    private static final int STATE_DELETED = 4;
    private int state = 1;
    public static final int SESSION_KEY = 0;
    public static final int INITIATOR_SUBKEY = 1;
    public static final int ACCEPTOR_SUBKEY = 2;
    private boolean credDelegState = false;
    private boolean mutualAuthState = true;
    private boolean replayDetState = true;
    private boolean sequenceDetState = true;
    private boolean confState = true;
    private boolean integState = true;
    private boolean delegPolicyState = false;
    private boolean isConstrainedDelegationTried = false;
    private int mySeqNumber;
    private int peerSeqNumber;
    private int keySrc;
    private TokenTracker peerTokenTracker;
    private CipherHelper cipherHelper = null;
    private Object mySeqNumberLock = new Object();
    private Object peerSeqNumberLock = new Object();
    private EncryptionKey key;
    private Krb5NameElement myName;
    private Krb5NameElement peerName;
    private int lifetime;
    private boolean initiator;
    private ChannelBinding channelBinding;
    private Krb5CredElement myCred;
    private Krb5CredElement delegatedCred;
    private Credentials serviceCreds;
    private KrbApReq apReq;
    Ticket serviceTicket;
    private final GSSCaller caller;
    private static final boolean DEBUG = Krb5Util.DEBUG;
    private boolean[] tktFlags;
    private String authTime;
    private AuthorizationDataEntry[] authzData;

    Krb5Context(GSSCaller gSSCaller, Krb5NameElement krb5NameElement, Krb5CredElement krb5CredElement, int n) throws GSSException {
        if (krb5NameElement == null) {
            throw new IllegalArgumentException("Cannot have null peer name");
        }
        this.caller = gSSCaller;
        this.peerName = krb5NameElement;
        this.myCred = krb5CredElement;
        this.lifetime = n;
        this.initiator = true;
    }

    Krb5Context(GSSCaller gSSCaller, Krb5CredElement krb5CredElement) throws GSSException {
        this.caller = gSSCaller;
        this.myCred = krb5CredElement;
        this.initiator = false;
    }

    public Krb5Context(GSSCaller gSSCaller, byte[] byArray) throws GSSException {
        throw new GSSException(16, -1, "GSS Import Context not available");
    }

    @Override
    public final boolean isTransferable() throws GSSException {
        return false;
    }

    @Override
    public final int getLifetime() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void requestLifetime(int n) throws GSSException {
        if (this.state == 1 && this.isInitiator()) {
            this.lifetime = n;
        }
    }

    @Override
    public final void requestConf(boolean bl) throws GSSException {
        if (this.state == 1 && this.isInitiator()) {
            this.confState = bl;
        }
    }

    @Override
    public final boolean getConfState() {
        return this.confState;
    }

    @Override
    public final void requestInteg(boolean bl) throws GSSException {
        if (this.state == 1 && this.isInitiator()) {
            this.integState = bl;
        }
    }

    @Override
    public final boolean getIntegState() {
        return this.integState;
    }

    @Override
    public final void requestCredDeleg(boolean bl) throws GSSException {
        if (this.state == 1 && this.isInitiator() && (this.myCred == null || !(this.myCred instanceof Krb5ProxyCredential))) {
            this.credDelegState = bl;
        }
    }

    @Override
    public final boolean getCredDelegState() {
        if (this.isInitiator()) {
            return this.credDelegState;
        }
        this.tryConstrainedDelegation();
        return this.delegatedCred != null;
    }

    @Override
    public final void requestMutualAuth(boolean bl) throws GSSException {
        if (this.state == 1 && this.isInitiator()) {
            this.mutualAuthState = bl;
        }
    }

    @Override
    public final boolean getMutualAuthState() {
        return this.mutualAuthState;
    }

    @Override
    public final void requestReplayDet(boolean bl) throws GSSException {
        if (this.state == 1 && this.isInitiator()) {
            this.replayDetState = bl;
        }
    }

    @Override
    public final boolean getReplayDetState() {
        return this.replayDetState || this.sequenceDetState;
    }

    @Override
    public final void requestSequenceDet(boolean bl) throws GSSException {
        if (this.state == 1 && this.isInitiator()) {
            this.sequenceDetState = bl;
        }
    }

    @Override
    public final boolean getSequenceDetState() {
        return this.sequenceDetState || this.replayDetState;
    }

    @Override
    public final void requestDelegPolicy(boolean bl) {
        if (this.state == 1 && this.isInitiator()) {
            this.delegPolicyState = bl;
        }
    }

    @Override
    public final boolean getDelegPolicyState() {
        return this.delegPolicyState;
    }

    @Override
    public final void requestAnonymity(boolean bl) throws GSSException {
    }

    @Override
    public final boolean getAnonymityState() {
        return false;
    }

    final CipherHelper getCipherHelper(EncryptionKey encryptionKey) throws GSSException {
        EncryptionKey encryptionKey2 = null;
        if (this.cipherHelper == null) {
            encryptionKey2 = this.getKey() == null ? encryptionKey : this.getKey();
            this.cipherHelper = new CipherHelper(encryptionKey2);
        }
        return this.cipherHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int incrementMySequenceNumber() {
        int n;
        Object object = this.mySeqNumberLock;
        synchronized (object) {
            n = this.mySeqNumber;
            this.mySeqNumber = n + 1;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void resetMySequenceNumber(int n) {
        if (DEBUG) {
            System.out.println("Krb5Context setting mySeqNumber to: " + n);
        }
        Object object = this.mySeqNumberLock;
        synchronized (object) {
            this.mySeqNumber = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void resetPeerSequenceNumber(int n) {
        if (DEBUG) {
            System.out.println("Krb5Context setting peerSeqNumber to: " + n);
        }
        Object object = this.peerSeqNumberLock;
        synchronized (object) {
            this.peerSeqNumber = n;
            this.peerTokenTracker = new TokenTracker(this.peerSeqNumber);
        }
    }

    final void setKey(int n, EncryptionKey encryptionKey) throws GSSException {
        this.key = encryptionKey;
        this.keySrc = n;
        this.cipherHelper = new CipherHelper(encryptionKey);
    }

    public final int getKeySrc() {
        return this.keySrc;
    }

    private final EncryptionKey getKey() {
        return this.key;
    }

    final void setDelegCred(Krb5CredElement krb5CredElement) {
        this.delegatedCred = krb5CredElement;
    }

    final void setCredDelegState(boolean bl) {
        this.credDelegState = bl;
    }

    final void setMutualAuthState(boolean bl) {
        this.mutualAuthState = bl;
    }

    final void setReplayDetState(boolean bl) {
        this.replayDetState = bl;
    }

    final void setSequenceDetState(boolean bl) {
        this.sequenceDetState = bl;
    }

    final void setConfState(boolean bl) {
        this.confState = bl;
    }

    final void setIntegState(boolean bl) {
        this.integState = bl;
    }

    final void setDelegPolicyState(boolean bl) {
        this.delegPolicyState = bl;
    }

    @Override
    public final void setChannelBinding(ChannelBinding channelBinding) throws GSSException {
        this.channelBinding = channelBinding;
    }

    final ChannelBinding getChannelBinding() {
        return this.channelBinding;
    }

    @Override
    public final Oid getMech() {
        return Krb5MechFactory.GSS_KRB5_MECH_OID;
    }

    @Override
    public final GSSNameSpi getSrcName() throws GSSException {
        return this.isInitiator() ? this.myName : this.peerName;
    }

    @Override
    public final GSSNameSpi getTargName() throws GSSException {
        return !this.isInitiator() ? this.myName : this.peerName;
    }

    @Override
    public final GSSCredentialSpi getDelegCred() throws GSSException {
        if (this.state != 2 && this.state != 3) {
            throw new GSSException(12);
        }
        if (this.isInitiator()) {
            throw new GSSException(13);
        }
        this.tryConstrainedDelegation();
        if (this.delegatedCred == null) {
            throw new GSSException(13);
        }
        return this.delegatedCred;
    }

    private void tryConstrainedDelegation() {
        if (this.state != 2 && this.state != 3) {
            return;
        }
        if (!this.isConstrainedDelegationTried) {
            if (this.delegatedCred == null) {
                if (DEBUG) {
                    System.out.println(">>> Constrained deleg from " + this.caller);
                }
                try {
                    this.delegatedCred = new Krb5ProxyCredential(Krb5InitCredential.getInstance(GSSCaller.CALLER_ACCEPT, this.myName, this.lifetime), this.peerName, this.serviceTicket);
                }
                catch (GSSException gSSException) {
                    // empty catch block
                }
            }
            this.isConstrainedDelegationTried = true;
        }
    }

    @Override
    public final boolean isInitiator() {
        return this.initiator;
    }

    @Override
    public final boolean isProtReady() {
        return this.state == 3;
    }

    @Override
    public final byte[] initSecContext(InputStream inputStream, int n) throws GSSException {
        byte[] byArray;
        block29: {
            byArray = null;
            InitSecContextToken initSecContextToken = null;
            int n2 = 11;
            if (DEBUG) {
                System.out.println("Entered Krb5Context.initSecContext with state=" + Krb5Context.printState(this.state));
            }
            if (!this.isInitiator()) {
                throw new GSSException(11, -1, "initSecContext on an acceptor GSSContext");
            }
            try {
                if (this.state == 1) {
                    Serializable serializable;
                    Credentials credentials;
                    Krb5ProxyCredential krb5ProxyCredential;
                    this.state = 2;
                    n2 = 13;
                    if (this.myCred == null) {
                        this.myCred = Krb5InitCredential.getInstance(this.caller, this.myName, 0);
                        this.myCred = Krb5ProxyCredential.tryImpersonation(this.caller, (Krb5InitCredential)this.myCred);
                    } else if (!this.myCred.isInitiatorCredential()) {
                        throw new GSSException(n2, -1, "No TGT available");
                    }
                    this.myName = (Krb5NameElement)this.myCred.getName();
                    if (this.myCred instanceof Krb5InitCredential) {
                        krb5ProxyCredential = null;
                        credentials = ((Krb5InitCredential)this.myCred).getKrb5Credentials();
                    } else {
                        krb5ProxyCredential = (Krb5ProxyCredential)this.myCred;
                        credentials = krb5ProxyCredential.self.getKrb5Credentials();
                    }
                    this.checkPermission(this.peerName.getKrb5PrincipalName().getName(), "initiate");
                    final AccessControlContext accessControlContext = AccessController.getContext();
                    if (GSSUtil.useSubjectCredsOnly(this.caller)) {
                        block28: {
                            serializable = null;
                            try {
                                serializable = AccessController.doPrivileged(new PrivilegedExceptionAction<KerberosTicket>(){

                                    @Override
                                    public KerberosTicket run() throws Exception {
                                        return Krb5Util.getServiceTicket(GSSCaller.CALLER_UNKNOWN, krb5ProxyCredential == null ? Krb5Context.this.myName.getKrb5PrincipalName().getName() : krb5ProxyCredential.getName().getKrb5PrincipalName().getName(), Krb5Context.this.peerName.getKrb5PrincipalName().getName(), accessControlContext);
                                    }
                                });
                            }
                            catch (PrivilegedActionException privilegedActionException) {
                                if (!DEBUG) break block28;
                                System.out.println("Attempt to obtain service ticket from the subject failed!");
                            }
                        }
                        if (serializable != null) {
                            if (DEBUG) {
                                System.out.println("Found service ticket in the subject" + serializable);
                            }
                            this.serviceCreds = Krb5Util.ticketToCreds((KerberosTicket)serializable);
                        }
                    }
                    if (this.serviceCreds == null) {
                        if (DEBUG) {
                            System.out.println("Service ticket not found in the subject");
                        }
                        this.serviceCreds = krb5ProxyCredential == null ? Credentials.acquireServiceCreds(this.peerName.getKrb5PrincipalName().getName(), credentials) : Credentials.acquireS4U2proxyCreds(this.peerName.getKrb5PrincipalName().getName(), krb5ProxyCredential.tkt, krb5ProxyCredential.getName().getKrb5PrincipalName(), credentials);
                        if (GSSUtil.useSubjectCredsOnly(this.caller)) {
                            serializable = AccessController.doPrivileged(new PrivilegedAction<Subject>(){

                                @Override
                                public Subject run() {
                                    return Subject.getSubject(accessControlContext);
                                }
                            });
                            if (serializable != null && !((Subject)serializable).isReadOnly()) {
                                KerberosTicket kerberosTicket = Krb5Util.credsToTicket(this.serviceCreds);
                                AccessController.doPrivileged(new PrivilegedAction<Void>((Subject)serializable, kerberosTicket){
                                    final /* synthetic */ Subject val$subject;
                                    final /* synthetic */ KerberosTicket val$kt;
                                    {
                                        this.val$subject = subject;
                                        this.val$kt = kerberosTicket;
                                    }

                                    @Override
                                    public Void run() {
                                        this.val$subject.getPrivateCredentials().add(this.val$kt);
                                        return null;
                                    }
                                });
                            } else if (DEBUG) {
                                System.out.println("Subject is readOnly;Kerberos Service ticket not stored");
                            }
                        }
                    }
                    n2 = 11;
                    initSecContextToken = new InitSecContextToken(this, credentials, this.serviceCreds);
                    this.apReq = initSecContextToken.getKrbApReq();
                    byArray = ((InitialToken)initSecContextToken).encode();
                    this.myCred = null;
                    if (!this.getMutualAuthState()) {
                        this.state = 3;
                    }
                    if (DEBUG) {
                        System.out.println("Created InitSecContextToken:\n" + new HexDumpEncoder().encodeBuffer(byArray));
                    }
                    break block29;
                }
                if (this.state == 2) {
                    new AcceptSecContextToken(this, this.serviceCreds, this.apReq, inputStream);
                    this.serviceCreds = null;
                    this.apReq = null;
                    this.state = 3;
                } else if (DEBUG) {
                    System.out.println(this.state);
                }
            }
            catch (KrbException krbException) {
                if (DEBUG) {
                    krbException.printStackTrace();
                }
                GSSException gSSException = new GSSException(n2, -1, krbException.getMessage());
                gSSException.initCause(krbException);
                throw gSSException;
            }
            catch (IOException iOException) {
                GSSException gSSException = new GSSException(n2, -1, iOException.getMessage());
                gSSException.initCause(iOException);
                throw gSSException;
            }
        }
        return byArray;
    }

    @Override
    public final boolean isEstablished() {
        return this.state == 3;
    }

    @Override
    public final byte[] acceptSecContext(InputStream inputStream, int n) throws GSSException {
        byte[] byArray = null;
        if (DEBUG) {
            System.out.println("Entered Krb5Context.acceptSecContext with state=" + Krb5Context.printState(this.state));
        }
        if (this.isInitiator()) {
            throw new GSSException(11, -1, "acceptSecContext on an initiator GSSContext");
        }
        try {
            if (this.state == 1) {
                this.state = 2;
                if (this.myCred == null) {
                    this.myCred = Krb5AcceptCredential.getInstance(this.caller, this.myName);
                } else if (!this.myCred.isAcceptorCredential()) {
                    throw new GSSException(13, -1, "No Secret Key available");
                }
                this.myName = (Krb5NameElement)this.myCred.getName();
                if (this.myName != null) {
                    Krb5MechFactory.checkAcceptCredPermission(this.myName, this.myName);
                }
                InitSecContextToken initSecContextToken = new InitSecContextToken(this, (Krb5AcceptCredential)this.myCred, inputStream);
                PrincipalName principalName = initSecContextToken.getKrbApReq().getClient();
                this.peerName = Krb5NameElement.getInstance(principalName);
                if (this.myName == null) {
                    this.myName = Krb5NameElement.getInstance(initSecContextToken.getKrbApReq().getCreds().getServer());
                    Krb5MechFactory.checkAcceptCredPermission(this.myName, this.myName);
                }
                if (this.getMutualAuthState()) {
                    byArray = new AcceptSecContextToken(this, initSecContextToken.getKrbApReq()).encode();
                }
                this.serviceTicket = initSecContextToken.getKrbApReq().getCreds().getTicket();
                this.myCred = null;
                this.state = 3;
            } else if (DEBUG) {
                System.out.println(this.state);
            }
        }
        catch (KrbException krbException) {
            GSSException gSSException = new GSSException(11, -1, krbException.getMessage());
            gSSException.initCause(krbException);
            throw gSSException;
        }
        catch (IOException iOException) {
            if (DEBUG) {
                iOException.printStackTrace();
            }
            GSSException gSSException = new GSSException(11, -1, iOException.getMessage());
            gSSException.initCause(iOException);
            throw gSSException;
        }
        return byArray;
    }

    @Override
    public final int getWrapSizeLimit(int n, boolean bl, int n2) throws GSSException {
        int n3 = 0;
        if (this.cipherHelper.getProto() == 0) {
            n3 = WrapToken.getSizeLimit(n, bl, n2, this.getCipherHelper(null));
        } else if (this.cipherHelper.getProto() == 1) {
            n3 = WrapToken_v2.getSizeLimit(n, bl, n2, this.getCipherHelper(null));
        }
        return n3;
    }

    @Override
    public final byte[] wrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        if (this.state != 3) {
            throw new GSSException(12, -1, "Wrap called in invalid state!");
        }
        byte[] byArray2 = null;
        try {
            if (this.cipherHelper.getProto() == 0) {
                WrapToken wrapToken = new WrapToken(this, messageProp, byArray, n, n2);
                byArray2 = wrapToken.encode();
            } else if (this.cipherHelper.getProto() == 1) {
                WrapToken_v2 wrapToken_v2 = new WrapToken_v2(this, messageProp, byArray, n, n2);
                byArray2 = wrapToken_v2.encode();
            }
            if (DEBUG) {
                System.out.println("Krb5Context.wrap: token=[" + Krb5Context.getHexBytes(byArray2, 0, byArray2.length) + "]");
            }
            return byArray2;
        }
        catch (IOException iOException) {
            byArray2 = null;
            GSSException gSSException = new GSSException(11, -1, iOException.getMessage());
            gSSException.initCause(iOException);
            throw gSSException;
        }
    }

    public final int wrap(byte[] byArray, int n, int n2, byte[] byArray2, int n3, MessageProp messageProp) throws GSSException {
        if (this.state != 3) {
            throw new GSSException(12, -1, "Wrap called in invalid state!");
        }
        int n4 = 0;
        try {
            if (this.cipherHelper.getProto() == 0) {
                WrapToken wrapToken = new WrapToken(this, messageProp, byArray, n, n2);
                n4 = wrapToken.encode(byArray2, n3);
            } else if (this.cipherHelper.getProto() == 1) {
                WrapToken_v2 wrapToken_v2 = new WrapToken_v2(this, messageProp, byArray, n, n2);
                n4 = wrapToken_v2.encode(byArray2, n3);
            }
            if (DEBUG) {
                System.out.println("Krb5Context.wrap: token=[" + Krb5Context.getHexBytes(byArray2, n3, n4) + "]");
            }
            return n4;
        }
        catch (IOException iOException) {
            n4 = 0;
            GSSException gSSException = new GSSException(11, -1, iOException.getMessage());
            gSSException.initCause(iOException);
            throw gSSException;
        }
    }

    public final void wrap(byte[] byArray, int n, int n2, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        if (this.state != 3) {
            throw new GSSException(12, -1, "Wrap called in invalid state!");
        }
        byte[] byArray2 = null;
        try {
            if (this.cipherHelper.getProto() == 0) {
                WrapToken wrapToken = new WrapToken(this, messageProp, byArray, n, n2);
                wrapToken.encode(outputStream);
                if (DEBUG) {
                    byArray2 = wrapToken.encode();
                }
            } else if (this.cipherHelper.getProto() == 1) {
                WrapToken_v2 wrapToken_v2 = new WrapToken_v2(this, messageProp, byArray, n, n2);
                wrapToken_v2.encode(outputStream);
                if (DEBUG) {
                    byArray2 = wrapToken_v2.encode();
                }
            }
        }
        catch (IOException iOException) {
            GSSException gSSException = new GSSException(11, -1, iOException.getMessage());
            gSSException.initCause(iOException);
            throw gSSException;
        }
        if (DEBUG) {
            System.out.println("Krb5Context.wrap: token=[" + Krb5Context.getHexBytes(byArray2, 0, byArray2.length) + "]");
        }
    }

    @Override
    public final void wrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        byte[] byArray;
        try {
            byArray = new byte[inputStream.available()];
            inputStream.read(byArray);
        }
        catch (IOException iOException) {
            GSSException gSSException = new GSSException(11, -1, iOException.getMessage());
            gSSException.initCause(iOException);
            throw gSSException;
        }
        this.wrap(byArray, 0, byArray.length, outputStream, messageProp);
    }

    @Override
    public final byte[] unwrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        if (DEBUG) {
            System.out.println("Krb5Context.unwrap: token=[" + Krb5Context.getHexBytes(byArray, n, n2) + "]");
        }
        if (this.state != 3) {
            throw new GSSException(12, -1, " Unwrap called in invalid state!");
        }
        byte[] byArray2 = null;
        if (this.cipherHelper.getProto() == 0) {
            WrapToken wrapToken = new WrapToken(this, byArray, n, n2, messageProp);
            byArray2 = wrapToken.getData();
            this.setSequencingAndReplayProps(wrapToken, messageProp);
        } else if (this.cipherHelper.getProto() == 1) {
            WrapToken_v2 wrapToken_v2 = new WrapToken_v2(this, byArray, n, n2, messageProp);
            byArray2 = wrapToken_v2.getData();
            this.setSequencingAndReplayProps(wrapToken_v2, messageProp);
        }
        return byArray2;
    }

    public final int unwrap(byte[] byArray, int n, int n2, byte[] byArray2, int n3, MessageProp messageProp) throws GSSException {
        if (this.state != 3) {
            throw new GSSException(12, -1, "Unwrap called in invalid state!");
        }
        if (this.cipherHelper.getProto() == 0) {
            WrapToken wrapToken = new WrapToken(this, byArray, n, n2, messageProp);
            n2 = wrapToken.getData(byArray2, n3);
            this.setSequencingAndReplayProps(wrapToken, messageProp);
        } else if (this.cipherHelper.getProto() == 1) {
            WrapToken_v2 wrapToken_v2 = new WrapToken_v2(this, byArray, n, n2, messageProp);
            n2 = wrapToken_v2.getData(byArray2, n3);
            this.setSequencingAndReplayProps(wrapToken_v2, messageProp);
        }
        return n2;
    }

    public final int unwrap(InputStream inputStream, byte[] byArray, int n, MessageProp messageProp) throws GSSException {
        if (this.state != 3) {
            throw new GSSException(12, -1, "Unwrap called in invalid state!");
        }
        int n2 = 0;
        if (this.cipherHelper.getProto() == 0) {
            WrapToken wrapToken = new WrapToken(this, inputStream, messageProp);
            n2 = wrapToken.getData(byArray, n);
            this.setSequencingAndReplayProps(wrapToken, messageProp);
        } else if (this.cipherHelper.getProto() == 1) {
            WrapToken_v2 wrapToken_v2 = new WrapToken_v2(this, inputStream, messageProp);
            n2 = wrapToken_v2.getData(byArray, n);
            this.setSequencingAndReplayProps(wrapToken_v2, messageProp);
        }
        return n2;
    }

    @Override
    public final void unwrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        Krb5Token krb5Token;
        if (this.state != 3) {
            throw new GSSException(12, -1, "Unwrap called in invalid state!");
        }
        byte[] byArray = null;
        if (this.cipherHelper.getProto() == 0) {
            krb5Token = new WrapToken(this, inputStream, messageProp);
            byArray = ((WrapToken)krb5Token).getData();
            this.setSequencingAndReplayProps((MessageToken)krb5Token, messageProp);
        } else if (this.cipherHelper.getProto() == 1) {
            krb5Token = new WrapToken_v2(this, inputStream, messageProp);
            byArray = ((WrapToken_v2)krb5Token).getData();
            this.setSequencingAndReplayProps((MessageToken_v2)krb5Token, messageProp);
        }
        try {
            outputStream.write(byArray);
        }
        catch (IOException iOException) {
            GSSException gSSException = new GSSException(11, -1, iOException.getMessage());
            gSSException.initCause(iOException);
            throw gSSException;
        }
    }

    @Override
    public final byte[] getMIC(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        byte[] byArray2 = null;
        try {
            if (this.cipherHelper.getProto() == 0) {
                MicToken micToken = new MicToken(this, messageProp, byArray, n, n2);
                byArray2 = micToken.encode();
            } else if (this.cipherHelper.getProto() == 1) {
                MicToken_v2 micToken_v2 = new MicToken_v2(this, messageProp, byArray, n, n2);
                byArray2 = micToken_v2.encode();
            }
            return byArray2;
        }
        catch (IOException iOException) {
            byArray2 = null;
            GSSException gSSException = new GSSException(11, -1, iOException.getMessage());
            gSSException.initCause(iOException);
            throw gSSException;
        }
    }

    private int getMIC(byte[] byArray, int n, int n2, byte[] byArray2, int n3, MessageProp messageProp) throws GSSException {
        int n4 = 0;
        try {
            if (this.cipherHelper.getProto() == 0) {
                MicToken micToken = new MicToken(this, messageProp, byArray, n, n2);
                n4 = micToken.encode(byArray2, n3);
            } else if (this.cipherHelper.getProto() == 1) {
                MicToken_v2 micToken_v2 = new MicToken_v2(this, messageProp, byArray, n, n2);
                n4 = micToken_v2.encode(byArray2, n3);
            }
            return n4;
        }
        catch (IOException iOException) {
            n4 = 0;
            GSSException gSSException = new GSSException(11, -1, iOException.getMessage());
            gSSException.initCause(iOException);
            throw gSSException;
        }
    }

    private void getMIC(byte[] byArray, int n, int n2, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        try {
            if (this.cipherHelper.getProto() == 0) {
                MicToken micToken = new MicToken(this, messageProp, byArray, n, n2);
                micToken.encode(outputStream);
            } else if (this.cipherHelper.getProto() == 1) {
                MicToken_v2 micToken_v2 = new MicToken_v2(this, messageProp, byArray, n, n2);
                micToken_v2.encode(outputStream);
            }
        }
        catch (IOException iOException) {
            GSSException gSSException = new GSSException(11, -1, iOException.getMessage());
            gSSException.initCause(iOException);
            throw gSSException;
        }
    }

    @Override
    public final void getMIC(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        byte[] byArray;
        try {
            byArray = new byte[inputStream.available()];
            inputStream.read(byArray);
        }
        catch (IOException iOException) {
            GSSException gSSException = new GSSException(11, -1, iOException.getMessage());
            gSSException.initCause(iOException);
            throw gSSException;
        }
        this.getMIC(byArray, 0, byArray.length, outputStream, messageProp);
    }

    @Override
    public final void verifyMIC(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, MessageProp messageProp) throws GSSException {
        if (this.cipherHelper.getProto() == 0) {
            MicToken micToken = new MicToken(this, byArray, n, n2, messageProp);
            micToken.verify(byArray2, n3, n4);
            this.setSequencingAndReplayProps(micToken, messageProp);
        } else if (this.cipherHelper.getProto() == 1) {
            MicToken_v2 micToken_v2 = new MicToken_v2(this, byArray, n, n2, messageProp);
            micToken_v2.verify(byArray2, n3, n4);
            this.setSequencingAndReplayProps(micToken_v2, messageProp);
        }
    }

    private void verifyMIC(InputStream inputStream, byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        if (this.cipherHelper.getProto() == 0) {
            MicToken micToken = new MicToken(this, inputStream, messageProp);
            micToken.verify(byArray, n, n2);
            this.setSequencingAndReplayProps(micToken, messageProp);
        } else if (this.cipherHelper.getProto() == 1) {
            MicToken_v2 micToken_v2 = new MicToken_v2(this, inputStream, messageProp);
            micToken_v2.verify(byArray, n, n2);
            this.setSequencingAndReplayProps(micToken_v2, messageProp);
        }
    }

    @Override
    public final void verifyMIC(InputStream inputStream, InputStream inputStream2, MessageProp messageProp) throws GSSException {
        byte[] byArray;
        try {
            byArray = new byte[inputStream2.available()];
            inputStream2.read(byArray);
        }
        catch (IOException iOException) {
            GSSException gSSException = new GSSException(11, -1, iOException.getMessage());
            gSSException.initCause(iOException);
            throw gSSException;
        }
        this.verifyMIC(inputStream, byArray, 0, byArray.length, messageProp);
    }

    @Override
    public final byte[] export() throws GSSException {
        throw new GSSException(16, -1, "GSS Export Context not available");
    }

    @Override
    public final void dispose() throws GSSException {
        this.state = 4;
        this.delegatedCred = null;
    }

    @Override
    public final Provider getProvider() {
        return Krb5MechFactory.PROVIDER;
    }

    private void setSequencingAndReplayProps(MessageToken messageToken, MessageProp messageProp) {
        if (this.replayDetState || this.sequenceDetState) {
            int n = messageToken.getSequenceNumber();
            this.peerTokenTracker.getProps(n, messageProp);
        }
    }

    private void setSequencingAndReplayProps(MessageToken_v2 messageToken_v2, MessageProp messageProp) {
        if (this.replayDetState || this.sequenceDetState) {
            int n = messageToken_v2.getSequenceNumber();
            this.peerTokenTracker.getProps(n, messageProp);
        }
    }

    private void checkPermission(String string, String string2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            ServicePermission servicePermission = new ServicePermission(string, string2);
            securityManager.checkPermission(servicePermission);
        }
    }

    private static String getHexBytes(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            int n3 = byArray[i] >> 4 & 0xF;
            int n4 = byArray[i] & 0xF;
            stringBuffer.append(Integer.toHexString(n3));
            stringBuffer.append(Integer.toHexString(n4));
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    private static String printState(int n) {
        switch (n) {
            case 1: {
                return "STATE_NEW";
            }
            case 2: {
                return "STATE_IN_PROCESS";
            }
            case 3: {
                return "STATE_DONE";
            }
            case 4: {
                return "STATE_DELETED";
            }
        }
        return "Unknown state " + n;
    }

    GSSCaller getCaller() {
        return this.caller;
    }

    @Override
    public Object inquireSecContext(InquireType inquireType) throws GSSException {
        if (!this.isEstablished()) {
            throw new GSSException(12, -1, "Security context not established.");
        }
        switch (inquireType) {
            case KRB5_GET_SESSION_KEY: {
                return new KerberosSessionKey(this.key);
            }
            case KRB5_GET_TKT_FLAGS: {
                return this.tktFlags.clone();
            }
            case KRB5_GET_AUTHZ_DATA: {
                if (this.isInitiator()) {
                    throw new GSSException(16, -1, "AuthzData not available on initiator side.");
                }
                return this.authzData == null ? null : this.authzData.clone();
            }
            case KRB5_GET_AUTHTIME: {
                return this.authTime;
            }
        }
        throw new GSSException(16, -1, "Inquire type not supported.");
    }

    public void setTktFlags(boolean[] blArray) {
        this.tktFlags = blArray;
    }

    public void setAuthTime(String string) {
        this.authTime = string;
    }

    public void setAuthzData(AuthorizationDataEntry[] authorizationDataEntryArray) {
        this.authzData = authorizationDataEntryArray;
    }

    static class KerberosSessionKey
    implements Key {
        private static final long serialVersionUID = 699307378954123869L;
        private final EncryptionKey key;

        KerberosSessionKey(EncryptionKey encryptionKey) {
            this.key = encryptionKey;
        }

        @Override
        public String getAlgorithm() {
            return Integer.toString(this.key.getEType());
        }

        @Override
        public String getFormat() {
            return "RAW";
        }

        @Override
        public byte[] getEncoded() {
            return (byte[])this.key.getBytes().clone();
        }

        public String toString() {
            return "Kerberos session key: etype=" + this.key.getEType() + ", " + Krb5Util.keyInfo(this.key.getBytes());
        }
    }
}

