/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.awt.peer.ComponentPeer;
import java.awt.peer.WindowPeer;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import sun.awt.AWTAccessor;
import sun.awt.AWTIcon32_java_icon16_png;
import sun.awt.AWTIcon32_java_icon24_png;
import sun.awt.AWTIcon32_java_icon32_png;
import sun.awt.AWTIcon32_java_icon48_png;
import sun.awt.AWTIcon64_java_icon16_png;
import sun.awt.AWTIcon64_java_icon24_png;
import sun.awt.AWTIcon64_java_icon32_png;
import sun.awt.AWTIcon64_java_icon48_png;
import sun.awt.DisplayChangedListener;
import sun.awt.IconInfo;
import sun.awt.SunToolkit;
import sun.awt.UngrabEvent;
import sun.awt.X11.Native;
import sun.awt.X11.PropMwmHints;
import sun.awt.X11.ToplevelStateListener;
import sun.awt.X11.XAtom;
import sun.awt.X11.XAtomList;
import sun.awt.X11.XAwtState;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XButtonEvent;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XConfigureEvent;
import sun.awt.X11.XConstants;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XCrossingEvent;
import sun.awt.X11.XDecoratedPeer;
import sun.awt.X11.XDialogPeer;
import sun.awt.X11.XDropTargetRegistry;
import sun.awt.X11.XEvent;
import sun.awt.X11.XEventDispatcher;
import sun.awt.X11.XFocusChangeEvent;
import sun.awt.X11.XFocusProxyWindow;
import sun.awt.X11.XKeyboardFocusManagerPeer;
import sun.awt.X11.XLightweightFramePeer;
import sun.awt.X11.XMotionEvent;
import sun.awt.X11.XNETProtocol;
import sun.awt.X11.XPanelPeer;
import sun.awt.X11.XPropertyEvent;
import sun.awt.X11.XQueryTree;
import sun.awt.X11.XSizeHints;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XUnmapEvent;
import sun.awt.X11.XVisibilityEvent;
import sun.awt.X11.XWM;
import sun.awt.X11.XWMHints;
import sun.awt.X11.XWarningWindow;
import sun.awt.X11.XWindow;
import sun.awt.X11.XWindowAttributesData;
import sun.awt.X11.XlibUtil;
import sun.awt.X11.XlibWrapper;
import sun.awt.X11GraphicsDevice;
import sun.awt.X11GraphicsEnvironment;
import sun.java2d.pipe.Region;
import sun.util.logging.PlatformLogger;

class XWindowPeer
extends XPanelPeer
implements WindowPeer,
DisplayChangedListener {
    private static final PlatformLogger log = PlatformLogger.getLogger("sun.awt.X11.XWindowPeer");
    private static final PlatformLogger focusLog = PlatformLogger.getLogger("sun.awt.X11.focus.XWindowPeer");
    private static final PlatformLogger insLog = PlatformLogger.getLogger("sun.awt.X11.insets.XWindowPeer");
    private static final PlatformLogger grabLog = PlatformLogger.getLogger("sun.awt.X11.grab.XWindowPeer");
    private static final PlatformLogger iconLog = PlatformLogger.getLogger("sun.awt.X11.icon.XWindowPeer");
    private static Set<XWindowPeer> windows = new HashSet<XWindowPeer>();
    private boolean cachedFocusableWindow;
    XWarningWindow warningWindow;
    private boolean alwaysOnTop;
    private boolean locationByPlatform;
    Dialog modalBlocker;
    boolean delayedModalBlocking = false;
    Dimension targetMinimumSize = null;
    private XWindowPeer ownerPeer;
    protected XWindowPeer prevTransientFor;
    protected XWindowPeer nextTransientFor;
    private XBaseWindow curRealTransientFor;
    private boolean grab = false;
    private boolean isMapped = false;
    private boolean mustControlStackPosition = false;
    private XEventDispatcher rootPropertyEventDispatcher = null;
    private static final AtomicBoolean isStartupNotificationRemoved = new AtomicBoolean();
    private boolean isUnhiding = false;
    private boolean isBeforeFirstMapNotify = false;
    private Window.Type windowType = Window.Type.NORMAL;
    protected Vector<ToplevelStateListener> toplevelStateListeners = new Vector();
    private static final int PREFERRED_SIZE_FOR_ICON = 128;
    private static final int MAXIMUM_BUFFER_LENGTH_NET_WM_ICON = 65535;
    private static ArrayList<IconInfo> defaultIconInfo;
    private int dropTargetCount = 0;
    XAtom XA_NET_WM_STATE;
    XAtomList net_wm_state;
    private XBaseWindow pressTarget = this;

    public final Window.Type getWindowType() {
        return this.windowType;
    }

    XWindowPeer(XCreateWindowParams xCreateWindowParams) {
        super(xCreateWindowParams.putIfNull((Object)"parent window", (Object)0L));
    }

    XWindowPeer(Window window) {
        super(new XCreateWindowParams(new Object[]{"target", window, "parent window", 0L}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void preInit(XCreateWindowParams xCreateWindowParams) {
        Object object;
        Color color;
        this.target = (Component)xCreateWindowParams.get("target");
        this.windowType = ((Window)this.target).getType();
        xCreateWindowParams.put("reparented", this.isOverrideRedirect() || this.isSimpleWindow());
        super.preInit(xCreateWindowParams);
        xCreateWindowParams.putIfNull((Object)"bit gravity", (Object)1);
        long l = 0L;
        if (xCreateWindowParams.containsKey("event mask")) {
            l = (Long)xCreateWindowParams.get("event mask");
        }
        xCreateWindowParams.put("event mask", l |= 0x10000L);
        this.XA_NET_WM_STATE = XAtom.get("_NET_WM_STATE");
        xCreateWindowParams.put("overrideRedirect", this.isOverrideRedirect());
        SunToolkit.awtLock();
        try {
            windows.add(this);
        }
        finally {
            SunToolkit.awtUnlock();
        }
        this.cachedFocusableWindow = this.isFocusableWindow();
        Font font = this.target.getFont();
        if (font == null) {
            font = XWindow.getDefaultFont();
            this.target.setFont(font);
        }
        if ((color = this.target.getBackground()) == null) {
            object = SystemColor.window;
            this.target.setBackground((Color)object);
        }
        if ((color = this.target.getForeground()) == null) {
            this.target.setForeground(SystemColor.windowText);
        }
        this.alwaysOnTop = ((Window)this.target).isAlwaysOnTop() && ((Window)this.target).isAlwaysOnTopSupported();
        object = this.getGraphicsConfiguration();
        ((X11GraphicsDevice)((GraphicsConfiguration)object).getDevice()).addDisplayChangedListener(this);
    }

    @Override
    protected String getWMName() {
        String string = this.target.getName();
        if (string == null || string.trim().equals("")) {
            string = " ";
        }
        return string;
    }

    private static native String getLocalHostname();

    private static native int getJvmPID();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void postInit(XCreateWindowParams xCreateWindowParams) {
        XNETProtocol xNETProtocol;
        super.postInit(xCreateWindowParams);
        this.initWMProtocols();
        XAtom.get("WM_CLIENT_MACHINE").setProperty(this.getWindow(), XWindowPeer.getLocalHostname());
        XAtom.get("_NET_WM_PID").setCard32Property(this.getWindow(), (long)XWindowPeer.getJvmPID());
        Window window = (Window)this.target;
        Window window2 = window.getOwner();
        if (window2 != null) {
            long l;
            this.ownerPeer = (XWindowPeer)window2.getPeer();
            if (focusLog.isLoggable(PlatformLogger.Level.FINER)) {
                focusLog.finer("Owner is " + window2);
                focusLog.finer("Owner peer is " + this.ownerPeer);
                focusLog.finer("Owner X window " + Long.toHexString(this.ownerPeer.getWindow()));
                focusLog.finer("Owner content X window " + Long.toHexString(this.ownerPeer.getContentWindow()));
            }
            if ((l = this.ownerPeer.getWindow()) != 0L) {
                XToolkit.awtLock();
                try {
                    if (focusLog.isLoggable(PlatformLogger.Level.FINE)) {
                        focusLog.fine("Setting transient on " + Long.toHexString(this.getWindow()) + " for " + Long.toHexString(l));
                    }
                    XWindowPeer.setToplevelTransientFor(this, this.ownerPeer, false, true);
                    XWMHints xWMHints = this.getWMHints();
                    xWMHints.set_flags(xWMHints.get_flags() | 0x40L);
                    xWMHints.set_window_group(l);
                    XlibWrapper.XSetWMHints(XToolkit.getDisplay(), this.getWindow(), xWMHints.pData);
                }
                finally {
                    XToolkit.awtUnlock();
                }
            }
        }
        if ((window2 != null || this.isSimpleWindow()) && (xNETProtocol = XWM.getWM().getNETProtocol()) != null && xNETProtocol.active()) {
            XToolkit.awtLock();
            try {
                XAtomList xAtomList = this.getNETWMState();
                xAtomList.add(xNETProtocol.XA_NET_WM_STATE_SKIP_TASKBAR);
                this.setNETWMState(xAtomList);
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        if (((Window)this.target).getWarningString() != null && !AWTAccessor.getWindowAccessor().isTrayIconWindow((Window)this.target)) {
            this.warningWindow = new XWarningWindow((Window)this.target, this.getWindow(), this);
        }
        this.setSaveUnder(true);
        this.updateIconImages();
        this.updateShape();
        this.updateOpacity();
    }

    @Override
    public void updateIconImages() {
        Window window = (Window)this.target;
        List<Image> list = window.getIconImages();
        XWindowPeer xWindowPeer = this.getOwnerPeer();
        this.winAttr.icons = new ArrayList<IconInfo>();
        if (list.size() != 0) {
            this.winAttr.iconsInherited = false;
            for (Image image : list) {
                IconInfo iconInfo;
                if (image == null) {
                    if (!log.isLoggable(PlatformLogger.Level.FINEST)) continue;
                    log.finest("XWindowPeer.updateIconImages: Skipping the image passed into Java because it's null.");
                    continue;
                }
                try {
                    iconInfo = new IconInfo(image);
                }
                catch (Exception exception) {
                    if (!log.isLoggable(PlatformLogger.Level.FINEST)) continue;
                    log.finest("XWindowPeer.updateIconImages: Perhaps the image passed into Java is broken. Skipping this icon.");
                    continue;
                }
                if (!iconInfo.isValid()) continue;
                this.winAttr.icons.add(iconInfo);
            }
        }
        this.winAttr.icons = XWindowPeer.normalizeIconImages(this.winAttr.icons);
        if (this.winAttr.icons.size() == 0) {
            if (xWindowPeer != null) {
                this.winAttr.iconsInherited = true;
                this.winAttr.icons = xWindowPeer.getIconInfo();
            } else {
                this.winAttr.iconsInherited = false;
                this.winAttr.icons = XWindowPeer.getDefaultIconInfo();
            }
        }
        this.recursivelySetIcon(this.winAttr.icons);
    }

    static List<IconInfo> normalizeIconImages(List<IconInfo> list) {
        ArrayList<IconInfo> arrayList = new ArrayList<IconInfo>();
        int n = 0;
        boolean bl = false;
        for (IconInfo iconInfo : list) {
            int n2 = iconInfo.getWidth();
            int n3 = iconInfo.getHeight();
            int n4 = iconInfo.getRawLength();
            if (n2 > 128 || n3 > 128) {
                int n5;
                if (bl) continue;
                int n6 = n2;
                for (n5 = n3; n6 > 128 || n5 > 128; n6 /= 2, n5 /= 2) {
                }
                iconInfo.setScaledSize(n6, n5);
                n4 = iconInfo.getRawLength();
            }
            if (n + n4 > 65535) continue;
            n += n4;
            arrayList.add(iconInfo);
            if (n2 <= 128 && n3 <= 128) continue;
            bl = true;
        }
        if (iconLog.isLoggable(PlatformLogger.Level.FINEST)) {
            iconLog.finest(">>> Length_ of buffer of icons data: " + n + ", maximum length: " + 65535);
        }
        return arrayList;
    }

    static void dumpIcons(List<IconInfo> list) {
        if (iconLog.isLoggable(PlatformLogger.Level.FINEST)) {
            iconLog.finest(">>> Sizes of icon images:");
            Iterator<IconInfo> iterator = list.iterator();
            while (iterator.hasNext()) {
                iconLog.finest("    {0}", iterator.next());
            }
        }
    }

    public void recursivelySetIcon(List<IconInfo> list) {
        XWindowPeer.dumpIcons(this.winAttr.icons);
        this.setIconHints(list);
        Window window = (Window)this.target;
        Window[] windowArray = window.getOwnedWindows();
        int n = windowArray.length;
        for (int i = 0; i < n; ++i) {
            ComponentPeer componentPeer = windowArray[i].getPeer();
            if (componentPeer == null || !(componentPeer instanceof XWindowPeer) || !((XWindowPeer)componentPeer).winAttr.iconsInherited) continue;
            ((XWindowPeer)componentPeer).winAttr.icons = list;
            ((XWindowPeer)componentPeer).recursivelySetIcon(list);
        }
    }

    List<IconInfo> getIconInfo() {
        return this.winAttr.icons;
    }

    void setIconHints(List<IconInfo> list) {
    }

    protected static synchronized List<IconInfo> getDefaultIconInfo() {
        if (defaultIconInfo == null) {
            defaultIconInfo = new ArrayList();
            if (XlibWrapper.dataModel == 32) {
                defaultIconInfo.add(new IconInfo(AWTIcon32_java_icon16_png.java_icon16_png));
                defaultIconInfo.add(new IconInfo(AWTIcon32_java_icon24_png.java_icon24_png));
                defaultIconInfo.add(new IconInfo(AWTIcon32_java_icon32_png.java_icon32_png));
                defaultIconInfo.add(new IconInfo(AWTIcon32_java_icon48_png.java_icon48_png));
            } else {
                defaultIconInfo.add(new IconInfo(AWTIcon64_java_icon16_png.java_icon16_png));
                defaultIconInfo.add(new IconInfo(AWTIcon64_java_icon24_png.java_icon24_png));
                defaultIconInfo.add(new IconInfo(AWTIcon64_java_icon32_png.java_icon32_png));
                defaultIconInfo.add(new IconInfo(AWTIcon64_java_icon48_png.java_icon48_png));
            }
        }
        return defaultIconInfo;
    }

    private void updateShape() {
        Shape shape = AWTAccessor.getWindowAccessor().getShape((Window)this.target);
        if (shape != null) {
            this.applyShape(Region.getInstance(shape, null));
        }
    }

    private void updateOpacity() {
        float f = AWTAccessor.getWindowAccessor().getOpacity((Window)this.target);
        if (f < 1.0f) {
            this.setOpacity(f);
        }
    }

    @Override
    public void updateMinimumSize() {
        this.targetMinimumSize = this.target.isMinimumSizeSet() ? this.target.getMinimumSize() : null;
    }

    public Dimension getTargetMinimumSize() {
        return this.targetMinimumSize == null ? null : new Dimension(this.targetMinimumSize);
    }

    public XWindowPeer getOwnerPeer() {
        return this.ownerPeer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBounds(int n, int n2, int n3, int n4, int n5) {
        XToolkit.awtLock();
        try {
            boolean bl;
            Rectangle rectangle = this.getBounds();
            super.setBounds(n, n2, n3, n4, n5);
            Rectangle rectangle2 = this.getBounds();
            XSizeHints xSizeHints = this.getHints();
            this.setSizeHints(xSizeHints.get_flags() | 4L | 8L, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            XWM.setMotifDecor(this, false, 0, 0);
            boolean bl2 = !rectangle2.getSize().equals(rectangle.getSize());
            boolean bl3 = bl = !rectangle2.getLocation().equals(rectangle.getLocation());
            if (bl || bl2) {
                this.repositionSecurityWarning();
            }
            if (bl2) {
                this.postEventToEventQueue(new ComponentEvent(this.getEventSource(), 101));
            }
            if (bl) {
                this.postEventToEventQueue(new ComponentEvent(this.getEventSource(), 100));
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    void updateFocusability() {
        this.updateFocusableWindowState();
        XToolkit.awtLock();
        try {
            XWMHints xWMHints = this.getWMHints();
            xWMHints.set_flags(xWMHints.get_flags() | 1L);
            xWMHints.set_input(false);
            XlibWrapper.XSetWMHints(XToolkit.getDisplay(), this.getWindow(), xWMHints.pData);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    @Override
    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public void handleIconify() {
        this.postEvent(new WindowEvent((Window)this.target, 203));
    }

    public void handleDeiconify() {
        this.postEvent(new WindowEvent((Window)this.target, 204));
    }

    public void handleStateChange(int n, int n2) {
        this.postEvent(new WindowEvent((Window)this.target, 209, n, n2));
    }

    @Override
    public Insets insets() {
        return this.getInsets();
    }

    boolean isAutoRequestFocus() {
        if (XToolkit.isToolkitThread()) {
            return AWTAccessor.getWindowAccessor().isAutoRequestFocus((Window)this.target);
        }
        return ((Window)this.target).isAutoRequestFocus();
    }

    static XWindowPeer getNativeFocusedWindowPeer() {
        XBaseWindow xBaseWindow = XToolkit.windowToXWindow(XWindowPeer.xGetInputFocus());
        return xBaseWindow instanceof XWindowPeer ? (XWindowPeer)xBaseWindow : (xBaseWindow instanceof XFocusProxyWindow ? ((XFocusProxyWindow)xBaseWindow).getOwner() : null);
    }

    static Window getNativeFocusedWindow() {
        XWindowPeer xWindowPeer = XWindowPeer.getNativeFocusedWindowPeer();
        return xWindowPeer != null ? (Window)xWindowPeer.target : null;
    }

    boolean isFocusableWindow() {
        if (XToolkit.isToolkitThread() || SunToolkit.isAWTLockHeldByCurrentThread()) {
            return this.cachedFocusableWindow;
        }
        return ((Window)this.target).isFocusableWindow();
    }

    boolean isFocusedWindowModalBlocker() {
        return false;
    }

    long getFocusTargetWindow() {
        return this.getContentWindow();
    }

    boolean isNativelyNonFocusableWindow() {
        if (XToolkit.isToolkitThread() || SunToolkit.isAWTLockHeldByCurrentThread()) {
            return this.isSimpleWindow() || !this.cachedFocusableWindow;
        }
        return this.isSimpleWindow() || !((Window)this.target).isFocusableWindow();
    }

    public void handleWindowFocusIn_Dispatch() {
        if (EventQueue.isDispatchThread()) {
            XKeyboardFocusManagerPeer.getInstance().setCurrentFocusedWindow((Window)this.target);
            WindowEvent windowEvent = new WindowEvent((Window)this.target, 207);
            SunToolkit.setSystemGenerated(windowEvent);
            this.target.dispatchEvent(windowEvent);
        }
    }

    public void handleWindowFocusInSync(long l) {
        WindowEvent windowEvent = new WindowEvent((Window)this.target, 207);
        XKeyboardFocusManagerPeer.getInstance().setCurrentFocusedWindow((Window)this.target);
        XWindowPeer.sendEvent(windowEvent);
    }

    public void handleWindowFocusIn(long l) {
        WindowEvent windowEvent = new WindowEvent((Window)this.target, 207);
        XKeyboardFocusManagerPeer.getInstance().setCurrentFocusedWindow((Window)this.target);
        this.postEvent(XWindowPeer.wrapInSequenced(windowEvent));
    }

    public void handleWindowFocusOut(Window window, long l) {
        WindowEvent windowEvent = new WindowEvent((Window)this.target, 208, window);
        XKeyboardFocusManagerPeer.getInstance().setCurrentFocusedWindow(null);
        XKeyboardFocusManagerPeer.getInstance().setCurrentFocusOwner(null);
        this.postEvent(XWindowPeer.wrapInSequenced(windowEvent));
    }

    public void handleWindowFocusOutSync(Window window, long l) {
        WindowEvent windowEvent = new WindowEvent((Window)this.target, 208, window);
        XKeyboardFocusManagerPeer.getInstance().setCurrentFocusedWindow(null);
        XKeyboardFocusManagerPeer.getInstance().setCurrentFocusOwner(null);
        XWindowPeer.sendEvent(windowEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkIfOnNewScreen(Rectangle rectangle) {
        if (!XToolkit.localEnv.runningXinerama()) {
            return;
        }
        if (log.isLoggable(PlatformLogger.Level.FINEST)) {
            log.finest("XWindowPeer: Check if we've been moved to a new screen since we're running in Xinerama mode");
        }
        int n = rectangle.width * rectangle.height;
        int n2 = 0;
        int n3 = ((X11GraphicsDevice)this.getGraphicsConfiguration().getDevice()).getScreen();
        int n4 = 0;
        GraphicsDevice[] graphicsDeviceArray = XToolkit.localEnv.getScreenDevices();
        GraphicsConfiguration graphicsConfiguration = null;
        XToolkit.awtUnlock();
        try {
            for (int i = 0; i < graphicsDeviceArray.length; ++i) {
                int n5;
                Rectangle rectangle2 = graphicsDeviceArray[i].getDefaultConfiguration().getBounds();
                if (!rectangle.intersects(rectangle2)) continue;
                int n6 = Math.min(rectangle.x + rectangle.width, rectangle2.x + rectangle2.width) - Math.max(rectangle.x, rectangle2.x);
                int n7 = n6 * (n5 = Math.min(rectangle.y + rectangle.height, rectangle2.y + rectangle2.height) - Math.max(rectangle.y, rectangle2.y));
                if (n7 == n) {
                    n4 = i;
                    graphicsConfiguration = graphicsDeviceArray[i].getDefaultConfiguration();
                    break;
                }
                if (n7 <= n2) continue;
                n2 = n7;
                n4 = i;
                graphicsConfiguration = graphicsDeviceArray[i].getDefaultConfiguration();
            }
        }
        finally {
            XToolkit.awtLock();
        }
        if (n4 != n3) {
            if (log.isLoggable(PlatformLogger.Level.FINEST)) {
                log.finest("XWindowPeer: Moved to a new screen");
            }
            this.executeDisplayChangedOnEDT(graphicsConfiguration);
        }
    }

    private void executeDisplayChangedOnEDT(final GraphicsConfiguration graphicsConfiguration) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AWTAccessor.getComponentAccessor().setGraphicsConfiguration(XWindowPeer.this.target, graphicsConfiguration);
            }
        };
        SunToolkit.executeOnEventHandlerThread(this.target, runnable);
    }

    @Override
    public void displayChanged() {
        this.executeDisplayChangedOnEDT(this.getGraphicsConfiguration());
    }

    @Override
    public void paletteChanged() {
    }

    private Point queryXLocation() {
        return XlibUtil.translateCoordinates(this.getContentWindow(), XlibWrapper.RootWindow(XToolkit.getDisplay(), this.getScreenNumber()), new Point(0, 0));
    }

    protected Point getNewLocation(XConfigureEvent xConfigureEvent, int n, int n2) {
        Rectangle rectangle = AWTAccessor.getComponentAccessor().getBounds(this.target);
        int n3 = XWM.getWMID();
        Point point = rectangle.getLocation();
        if (xConfigureEvent.get_send_event() || n3 == 2 || XWM.isNonReparentingWM()) {
            point = new Point(xConfigureEvent.get_x() - n, xConfigureEvent.get_y() - n2);
        } else {
            switch (n3) {
                case 5: 
                case 6: 
                case 9: 
                case 11: 
                case 15: {
                    Point point2 = this.queryXLocation();
                    if (log.isLoggable(PlatformLogger.Level.FINE)) {
                        log.fine("New X location: {0}", point2);
                    }
                    if (point2 == null) break;
                    point = point2;
                    break;
                }
            }
        }
        return point;
    }

    @Override
    public void handleConfigureNotifyEvent(XEvent xEvent) {
        XConfigureEvent xConfigureEvent = xEvent.get_xconfigure();
        Point point = this.getNewLocation(xConfigureEvent, 0, 0);
        xConfigureEvent.set_x(point.x);
        xConfigureEvent.set_y(point.y);
        this.checkIfOnNewScreen(new Rectangle(xConfigureEvent.get_x(), xConfigureEvent.get_y(), xConfigureEvent.get_width(), xConfigureEvent.get_height()));
        super.handleConfigureNotifyEvent(xEvent);
        this.repositionSecurityWarning();
    }

    final void requestXFocus(long l) {
        this.requestXFocus(l, true);
    }

    final void requestXFocus() {
        this.requestXFocus(0L, false);
    }

    protected void requestXFocus(long l, boolean bl) {
        if (focusLog.isLoggable(PlatformLogger.Level.FINE)) {
            focusLog.fine("Requesting window focus");
        }
        this.requestWindowFocus(l, bl);
    }

    public final boolean focusAllowedFor() {
        if (this.isNativelyNonFocusableWindow()) {
            return false;
        }
        return !this.isModalBlocked();
    }

    public void handleFocusEvent(XEvent xEvent) {
        XFocusChangeEvent xFocusChangeEvent = xEvent.get_xfocus();
        if (focusLog.isLoggable(PlatformLogger.Level.FINE)) {
            focusLog.fine("{0}", xFocusChangeEvent);
        }
        if (this.isEventDisabled(xEvent)) {
            return;
        }
        if (xEvent.get_type() == 9) {
            if (this.focusAllowedFor() && (xFocusChangeEvent.get_mode() == 0 || xFocusChangeEvent.get_mode() == 3)) {
                this.handleWindowFocusIn(xFocusChangeEvent.get_serial());
            }
        } else if (!(xFocusChangeEvent.get_mode() != 0 && xFocusChangeEvent.get_mode() != 3 || this.isNativelyNonFocusableWindow())) {
            XWindowPeer xWindowPeer = XWindowPeer.getNativeFocusedWindowPeer();
            Object object = xWindowPeer != null ? xWindowPeer.getTarget() : null;
            Window window = null;
            if (object instanceof Window) {
                window = (Window)object;
            }
            if (xWindowPeer != null && xWindowPeer.isNativelyNonFocusableWindow()) {
                return;
            }
            if (this == xWindowPeer) {
                window = null;
            } else if (xWindowPeer instanceof XDecoratedPeer && ((XDecoratedPeer)xWindowPeer).actualFocusedWindow != null && (object = (xWindowPeer = ((XDecoratedPeer)xWindowPeer).actualFocusedWindow).getTarget()) instanceof Window && xWindowPeer.isVisible() && xWindowPeer.isNativelyNonFocusableWindow()) {
                window = (Window)object;
            }
            this.handleWindowFocusOut(window, xFocusChangeEvent.get_serial());
        }
    }

    void setSaveUnder(boolean bl) {
    }

    @Override
    public void toFront() {
        if (this.isOverrideRedirect() && this.mustControlStackPosition) {
            this.mustControlStackPosition = false;
            this.removeRootPropertyEventDispatcher();
        }
        if (this.isVisible()) {
            super.toFront();
            if (this.isFocusableWindow() && this.isAutoRequestFocus() && !this.isModalBlocked() && !this.isWithdrawn()) {
                this.requestInitialFocus();
            }
        } else {
            this.setVisible(true);
        }
    }

    @Override
    public void toBack() {
        XToolkit.awtLock();
        try {
            if (!this.isOverrideRedirect()) {
                XlibWrapper.XLowerWindow(XToolkit.getDisplay(), this.getWindow());
            } else {
                this.lowerOverrideRedirect();
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lowerOverrideRedirect() {
        HashSet<Long> hashSet = new HashSet<Long>();
        long l = 0L;
        long l2 = 0L;
        for (XWindowPeer xWindowPeer : windows) {
            l = this.getToplevelWindow(xWindowPeer.getWindow());
            if (xWindowPeer.equals(this)) {
                l2 = l;
            }
            if (l <= 0L) continue;
            hashSet.add(l);
        }
        long l3 = -1L;
        long l4 = -1L;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        XQueryTree xQueryTree = new XQueryTree(XToolkit.getDefaultRootWindow());
        try {
            if (xQueryTree.execute() > 0) {
                int n5 = xQueryTree.get_nchildren();
                long l5 = xQueryTree.get_children();
                for (n4 = 0; n4 < n5; ++n4) {
                    long l6 = Native.getWindow(l5, n4);
                    if (l6 == l2) {
                        n = n4;
                        continue;
                    }
                    if (XWindowPeer.isDesktopWindow(l6)) {
                        n2 = n4;
                        l3 = l6;
                        continue;
                    }
                    if (n3 >= 0 || !hashSet.contains(l6) || l6 == l2) continue;
                    n3 = n4;
                    l4 = l6;
                }
            }
            if ((n < n3 || n3 < 0) && n2 < n) {
                return;
            }
            long l7 = Native.allocateLongArray(2);
            Native.putLong(l7, 0, l4);
            Native.putLong(l7, 1, l2);
            XlibWrapper.XRestackWindows(XToolkit.getDisplay(), l7, 2);
            XlibWrapper.unsafe.freeMemory(l7);
            if (!this.mustControlStackPosition) {
                this.mustControlStackPosition = true;
                this.addRootPropertyEventDispatcher();
            }
        }
        finally {
            xQueryTree.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getToplevelWindow(long l) {
        long l2;
        long l3;
        long l4 = l;
        do {
            l2 = l4;
            XQueryTree xQueryTree = new XQueryTree(l4);
            try {
                if (xQueryTree.execute() == 0) {
                    long l5 = 0L;
                    return l5;
                }
                l3 = xQueryTree.get_root();
                l4 = xQueryTree.get_parent();
            }
            finally {
                xQueryTree.dispose();
            }
        } while (l4 != l3);
        return l2;
    }

    private static boolean isDesktopWindow(long l) {
        return XWM.getWM().isDesktopWindow(l);
    }

    private void updateAlwaysOnTop() {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("Promoting always-on-top state {0}", this.alwaysOnTop);
        }
        XWM.getWM().setLayer(this, this.alwaysOnTop ? 1 : 0);
    }

    @Override
    public void updateAlwaysOnTopState() {
        this.alwaysOnTop = ((Window)this.target).isAlwaysOnTop();
        if (this.ownerPeer != null) {
            XToolkit.awtLock();
            try {
                XWindowPeer.restoreTransientFor(this);
                this.applyWindowType();
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        this.updateAlwaysOnTop();
    }

    @Override
    boolean isLocationByPlatform() {
        return this.locationByPlatform;
    }

    private void promoteDefaultPosition() {
        this.locationByPlatform = ((Window)this.target).isLocationByPlatform();
        if (this.locationByPlatform) {
            XToolkit.awtLock();
            try {
                Rectangle rectangle = this.getBounds();
                XSizeHints xSizeHints = this.getHints();
                this.setSizeHints(xSizeHints.get_flags() & 0xFFFFFFFFFFFFFFFAL, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVisible(boolean bl) {
        if (!this.isVisible() && bl) {
            this.isBeforeFirstMapNotify = true;
            this.winAttr.initialFocus = this.isAutoRequestFocus();
            if (!this.winAttr.initialFocus) {
                this.suppressWmTakeFocus(true);
            }
        }
        this.updateFocusability();
        this.promoteDefaultPosition();
        if (!bl && this.warningWindow != null) {
            this.warningWindow.setSecurityWarningVisible(false, false);
        }
        boolean bl2 = this.isVisible() != bl;
        super.setVisible(bl);
        if (bl2) {
            for (Window window : ((Window)this.target).getOwnedWindows()) {
                XToolkit.awtLock();
                try {
                    ComponentPeer componentPeer;
                    if (window.isLightweight() || !window.isVisible() || !((componentPeer = AWTAccessor.getComponentAccessor().getPeer(window)) instanceof XWindowPeer)) continue;
                    XWindowPeer xWindowPeer = (XWindowPeer)componentPeer;
                    XWindowPeer.restoreTransientFor(xWindowPeer);
                    xWindowPeer.applyWindowType();
                }
                finally {
                    XToolkit.awtUnlock();
                }
            }
        }
        if (!bl && !this.isWithdrawn()) {
            XToolkit.awtLock();
            try {
                XUnmapEvent xUnmapEvent = new XUnmapEvent();
                xUnmapEvent.set_window(this.window);
                xUnmapEvent.set_event(XToolkit.getDefaultRootWindow());
                xUnmapEvent.set_type(18);
                xUnmapEvent.set_from_configure(false);
                XlibWrapper.XSendEvent(XToolkit.getDisplay(), XToolkit.getDefaultRootWindow(), false, 0x180000L, xUnmapEvent.pData);
                xUnmapEvent.dispose();
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        if (this.isOverrideRedirect() && bl) {
            this.updateChildrenSizes();
        }
        this.repositionSecurityWarning();
    }

    protected void suppressWmTakeFocus(boolean bl) {
    }

    final boolean isSimpleWindow() {
        return !(this.target instanceof Frame) && !(this.target instanceof Dialog);
    }

    boolean hasWarningWindow() {
        return ((Window)this.target).getWarningString() != null;
    }

    int getMenuBarHeight() {
        return 0;
    }

    void updateChildrenSizes() {
    }

    @Override
    public void repositionSecurityWarning() {
        if (this.warningWindow != null) {
            AWTAccessor.ComponentAccessor componentAccessor = AWTAccessor.getComponentAccessor();
            int n = componentAccessor.getX(this.target);
            int n2 = componentAccessor.getY(this.target);
            int n3 = componentAccessor.getWidth(this.target);
            int n4 = componentAccessor.getHeight(this.target);
            this.warningWindow.reposition(n, n2, n3, n4);
        }
    }

    @Override
    protected void setMouseAbove(boolean bl) {
        super.setMouseAbove(bl);
        this.updateSecurityWarningVisibility();
    }

    @Override
    public void setFullScreenExclusiveModeState(boolean bl) {
        super.setFullScreenExclusiveModeState(bl);
        this.updateSecurityWarningVisibility();
    }

    public void updateSecurityWarningVisibility() {
        if (this.warningWindow == null) {
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        boolean bl = false;
        if (!this.isFullScreenExclusiveMode()) {
            int n = this.getWMState();
            if (this.isVisible() && (n == 1 || this.isSimpleWindow())) {
                if (XKeyboardFocusManagerPeer.getInstance().getCurrentFocusedWindow() == this.getTarget()) {
                    bl = true;
                }
                if (this.isMouseAbove() || this.warningWindow.isMouseAbove()) {
                    bl = true;
                }
            }
        }
        this.warningWindow.setSecurityWarningVisible(bl, true);
    }

    boolean isOverrideRedirect() {
        return XWM.getWMID() == 4 || Window.Type.POPUP.equals((Object)this.getWindowType());
    }

    final boolean isOLWMDecorBug() {
        return XWM.getWMID() == 4 && !this.winAttr.nativeDecor;
    }

    @Override
    public void dispose() {
        if (this.isGrabbed()) {
            if (grabLog.isLoggable(PlatformLogger.Level.FINE)) {
                grabLog.fine("Generating UngrabEvent on {0} because of the window disposal", this);
            }
            this.postEventToEventQueue(new UngrabEvent(this.getEventSource()));
        }
        SunToolkit.awtLock();
        try {
            windows.remove(this);
        }
        finally {
            SunToolkit.awtUnlock();
        }
        if (this.warningWindow != null) {
            this.warningWindow.destroy();
        }
        this.removeRootPropertyEventDispatcher();
        this.mustControlStackPosition = false;
        super.dispose();
        if (this.isSimpleWindow() && this.target == XKeyboardFocusManagerPeer.getInstance().getCurrentFocusedWindow()) {
            Window window = XWindowPeer.getDecoratedOwner((Window)this.target);
            ((XWindowPeer)AWTAccessor.getComponentAccessor().getPeer(window)).requestWindowFocus();
        }
    }

    @Override
    boolean isResizable() {
        return this.winAttr.isResizable;
    }

    @Override
    public void handleVisibilityEvent(XEvent xEvent) {
        super.handleVisibilityEvent(xEvent);
        XVisibilityEvent xVisibilityEvent = xEvent.get_xvisibility();
        this.winAttr.visibilityState = xVisibilityEvent.get_state();
        this.repositionSecurityWarning();
    }

    void handleRootPropertyNotify(XEvent xEvent) {
        XPropertyEvent xPropertyEvent = xEvent.get_xproperty();
        if (this.mustControlStackPosition && xPropertyEvent.get_atom() == XAtom.get("_NET_CLIENT_LIST_STACKING").getAtom() && this.isOverrideRedirect()) {
            this.toBack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeStartupNotification() {
        byte[] byArray;
        if (isStartupNotificationRemoved.getAndSet(true)) {
            return;
        }
        String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return XToolkit.getEnv("DESKTOP_STARTUP_ID");
            }
        });
        if (string == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("remove: ID=");
        stringBuilder.append('\"');
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\"' || string.charAt(i) == '\\') {
                stringBuilder.append('\\');
            }
            stringBuilder.append(string.charAt(i));
        }
        stringBuilder.append('\"');
        stringBuilder.append('\u0000');
        try {
            byArray = stringBuilder.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return;
        }
        XClientMessageEvent xClientMessageEvent = null;
        XToolkit.awtLock();
        try {
            XAtom xAtom = XAtom.get("_NET_STARTUP_INFO_BEGIN");
            XAtom xAtom2 = XAtom.get("_NET_STARTUP_INFO");
            xClientMessageEvent = new XClientMessageEvent();
            xClientMessageEvent.set_type(33);
            xClientMessageEvent.set_window(this.getWindow());
            xClientMessageEvent.set_message_type(xAtom.getAtom());
            xClientMessageEvent.set_format(8);
            for (int i = 0; i < byArray.length; i += 20) {
                int n;
                int n2 = Math.min(byArray.length - i, 20);
                for (n = 0; n < n2; ++n) {
                    XlibWrapper.unsafe.putByte(xClientMessageEvent.get_data() + (long)n, byArray[i + n]);
                }
                while (n < 20) {
                    XlibWrapper.unsafe.putByte(xClientMessageEvent.get_data() + (long)n, (byte)0);
                    ++n;
                }
                XlibWrapper.XSendEvent(XToolkit.getDisplay(), XlibWrapper.RootWindow(XToolkit.getDisplay(), this.getScreenNumber()), false, 0x400000L, xClientMessageEvent.pData);
                xClientMessageEvent.set_message_type(xAtom2.getAtom());
            }
        }
        finally {
            XToolkit.awtUnlock();
            if (xClientMessageEvent != null) {
                xClientMessageEvent.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMapNotifyEvent(XEvent xEvent) {
        this.removeStartupNotification();
        this.isUnhiding |= this.isWMStateNetHidden();
        super.handleMapNotifyEvent(xEvent);
        if (!this.winAttr.initialFocus) {
            this.suppressWmTakeFocus(false);
            XToolkit.awtLock();
            try {
                XlibWrapper.XRaiseWindow(XToolkit.getDisplay(), this.getWindow());
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        if (this.shouldFocusOnMapNotify()) {
            focusLog.fine("Automatically request focus on window");
            this.requestInitialFocus();
        }
        this.isUnhiding = false;
        this.isBeforeFirstMapNotify = false;
        this.updateAlwaysOnTop();
        Object object = this.getStateLock();
        synchronized (object) {
            if (!this.isMapped) {
                this.isMapped = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleUnmapNotifyEvent(XEvent xEvent) {
        super.handleUnmapNotifyEvent(xEvent);
        this.isUnhiding |= this.isWMStateNetHidden();
        Object object = this.getStateLock();
        synchronized (object) {
            if (this.isMapped) {
                this.isMapped = false;
            }
        }
    }

    private boolean shouldFocusOnMapNotify() {
        boolean bl = false;
        bl = this.isBeforeFirstMapNotify ? this.winAttr.initialFocus || this.isFocusedWindowModalBlocker() : this.isUnhiding;
        bl = bl && this.isFocusableWindow() && !this.isModalBlocked();
        return bl;
    }

    protected boolean isWMStateNetHidden() {
        XNETProtocol xNETProtocol = XWM.getWM().getNETProtocol();
        return xNETProtocol != null && xNETProtocol.isWMStateNetHidden(this);
    }

    protected void requestInitialFocus() {
        this.requestXFocus();
    }

    public void addToplevelStateListener(ToplevelStateListener toplevelStateListener) {
        this.toplevelStateListeners.add(toplevelStateListener);
    }

    public void removeToplevelStateListener(ToplevelStateListener toplevelStateListener) {
        this.toplevelStateListeners.remove(toplevelStateListener);
    }

    @Override
    protected void stateChanged(long l, int n, int n2) {
        this.updateTransientFor();
        for (ToplevelStateListener toplevelStateListener : this.toplevelStateListeners) {
            toplevelStateListener.stateChangedICCCM(n, n2);
        }
        this.updateSecurityWarningVisibility();
    }

    boolean isWithdrawn() {
        return this.getWMState() == 0;
    }

    boolean hasDecorations(int n) {
        boolean bl;
        if (!this.winAttr.nativeDecor) {
            return false;
        }
        int n2 = this.winAttr.decorations;
        boolean bl2 = bl = (n2 & n) == n;
        if ((n2 & XWindowAttributesData.AWT_DECOR_ALL) != 0) {
            return !bl;
        }
        return bl;
    }

    @Override
    void setReparented(boolean bl) {
        super.setReparented(bl);
        XToolkit.awtLock();
        try {
            if (this.isReparented() && this.delayedModalBlocking) {
                this.addToTransientFors((XDialogPeer)AWTAccessor.getComponentAccessor().getPeer(this.modalBlocker));
                this.delayedModalBlocking = false;
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Vector<XWindowPeer> collectJavaToplevels() {
        long l;
        int n;
        Vector<XWindowPeer> vector = new Vector<XWindowPeer>();
        Vector<Long> vector2 = new Vector<Long>();
        X11GraphicsEnvironment x11GraphicsEnvironment = (X11GraphicsEnvironment)GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = x11GraphicsEnvironment.getScreenDevices();
        if (!x11GraphicsEnvironment.runningXinerama() && graphicsDeviceArray.length > 1) {
            for (GraphicsDevice object : graphicsDeviceArray) {
                n = ((X11GraphicsDevice)object).getScreen();
                l = XlibWrapper.RootWindow(XToolkit.getDisplay(), n);
                vector2.add(l);
            }
        } else {
            vector2.add(XToolkit.getDefaultRootWindow());
        }
        int n2 = windows.size();
        while (vector2.size() > 0 && vector.size() < n2) {
            long l2 = (Long)vector2.remove(0);
            XQueryTree xQueryTree = new XQueryTree(l2);
            try {
                if (xQueryTree.execute() == 0) continue;
                n = xQueryTree.get_nchildren();
                l = xQueryTree.get_children();
                for (int i = 0; i < n; ++i) {
                    long l3 = Native.getWindow(l, i);
                    XBaseWindow xBaseWindow = XToolkit.windowToXWindow(l3);
                    if (xBaseWindow != null && !(xBaseWindow instanceof XWindowPeer)) continue;
                    vector2.add(l3);
                    if (!(xBaseWindow instanceof XWindowPeer)) continue;
                    XWindowPeer xWindowPeer = (XWindowPeer)xBaseWindow;
                    vector.add(xWindowPeer);
                    int n3 = 0;
                    XWindowPeer xWindowPeer2 = vector.get(n3);
                    while (xWindowPeer2 != xWindowPeer) {
                        XWindowPeer xWindowPeer3 = xWindowPeer2.getOwnerPeer();
                        if (xWindowPeer3 == xWindowPeer) {
                            vector.remove(n3);
                            vector.add(xWindowPeer2);
                        } else {
                            ++n3;
                        }
                        xWindowPeer2 = vector.get(n3);
                    }
                }
            }
            finally {
                xQueryTree.dispose();
            }
        }
        return vector;
    }

    @Override
    public void setModalBlocked(Dialog dialog, boolean bl) {
        this.setModalBlocked(dialog, bl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModalBlocked(Dialog dialog, boolean bl, Vector<XWindowPeer> vector) {
        XToolkit.awtLock();
        try {
            Object object = this.getStateLock();
            synchronized (object) {
                XDialogPeer xDialogPeer = (XDialogPeer)AWTAccessor.getComponentAccessor().getPeer(dialog);
                if (bl) {
                    if (log.isLoggable(PlatformLogger.Level.FINE)) {
                        log.fine("{0} is blocked by {1}", this, xDialogPeer);
                    }
                    this.modalBlocker = dialog;
                    if (this.isReparented() || XWM.isNonReparentingWM()) {
                        this.addToTransientFors(xDialogPeer, vector);
                    } else {
                        this.delayedModalBlocking = true;
                    }
                } else {
                    if (dialog != this.modalBlocker) {
                        throw new IllegalStateException("Trying to unblock window blocked by another dialog");
                    }
                    this.modalBlocker = null;
                    if (this.isReparented() || XWM.isNonReparentingWM()) {
                        this.removeFromTransientFors();
                    } else {
                        this.delayedModalBlocking = false;
                    }
                }
                this.updateTransientFor();
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    static void setToplevelTransientFor(XWindowPeer xWindowPeer, XWindowPeer xWindowPeer2, boolean bl, boolean bl2) {
        XLightweightFramePeer xLightweightFramePeer;
        long l;
        if (xWindowPeer == null || xWindowPeer2 == null) {
            return;
        }
        if (bl) {
            xWindowPeer.prevTransientFor = xWindowPeer2;
            xWindowPeer2.nextTransientFor = xWindowPeer;
        }
        if (!bl2 && xWindowPeer.getWMState() != xWindowPeer2.getWMState()) {
            return;
        }
        if (xWindowPeer.getScreenNumber() != xWindowPeer2.getScreenNumber()) {
            return;
        }
        long l2 = xWindowPeer.getWindow();
        while (!XlibUtil.isToplevelWindow(l2) && !XlibUtil.isXAWTToplevelWindow(l2)) {
            l2 = XlibUtil.getParentWindow(l2);
        }
        long l3 = xWindowPeer2.getWindow();
        XBaseWindow xBaseWindow = xWindowPeer2;
        while (!(l3 == 0L || (XlibUtil.isToplevelWindow(l3) || XlibUtil.isXAWTToplevelWindow(l3)) && xBaseWindow.isVisible())) {
            l3 = XlibUtil.getParentWindow(l3);
            xBaseWindow = XToolkit.windowToXWindow(l3);
        }
        if (xBaseWindow instanceof XLightweightFramePeer && (l = (xLightweightFramePeer = (XLightweightFramePeer)xBaseWindow).getOverriddenWindowHandle()) != 0L) {
            l3 = l;
        }
        XlibWrapper.XSetTransientFor(XToolkit.getDisplay(), l2, l3);
        xWindowPeer.curRealTransientFor = xBaseWindow;
    }

    void updateTransientFor() {
        int n = this.getWMState();
        XWindowPeer xWindowPeer = this.prevTransientFor;
        while (xWindowPeer != null && (xWindowPeer.getWMState() != n || xWindowPeer.getScreenNumber() != this.getScreenNumber())) {
            xWindowPeer = xWindowPeer.prevTransientFor;
        }
        if (xWindowPeer != null) {
            XWindowPeer.setToplevelTransientFor(this, xWindowPeer, false, false);
        } else {
            XWindowPeer.restoreTransientFor(this);
        }
        XWindowPeer xWindowPeer2 = this.nextTransientFor;
        while (xWindowPeer2 != null && (xWindowPeer2.getWMState() != n || xWindowPeer2.getScreenNumber() != this.getScreenNumber())) {
            xWindowPeer2 = xWindowPeer2.nextTransientFor;
        }
        if (xWindowPeer2 != null) {
            XWindowPeer.setToplevelTransientFor(xWindowPeer2, this, false, false);
        }
    }

    private static void removeTransientForHint(XWindowPeer xWindowPeer) {
        XAtom xAtom = XAtom.get(68L);
        long l = xWindowPeer.getWindow();
        while (!XlibUtil.isToplevelWindow(l) && !XlibUtil.isXAWTToplevelWindow(l)) {
            l = XlibUtil.getParentWindow(l);
        }
        XlibWrapper.XDeleteProperty(XToolkit.getDisplay(), l, xAtom.getAtom());
        xWindowPeer.curRealTransientFor = null;
    }

    private void addToTransientFors(XDialogPeer xDialogPeer) {
        this.addToTransientFors(xDialogPeer, null);
    }

    private void addToTransientFors(XDialogPeer xDialogPeer, Vector<XWindowPeer> vector) {
        XWindowPeer xWindowPeer = xDialogPeer;
        while (xWindowPeer.prevTransientFor != null) {
            xWindowPeer = xWindowPeer.prevTransientFor;
        }
        XWindowPeer xWindowPeer2 = this;
        while (xWindowPeer2.prevTransientFor != null) {
            xWindowPeer2 = xWindowPeer2.prevTransientFor;
        }
        if (xWindowPeer == xDialogPeer) {
            XWindowPeer.setToplevelTransientFor(xDialogPeer, this, true, false);
        } else {
            if (vector == null) {
                vector = XWindowPeer.collectJavaToplevels();
            }
            XWindowPeer xWindowPeer3 = null;
            for (XWindowPeer xWindowPeer4 : vector) {
                XWindowPeer xWindowPeer5 = xWindowPeer3;
                if (xWindowPeer4 == xWindowPeer2) {
                    if (xWindowPeer2 == this) {
                        if (xWindowPeer5 != null) {
                            XWindowPeer.setToplevelTransientFor(this, xWindowPeer5, true, false);
                        }
                        XWindowPeer.setToplevelTransientFor(xWindowPeer, this, true, false);
                        break;
                    }
                    xWindowPeer3 = xWindowPeer2;
                    xWindowPeer2 = xWindowPeer2.nextTransientFor;
                } else {
                    if (xWindowPeer4 != xWindowPeer) continue;
                    xWindowPeer3 = xWindowPeer;
                    xWindowPeer = xWindowPeer.nextTransientFor;
                }
                if (xWindowPeer5 == null) {
                    xWindowPeer3.prevTransientFor = null;
                } else {
                    XWindowPeer.setToplevelTransientFor(xWindowPeer3, xWindowPeer5, true, false);
                    xWindowPeer3.updateTransientFor();
                }
                if (xWindowPeer != xDialogPeer) continue;
                XWindowPeer.setToplevelTransientFor(xWindowPeer2, xWindowPeer3, true, false);
                XWindowPeer.setToplevelTransientFor(xWindowPeer, this, true, false);
                break;
            }
        }
        XToolkit.XSync();
    }

    static void restoreTransientFor(XWindowPeer xWindowPeer) {
        XWindowPeer xWindowPeer2 = xWindowPeer.getOwnerPeer();
        if (xWindowPeer2 != null) {
            XWindowPeer.setToplevelTransientFor(xWindowPeer, xWindowPeer2, false, true);
        } else {
            XWindowPeer.removeTransientForHint(xWindowPeer);
        }
    }

    private void removeFromTransientFors() {
        XWindowPeer xWindowPeer = this;
        XWindowPeer xWindowPeer2 = this.nextTransientFor;
        HashSet<XWindowPeer> hashSet = new HashSet<XWindowPeer>();
        hashSet.add(this);
        XWindowPeer xWindowPeer3 = this.prevTransientFor;
        while (xWindowPeer3 != null) {
            XWindowPeer xWindowPeer4 = (XWindowPeer)AWTAccessor.getComponentAccessor().getPeer(xWindowPeer3.modalBlocker);
            if (hashSet.contains(xWindowPeer4)) {
                XWindowPeer.setToplevelTransientFor(xWindowPeer, xWindowPeer3, true, false);
                xWindowPeer = xWindowPeer3;
                hashSet.add(xWindowPeer3);
            } else {
                XWindowPeer.setToplevelTransientFor(xWindowPeer2, xWindowPeer3, true, false);
                xWindowPeer2 = xWindowPeer3;
            }
            xWindowPeer3 = xWindowPeer3.prevTransientFor;
        }
        XWindowPeer.restoreTransientFor(xWindowPeer);
        xWindowPeer.prevTransientFor = null;
        XWindowPeer.restoreTransientFor(xWindowPeer2);
        xWindowPeer2.prevTransientFor = null;
        this.nextTransientFor = null;
        XToolkit.XSync();
    }

    boolean isModalBlocked() {
        return this.modalBlocker != null;
    }

    static Window getDecoratedOwner(Window window) {
        while (null != window && !(window instanceof Frame) && !(window instanceof Dialog)) {
            window = (Window)AWTAccessor.getComponentAccessor().getParent(window);
        }
        return window;
    }

    public boolean requestWindowFocus(XWindowPeer xWindowPeer) {
        this.setActualFocusedWindow(xWindowPeer);
        return this.requestWindowFocus();
    }

    public boolean requestWindowFocus() {
        return this.requestWindowFocus(0L, false);
    }

    public boolean requestWindowFocus(long l, boolean bl) {
        focusLog.fine("Request for window focus");
        Window window = XWindowPeer.getDecoratedOwner((Window)this.target);
        Window window2 = XKeyboardFocusManagerPeer.getInstance().getCurrentFocusedWindow();
        Window window3 = XWindowPeer.getDecoratedOwner(window2);
        if (this.isWMStateNetHidden()) {
            focusLog.fine("The window is unmapped, so rejecting the request");
            return false;
        }
        if (window3 == window) {
            focusLog.fine("Parent window is active - generating focus for this window");
            this.handleWindowFocusInSync(-1L);
            return true;
        }
        focusLog.fine("Parent window is not active");
        XDecoratedPeer xDecoratedPeer = (XDecoratedPeer)AWTAccessor.getComponentAccessor().getPeer(window);
        if (xDecoratedPeer != null && xDecoratedPeer.requestWindowFocus(this, l, bl)) {
            focusLog.fine("Parent window accepted focus request - generating focus for this window");
            return true;
        }
        focusLog.fine("Denied - parent window is not active and didn't accept focus request");
        return false;
    }

    void setActualFocusedWindow(XWindowPeer xWindowPeer) {
    }

    private void applyWindowType() {
        XNETProtocol xNETProtocol = XWM.getWM().getNETProtocol();
        if (xNETProtocol == null) {
            return;
        }
        XAtom xAtom = null;
        switch (this.getWindowType()) {
            case NORMAL: {
                xAtom = this.curRealTransientFor == null ? xNETProtocol.XA_NET_WM_WINDOW_TYPE_NORMAL : xNETProtocol.XA_NET_WM_WINDOW_TYPE_DIALOG;
                break;
            }
            case UTILITY: {
                xAtom = xNETProtocol.XA_NET_WM_WINDOW_TYPE_UTILITY;
                break;
            }
            case POPUP: {
                xAtom = xNETProtocol.XA_NET_WM_WINDOW_TYPE_POPUP_MENU;
            }
        }
        if (xAtom != null) {
            XAtomList xAtomList = new XAtomList();
            xAtomList.add(xAtom);
            xNETProtocol.XA_NET_WM_WINDOW_TYPE.setAtomListProperty(this.getWindow(), xAtomList);
        } else {
            xNETProtocol.XA_NET_WM_WINDOW_TYPE.DeleteProperty(this.getWindow());
        }
    }

    @Override
    public void xSetVisible(boolean bl) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("Setting visible on " + this + " to " + bl);
        }
        XToolkit.awtLock();
        try {
            this.visible = bl;
            if (bl) {
                this.applyWindowType();
                XlibWrapper.XMapRaised(XToolkit.getDisplay(), this.getWindow());
            } else {
                XlibWrapper.XUnmapWindow(XToolkit.getDisplay(), this.getWindow());
            }
            XlibWrapper.XFlush(XToolkit.getDisplay());
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    public void addDropTarget() {
        XToolkit.awtLock();
        try {
            long l;
            if (this.dropTargetCount == 0 && (l = this.getWindow()) != 0L) {
                XDropTargetRegistry.getRegistry().registerDropSite(l);
            }
            ++this.dropTargetCount;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    public void removeDropTarget() {
        XToolkit.awtLock();
        try {
            long l;
            --this.dropTargetCount;
            if (this.dropTargetCount == 0 && (l = this.getWindow()) != 0L) {
                XDropTargetRegistry.getRegistry().unregisterDropSite(l);
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    void addRootPropertyEventDispatcher() {
        if (this.rootPropertyEventDispatcher == null) {
            this.rootPropertyEventDispatcher = new XEventDispatcher(){

                @Override
                public void dispatchEvent(XEvent xEvent) {
                    if (xEvent.get_type() == 28) {
                        XWindowPeer.this.handleRootPropertyNotify(xEvent);
                    }
                }
            };
            XlibWrapper.XSelectInput(XToolkit.getDisplay(), XToolkit.getDefaultRootWindow(), 0x400000L);
            XToolkit.addEventDispatcher(XToolkit.getDefaultRootWindow(), this.rootPropertyEventDispatcher);
        }
    }

    void removeRootPropertyEventDispatcher() {
        if (this.rootPropertyEventDispatcher != null) {
            XToolkit.removeEventDispatcher(XToolkit.getDefaultRootWindow(), this.rootPropertyEventDispatcher);
            this.rootPropertyEventDispatcher = null;
        }
    }

    @Override
    public void updateFocusableWindowState() {
        this.cachedFocusableWindow = this.isFocusableWindow();
    }

    public XAtomList getNETWMState() {
        if (this.net_wm_state == null) {
            this.net_wm_state = this.XA_NET_WM_STATE.getAtomListPropertyList(this);
        }
        return this.net_wm_state;
    }

    public void setNETWMState(XAtomList xAtomList) {
        this.net_wm_state = xAtomList;
        if (xAtomList != null) {
            this.XA_NET_WM_STATE.setAtomListProperty((XBaseWindow)this, xAtomList);
        }
    }

    @Override
    public PropMwmHints getMWMHints() {
        if (this.mwm_hints == null) {
            this.mwm_hints = new PropMwmHints();
            if (!XWM.XA_MWM_HINTS.getAtomData(this.getWindow(), this.mwm_hints.pData, 5)) {
                this.mwm_hints.zero();
            }
        }
        return this.mwm_hints;
    }

    @Override
    public void setMWMHints(PropMwmHints propMwmHints) {
        this.mwm_hints = propMwmHints;
        if (propMwmHints != null) {
            XWM.XA_MWM_HINTS.setAtomData(this.getWindow(), this.mwm_hints.pData, 5);
        }
    }

    protected void updateDropTarget() {
        XToolkit.awtLock();
        try {
            long l;
            if (this.dropTargetCount > 0 && (l = this.getWindow()) != 0L) {
                XDropTargetRegistry.getRegistry().unregisterDropSite(l);
                XDropTargetRegistry.getRegistry().registerDropSite(l);
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    public void setGrab(boolean bl) {
        this.grab = bl;
        if (bl) {
            this.pressTarget = this;
            this.grabInput();
        } else {
            XWindowPeer.ungrabInput();
        }
    }

    public boolean isGrabbed() {
        return this.grab && XAwtState.getGrabWindow() == this;
    }

    @Override
    public void handleXCrossingEvent(XEvent xEvent) {
        XCrossingEvent xCrossingEvent = xEvent.get_xcrossing();
        if (grabLog.isLoggable(PlatformLogger.Level.FINE)) {
            grabLog.fine("{0}, when grabbed {1}, contains {2}", xCrossingEvent, this.isGrabbed(), this.containsGlobal(xCrossingEvent.get_x_root(), xCrossingEvent.get_y_root()));
        }
        if (this.isGrabbed()) {
            XBaseWindow xBaseWindow = XToolkit.windowToXWindow(xCrossingEvent.get_window());
            if (grabLog.isLoggable(PlatformLogger.Level.FINER)) {
                grabLog.finer("  -  Grab event target {0}", xBaseWindow);
            }
            if (xBaseWindow != null && xBaseWindow != this) {
                xBaseWindow.dispatchEvent(xEvent);
                return;
            }
        }
        super.handleXCrossingEvent(xEvent);
    }

    @Override
    public void handleMotionNotify(XEvent xEvent) {
        XMotionEvent xMotionEvent = xEvent.get_xmotion();
        if (grabLog.isLoggable(PlatformLogger.Level.FINER)) {
            grabLog.finer("{0}, when grabbed {1}, contains {2}", xMotionEvent, this.isGrabbed(), this.containsGlobal(xMotionEvent.get_x_root(), xMotionEvent.get_y_root()));
        }
        if (this.isGrabbed()) {
            boolean bl = false;
            int n = XToolkit.getNumberOfButtonsForMask();
            for (int i = 0; i < n; ++i) {
                if (i == 4 || i == 5) continue;
                bl = bl || (xMotionEvent.get_state() & XlibUtil.getButtonMask(i + 1)) != 0;
            }
            XBaseWindow xBaseWindow = XToolkit.windowToXWindow(xMotionEvent.get_window());
            if (bl && this.pressTarget != xBaseWindow) {
                xBaseWindow = this.pressTarget.isVisible() ? this.pressTarget : this;
                xMotionEvent.set_window(xBaseWindow.getWindow());
                Point point = xBaseWindow.toLocal(xMotionEvent.get_x_root(), xMotionEvent.get_y_root());
                xMotionEvent.set_x(point.x);
                xMotionEvent.set_y(point.y);
            }
            if (grabLog.isLoggable(PlatformLogger.Level.FINER)) {
                grabLog.finer("  -  Grab event target {0}", xBaseWindow);
            }
            if (xBaseWindow != null && xBaseWindow != this.getContentXWindow() && xBaseWindow != this) {
                xBaseWindow.dispatchEvent(xEvent);
                return;
            }
            if (!this.containsGlobal(xMotionEvent.get_x_root(), xMotionEvent.get_y_root()) && !bl) {
                return;
            }
        }
        super.handleMotionNotify(xEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleButtonPressRelease(XEvent xEvent) {
        block42: {
            block44: {
                Object object;
                XBaseWindow xBaseWindow;
                XButtonEvent xButtonEvent;
                block39: {
                    block40: {
                        block43: {
                            block41: {
                                xButtonEvent = xEvent.get_xbutton();
                                if (xButtonEvent.get_button() > 20) {
                                    return;
                                }
                                if (grabLog.isLoggable(PlatformLogger.Level.FINE)) {
                                    grabLog.fine("{0}, when grabbed {1}, contains {2} ({3}, {4}, {5}x{6})", xButtonEvent, this.isGrabbed(), this.containsGlobal(xButtonEvent.get_x_root(), xButtonEvent.get_y_root()), this.getAbsoluteX(), this.getAbsoluteY(), this.getWidth(), this.getHeight());
                                }
                                if (!this.isGrabbed()) break block42;
                                xBaseWindow = XToolkit.windowToXWindow(xButtonEvent.get_window());
                                try {
                                    if (grabLog.isLoggable(PlatformLogger.Level.FINER)) {
                                        grabLog.finer("  -  Grab event target {0} (press target {1})", xBaseWindow, this.pressTarget);
                                    }
                                    if (xButtonEvent.get_type() == 4 && xButtonEvent.get_button() == XConstants.buttons[0]) {
                                        this.pressTarget = xBaseWindow;
                                    } else if (xButtonEvent.get_type() == 5 && xButtonEvent.get_button() == XConstants.buttons[0] && this.pressTarget != xBaseWindow) {
                                        xBaseWindow = this.pressTarget.isVisible() ? this.pressTarget : this;
                                        xButtonEvent.set_window(xBaseWindow.getWindow());
                                        object = xBaseWindow.toLocal(xButtonEvent.get_x_root(), xButtonEvent.get_y_root());
                                        xButtonEvent.set_x(((Point)object).x);
                                        xButtonEvent.set_y(((Point)object).y);
                                        this.pressTarget = this;
                                    }
                                    if (xBaseWindow == null || xBaseWindow == this.getContentXWindow() || xBaseWindow == this) break block39;
                                    xBaseWindow.dispatchEvent(xEvent);
                                    if (xBaseWindow == null) break block40;
                                    if (xBaseWindow == this) break block41;
                                }
                                catch (Throwable throwable) {
                                    if (xBaseWindow != null) {
                                        if (!(xBaseWindow != this && xBaseWindow != this.getContentXWindow() || this.containsGlobal(xButtonEvent.get_x_root(), xButtonEvent.get_y_root()) || xButtonEvent.get_type() != 4)) {
                                            if (grabLog.isLoggable(PlatformLogger.Level.FINE)) {
                                                grabLog.fine("Generating UngrabEvent on {0} because not inside of shell", this);
                                            }
                                            this.postEventToEventQueue(new UngrabEvent(this.getEventSource()));
                                            return;
                                        }
                                        XWindowPeer xWindowPeer = xBaseWindow.getToplevelXWindow();
                                        if (xWindowPeer != null) {
                                            Window window = (Window)xWindowPeer.target;
                                            while (window != null && xWindowPeer != this && !(xWindowPeer instanceof XDialogPeer)) {
                                                window = (Window)AWTAccessor.getComponentAccessor().getParent(window);
                                                if (window == null) continue;
                                                xWindowPeer = (XWindowPeer)AWTAccessor.getComponentAccessor().getPeer(window);
                                            }
                                            if (window != null) {
                                                if (window == this.target) throw throwable;
                                                if (!(window instanceof Dialog)) throw throwable;
                                            }
                                            if (grabLog.isLoggable(PlatformLogger.Level.FINE)) {
                                                grabLog.fine("Generating UngrabEvent on {0} because hierarchy ended", this);
                                            }
                                            this.postEventToEventQueue(new UngrabEvent(this.getEventSource()));
                                            throw throwable;
                                        }
                                        if (grabLog.isLoggable(PlatformLogger.Level.FINE)) {
                                            grabLog.fine("Generating UngrabEvent on {0} because toplevel is null", this);
                                        }
                                        this.postEventToEventQueue(new UngrabEvent(this.getEventSource()));
                                        return;
                                    }
                                    if (grabLog.isLoggable(PlatformLogger.Level.FINE)) {
                                        grabLog.fine("Generating UngrabEvent on because target is null {0}", this);
                                    }
                                    this.postEventToEventQueue(new UngrabEvent(this.getEventSource()));
                                    return;
                                }
                                if (xBaseWindow != this.getContentXWindow()) break block43;
                            }
                            if (!this.containsGlobal(xButtonEvent.get_x_root(), xButtonEvent.get_y_root()) && xButtonEvent.get_type() == 4) {
                                if (grabLog.isLoggable(PlatformLogger.Level.FINE)) {
                                    grabLog.fine("Generating UngrabEvent on {0} because not inside of shell", this);
                                }
                                this.postEventToEventQueue(new UngrabEvent(this.getEventSource()));
                                return;
                            }
                        }
                        if ((object = xBaseWindow.getToplevelXWindow()) != null) {
                            Window window = (Window)((XWindowPeer)object).target;
                            while (window != null && object != this && !(object instanceof XDialogPeer)) {
                                window = (Window)AWTAccessor.getComponentAccessor().getParent(window);
                                if (window == null) continue;
                                object = (XWindowPeer)AWTAccessor.getComponentAccessor().getPeer(window);
                            }
                            if (window != null) {
                                if (window == this.target) return;
                                if (!(window instanceof Dialog)) return;
                            }
                            if (grabLog.isLoggable(PlatformLogger.Level.FINE)) {
                                grabLog.fine("Generating UngrabEvent on {0} because hierarchy ended", this);
                            }
                            this.postEventToEventQueue(new UngrabEvent(this.getEventSource()));
                            return;
                        }
                        if (grabLog.isLoggable(PlatformLogger.Level.FINE)) {
                            grabLog.fine("Generating UngrabEvent on {0} because toplevel is null", this);
                        }
                        this.postEventToEventQueue(new UngrabEvent(this.getEventSource()));
                        return;
                    }
                    if (grabLog.isLoggable(PlatformLogger.Level.FINE)) {
                        grabLog.fine("Generating UngrabEvent on because target is null {0}", this);
                    }
                    this.postEventToEventQueue(new UngrabEvent(this.getEventSource()));
                    return;
                }
                if (xBaseWindow == null) break block44;
                if (!(xBaseWindow != this && xBaseWindow != this.getContentXWindow() || this.containsGlobal(xButtonEvent.get_x_root(), xButtonEvent.get_y_root()) || xButtonEvent.get_type() != 4)) {
                    if (grabLog.isLoggable(PlatformLogger.Level.FINE)) {
                        grabLog.fine("Generating UngrabEvent on {0} because not inside of shell", this);
                    }
                    this.postEventToEventQueue(new UngrabEvent(this.getEventSource()));
                    return;
                }
                object = xBaseWindow.getToplevelXWindow();
                if (object != null) {
                    Window window = (Window)((XWindowPeer)object).target;
                    while (window != null && object != this && !(object instanceof XDialogPeer)) {
                        window = (Window)AWTAccessor.getComponentAccessor().getParent(window);
                        if (window == null) continue;
                        object = (XWindowPeer)AWTAccessor.getComponentAccessor().getPeer(window);
                    }
                    if (window == null || window != this.target && window instanceof Dialog) {
                        if (grabLog.isLoggable(PlatformLogger.Level.FINE)) {
                            grabLog.fine("Generating UngrabEvent on {0} because hierarchy ended", this);
                        }
                        this.postEventToEventQueue(new UngrabEvent(this.getEventSource()));
                    }
                    break block42;
                } else {
                    if (grabLog.isLoggable(PlatformLogger.Level.FINE)) {
                        grabLog.fine("Generating UngrabEvent on {0} because toplevel is null", this);
                    }
                    this.postEventToEventQueue(new UngrabEvent(this.getEventSource()));
                    return;
                }
            }
            if (grabLog.isLoggable(PlatformLogger.Level.FINE)) {
                grabLog.fine("Generating UngrabEvent on because target is null {0}", this);
            }
            this.postEventToEventQueue(new UngrabEvent(this.getEventSource()));
            return;
        }
        super.handleButtonPressRelease(xEvent);
    }

    @Override
    public void print(Graphics graphics) {
        Shape shape = AWTAccessor.getWindowAccessor().getShape((Window)this.target);
        if (shape != null) {
            graphics.setClip(shape);
        }
        super.print(graphics);
    }

    @Override
    public void setOpacity(float f) {
        long l = (long)(f * 4.2949673E9f);
        if (l < 0L) {
            l = 0L;
        }
        if (l > 0xFFFFFFFFL) {
            l = 0xFFFFFFFFL;
        }
        XAtom xAtom = XAtom.get("_NET_WM_WINDOW_OPACITY");
        if (l == 0xFFFFFFFFL) {
            xAtom.DeleteProperty(this.getWindow());
        } else {
            xAtom.setCard32Property(this.getWindow(), l);
        }
    }

    @Override
    public void setOpaque(boolean bl) {
    }

    @Override
    public void updateWindow() {
    }
}

