/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Iterator;
import java.util.NoSuchElementException;
import sun.nio.fs.NativeBuffer;
import sun.nio.fs.WindowsException;
import sun.nio.fs.WindowsFileAttributes;
import sun.nio.fs.WindowsNativeDispatcher;
import sun.nio.fs.WindowsPath;

class WindowsDirectoryStream
implements DirectoryStream<Path> {
    private final WindowsPath dir;
    private final DirectoryStream.Filter<? super Path> filter;
    private final long handle;
    private final String firstName;
    private final NativeBuffer findDataBuffer;
    private final Object closeLock = new Object();
    private boolean isOpen = true;
    private Iterator<Path> iterator;

    WindowsDirectoryStream(WindowsPath windowsPath, DirectoryStream.Filter<? super Path> filter) throws IOException {
        this.dir = windowsPath;
        this.filter = filter;
        try {
            String string = windowsPath.getPathForWin32Calls();
            char c = string.charAt(string.length() - 1);
            string = c == ':' || c == '\\' ? string + "*" : string + "\\*";
            WindowsNativeDispatcher.FirstFile firstFile = WindowsNativeDispatcher.FindFirstFile(string);
            this.handle = firstFile.handle();
            this.firstName = firstFile.name();
            this.findDataBuffer = WindowsFileAttributes.getBufferForFindData();
        }
        catch (WindowsException windowsException) {
            if (windowsException.lastError() == 267) {
                throw new NotDirectoryException(windowsPath.getPathForExceptionMessage());
            }
            windowsException.rethrowAsIOException(windowsPath);
            throw new AssertionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (!this.isOpen) {
                return;
            }
            this.isOpen = false;
        }
        this.findDataBuffer.release();
        try {
            WindowsNativeDispatcher.FindClose(this.handle);
        }
        catch (WindowsException windowsException) {
            windowsException.rethrowAsIOException(this.dir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Path> iterator() {
        if (!this.isOpen) {
            throw new IllegalStateException("Directory stream is closed");
        }
        WindowsDirectoryStream windowsDirectoryStream = this;
        synchronized (windowsDirectoryStream) {
            if (this.iterator != null) {
                throw new IllegalStateException("Iterator already obtained");
            }
            this.iterator = new WindowsDirectoryIterator(this.firstName);
            return this.iterator;
        }
    }

    private class WindowsDirectoryIterator
    implements Iterator<Path> {
        private boolean atEof = false;
        private String first;
        private Path nextEntry;
        private String prefix;

        WindowsDirectoryIterator(String string) {
            this.first = string;
            this.prefix = WindowsDirectoryStream.this.dir.needsSlashWhenResolving() ? WindowsDirectoryStream.this.dir.toString() + "\\" : WindowsDirectoryStream.this.dir.toString();
        }

        private boolean isSelfOrParent(String string) {
            return string.equals(".") || string.equals("..");
        }

        private Path acceptEntry(String string, BasicFileAttributes basicFileAttributes) {
            WindowsPath windowsPath = WindowsPath.createFromNormalizedPath(WindowsDirectoryStream.this.dir.getFileSystem(), this.prefix + string, basicFileAttributes);
            try {
                if (WindowsDirectoryStream.this.filter.accept(windowsPath)) {
                    return windowsPath;
                }
            }
            catch (IOException iOException) {
                throw new DirectoryIteratorException(iOException);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Path readNextEntry() {
            Object object;
            if (this.first != null) {
                this.nextEntry = this.isSelfOrParent(this.first) ? null : this.acceptEntry(this.first, null);
                this.first = null;
                if (this.nextEntry != null) {
                    return this.nextEntry;
                }
            }
            while (true) {
                WindowsFileAttributes windowsFileAttributes;
                String string = null;
                object = WindowsDirectoryStream.this.closeLock;
                synchronized (object) {
                    try {
                        if (WindowsDirectoryStream.this.isOpen) {
                            string = WindowsNativeDispatcher.FindNextFile(WindowsDirectoryStream.this.handle, WindowsDirectoryStream.this.findDataBuffer.address());
                        }
                    }
                    catch (WindowsException windowsException) {
                        IOException iOException = windowsException.asIOException(WindowsDirectoryStream.this.dir);
                        throw new DirectoryIteratorException(iOException);
                    }
                    if (string == null) {
                        this.atEof = true;
                        return null;
                    }
                    if (this.isSelfOrParent(string)) {
                        continue;
                    }
                    windowsFileAttributes = WindowsFileAttributes.fromFindData(WindowsDirectoryStream.this.findDataBuffer.address());
                }
                object = this.acceptEntry(string, windowsFileAttributes);
                if (object != null) break;
            }
            return object;
        }

        @Override
        public synchronized boolean hasNext() {
            if (this.nextEntry == null && !this.atEof) {
                this.nextEntry = this.readNextEntry();
            }
            return this.nextEntry != null;
        }

        @Override
        public synchronized Path next() {
            Path path = null;
            if (this.nextEntry == null && !this.atEof) {
                path = this.readNextEntry();
            } else {
                path = this.nextEntry;
                this.nextEntry = null;
            }
            if (path == null) {
                throw new NoSuchElementException();
            }
            return path;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

