/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.nio.channels.spi.AsynchronousChannelProvider;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;

public class DefaultAsynchronousChannelProvider {
    private DefaultAsynchronousChannelProvider() {
    }

    private static AsynchronousChannelProvider createProvider(String string) {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Object)classNotFoundException);
        }
        try {
            return (AsynchronousChannelProvider)clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            throw new AssertionError((Object)reflectiveOperationException);
        }
    }

    public static AsynchronousChannelProvider create() {
        String string = AccessController.doPrivileged(new GetPropertyAction("os.name"));
        if (string.equals("SunOS")) {
            return DefaultAsynchronousChannelProvider.createProvider("sun.nio.ch.SolarisAsynchronousChannelProvider");
        }
        if (string.equals("Linux")) {
            return DefaultAsynchronousChannelProvider.createProvider("sun.nio.ch.LinuxAsynchronousChannelProvider");
        }
        if (string.contains("OS X")) {
            return DefaultAsynchronousChannelProvider.createProvider("sun.nio.ch.BsdAsynchronousChannelProvider");
        }
        if (string.equals("AIX")) {
            return DefaultAsynchronousChannelProvider.createProvider("sun.nio.ch.AixAsynchronousChannelProvider");
        }
        throw new InternalError("platform not recognized");
    }
}

