/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.util;

import java.util.Objects;
import jdk.test.lib.util.Pair;

public class Triple<F, S, T> {
    private final Pair<F, Pair<S, T>> container;

    public Triple(F first, S second, T third) {
        this.container = new Pair<F, Pair<Pair<S, T>, T>>(first, new Pair<S, T>(second, third));
    }

    public F getFirst() {
        return this.container.first;
    }

    public S getSecond() {
        return (S)((Pair)this.container.second).first;
    }

    public T getThird() {
        return (T)((Pair)this.container.second).second;
    }

    public int hashCode() {
        return this.container.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Triple) {
            Triple objTriple = (Triple)obj;
            return Objects.equals(this.container.first, objTriple.container.first) && Objects.equals(this.container.second, objTriple.container.second);
        }
        return false;
    }

    public String toString() {
        return "(" + String.valueOf(this.getFirst()) + " : " + String.valueOf(this.getSecond()) + " : " + String.valueOf(this.getThird()) + ")";
    }
}

