/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Colors;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.color.ColorSpace;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java2d.Surface;

public class ColorConvert
extends Surface {
    private static Image img;
    private static Color[] colors;

    public ColorConvert() {
        this.setBackground(Color.white);
        img = this.getImage("clouds.jpg");
    }

    @Override
    public void render(int w, int h, Graphics2D g2) {
        int iw = img.getWidth(this);
        int ih = img.getHeight(this);
        FontRenderContext frc = g2.getFontRenderContext();
        Font font = g2.getFont();
        g2.setColor(Color.black);
        TextLayout tl = new TextLayout("ColorConvertOp RGB->GRAY", font, frc);
        tl.draw(g2, (float)((double)(w / 2) - tl.getBounds().getWidth() / 2.0), tl.getAscent() + tl.getLeading());
        BufferedImage srcImg = new BufferedImage(iw, ih, 1);
        Graphics2D srcG = srcImg.createGraphics();
        RenderingHints rhs = g2.getRenderingHints();
        srcG.setRenderingHints(rhs);
        srcG.drawImage(img, 0, 0, null);
        String s = "OpenJDK";
        Font f = new Font("Serif", 1, iw / 6);
        tl = new TextLayout(s, f, frc);
        Rectangle2D tlb = tl.getBounds();
        char[] chars = s.toCharArray();
        float charWidth = 0.0f;
        int rw = iw / chars.length;
        int rh = ih / chars.length;
        for (int i = 0; i < chars.length; ++i) {
            tl = new TextLayout(String.valueOf(chars[i]), f, frc);
            Shape shape = tl.getOutline(null);
            srcG.setColor(colors[i % colors.length]);
            tl.draw(srcG, (float)((double)(iw / 2) - tlb.getWidth() / 2.0 + (double)charWidth), (float)((double)(ih / 2) + tlb.getHeight() / 2.0));
            charWidth += (float)shape.getBounds().getWidth();
            srcG.fillRect(i * rw, ih - rh, rw, rh);
            srcG.setColor(colors[colors.length - 1 - i % colors.length]);
            srcG.fillRect(i * rw, 0, rw, rh);
        }
        ColorSpace cs = ColorSpace.getInstance(1003);
        ColorConvertOp theOp = new ColorConvertOp(cs, rhs);
        BufferedImage dstImg = new BufferedImage(iw, ih, 1);
        theOp.filter(srcImg, dstImg);
        g2.drawImage(srcImg, 10, 20, w / 2 - 20, h - 30, null);
        g2.drawImage(dstImg, w / 2 + 10, 20, w / 2 - 20, h - 30, null);
    }

    public static void main(String[] s) {
        ColorConvert.createDemoFrame(new ColorConvert());
    }

    static {
        colors = new Color[]{Color.red, Color.pink, Color.orange, Color.yellow, Color.green, Color.magenta, Color.cyan, Color.blue};
    }
}

