/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ne extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_NR = "\u0928\u093e\u0909\u0930\u0942";
        final String metaValue_WS = "\u0938\u093e\u092e\u094b\u0906";
        final String metaValue_ar = "\u0905\u0930\u092c\u0940";
        final String metaValue_bo = "\u0924\u093f\u092c\u094d\u092c\u0924\u0940";
        final String metaValue_el = "\u0917\u094d\u0930\u0940\u0915";
        final String metaValue_gu = "\u0917\u0941\u091c\u0930\u093e\u0924\u0940";
        final String metaValue_he = "\u0939\u093f\u092c\u094d\u0930\u0941";
        final String metaValue_hy = "\u0906\u0930\u094d\u092e\u0947\u0928\u093f\u092f\u093e\u0932\u0940";
        final String metaValue_ja = "\u091c\u093e\u092a\u093e\u0928\u0940";
        final String metaValue_jv = "\u091c\u093e\u092d\u093e\u0928\u0940";
        final String metaValue_ka = "\u091c\u0930\u094d\u091c\u093f\u092f\u093e\u0932\u0940";
        final String metaValue_km = "\u0916\u092e\u0947\u0930";
        final String metaValue_la = "\u0932\u094d\u092f\u093e\u091f\u093f\u0928";
        final String metaValue_lo = "\u0932\u093e\u0913";
        final String metaValue_ta = "\u0924\u093e\u092e\u093f\u0932";
        final String metaValue_te = "\u0924\u0947\u0932\u0941\u0917\u0941";
        final String metaValue_th = "\u0925\u093e\u0908";
        final String metaValue_ban = "\u092c\u093e\u0932\u0940";
        final String metaValue_chr = "\u091a\u0947\u0930\u094b\u0915\u0940";
        final String metaValue_got = "\u0917\u094b\u0925\u093f\u0915";
        final String metaValue_syr = "\u0938\u093f\u0930\u093f\u092f\u093e\u0915";
        final String metaValue_vai = "\u092d\u093e\u0907";
        final String metaValue_Deva = "\u0926\u0947\u0935\u093e\u0928\u093e\u0917\u0930\u0940";
        final String metaValue_Hans = "\u0938\u0930\u0932\u093f\u0915\u0943\u0924 \u091a\u093f\u0928\u093f\u092f\u093e\u0901";
        final String metaValue_Hant = "\u092a\u0930\u092e\u094d\u092a\u0930\u093e\u0917\u0924 \u091a\u093f\u0928\u093f\u092f\u093e\u0901";
        final Object[][] data = new Object[][] {
            { "ksh", "\u0915\u094b\u0932\u094b\u0917\u094d\u0928\u093f\u092f\u093e\u0932\u0940" },
            { "Ogam", "\u0913\u0918\u093e\u092e" },
            { "mwl", "\u092e\u093f\u0930\u093e\u0928\u094d\u0921\u0940" },
            { "Zsym", "\u092a\u094d\u0930\u0924\u0940\u0915\u0939\u0930\u0942" },
            { "cch", "\u0905\u091f\u094d\u0938\u093e\u092e" },
            { "mwr", "\u092e\u093e\u0921\u0935\u093e\u0930\u0940" },
            { "egl", "\u090f\u092e\u093f\u0932\u093f\u092f\u093e\u0932\u0940" },
            { "mwv", "\u092e\u0947\u0928\u094d\u091f\u093e\u0935\u093e\u0908" },
            { "Tagb", "\u091f\u093e\u0917\u094d\u0935\u093e\u0928\u094d\u0935\u093e" },
            { "Zsye", "Zsye" },
            { "xmf", "\u092e\u093f\u0928\u0917\u094d\u0930\u0947\u0932\u093f\u092f\u093e\u0932\u0940" },
            { "egy", "\u092a\u0941\u0930\u093e\u0924\u0928 \u0907\u091c\u093f\u092a\u094d\u091f\u0940" },
            { "raj", "\u0930\u093e\u091c\u0938\u094d\u0925\u093e\u0928\u0940" },
            { "Phag", "\u092b\u093e\u0917\u094d\u0938-\u092a\u093e" },
            { "tem", "\u091f\u093f\u092e\u094d\u0928\u0947" },
            { "teo", "\u091f\u0947\u0938\u094b" },
            { "rap", "\u0930\u093e\u092a\u093e\u0928\u0941\u0908" },
            { "AC", "\u090f\u0938\u094d\u0915\u0947\u0928\u094d\u0938\u0928 \u091f\u093e\u092a\u0941" },
            { "rar", "\u0930\u093e\u0930\u094b\u091f\u094b\u0919\u094d\u0917\u093e\u0928" },
            { "tet", "\u091f\u0947\u091f\u0941\u092e" },
            { "AD", "\u0905\u0928\u094d\u0921\u094b\u0930\u094d\u0930\u093e" },
            { "AE", "\u0938\u0902\u092f\u0941\u0915\u094d\u0924 \u0905\u0930\u092c \u0907\u092e\u093f\u0930\u093e\u091f\u094d\u0938" },
            { "nl_BE", "\u092b\u094d\u0932\u0947\u092e\u093f\u0938" },
            { "AF", "\u0905\u092b\u0917\u093e\u0928\u093f\u0938\u094d\u0924\u093e\u0928" },
            { "AG", "\u090f\u0928\u094d\u091f\u093f\u0917\u0941\u0906 \u0930 \u092c\u093e\u0930\u092c\u0941\u0921\u093e" },
            { "type.ca.ethiopic", "\u0907\u0925\u093f\u0913\u092a\u093f\u0915 \u092a\u093e\u0924\u094d\u0930\u094b" },
            { "glk", "\u0917\u093f\u0932\u093e\u0915\u0940" },
            { "AI", "\u0906\u0919\u094d\u0917\u0941\u0907\u0932\u093e" },
            { "AL", "\u0905\u0932\u094d\u092c\u0947\u0928\u093f\u092f\u093e" },
            { "AM", "\u0906\u0930\u094d\u092e\u0947\u0928\u093f\u092f\u093e" },
            { "Teng", "\u091f\u0947\u0919\u094d\u0935\u093e\u0930" },
            { "AO", "\u0905\u0919\u094d\u0917\u094b\u0932\u093e" },
            { "AQ", "\u0905\u0928\u094d\u091f\u093e\u0930\u091f\u093f\u0915\u093e" },
            { "AR", "\u0905\u0930\u094d\u091c\u0947\u0928\u094d\u091f\u093f\u0928\u093e" },
            { "Prti", "\u092a\u093f\u0906\u0930\u091f\u0940" },
            { "AS", "\u0905\u092e\u0947\u0930\u093f\u0915\u0940 \u0938\u092e\u094b\u0906" },
            { "AT", "\u0905\u0937\u094d\u091f\u094d\u0930\u093f\u092f\u093e" },
            { "AU", "\u0905\u0937\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e" },
            { "AW", "\u0905\u0930\u0941\u092c\u093e" },
            { "en_US", "\u0905\u092e\u0947\u0930\u093f\u0915\u0940 \u0905\u0919\u094d\u0917\u094d\u0930\u0947\u091c\u0940" },
            { "AX", "\u0905\u0932\u093e\u0928\u094d\u0921 \u091f\u093e\u092a\u0941\u0939\u0930\u0941" },
            { "mye", "\u092e\u094d\u092f\u0947\u0928\u0947" },
            { "AZ", "\u0905\u091c\u0930\u092c\u0948\u091c\u093e\u0928" },
            { "%%AREVELA", "\u092a\u0942\u0930\u094d\u0935\u0940 \u0906\u0930\u094d\u092e\u0947\u0928\u093f\u092f\u093e\u0932\u0940" },
            { "BA", "\u092c\u094b\u0938\u094d\u0928\u093f\u092f\u093e \u090f\u0923\u094d\u0921 \u0939\u0930\u094d\u091c\u0917\u094b\u092d\u093f\u0928\u093f\u092f\u093e" },
            { "BB", "\u092c\u093e\u0930\u094d\u092c\u093e\u0921\u094b\u0938" },
            { "ceb", "\u0938\u0947\u092c\u0941\u0906\u0928\u094b" },
            { "BD", "\u092c\u0919\u094d\u0917\u0932\u093e\u0926\u0947\u0936" },
            { "kum", "\u0915\u0941\u092e\u093f\u0915" },
            { "BE", "\u092c\u0947\u0932\u094d\u091c\u093f\u092f\u092e" },
            { "gmh", "\u092e\u0927\u094d\u092f \u0909\u091a\u094d\u091a \u091c\u0930\u094d\u092e\u0928" },
            { "BF", "\u092c\u0930\u094d\u0915\u093f\u0928\u093e \u092b\u093e\u0938\u094b" },
            { "BG", "\u092c\u0941\u0932\u094d\u0917\u0947\u0930\u093f\u092f\u093e" },
            { "BH", "\u092c\u0939\u0930\u093e\u0907\u0928" },
            { "BI", "\u092c\u0941\u0930\u0942\u0923\u094d\u0921\u0940" },
            { "BJ", "\u092c\u0947\u0928\u093f\u0928" },
            { "BL", "\u0938\u0947\u0928\u094d\u091f \u092c\u093e\u0930\u094d\u0925\u093e\u0932\u0947\u092e\u0940" },
            { "BM", "\u092c\u0930\u094d\u092e\u0941\u0921\u093e" },
            { "kut", "\u0915\u0941\u0924\u0947\u0928\u093e\u0907" },
            { "myv", "\u0907\u0930\u094d\u091c\u094d\u092f\u093e" },
            { "BN", "\u092c\u094d\u0930\u0941\u0928\u093e\u0907" },
            { "BO", "\u092c\u094b\u0932\u093f\u092d\u093f\u092f\u093e" },
            { "BQ", "\u0915\u094d\u092f\u093e\u0930\u093f\u0935\u093f\u092f\u0928 \u0928\u0947\u0926\u0930\u0932\u094d\u092f\u093e\u0923\u094d\u0921\u094d\u0938" },
            { "BR", "\u092c\u094d\u0930\u093e\u091c\u093f\u0932" },
            { "BS", "\u092c\u0939\u093e\u092e\u093e\u0938" },
            { "xog", "\u0938\u094b\u0917\u093e" },
            { "BT", "\u092d\u0941\u091f\u093e\u0928" },
            { "BV", "\u092c\u0941\u092d\u0947\u091f \u091f\u093e\u092a\u0941" },
            { "BW", "\u092c\u094b\u091f\u094d\u0938\u094d\u0935\u093e\u0928\u093e" },
            { "BY", "\u092c\u0947\u0932\u093e\u0930\u0942\u0938" },
            { "BZ", "\u092c\u0947\u0932\u093f\u091c" },
            { "Visp", "\u0926\u0943\u0936\u094d\u092f\u092e\u092f \u0935\u093e\u0923\u0940" },
            { "type.ca.persian", "\u092b\u093e\u0930\u0938\u0940 \u092a\u093e\u0924\u094d\u0930\u094b" },
            { "type.nu.hebr", "\u0939\u093f\u092c\u094d\u0930\u0941 \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "CA", "\u0915\u094d\u092f\u093e\u0928\u093e\u0921\u093e" },
            { "CC", "\u0915\u094b\u0915\u094b\u0938 (\u0915\u093f\u0932\u093f\u0902\u0917) \u091f\u093e\u092a\u0941\u0939\u0930\u0941" },
            { "mzn", "\u092e\u091c\u093e\u0928\u0921\u0947\u0930\u093e\u0928\u0940" },
            { "CD", "\u0915\u0919\u094d\u0917\u094b - \u0915\u093f\u0928\u094d\u0936\u093e\u0938\u093e" },
            { "CF", "\u0915\u0947\u0928\u094d\u0926\u094d\u0930\u0940\u092f \u0905\u092b\u094d\u0930\u093f\u0915\u0940 \u0917\u0923\u0924\u0928\u094d\u0924\u094d\u0930" },
            { "CG", "\u0915\u0919\u094d\u0917\u094b \u092c\u094d\u0930\u093e\u091c\u093e\u092d\u093f\u0932" },
            { "CH", "\u0938\u094d\u0935\u093f\u091c\u0930\u0932\u094d\u092f\u093e\u0923\u094d\u0921" },
            { "CI", "\u0906\u0907\u092d\u094b\u0930\u0940 \u0915\u094b\u0938\u094d\u091f" },
            { "CK", "\u0915\u0941\u0915 \u091f\u093e\u092a\u0941\u0939\u0930\u0941" },
            { "CL", "\u091a\u093f\u0932\u0940" },
            { "Kthi", "\u0915\u094d\u0925\u0940" },
            { "CM", "\u0915\u094d\u092f\u093e\u092e\u0930\u0942\u0928" },
            { "CN", "\u091a\u0940\u0928" },
            { "CO", "\u0915\u094b\u0932\u094b\u092e\u094d\u092c\u093f\u092f\u093e" },
            { "CP", "\u0915\u094d\u0932\u093f\u092a\u094d\u092a\u0947\u0930\u094d\u091f\u0928 \u091f\u093e\u092a\u0941" },
            { "CR", "\u0915\u094b\u0937\u094d\u091f\u093e\u0930\u093f\u0915\u093e" },
            { "CU", "\u0915\u094d\u092f\u0941\u092c\u093e" },
            { "CV", "\u0915\u0947\u092a \u092d\u0930\u094d\u0921\u0947" },
            { "CW", "\u0915\u0941\u0930\u093e\u0915\u093e\u0913" },
            { "CX", "\u0915\u094d\u0930\u093f\u0937\u094d\u091f\u092e\u0938 \u091f\u093e\u092a\u0941" },
            { "CY", "\u0938\u093e\u0907\u092a\u094d\u0930\u0938" },
            { "CZ", "\u091a\u0947\u0915\u093f\u092f\u093e" },
            { "eka", "\u090f\u0915\u093e\u091c\u0941\u0915" },
            { "DE", "\u091c\u0930\u094d\u092e\u0928\u0940" },
            { "goh", "\u092a\u0941\u0930\u093e\u0924\u0928 \u0909\u091a\u094d\u091a \u091c\u0930\u094d\u092e\u0928" },
            { "ace", "\u0905\u091a\u093e\u0907\u0928\u093f\u091c" },
            { "cgg", "\u091a\u093f\u0917\u093e" },
            { "DG", "\u0921\u093f\u092f\u0917\u094b \u0917\u093e\u0930\u094d\u0938\u093f\u092f\u093e" },
            { "gom", "\u0917\u094b\u0935\u093e \u0915\u094b\u0928\u094d\u0915\u093e\u0928\u0940" },
            { "type.nu.deva", metaValue_Deva },
            { "DJ", "\u0921\u093f\u091c\u093f\u092c\u0941\u091f\u0940" },
            { "DK", "\u0921\u0947\u0928\u092e\u093e\u0930\u094d\u0915" },
            { "ach", "\u0905\u0915\u094b\u0932\u0940" },
            { "gon", "\u0917\u094b\u0928\u094d\u0921\u0940" },
            { "Brai", "\u092c\u094d\u0930\u0947\u0932" },
            { "Brah", "\u092c\u094d\u0930\u093e\u0939\u094d\u092e\u0940" },
            { "DM", "\u0921\u094b\u092e\u093f\u0928\u093f\u0915\u093e" },
            { "type.nu.armnlow", "\u0906\u0930\u094d\u092e\u0947\u0928\u093f\u092f\u093e\u0932\u0940 \u0938\u093e\u0928\u093e \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "DO", "\u0921\u094b\u092e\u093f\u0928\u093f\u0915\u0928 \u0917\u0923\u0924\u0928\u094d\u0924\u094d\u0930" },
            { "gor", "\u0917\u094b\u0930\u094b\u0928\u094d\u091f\u093e\u0932\u094b" },
            { "got", metaValue_got },
            { "vmf", "\u092e\u0941\u0916\u094d\u092f-\u092b\u094d\u0930\u093e\u0919\u094d\u0915\u094b\u0928\u093f\u092f\u093e\u0932\u0940" },
            { "Mtei", "\u092e\u093e\u0907\u091f\u0947\u0907 \u092e\u093e\u092f\u0947\u0915" },
            { "zun", "\u091c\u0941\u0928\u0940" },
            { "tig", "\u091f\u093f\u0917\u094d\u0930\u0947" },
            { "DZ", "\u0905\u0932\u094d\u091c\u0947\u0930\u093f\u092f\u093e" },
            { "pag", "\u092a\u093e\u0919\u094d\u0917\u093e\u0938\u093f\u0928\u093e\u0928" },
            { "pal", "\u092a\u093e\u0939\u0932\u093e\u0935\u0940" },
            { "EA", "\u0938\u093f\u0909\u091f\u093e \u0930 \u092e\u0947\u0932\u093f\u0932\u093e" },
            { "chb", "\u091a\u093f\u092c\u094d\u091a\u093e" },
            { "pam", "\u092a\u093e\u092e\u092a\u093e\u0919\u094d\u0917\u093e" },
            { "EC", "\u0907\u0915\u094d\u0935\u0947\u0921\u094b\u0930" },
            { "pap", "\u092a\u093e\u092a\u093f\u092f\u093e\u092e\u0947\u0928\u094d\u0924\u094b" },
            { "ada", "\u0905\u0926\u093e\u0919\u092e\u0947" },
            { "EE", "\u0907\u0938\u094d\u091f\u094b\u0928\u093f\u092f\u093e" },
            { "EG", "\u0907\u091c\u093f\u092a\u094d\u091f" },
            { "EH", "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0938\u093e\u0939\u093e\u0930\u093e" },
            { "chg", "\u091a\u093e\u0917\u093e\u091f\u093e\u0908" },
            { "pau", "\u092a\u093e\u0932\u093e\u0909\u0935\u093e\u0932\u0940" },
            { "chk", "\u091a\u0941\u0915\u0947\u0938\u0947" },
            { "chn", "\u091a\u093f\u0928\u0941\u0915 \u091c\u093e\u0930\u094d\u0917\u0928" },
            { "chm", "\u092e\u093e\u0930\u0940" },
            { "chp", "\u091a\u093f\u092a\u0947\u0935\u094d\u092f\u093e\u0928" },
            { "cho", "\u091a\u094b\u0915\u094d\u091f\u093e\u0935" },
            { "chr", metaValue_chr },
            { "ER", "\u090f\u0930\u093f\u0924\u094d\u0930\u093f\u092f\u093e" },
            { "ES", "\u0938\u094d\u092a\u0947\u0928" },
            { "ET", "\u0907\u0925\u093f\u092f\u094b\u092a\u093f\u092f\u093e" },
            { "EU", "\u092f\u0941\u0930\u094b\u092a\u093f\u092f\u0928 \u092f\u0941\u0928\u093f\u092f\u0928" },
            { "elx", "\u090f\u0932\u093e\u092e\u093e\u0907\u091f" },
            { "type.ca.gregorian", "\u0917\u094d\u0930\u0947\u0917\u094b\u0930\u093f\u092f\u0928 \u092a\u093e\u0924\u094d\u0930\u094b" },
            { "EZ", "\u092f\u0941\u0930\u094b\u091c\u094b\u0928" },
            { "chy", "\u091a\u0947\u092f\u0947\u0928\u094d\u0928\u0947" },
            { "type.nu.gujr", "\u0917\u0941\u091c\u0930\u093e\u0924\u0940 \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "Inds", "\u0907\u0928\u094d\u0926\u0941\u0938" },
            { "ady", "\u0905\u0926\u093f\u0918\u0947" },
            { "FI", "\u092b\u093f\u0928\u094d\u0932\u094d\u092f\u093e\u0923\u094d\u0921" },
            { "FJ", "\u092b\u093f\u091c\u0940" },
            { "FK", "\u092b\u0915\u0932\u094d\u092f\u093e\u0923\u094d\u0921 \u091f\u093e\u092a\u0941\u0939\u0930\u0941" },
            { "FM", "\u092e\u093e\u0907\u0915\u094d\u0930\u094b\u0928\u0947\u0938\u093f\u092f\u093e" },
            { "FO", "\u092b\u093e\u0930\u094b \u091f\u093e\u092a\u0941\u0939\u0930\u0942" },
            { "Taml", metaValue_ta },
            { "FR", "\u092b\u094d\u0930\u093e\u0928\u094d\u0938" },
            { "pcd", "\u092a\u093f\u0915\u093e\u0930\u094d\u0921" },
            { "grb", "\u0917\u094d\u0930\u0947\u092c\u094b" },
            { "root", "\u0930\u0941\u091f" },
            { "type.ca.indian", "\u092d\u093e\u0930\u0924\u0940\u092f \u0930\u093e\u0937\u094d\u091f\u094d\u0930\u093f\u092f \u092a\u093e\u0924\u094d\u0930\u094b" },
            { "grc", "\u092a\u0941\u0930\u093e\u0924\u0928 \u0917\u094d\u0930\u093f\u0915" },
            { "GA", "\u0917\u093e\u0935\u094b\u0928" },
            { "GB", "\u092c\u0947\u0932\u093e\u092f\u0924" },
            { "pcm", "\u0928\u093e\u0907\u091c\u0947\u0930\u093f\u092f\u093e\u0932\u0940 \u092a\u093f\u0921\u094d\u091c\u093f\u0928" },
            { "GD", "\u0917\u094d\u0930\u0947\u0928\u093e\u0921\u093e" },
            { "GE", "\u091c\u0930\u094d\u091c\u093f\u092f\u093e" },
            { "GF", "\u092b\u094d\u0930\u093e\u0928\u094d\u0938\u0947\u0932\u0940 \u0917\u093e\u092f\u0928\u093e" },
            { "GG", "\u0917\u0941\u090f\u0930\u094d\u0928\u0938\u0947" },
            { "GH", "\u0918\u093e\u0928\u093e" },
            { "Tale", "\u091f\u093e\u0907\u0932\u0947" },
            { "GI", "\u091c\u093f\u092c\u094d\u0930\u093e\u0932\u094d\u091f\u093e\u0930" },
            { "afh", "\u0905\u092b\u094d\u0930\u093f\u0939\u093f\u0932\u0940" },
            { "GL", "\u0917\u094d\u0930\u093f\u0928\u0932\u094d\u092f\u093e\u0923\u094d\u0921" },
            { "enm", "\u092e\u0927\u094d\u092f \u0905\u0919\u094d\u0917\u094d\u0930\u0947\u091c\u0940" },
            { "GM", "\u0917\u093e\u092e\u094d\u0935\u093f\u092f\u093e" },
            { "GN", "\u0917\u093f\u0928\u0940" },
            { "GP", "\u0917\u094d\u0935\u093e\u0921\u0947\u0932\u0941\u092a" },
            { "GQ", "\u092d\u0942-\u092e\u0927\u094d\u092f\u0940\u092f \u0917\u093f\u0928\u0940" },
            { "GR", "\u0917\u094d\u0930\u093f\u0938" },
            { "GS", "\u0926\u0915\u094d\u0937\u093f\u0923 \u091c\u0930\u094d\u091c\u093f\u092f\u093e \u0930 \u0926\u0915\u094d\u0937\u093f\u0923 \u0938\u094d\u092f\u093e\u0928\u094d\u0921\u0935\u0940\u091a \u091f\u093e\u092a\u0941\u0939\u0930\u0942" },
            { "GT", "\u0917\u094d\u0935\u093e\u091f\u0947\u092e\u093e\u0932\u093e" },
            { "GU", "\u0917\u0941\u0935\u093e\u092e" },
            { "pdc", "\u092a\u0947\u0928\u094d\u0938\u093f\u0932\u092d\u093e\u0928\u093f\u092f\u093e\u0932\u0940 \u091c\u0930\u094d\u092e\u0928" },
            { "GW", "\u0917\u093f\u0928\u0940-\u092c\u093f\u0938\u093e\u0909" },
            { "tlh", "\u0915\u094d\u0932\u093f\u0919\u094d\u0917\u0928" },
            { "Talu", "\u0928\u094d\u092f\u0942 \u091f\u093e\u0907 \u0932\u0941\u0907" },
            { "GY", "\u0917\u0941\u092f\u093e\u0928\u093e" },
            { "ckb", "\u0915\u0947\u0928\u094d\u0926\u094d\u0930\u0940\u092f \u0915\u0941\u0930\u094d\u0926\u0940" },
            { "zxx", "\u092d\u093e\u0937\u093f\u0915 \u0938\u093e\u092e\u0917\u094d\u0930\u0940 \u091b\u0948\u0928" },
            { "de_AT", "\u0905\u0938\u094d\u091f\u094d\u0930\u093f\u090f\u0928 \u091c\u0930\u094d\u092e\u0928" },
            { "Vaii", metaValue_vai },
            { "HK", "\u0939\u0919\u0915\u0919 \u091a\u093f\u0928\u093f\u092f\u093e\u0901 \u0938\u092e\u093e\u091c\u092c\u093e\u0926\u0940 \u0938\u094d\u0935\u093e\u092f\u0924\u094d\u0924 \u0915\u094d\u0937\u0947\u0924\u094d\u0930" },
            { "HM", "\u0939\u0930\u094d\u0921 \u091f\u093e\u092a\u0941 \u0930 \u092e\u094d\u092f\u093e\u0915\u0921\u094b\u0928\u093e\u0932\u094d\u0921 \u091f\u093e\u092a\u0941\u0939\u0930\u0941" },
            { "HN", "\u0939\u0928\u094d\u0921\u0941\u0930\u093e\u0938" },
            { "HR", "\u0915\u094d\u0930\u094b\u090f\u0936\u093f\u092f\u093e" },
            { "agq", "\u0906\u0918\u0947\u092e" },
            { "gsw", "\u0938\u094d\u0935\u0940\u0938 \u091c\u0930\u094d\u092e\u0928" },
            { "HT", "\u0939\u0948\u091f\u0940" },
            { "HU", "\u0939\u0919\u094d\u0917\u0947\u0930\u0940" },
            { "IC", "\u0915\u094d\u092f\u093e\u0928\u093e\u0930\u0940 \u091f\u093e\u092a\u0941\u0939\u0930\u0942" },
            { "nan", "\u092e\u093f\u0928 \u0928\u093e\u0928 \u091a\u093f\u0928\u093f\u092f\u093e\u0901" },
            { "ID", "\u0907\u0928\u094d\u0921\u094b\u0928\u0947\u0936\u093f\u092f\u093e" },
            { "peo", "\u092a\u0941\u0930\u093e\u0924\u0928 \u092b\u093e\u0930\u0938\u0940" },
            { "IE", "\u0906\u092f\u0930\u0932\u094d\u092f\u093e\u0923\u094d\u0921" },
            { "nap", "\u0928\u0947\u092a\u094b\u0932\u093f\u091f\u093e\u0928" },
            { "naq", "\u0928\u093e\u092e\u093e" },
            { "zza", "\u091c\u093e\u091c\u093e" },
            { "IL", "\u0907\u091c\u0930\u093e\u092f\u0932" },
            { "IM", "\u0906\u0907\u0932 \u0905\u092b \u092e\u094d\u092f\u093e\u0928" },
            { "IN", "\u092d\u093e\u0930\u0924" },
            { "IO", "\u092c\u0947\u0932\u093e\u092f\u0924\u0940 \u0939\u093f\u0928\u094d\u0926 \u092e\u0939\u093e\u0938\u093e\u0917\u0930 \u0915\u094d\u0937\u0947\u0924\u094d\u0930" },
            { "IQ", "\u0907\u0930\u093e\u0915" },
            { "IR", "\u0907\u0930\u093e\u0928" },
            { "IS", "\u0906\u0907\u0938\u094d\u0932\u094d\u092f\u093e\u0923\u094d\u0921" },
            { "IT", "\u0907\u091f\u093e\u0932\u0940" },
            { "Zmth", "Zmth" },
            { "type.nu.thai", "\u0925\u093e\u0908 \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "%%POSIX", "\u0915\u092e\u094d\u092a\u094d\u092f\u0941\u091f\u0930" },
            { "type.nu.beng", "\u092c\u0919\u094d\u0917\u093e\u0932\u0940 \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "pfl", "\u092a\u093e\u0932\u093e\u091f\u093f\u0928 \u091c\u0930\u094d\u092e\u0928" },
            { "JE", "\u091c\u0930\u094d\u0938\u0940" },
            { "type.ca.islamic", "\u0907\u0938\u094d\u0932\u093e\u092e\u0940 \u092a\u093e\u0924\u094d\u0930\u094b" },
            { "JM", "\u091c\u092e\u093e\u0907\u0915\u093e" },
            { "Beng", "\u092c\u0919\u094d\u0917\u093e\u0932\u0940" },
            { "JO", "\u091c\u094b\u0930\u094d\u0921\u0928" },
            { "gur", "\u092b\u094d\u0930\u093e\u092b\u094d\u0930\u093e" },
            { "JP", "\u091c\u093e\u092a\u093e\u0928" },
            { "ain", "\u0905\u0907\u0928\u0941" },
            { "guz", "\u0917\u0941\u0938\u0940" },
            { "tog", "\u0928\u094d\u092f\u093e\u0938 \u091f\u094b\u0919\u094d\u0917\u093e" },
            { "type.nu.knda", "\u0915\u0928\u094d\u0928\u093e\u0921\u093e \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "Kali", "\u0915\u093e\u092f\u093e\u0939\u0932\u0940" },
            { "de_CH", "\u0938\u094d\u0935\u0940\u0938 \u0939\u093e\u0908 \u091c\u0930\u094d\u092e\u0928" },
            { "izh", "\u0907\u0928\u094d\u0917\u094d\u0930\u093f\u092f\u093e\u0932\u0940" },
            { "type.ca.buddhist", "\u092c\u0941\u0926\u094d\u0927\u093f\u0937\u094d\u091f \u092a\u093e\u0924\u094d\u0930\u094b" },
            { "KE", "\u0915\u0947\u0928\u094d\u092f\u093e" },
            { "419", "\u0932\u094d\u092f\u093e\u091f\u093f\u0928 \u0905\u092e\u0947\u0930\u093f\u0915\u093e" },
            { "KG", "\u0915\u093f\u0930\u094d\u0917\u093f\u0938\u094d\u0924\u093e\u0928" },
            { "KH", "\u0915\u092e\u094d\u092c\u094b\u0921\u093f\u092f\u093e" },
            { "KI", "\u0915\u093f\u0930\u093f\u092c\u093e\u091f\u0940" },
            { "KM", "\u0915\u094b\u092e\u094b\u0930\u094b\u0938" },
            { "KN", "\u0938\u0947\u0928\u094d\u091f \u0915\u093f\u091f\u094d\u0938 \u0930 \u0928\u0947\u092d\u093f\u0938" },
            { "Knda", "\u0915\u093e\u0928\u094d\u0928\u093e\u0921\u093e" },
            { "Zinh", "\u0907\u0928\u094d\u0939\u0947\u0930\u093f\u091f\u0947\u0921" },
            { "fr_CA", "\u0915\u094d\u092f\u093e\u0928\u0947\u0921\u093e\u0932\u0940 \u092b\u094d\u0930\u093e\u0928\u094d\u0938\u0947\u0932\u0940" },
            { "KP", "\u0909\u0924\u094d\u0924\u0930 \u0915\u094b\u0930\u093f\u092f\u093e" },
            { "KR", "\u0926\u0915\u094d\u0937\u093f\u0923 \u0915\u094b\u0930\u093f\u092f\u093e" },
            { "Plrd", "\u092a\u094b\u0932\u094d\u0932\u093e\u0930\u094d\u0921 \u092b\u094b\u0928\u0947\u091f\u093f\u0915" },
            { "fr_CH", "\u0938\u094d\u0935\u093f\u0938 \u092b\u094d\u0930\u0947\u0928\u094d\u091a" },
            { "KW", "\u0915\u0941\u0935\u0947\u0924" },
            { "tpi", "\u091f\u094b\u0915 \u092a\u093f\u0938\u093f\u0928" },
            { "KY", "\u0915\u0947\u092f\u092e\u093e\u0928 \u091f\u093e\u092a\u0941" },
            { "KZ", "\u0915\u093e\u091c\u093e\u0915\u0938\u094d\u0924\u093e\u0928" },
            { "Cyrl", "\u0938\u093f\u0930\u093f\u0932\u093f\u0915" },
            { "LA", "\u0932\u093e\u0913\u0938" },
            { "LB", "\u0932\u0947\u092c\u0928\u0928" },
            { "LC", "\u0938\u0947\u0928\u094d\u091f \u0932\u0941\u0938\u093f\u092f\u093e" },
            { "phn", "\u092b\u094b\u0928\u093f\u0938\u093f\u092f\u093e\u0932\u0940" },
            { "gwi", "\u0917\u0941\u0907\u091a\u093f\u0928" },
            { "nds", "\u0924\u0932\u094d\u0932\u094b \u091c\u0930\u094d\u092e\u0928" },
            { "LI", "\u0932\u093f\u090f\u0916\u091f\u0947\u0928\u094d\u0938\u094d\u091f\u093e\u0907\u0928" },
            { "LK", "\u0936\u094d\u0930\u0940\u0932\u0919\u094d\u0915\u093e" },
            { "akk", "\u0905\u0915\u094d\u0915\u093e\u0926\u093f\u092f\u093e\u0932\u0940" },
            { "cop", "\u0915\u094b\u092a\u094d\u091f\u093f\u0915" },
            { "LR", "\u0932\u093e\u0907\u092c\u0947\u0930\u093f\u092f\u093e" },
            { "esu", "\u0915\u0947\u0928\u094d\u0926\u094d\u0930\u0940\u092f \u092f\u0941\u092a\u093f\u0915" },
            { "LS", "\u0932\u0947\u0938\u094b\u0925\u094b" },
            { "Phlv", "\u092c\u0941\u0915 \u092a\u0939\u0932\u094d\u092d\u0940" },
            { "LT", "\u0932\u093f\u0925\u0941\u090f\u0928\u093f\u092f\u093e" },
            { "LU", "\u0932\u0915\u094d\u091c\u0947\u092e\u092c\u0930\u094d\u0917" },
            { "LV", "\u0932\u093e\u091f\u094d\u092d\u093f\u092f\u093e" },
            { "Kana", "\u0915\u093e\u0924\u093e\u0915\u093e\u0928\u093e" },
            { "LY", "\u0932\u093f\u092c\u093f\u092f\u093e" },
            { "lad", "\u0932\u093e\u0921\u093f\u0928\u094b" },
            { "vun", "\u092d\u0941\u0928\u094d\u091c\u094b" },
            { "akz", "\u0905\u0932\u093e\u092c\u093e\u092e\u093e" },
            { "lah", "\u0932\u093e\u0939\u0928\u094d\u0921\u093e" },
            { "lag", "\u0932\u093e\u0919\u094d\u0917\u0940" },
            { "Thaa", "\u0925\u093e\u0928\u093e" },
            { "MA", "\u092e\u094b\u0930\u094b\u0915\u094d\u0915\u094b" },
            { "MC", "\u092e\u094b\u0928\u093e\u0915\u094b" },
            { "MD", "\u092e\u093e\u0932\u094d\u0921\u094b\u092d\u093e" },
            { "ME", "\u092e\u094b\u0928\u094d\u091f\u0947\u0928\u0947\u0917\u094d\u0930\u094b" },
            { "MF", "\u0938\u0947\u0928\u094d\u091f \u092e\u093e\u0930\u094d\u091f\u093f\u0928" },
            { "lam", "\u0932\u093e\u092e\u094d\u092c\u093e" },
            { "MG", "\u092e\u093e\u0921\u093e\u0917\u093e\u0938\u094d\u0915\u0930" },
            { "Thai", metaValue_th },
            { "MH", "\u092e\u093e\u0930\u094d\u0936\u0932 \u091f\u093e\u092a\u0941\u0939\u0930\u0941" },
            { "ale", "\u0905\u0932\u0947\u0909\u091f" },
            { "MK", "\u092e\u094d\u092f\u093e\u0938\u0947\u0921\u094b\u0928\u093f\u092f\u093e" },
            { "ML", "\u092e\u093e\u0932\u0940" },
            { "MM", "\u092e\u094d\u092f\u093e\u0928\u094d\u092e\u093e\u0930 (\u092c\u0930\u094d\u092e\u093e)" },
            { "MN", "\u092e\u0919\u094d\u0917\u094b\u0932\u093f\u092f\u093e" },
            { "new", "\u0928\u0947\u0935\u093e\u0930\u0940" },
            { "MO", "\u092e\u0915\u093e\u0909 \u091a\u093f\u0928\u093f\u092f\u093e\u0901 \u0938\u094d\u0935\u0936\u093e\u0938\u093f\u0924 \u0915\u094d\u0937\u0947\u0924\u094d\u0930" },
            { "aln", "\u0918\u0947\u0917 \u0905\u0932\u094d\u092c\u093e\u0928\u093f\u092f\u093e\u0932\u0940" },
            { "MP", "\u0909\u0924\u094d\u0924\u0930\u0940 \u092e\u093e\u0930\u093f\u0906\u0928\u093e \u091f\u093e\u092a\u0941" },
            { "MQ", "\u092e\u093e\u0930\u094d\u091f\u093f\u0928\u093f\u0915" },
            { "MR", "\u092e\u093e\u0909\u0930\u093f\u091f\u093e\u0928\u093f\u092f\u093e" },
            { "MS", "\u092e\u094b\u0928\u094d\u091f\u0938\u0947\u0930\u094d\u0930\u093e\u091f" },
            { "MT", "\u092e\u093e\u0932\u094d\u091f\u093e" },
            { "cps", "\u0915\u093e\u092a\u093f\u091c\u094d\u0928\u094b\u0928" },
            { "MU", "\u092e\u093e\u0909\u0930\u093f\u091f\u0938" },
            { "alt", "\u0926\u0915\u094d\u0937\u093f\u0923\u0940 \u0906\u0932\u094d\u091f\u093e\u0907" },
            { "MV", "\u092e\u093e\u0932\u094d\u0926\u093f\u092d\u094d\u0938" },
            { "MW", "\u092e\u093e\u0932\u093e\u0935\u0940" },
            { "MX", "\u092e\u0947\u0915\u094d\u0938\u093f\u0915\u094b" },
            { "type.ca.japanese", "\u091c\u093e\u092a\u093e\u0928\u0940 \u092a\u093e\u0924\u094d\u0930\u094b" },
            { "MY", "\u092e\u0932\u0947\u0938\u093f\u092f\u093e" },
            { "MZ", "\u092e\u094b\u091c\u093e\u092e\u094d\u092c\u093f\u0915" },
            { "Phli", "\u092b\u094d\u0932\u093f" },
            { "NA", "\u0928\u093e\u092e\u093f\u092c\u093f\u092f\u093e" },
            { "202", "\u0909\u092a-\u0938\u093e\u0939\u093e\u0930\u093e \u0905\u092b\u094d\u0930\u093f\u0915\u093e" },
            { "type.ca.hebrew", "\u0939\u093f\u092c\u094d\u0930\u0941 \u092a\u093e\u0924\u094d\u0930\u094b" },
            { "NC", "\u0928\u094d\u092f\u0941 \u0915\u094d\u092f\u093e\u0932\u0947\u0921\u094b\u0928\u093f\u092f\u093e" },
            { "NE", "\u0928\u093e\u0907\u091c\u0930" },
            { "NF", "\u0928\u094b\u0930\u092b\u094b\u0932\u094d\u0915 \u091f\u093e\u092a\u0941" },
            { "NG", "\u0928\u093e\u0907\u091c\u0947\u0930\u093f\u092f\u093e" },
            { "trv", "\u091f\u093e\u0930\u094b\u0915\u094b" },
            { "Phlp", "\u092b\u094d\u0932\u094d\u092a" },
            { "NI", "\u0928\u093f\u0915\u093e\u0930\u093e\u0917\u0941\u0935\u093e" },
            { "Hmng", "\u092a\u0939\u093e\u0935\u0939 \u0939\u092e\u094b\u0919\u094d\u0917" },
            { "NL", "\u0928\u0947\u0926\u0930\u0932\u094d\u092f\u093e\u0923\u094d\u0921" },
            { "NO", "\u0928\u0930\u094d\u0935\u0947" },
            { "NP", "\u0928\u0947\u092a\u093e\u0932" },
            { "NR", metaValue_NR },
            { "NU", "\u0928\u093f\u092f\u0941\u0907" },
            { "Phnx", "\u092b\u094b\u0928\u093f\u0938\u093f\u092f\u0928" },
            { "rof", "\u0930\u094b\u092e\u094d\u092c\u094b" },
            { "NZ", "\u0928\u094d\u092f\u0941\u091c\u093f\u0932\u094d\u092f\u093e\u0923\u094d\u0921" },
            { "Mero", "\u092e\u0947\u0930\u093f\u092f\u094b\u091f\u093f\u0915" },
            { "crh", "\u0915\u094d\u0930\u093f\u092e\u093f\u092f\u093e\u0932\u0940 \u0924\u0941\u0930\u094d\u0915" },
            { "ang", "\u092a\u0941\u0930\u093e\u0924\u0928 \u0905\u0919\u094d\u0917\u094d\u0930\u0947\u091c\u0940" },
            { "OM", "\u0913\u092e\u0928" },
            { "anp", "\u0905\u0919\u094d\u0917\u093f\u0915\u093e" },
            { "crs", "\u0938\u0947\u0938\u0947\u0932\u094d\u0935\u093e \u0915\u094d\u0930\u093f\u0913\u0932 \u092b\u094d\u0930\u093e\u0928\u094d\u0938\u0947\u0932\u0940" },
            { "Xpeo", "\u092a\u0941\u0930\u093e\u0928\u094b \u092a\u0930\u094d\u0938\u093f\u092f\u0928" },
            { "PA", "\u092a\u094d\u092f\u093e\u0928\u093e\u092e\u093e" },
            { "type.ca.islamic-civil", "\u0907\u0938\u094d\u0932\u093e\u092e\u0940 \u0928\u093e\u0917\u0930\u093f\u0915 \u092a\u093e\u0924\u094d\u0930\u094b" },
            { "csb", "\u0915\u093e\u0938\u0941\u0935\u093f\u092f\u0928" },
            { "en_GB", "\u092c\u0947\u0932\u093e\u092f\u0924\u0940 \u0905\u0919\u094d\u0917\u094d\u0930\u0947\u091c\u0940" },
            { "PE", "\u092a\u0947\u0930\u0942" },
            { "ttt", "\u092e\u0941\u0938\u094d\u0932\u093f\u092e \u091f\u093e\u091f" },
            { "PF", "\u092b\u094d\u0930\u093e\u0928\u094d\u0938\u0947\u0932\u0940 \u092a\u094b\u0932\u093f\u0928\u0947\u0938\u093f\u092f\u093e" },
            { "PG", "\u092a\u092a\u0941\u0906 \u0928\u094d\u092f\u0942 \u0917\u093e\u0907\u0928\u093f\u092f\u093e" },
            { "PH", "\u092b\u093f\u0932\u093f\u092a\u093f\u0928\u094d\u0938" },
            { "PK", "\u092a\u093e\u0915\u093f\u0938\u094d\u0924\u093e\u0928" },
            { "PL", "\u092a\u094b\u0932\u094d\u092f\u093e\u0923\u094d\u0921" },
            { "ewo", "\u0907\u0935\u094b\u0928\u094d\u0921\u094b" },
            { "PM", "\u0938\u0947\u0928\u094d\u091f \u092a\u093f\u0930\u094d\u0930\u0947 \u0930 \u092e\u093f\u0915\u094d\u0915\u0947\u0932\u094b\u0928" },
            { "PN", "\u092a\u093f\u091f\u0915\u093e\u0907\u0930\u094d\u0928 \u091f\u093e\u092a\u0941\u0939\u0930\u0941" },
            { "PR", "\u092a\u0941\u090f\u0930\u094d\u091f\u094b \u0930\u093f\u0915\u094b" },
            { "Bali", metaValue_ban },
            { "PS", "\u092a\u094d\u092f\u093e\u0932\u0947\u0938\u094d\u091f\u0928\u0940 \u092d\u0942-\u092d\u093e\u0917\u0939\u0930\u0941" },
            { "PT", "\u092a\u094b\u0930\u094d\u091a\u0941\u0917\u0932" },
            { "PW", "\u092a\u0932\u093e\u0909" },
            { "nia", "\u0928\u093f\u092f\u093e\u0938" },
            { "type.nu.greklow", "\u0917\u094d\u0930\u0940\u0915 \u0938\u093e\u0928\u093e \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "PY", "\u092a\u094d\u092f\u093e\u0930\u093e\u0917\u094d\u0935\u0947" },
            { "tum", "\u091f\u0941\u092e\u094d\u092c\u0941\u0915\u093e" },
            { "Hebr", metaValue_he },
            { "QA", "\u0915\u0924\u093e\u0930" },
            { "jam", "\u091c\u092e\u0948\u0915\u093e\u0932\u0940 \u0915\u094d\u0930\u0947\u0913\u0932\u0947 \u0905\u0919\u094d\u0917\u094d\u0930\u0947\u091c\u0940" },
            { "pms", "\u092a\u093f\u090f\u0921\u092e\u094b\u0928\u094d\u0924\u0947\u0938\u0947" },
            { "niu", "\u0928\u093f\u0909\u090f\u0928" },
            { "QO", "\u092c\u093e\u0939\u094d\u092f \u0913\u0938\u0928\u093f\u092f\u093e" },
            { "ext", "\u090f\u0915\u094d\u0938\u091f\u094d\u0930\u0947\u092e\u093e\u0926\u0941\u0930\u093e\u0932\u0940" },
            { "lez", "\u0932\u093e\u091c\u094d\u0918\u093f\u092f\u093e\u0932\u0940" },
            { "tvl", "\u091f\u0941\u092d\u093e\u0932\u0941" },
            { "Tavt", "\u091f\u093e\u092d\u094d\u091f" },
            { "001", "\u0935\u093f\u0936\u094d\u0935" },
            { "002", "\u0905\u092b\u094d\u0930\u093f\u0915\u093e" },
            { "njo", "\u0905\u0913 \u0928\u093e\u0917\u093e" },
            { "003", "\u0909\u0924\u094d\u0924\u0930 \u0905\u092e\u0947\u0930\u093f\u0915\u093e" },
            { "RE", "\u0930\u093f\u092f\u0941\u0928\u093f\u092f\u0928" },
            { "005", "\u0926\u0915\u094d\u0937\u093f\u0923 \u0905\u092e\u0947\u0930\u093f\u0915\u093e" },
            { "lfn", "\u0932\u093f\u0919\u094d\u0917\u0941\u0935\u093e \u092b\u094d\u0930\u093e\u0919\u094d\u0915\u093e \u0928\u094b\u092d\u093e" },
            { "jbo", "\u0932\u094b\u091c\u094d\u092c\u093e\u0928" },
            { "pnt", "\u092a\u094b\u0928\u094d\u091f\u093f\u0915" },
            { "Rjng", "\u0930\u0947\u091c\u093e\u0919" },
            { "009", "\u0913\u0938\u0928\u093f\u092f\u093e" },
            { "RO", "\u0930\u094b\u092e\u0947\u0928\u093f\u092f\u093e" },
            { "RS", "\u0938\u0930\u094d\u092c\u093f\u092f\u093e" },
            { "RU", "\u0930\u0942\u0938" },
            { "RW", "\u0930\u0935\u093e\u0923\u094d\u0921\u093e" },
            { "Mani", "\u092e\u093e\u0928\u093f\u0915\u093e\u090f\u0928" },
            { "Ugar", "\u092f\u0941\u0917\u093e\u0930\u093f\u091f\u093f\u0915" },
            { "Khar", "\u0916\u093e\u0930\u094b\u0938\u094d\u0925\u093f\u0924\u093f" },
            { "SA", "\u0938\u093e\u0909\u0926\u0940 \u0905\u0930\u092c" },
            { "Mand", "\u092e\u093e\u0928\u094d\u0921\u093e\u090f\u0928" },
            { "SB", "\u0938\u094b\u0932\u094b\u092e\u094b\u0928 \u091f\u093e\u092a\u0941\u0939\u0930\u0941" },
            { "twq", "\u0924\u093e\u0938\u093e\u0935\u093e\u0915" },
            { "011", "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0905\u092b\u094d\u0930\u093f\u0915\u093e" },
            { "SC", "\u0938\u0947\u091a\u0947\u0932\u0947\u0938" },
            { "SD", "\u0938\u0941\u0921\u093e\u0928" },
            { "013", "\u0915\u0947\u0928\u094d\u0926\u094d\u0930\u0940\u092f \u0905\u092e\u0947\u0930\u093f\u0915\u093e" },
            { "SE", "\u0938\u094d\u0935\u093f\u0921\u0947\u0928" },
            { "014", "\u092a\u0942\u0930\u094d\u0935\u0940 \u0905\u092b\u094d\u0930\u093f\u0915\u093e" },
            { "arc", "\u0905\u0930\u093e\u092e\u093e\u0907\u0915" },
            { "015", "\u0909\u0924\u094d\u0924\u0930\u0940 \u0905\u092b\u094d\u0930\u093f\u0915\u093e" },
            { "SG", "\u0938\u093f\u0919\u094d\u0917\u093e\u092a\u0941\u0930" },
            { "SH", "\u0938\u0947\u0928\u094d\u091f \u0939\u0947\u0932\u0947\u0928\u093e" },
            { "type.lb.strict", "strict" },
            { "017", "\u092e\u0927\u094d\u092f \u0905\u092b\u094d\u0930\u093f\u0915\u093e" },
            { "SI", "\u0938\u094d\u0932\u094b\u092d\u0947\u0928\u093f\u092f\u093e" },
            { "018", "\u0926\u0915\u094d\u0937\u093f\u0923\u0940 \u0905\u092b\u094d\u0930\u093f\u0915\u093e" },
            { "SJ", "\u0938\u092d\u093e\u0932\u094d\u092c\u093e\u0930\u094d\u0921 \u0930 \u091c\u093e\u0928 \u092e\u093e\u092f\u0947\u0928" },
            { "019", "\u0905\u092e\u0947\u0930\u093f\u0915\u093e\u0938" },
            { "SK", "\u0938\u094d\u0932\u094b\u092d\u093e\u0915\u093f\u092f\u093e" },
            { "SL", "\u0938\u093f\u090f\u0930\u094d\u0930\u093e \u0932\u093f\u0913\u0928" },
            { "SM", "\u0938\u093e\u0928\u094d \u092e\u093e\u0930\u093f\u0928\u094b" },
            { "SN", "\u0938\u0947\u0928\u0947\u0917\u0932" },
            { "SO", "\u0938\u094b\u092e\u093e\u0932\u093f\u092f\u093e" },
            { "arn", "\u092e\u093e\u092a\u0941\u091a\u0947" },
            { "arp", "\u0905\u0930\u093e\u092a\u093e\u0939\u094b" },
            { "type.nu.taml", "\u092a\u0930\u092e\u094d\u092a\u0930\u093e\u0917\u0924 \u0924\u093e\u092e\u093f\u0932 \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "SR", "\u0938\u0941\u0930\u093f\u0928\u0947\u092e" },
            { "aro", "\u0905\u0930\u093e\u0913\u0928\u093e" },
            { "SS", "\u0926\u0915\u094d\u0937\u093f\u0923\u0940 \u0938\u0941\u0921\u093e\u0928" },
            { "ST", "\u0938\u093e\u0913 \u091f\u094b\u092e\u0947 \u0930 \u092a\u094d\u0930\u093f\u0928\u094d\u0938\u093f\u092a" },
            { "arq", "\u0905\u0932\u094d\u091c\u0947\u0930\u093f\u092f\u093e\u0932\u0940 \u0905\u0930\u092c\u0940" },
            { "SV", "\u090f\u0932\u094d \u0938\u093e\u0932\u094d\u092d\u093e\u0921\u094b\u0930" },
            { "SX", "\u0938\u093f\u0928\u094d\u091f \u092e\u093e\u0930\u094d\u091f\u0947\u0928" },
            { "SY", "\u0938\u093f\u0930\u093f\u092f\u093e" },
            { "SZ", "\u0938\u094d\u0935\u093e\u091c\u093f\u0932\u094d\u092f\u093e\u0923\u094d\u0921" },
            { "arw", "\u0905\u0930\u093e\u0935\u093e\u0915" },
            { "arz", "\u0907\u091c\u093f\u092a\u094d\u091f \u0905\u0930\u092c\u0940" },
            { "ary", "\u092e\u094b\u0930\u094b\u0915\u094d\u0915\u094b\u0932\u0940 \u0905\u0930\u092c\u0940" },
            { "TA", "\u091f\u094d\u0930\u093f\u0938\u094d\u091f\u093e\u0928 \u0921\u093e \u0915\u0941\u0928\u094d\u0939\u093e" },
            { "asa", "\u0906\u0938\u0941" },
            { "type.ms.ussystem", "\u0938\u0902\u092f\u0941\u0915\u094d\u0924 \u0930\u093e\u091c\u094d\u092f \u092e\u093e\u092a\u0928 \u092a\u094d\u0930\u0923\u093e\u0932\u0940" },
            { "021", "\u0909\u0924\u094d\u0924\u0930\u0940 \u0905\u092e\u0947\u0930\u093f\u0915\u093e" },
            { "TC", "\u0924\u0941\u0930\u094d\u0915 \u0930 \u0915\u093e\u0907\u0915\u094b\u0938 \u091f\u093e\u092a\u0941" },
            { "yav", "\u092f\u093e\u0919\u094d\u092c\u0947\u0928" },
            { "TD", "\u091a\u093e\u0921" },
            { "TF", "\u092b\u094d\u0930\u093e\u0928\u094d\u0938\u0947\u0932\u0940 \u0926\u0915\u094d\u0937\u093f\u0923\u0940 \u0915\u094d\u0937\u0947\u0924\u094d\u0930\u0939\u0930\u0941" },
            { "ase", "\u0905\u092e\u0947\u0930\u093f\u0915\u0940 \u0938\u093e\u0919\u094d\u0915\u0947\u0924\u093f\u0915 \u092d\u093e\u0937\u093e" },
            { "TG", "\u091f\u094b\u0917\u094b" },
            { "TH", "\u0925\u093e\u0907\u0932\u094d\u092f\u093e\u0923\u094d\u0921" },
            { "TJ", "\u0924\u093e\u091c\u093f\u0915\u093f\u0938\u094d\u0924\u093e\u0928" },
            { "029", "\u0915\u094d\u092f\u093e\u0930\u093f\u092c\u093f\u092f\u0928" },
            { "TK", "\u0924\u094b\u0915\u0947\u0932\u093e\u0909" },
            { "TL", "\u091f\u093f\u092e\u094b\u0930-\u0932\u0947\u0938\u094d\u091f\u0947" },
            { "ybb", "\u092f\u0947\u092e\u094d\u092c\u093e" },
            { "TM", "\u0924\u0941\u0930\u094d\u0915\u092e\u0947\u0928\u093f\u0938\u094d\u0924\u093e\u0928" },
            { "TN", "\u091f\u094d\u092f\u0941\u0928\u093f\u0938\u093f\u092f\u093e" },
            { "TO", "\u091f\u094b\u0902\u0917\u093e" },
            { "TR", "\u091f\u0930\u094d\u0915\u0940" },
            { "TT", "\u0924\u094d\u0930\u093f\u0928\u093f\u0921\u093e\u0921 \u090f\u0923\u094d\u0921 \u091f\u094b\u092c\u093e\u0917\u094b" },
            { "TV", "\u0924\u0941\u092d\u093e\u0932\u0941" },
            { "TW", "\u0924\u093e\u0907\u0935\u093e\u0928" },
            { "ast", "\u0905\u0938\u094d\u091f\u0941\u0930\u093f\u092f\u093e\u0932\u0940" },
            { "Orkh", "\u0913\u0930\u094d\u0916\u094b\u0928" },
            { "TZ", "\u0924\u093e\u0928\u094d\u091c\u093e\u0928\u093f\u092f\u093e" },
            { "nmg", "\u0915\u094d\u0935\u093e\u0938\u093f\u092f\u094b" },
            { "Zzzz", "\u0905\u091c\u094d\u091e\u093e\u0924 \u0932\u093f\u092a\u093f" },
            { "UA", "\u092f\u0941\u0915\u094d\u0930\u0947\u0928" },
            { "lij", "\u0932\u093f\u0917\u0941\u0930\u093f\u092f\u093e\u0932\u0940" },
            { "rup", "\u0905\u0930\u094b\u092e\u093e\u0928\u0940\u092f\u093e\u0932\u0940" },
            { "030", "\u092a\u0942\u0930\u094d\u0935\u0940 \u090f\u0936\u093f\u092f\u093e" },
            { "tyv", "\u091f\u0941\u092d\u093f\u0928\u093f\u092f\u093e\u0932\u0940" },
            { "sw_CD", "\u0915\u0919\u094d\u0917\u094b \u0938\u094d\u0935\u093e\u0939\u093f\u0932\u0940" },
            { "034", "\u0926\u0915\u094d\u0937\u093f\u0923\u0940 \u090f\u0936\u093f\u092f\u093e" },
            { "hai", "\u0939\u093e\u0907\u0926\u093e" },
            { "035", "\u0926\u0915\u094d\u0937\u093f\u0923 \u092a\u0942\u0930\u094d\u0935\u0940 \u090f\u0936\u093f\u092f\u093e" },
            { "UG", "\u092f\u0941\u0917\u093e\u0923\u094d\u0921\u093e" },
            { "hak", "\u0939\u0915\u094d\u0915\u093e \u091a\u093f\u0928\u093f\u092f\u093e\u0901" },
            { "type.co.pinyin", "\u092a\u093f\u0928\u092f\u093f\u0928 \u0915\u094d\u0930\u092e\u092c\u0926\u094d\u0927\u0924\u093e \u092a\u0926\u094d\u0926\u0924\u093f" },
            { "039", "\u0926\u0915\u094d\u0937\u093f\u0923\u0940 \u092f\u0941\u0930\u094b\u092a" },
            { "Sinh", "\u0938\u093f\u0928\u094d\u0939\u093e\u0932\u093e" },
            { "UM", "\u0938\u0902\u092f\u0941\u0915\u094d\u0924 \u0930\u093e\u091c\u094d\u092f\u0915\u093e \u092c\u093e\u0939\u094d\u092f \u091f\u093e\u092a\u0941\u0939\u0930\u0941" },
            { "liv", "\u0932\u093f\u092d\u094b\u0928\u093f\u092f\u093e\u0932\u0940" },
            { "UN", "\u0938\u0902\u092f\u0941\u0915\u094d\u0924 \u0930\u093e\u0937\u094d\u091f\u094d\u0930 \u0938\u0902\u0918" },
            { "US", "\u0938\u0902\u092f\u0941\u0915\u094d\u0924 \u0930\u093e\u091c\u094d\u092f" },
            { "haw", "\u0939\u0935\u093e\u0907\u092f\u0928" },
            { "type.co.gb2312han", "\u0938\u0930\u0932\u093f\u0915\u0943\u0924 \u091a\u093f\u0928\u093f\u092f\u093e\u0901 \u0915\u094d\u0930\u092e\u092c\u0926\u094d\u0927\u0924\u093e \u092a\u0926\u094d\u0926\u0924\u093f-\u0917\u0940\u092c\u0940\u091f\u0941\u0925\u094d\u0930\u0940\u0935\u093e\u0928\u091f\u0941" },
            { "UY", "\u0909\u0930\u0942\u0917\u094d\u0935\u0947" },
            { "prg", "\u092a\u094d\u0930\u0938\u093f\u092f\u093e\u0932\u0940" },
            { "UZ", "\u0909\u091c\u094d\u092c\u0947\u0915\u093f\u0938\u094d\u0924\u093e\u0928" },
            { "tzm", "\u0915\u0947\u0928\u094d\u0926\u094d\u0930\u0940\u092f \u090f\u091f\u094d\u0932\u093e\u0938 \u091f\u093e\u092e\u093e\u091c\u093f\u0918\u091f" },
            { "type.co.stroke", "\u0938\u094d\u091f\u094d\u0930\u094b\u0915 \u0915\u094d\u0930\u092e\u092c\u0926\u094d\u0927\u0924\u093e \u092a\u0926\u094d\u0926\u0924\u093f" },
            { "nnh", "\u0928\u094d\u0917\u093f\u090f\u092e\u094d\u092c\u0941\u0928" },
            { "VA", "\u092d\u0947\u091f\u093f\u0915\u0928 \u0938\u093f\u091f\u0940" },
            { "pro", "\u092a\u0941\u0930\u093e\u0924\u0928 \u092a\u094d\u0930\u094b\u092d\u0947\u0928\u094d\u0915\u093e\u0932" },
            { "VC", "\u0938\u0947\u0928\u094d\u091f \u092d\u093f\u0928\u094d\u0938\u0947\u0928\u094d\u091f \u0930 \u0917\u094d\u0930\u0947\u0928\u093e\u0921\u093f\u0928\u094d\u0938" },
            { "VE", "\u092d\u0947\u0928\u0947\u091c\u0941\u090f\u0932\u093e" },
            { "VG", "\u092c\u0947\u0932\u093e\u092f\u0924\u0940 \u092d\u0930\u094d\u091c\u093f\u0928 \u091f\u093e\u092a\u0941\u0939\u0930\u0941" },
            { "VI", "\u0938\u0902\u092f\u0941\u0915\u094d\u0924 \u0930\u093e\u091c\u094d\u092f \u092d\u0930\u094d\u091c\u093f\u0928 \u091f\u093e\u092a\u0941\u0939\u0930\u0941" },
            { "VN", "\u092d\u093f\u090f\u0924\u0928\u093e\u092e" },
            { "VU", "\u092d\u093e\u0928\u0941\u0906\u0924\u0941" },
            { "nog", "\u0928\u094b\u0917\u093e\u0907" },
            { "rwk", "\u0930\u094d\u200c\u0935\u093e" },
            { "non", "\u092a\u0941\u0930\u093e\u0928\u094b \u0928\u094b\u0930\u094d\u0938\u0947" },
            { "053", "\u0905\u0937\u094d\u091f\u094d\u0930\u093e\u0932\u093e\u0938\u093f\u092f\u093e" },
            { "054", "\u092e\u0947\u0932\u093e\u0928\u0947\u0938\u093f\u092f\u093e" },
            { "WF", "\u0935\u093e\u0932\u093f\u0938 \u0930 \u092b\u0941\u091f\u0941\u0928\u093e" },
            { "type.co.traditional", "\u092a\u0930\u092e\u094d\u092a\u0930\u093e\u0917\u0924 \u0915\u094d\u0930\u092e\u092c\u0926\u094d\u0927\u0924\u093e \u092a\u0926\u094d\u0926\u0924\u093f" },
            { "057", "\u092e\u093e\u0907\u0915\u094d\u0930\u094b\u0928\u0947\u0938\u093f\u092f\u093e\u0932\u0940 \u0915\u094d\u0937\u0947\u0924\u094d\u0930" },
            { "jgo", "\u0928\u094d\u0917\u094b\u092e\u094d\u092c\u093e" },
            { "lkt", "\u0932\u093e\u0915\u094b\u0924\u093e" },
            { "nov", "\u0928\u094b\u092d\u093f\u092f\u0932" },
            { "avk", "\u0915\u094b\u091f\u093e\u0935\u093e" },
            { "wae", "\u0935\u093e\u0932\u094d\u0938\u0930" },
            { "WS", metaValue_WS },
            { "wal", "\u0935\u094b\u0932\u0947\u091f\u094d\u091f\u093e" },
            { "war", "\u0935\u093e\u0930\u0947" },
            { "awa", "\u0905\u0935\u0927\u0940" },
            { "061", "\u092a\u094b\u0932\u093f\u0928\u0947\u0936\u093f\u092f\u093e" },
            { "XK", "\u0915\u094b\u0938\u094b\u092d\u094b" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "\u0928\u0932\u0947\u0916\u093f\u090f\u0915\u094b" },
            { "Olck", "\u0913\u0932\u091a\u093f\u0915\u0940" },
            { "wbp", "\u0935\u093e\u0930\u094d\u0932\u094d\u092a\u093f\u0930\u0940" },
            { "Batk", "\u092c\u093e\u091f\u0915" },
            { "Blis", "\u092c\u094d\u0932\u093f\u091c\u0938\u093f\u092e\u094d\u092c\u094b\u0932\u094d\u0938" },
            { "YE", "\u092f\u0947\u092e\u0947\u0928" },
            { "nqo", "\u0928\u0915\u094b" },
            { "type.co.standard", "\u092e\u093e\u0928\u0915 \u0915\u094d\u0930\u092e\u092c\u0926\u094d\u0927\u0924\u093e" },
            { "lmo", "\u0932\u094b\u092e\u094d\u092c\u093e\u0930\u094d\u0921" },
            { "fan", "\u092b\u093e\u0919" },
            { "fat", "\u092b\u093e\u0928\u094d\u091f\u0940" },
            { "Sgnw", "\u0938\u093e\u0907\u0928\u0930\u093e\u0907\u091f\u093f\u0919" },
            { "YT", "\u092e\u093e\u092f\u094b\u091f\u094d\u091f" },
            { "ZA", "\u0926\u0915\u094d\u0937\u093f\u0923 \u0905\u092b\u094d\u0930\u093f\u0915\u093e" },
            { "type.lb.loose", "loose" },
            { "Deva", metaValue_Deva },
            { "type.nu.geor", "\u091c\u0930\u094d\u091c\u093f\u092f\u093e\u0932\u0940 \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "Hira", "\u0939\u093f\u0930\u093e\u0917\u0928\u093e" },
            { "ZM", "\u091c\u093e\u092e\u094d\u092c\u093f\u092f\u093e" },
            { "ZW", "\u091c\u093f\u092e\u094d\u092c\u093e\u092c\u0947" },
            { "ZZ", "\u0905\u091c\u094d\u091e\u093e\u0924 \u0915\u094d\u0937\u0947\u0924\u094d\u0930" },
            { "Runr", "\u0930\u0942\u0928\u093f\u0915" },
            { "type.ms.metric", "\u092e\u0947\u091f\u094d\u0930\u093f\u0915 \u092a\u094d\u0930\u0923\u093e\u0932\u0940" },
            { "type.ca.iso8601", "ISO-8601 Calendar" },
            { "lol", "\u092e\u094b\u0919\u094d\u0917\u094b" },
            { "nso", "\u0909\u0924\u094d\u0924\u0930\u0940 \u0938\u094b\u0925\u094b" },
            { "type.nu.telu", "\u0924\u0947\u0932\u0947\u0917\u0941 \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "loz", "\u0932\u094b\u091c\u0940" },
            { "jmc", "\u092e\u093e\u091a\u093e\u092e\u0947" },
            { "hif", "\u092b\u093f\u091c\u0940 \u0939\u093f\u0928\u094d\u0926\u0940" },
            { "type.nu.hansfin", "\u0938\u0930\u0932\u093f\u0915\u0943\u0924 \u091a\u093f\u0928\u093f\u092f\u093e\u0901 \u0935\u093f\u0924\u094d\u0924\u0940\u092f \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "hil", "\u0939\u093f\u0932\u093f\u0917\u093e\u092f\u0928\u094b\u0928" },
            { "type.nu.arabext", "\u0935\u093f\u0938\u094d\u0924\u0943\u0924 \u0905\u0930\u092c\u0940 \u092d\u093e\u0930\u0924\u0940\u092f \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "nus", "\u0928\u0941\u090f\u0930" },
            { "dak", "\u0921\u093e\u0915\u094b\u091f\u093e" },
            { "type.nu.fullwide", "\u092a\u0942\u0930\u093e \u091a\u094c\u0902\u0921\u093e\u0907\u0915\u093e \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "hit", "\u0939\u093f\u091f\u094d\u091f\u093f\u091f\u0947" },
            { "dar", "\u0926\u093e\u0930\u094d\u0917\u094d\u0935\u093e" },
            { "dav", "\u0924\u093e\u0907\u0924\u093e" },
            { "Maya", "\u092e\u093e\u092f\u093e \u0939\u093e\u0907\u0930\u094b\u0917\u094d\u0932\u093f\u092b\u094d\u0938" },
            { "lrc", "\u0909\u0924\u094d\u0924\u0930\u0940 \u0932\u0941\u0930\u0940" },
            { "Copt", "\u0915\u092a\u094d\u091f\u093f\u0915" },
            { "nwc", "\u092a\u0930\u092e\u094d\u092a\u0930\u093e\u0917\u0924 \u0928\u0947\u0935\u093e\u0930\u0940" },
            { "udm", "\u0909\u0921\u094d\u092e\u0941\u0930\u094d\u091f" },
            { "Khmr", metaValue_km },
            { "Limb", "\u0932\u093f\u092e\u094d\u092c\u0941" },
            { "sad", "\u0938\u093e\u0928\u094d\u0921\u0947\u0905" },
            { "type.nu.roman", "\u0930\u094b\u092e\u0928 \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "sah", "\u0938\u093e\u0916\u093e" },
            { "ltg", "\u0932\u093e\u091f\u094d\u0917\u093e\u0932\u0940" },
            { "saq", "\u0938\u093e\u092e\u094d\u092c\u0941\u0930\u0942" },
            { "sat", "\u0938\u093e\u0928\u094d\u0924\u093e\u0932\u0940" },
            { "Tfng", "\u091f\u093f\u092b\u093f\u0928\u093e\u0918" },
            { "jpr", "\u091c\u0941\u0921\u093f\u092f\u094b-\u092b\u093e\u0930\u0938\u0940" },
            { "sba", "\u0928\u094d\u0917\u093e\u092e\u092c\u093e\u092f" },
            { "Guru", "\u0917\u0941\u0930\u0942\u092e\u0941\u0916\u0940" },
            { "lua", "\u0932\u0941\u092c\u093e-\u0932\u0941\u0932\u0941\u0906" },
            { "sbp", "\u0938\u093e\u0919\u094d\u0917\u0941" },
            { "lui", "\u0932\u0941\u0907\u0938\u0947\u0928\u094b" },
            { "nyn", "\u0928\u094d\u092f\u093e\u0928\u094d\u0915\u094b\u0932" },
            { "nym", "\u0928\u094d\u092f\u093e\u092e\u0935\u0947\u091c\u0940" },
            { "lun", "\u0932\u0941\u0928\u094d\u0921\u093e" },
            { "nyo", "\u0928\u094d\u092f\u094b\u0930\u094b" },
            { "luo", "\u0932\u0941\u0913" },
            { "fil", "\u092b\u093f\u0932\u093f\u092a\u093f\u0928\u0940" },
            { "hmn", "\u0939\u092e\u094b\u0919" },
            { "del", "\u0926\u0947\u0932\u093e\u0935\u0930" },
            { "lus", "\u092e\u093f\u091c\u094b" },
            { "bal", "\u092c\u093e\u0932\u0941\u091a\u0940" },
            { "ban", metaValue_ban },
            { "luy", "\u0932\u0941\u0907\u092f\u093e" },
            { "bar", "\u092c\u093e\u092d\u093e\u0930\u093f\u092f\u093e\u0932\u0940" },
            { "bas", "\u092c\u093e\u0938\u093e" },
            { "bax", "\u092c\u093e\u092e\u0941\u0928" },
            { "jrb", "\u091c\u0941\u0921\u093f\u092f\u094b-\u0905\u0930\u092c\u0940" },
            { "es_ES", "\u092f\u0941\u0930\u094b\u092a\u0947\u0932\u0940 \u0938\u094d\u092a\u0947\u0928\u0940" },
            { "nzi", "\u0928\u091c\u093f\u092e\u093e" },
            { "sco", "\u0938\u094d\u0915\u091f\u094d\u0938" },
            { "scn", "\u0938\u093f\u0938\u093f\u0932\u093f\u092f\u093e\u0932\u0940" },
            { "aa", "\u0905\u092b\u093e\u0930" },
            { "ab", "\u0905\u092c\u094d\u0916\u093e\u091c\u093f\u092f\u093e\u0932\u0940" },
            { "bbc", "\u092c\u093e\u0924\u093e\u0915 \u0924\u094b\u092c\u093e" },
            { "ae", "\u0905\u0935\u0947\u0938\u094d\u0924\u093e\u0928" },
            { "af", "\u0905\u092b\u094d\u0930\u093f\u0915\u093e\u0928\u094d\u0938" },
            { "ak", "\u0906\u0915\u093e\u0928" },
            { "bbj", "\u0918\u094b\u092e\u093e\u0932\u093e" },
            { "am", "\u0905\u092e\u094d\u0939\u093e\u0930\u093f\u0915" },
            { "Arab", metaValue_ar },
            { "an", "\u0905\u0930\u093e\u0917\u094b\u0928\u0940" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "\u0915\u093e\u0924\u093e\u0915\u093e\u0928\u093e \u0935\u093e \u0939\u093f\u0930\u093e\u0917\u093e\u0928\u093e" },
            { "as", "\u0906\u0938\u093e\u092e\u0940" },
            { "av", "\u0905\u0935\u093e\u0930\u093f\u0915" },
            { "sdh", "\u0926\u0915\u094d\u0937\u093f\u0923\u0940 \u0915\u0941\u0930\u094d\u0926\u093f\u0936" },
            { "ay", "\u0910\u092e\u093e\u0930\u093e" },
            { "az", "\u0905\u091c\u0930\u092c\u0948\u091c\u093e\u0928\u0940" },
            { "ba", "\u092c\u093e\u0938\u094d\u0915\u093f\u0930" },
            { "be", "\u092c\u0947\u0932\u093e\u0930\u0941\u0938\u0940" },
            { "bg", "\u092c\u0941\u0932\u094d\u0917\u0947\u0930\u093f\u092f\u093e\u0932\u0940" },
            { "bi", "\u092c\u093f\u0938\u094d\u0932\u093e\u092e" },
            { "bm", "\u092c\u093e\u092e\u094d\u092c\u093e\u0930\u093e" },
            { "bn", "\u092c\u0902\u0917\u093e\u0932\u0940" },
            { "bo", metaValue_bo },
            { "dgr", "\u0926\u094b\u0917\u094d\u0930\u093f\u092c" },
            { "br", "\u092c\u094d\u0930\u0947\u091f\u0928" },
            { "bs", "\u092c\u094b\u0938\u094d\u0928\u093f\u092f\u093e\u0932\u0940" },
            { "Mymr", "\u092e\u094d\u092f\u093e\u0928\u094d\u092e\u093e\u0930" },
            { "type.nu.laoo", "\u0932\u093e\u0913 \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "seh", "\u0938\u0947\u0928\u093e" },
            { "Nkoo", "\u090f\u0928\u094d\u0915\u094b" },
            { "ca", "\u0915\u094d\u092f\u093e\u091f\u093e\u0932\u0928" },
            { "ses", "\u0915\u094b\u092f\u0930\u093e\u092c\u094b\u0930\u094b \u0938\u0947\u0928\u094d\u0928\u0940" },
            { "ce", "\u091a\u0947\u091a\u0947\u0928" },
            { "ch", "\u091a\u093e\u092e\u094b\u0930\u094d\u0930\u094b" },
            { "co", "\u0915\u094b\u0930\u094d\u0938\u093f\u0915\u0928" },
            { "Orya", "\u0913\u0921\u093f\u092f\u093e" },
            { "cr", "\u0915\u094d\u0930\u0940" },
            { "cs", "\u091a\u0947\u0915" },
            { "cu", "\u091a\u0930\u094d\u091a \u0938\u094d\u0932\u093e\u092d\u093f\u0915" },
            { "yrl", "\u0928\u094d\u0939\u093f\u0928\u0917\u093e\u0924\u0941" },
            { "cv", "\u091a\u0941\u092d\u093e\u0938" },
            { "cy", "\u0935\u0947\u0932\u094d\u0936" },
            { "type.nu.ethi", "\u0907\u0925\u093f\u092f\u094b\u092a\u093e\u0932\u0940 \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "Yiii", "\u092f\u0940" },
            { "da", "\u0921\u0947\u0928\u093f\u0938" },
            { "pt_PT", "\u092f\u0941\u0930\u094b\u092a\u0947\u0932\u0940 \u092a\u094b\u0930\u094d\u0924\u0941\u0917\u0940" },
            { "de", "\u091c\u0930\u094d\u092e\u0928" },
            { "type.cf.standard", "cf-standard" },
            { "bej", "\u092c\u0947\u091c\u093e" },
            { "din", "\u0926\u093f\u0928\u094d\u0915\u093e" },
            { "jut", "\u091c\u0941\u091f\u093f\u0938" },
            { "Bugi", "\u092c\u0941\u0917\u093f\u0928\u093f\u091c" },
            { "bem", "\u092c\u0947\u092e\u094d\u092c\u093e" },
            { "sga", "\u092a\u0941\u0930\u093e\u0924\u0928 \u0906\u092f\u0930\u0940\u0938" },
            { "dv", "\u0926\u093f\u092c\u0947\u0939\u0940" },
            { "es_419", "\u0932\u094d\u092f\u093e\u091f\u093f\u0928 \u0905\u092e\u0947\u0930\u093f\u0915\u0940 \u0938\u094d\u092a\u0947\u0928\u0940" },
            { "bew", "\u092c\u0947\u091f\u093e\u0935\u0940" },
            { "dz", "\u091c\u094b\u0919\u094d\u0916\u093e" },
            { "bez", "\u092c\u0947\u0928\u093e" },
            { "type.ca.chinese", "\u091a\u093f\u0928\u093f\u092f\u093e\u0901 \u092a\u093e\u0924\u094d\u0930\u094b" },
            { "lzh", "\u0938\u093e\u0939\u093f\u0924\u094d\u092f\u093f\u0915 \u091a\u093f\u0928\u093f\u092f\u093e\u0901" },
            { "dje", "\u091c\u0930\u094d\u092e\u093e" },
            { "type.nu.grek", "\u0917\u094d\u0930\u0940\u0915 \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "ee", "\u0907\u0935\u0940" },
            { "bfd", "\u092c\u093e\u092b\u0941\u091f" },
            { "type.lb.normal", "normal" },
            { "ro_MD", "\u092e\u094b\u0932\u094d\u0921\u093e\u092d\u093f\u092f\u093e\u0932\u0940" },
            { "el", metaValue_el },
            { "en", "\u0905\u0919\u094d\u0917\u094d\u0930\u0947\u091c\u0940" },
            { "eo", "\u090f\u0938\u094d\u092a\u0947\u0930\u093e\u0928\u094d\u0924\u094b" },
            { "bfq", "\u092c\u0921\u093e\u0917\u093e" },
            { "lzz", "\u0932\u093e\u091c" },
            { "type.co.big5han", "\u092a\u0930\u092e\u094d\u092a\u0930\u093e\u0917\u0924 \u091a\u093f\u0928\u093f\u0901\u092f\u093e \u0915\u094d\u0930\u092e\u092c\u0926\u094d\u0927\u0924\u093e \u092a\u0926\u094d\u0926\u0924\u093f - \u092c\u093f\u0917 \u092b\u093e\u0907\u092d" },
            { "es", "\u0938\u094d\u092a\u0947\u0928\u0940" },
            { "et", "\u0907\u0938\u094d\u091f\u094b\u0928\u093f\u092f\u0928" },
            { "Hanb", "\u0939\u093e\u0928\u094d\u092c" },
            { "eu", "\u092c\u093e\u0938\u094d\u0915" },
            { "Buhd", "\u092c\u0941\u0939\u093f\u0926" },
            { "Hang", "\u0939\u093e\u0928\u094d\u0917\u0941\u0932" },
            { "Samr", "\u0938\u092e\u093e\u0930\u093f\u091f\u0928" },
            { "shi", "\u091f\u093e\u091a\u0947\u0932\u094d\u0939\u093f\u091f" },
            { "hsb", "\u092e\u093e\u0925\u093f\u0932\u094d\u0932\u094b \u0938\u094b\u0930\u094d\u092c\u093f\u092f\u0928" },
            { "Hani", "\u0939\u093e\u0928" },
            { "shn", "\u0936\u093e\u0928" },
            { "Hano", "\u0939\u093e\u0928\u0941\u0928\u0941" },
            { "fa", "\u092b\u093e\u0930\u0938\u0940" },
            { "Hans", metaValue_Hans },
            { "type.nu.latn", "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "Hant", metaValue_Hant },
            { "ff", "\u092b\u0941\u0932\u093e\u0939" },
            { "shu", "\u091a\u093e\u0921 \u0905\u0930\u092c\u0940" },
            { "fi", "\u092b\u093f\u0928\u093f\u0938" },
            { "fj", "\u092b\u093f\u091c\u093f\u092f\u0928" },
            { "fon", "\u092b\u094b\u0928" },
            { "bgn", "\u092a\u0936\u094d\u091a\u093f\u092e \u092c\u093e\u0932\u094b\u091a\u0940" },
            { "yue", "\u0915\u094d\u092f\u093e\u0928\u094d\u091f\u094b\u0928\u093f\u091c" },
            { "fo", "\u092b\u093e\u0930\u094b\u091c" },
            { "umb", "\u0909\u092e\u094d\u092c\u0941\u0928\u094d\u0921\u0940" },
            { "fr", "\u092b\u094d\u0930\u093e\u0928\u094d\u0938\u0947\u0932\u0940" },
            { "fy", "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u092b\u094d\u0930\u093f\u0938\u093f\u092f\u0928" },
            { "ga", "\u0906\u0907\u0930\u093f\u0938" },
            { "gd", "\u0938\u094d\u0915\u091f\u093f\u0938 \u0917\u093e\u090f\u0932\u093f\u0915" },
            { "gl", "\u0917\u0932\u093f\u0938\u093f\u092f\u093e\u0932\u0940" },
            { "gn", "\u0917\u0941\u0935\u093e\u0930\u093e\u0928\u0940" },
            { "bho", "\u092d\u094b\u091c\u092a\u0941\u0930\u0940" },
            { "und", "\u0905\u091c\u094d\u091e\u093e\u0924 \u092d\u093e\u0937\u093e" },
            { "gu", metaValue_gu },
            { "gv", "\u092e\u093e\u0928\u094d\u0915\u094d\u0938" },
            { "ha", "\u0939\u093e\u0909\u0938\u093e" },
            { "he", metaValue_he },
            { "hi", "\u0939\u093f\u0928\u094d\u0926\u0940" },
            { "hup", "\u0939\u0941\u092a\u093e" },
            { "bik", "\u092c\u093f\u0915\u094b\u0932" },
            { "bin", "\u092c\u093f\u0928\u0940" },
            { "ho", "\u0939\u093f\u0930\u0940 \u092e\u094b\u091f\u0941" },
            { "hr", "\u0915\u094d\u0930\u094b\u092f\u0938\u093f\u092f\u093e\u0932\u0940" },
            { "ht", "\u0939\u0948\u091f\u093f\u092f\u093e\u0932\u0940 \u0915\u094d\u0930\u093f\u092f\u094b\u0932" },
            { "hu", "\u0939\u0919\u094d\u0917\u0947\u0930\u093f\u092f\u093e\u0932\u0940" },
            { "hy", metaValue_hy },
            { "hz", "\u0939\u0947\u0930\u0947\u0930\u094b" },
            { "frc", "\u0915\u093e\u0939\u0941\u0928 \u092b\u094d\u0930\u093e\u0928\u094d\u0938\u0947\u0932\u0940" },
            { "ia", "\u0907\u0928\u094d\u091f\u0930\u094d\u0932\u093f\u0919\u094d\u0917\u0941\u0906" },
            { "Jamo", "\u091c\u093e\u092e\u094b" },
            { "id", "\u0907\u0928\u094d\u0921\u094b\u0928\u0947\u0938\u093f\u092f\u093e\u0932\u0940" },
            { "type.nu.tibt", "\u0924\u093f\u092c\u094d\u092c\u0924\u0940 \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "ie", "\u0907\u0928\u094d\u091f\u0930\u0932\u093f\u0919\u094d\u0917\u094d\u0935\u0947" },
            { "ig", "\u0907\u0917\u094d\u092c\u094b" },
            { "ii", "\u0938\u093f\u091a\u0941\u0906\u0928 \u092f\u093f" },
            { "frm", "\u092e\u0927\u094d\u092f \u092b\u094d\u0930\u093e\u0928\u094d\u0938\u0947\u0932\u0940" },
            { "ik", "\u0907\u0928\u0941\u092a\u093f\u0906\u0915\u094d" },
            { "fro", "\u092a\u0941\u0930\u093e\u0924\u0928 \u092b\u094d\u0930\u093e\u0928\u094d\u0938\u0947\u0932\u0940" },
            { "frp", "\u0905\u0930\u094d\u092a\u093f\u0924\u093e\u0928" },
            { "io", "\u0907\u0921\u094b" },
            { "frs", "\u092a\u0942\u0930\u094d\u0935\u0940 \u092b\u094d\u0930\u093f\u0938\u093f\u092f\u093e\u0932\u0940" },
            { "bjn", "\u092c\u0928\u094d\u091c\u093e\u0930" },
            { "frr", "\u0909\u0924\u094d\u0924\u0930\u0940 \u092b\u094d\u0930\u093f\u091c\u0940" },
            { "is", "\u0906\u0907\u0938\u0932\u094d\u092f\u093e\u0928\u094d\u0921\u093f\u092f\u093e\u0932\u0940" },
            { "it", "\u0907\u091f\u093e\u0932\u0947\u0932\u0940" },
            { "iu", "\u0907\u0928\u0941\u0915\u094d\u091f\u093f\u091f\u0941\u091f" },
            { "sli", "\u0924\u0932\u094d\u0932\u094b \u0938\u093f\u0932\u0947\u0938\u093f\u092f\u093e\u0932\u0940" },
            { "ja", metaValue_ja },
            { "Mlym", "\u092e\u0932\u093e\u092f\u093e\u0932\u092e" },
            { "Sara", "\u0938\u093e\u0930\u0924\u0940" },
            { "doi", "\u0921\u094b\u0917\u0930\u0940" },
            { "bkm", "\u0915\u094b\u092e" },
            { "sma", "\u0926\u0915\u094d\u0937\u093f\u0923\u0940 \u0938\u093e\u092e\u0940" },
            { "jv", metaValue_jv },
            { "Shaw", "\u0936\u093e\u092d\u093f\u092f\u0928" },
            { "mad", "\u092e\u093e\u0926\u0941\u0930\u0947\u0938\u0947" },
            { "smj", "\u0932\u0941\u0932\u0947 \u0938\u093e\u092e\u0940" },
            { "mag", "\u092e\u0917\u0927\u0940" },
            { "maf", "\u092e\u093e\u092b\u093e" },
            { "mai", "\u092e\u0948\u0925\u093f\u0932\u0940" },
            { "smn", "\u0907\u0928\u093e\u0930\u0940 \u0938\u093e\u092e\u0940" },
            { "ka", metaValue_ka },
            { "bla", "\u0938\u093f\u0915\u094d\u0938\u093f\u0915\u093e" },
            { "mak", "\u092e\u093e\u0915\u093e\u0938\u093e\u0930" },
            { "sms", "\u0938\u094d\u0915\u094b\u0907\u091f \u0938\u093e\u092e\u0940" },
            { "man", "\u092e\u093e\u0928\u094d\u0926\u093f\u0919\u094b" },
            { "kg", "\u0915\u094b\u0919\u094d\u0917\u094b" },
            { "Goth", metaValue_got },
            { "ki", "\u0915\u093f\u0915\u0941\u092f\u0941" },
            { "mas", "\u092e\u0938\u093e\u0908" },
            { "kj", "\u0915\u0941\u0906\u0928\u094d\u092f\u093e\u092e\u093e" },
            { "kk", "\u0915\u093e\u091c\u093e\u0916" },
            { "kl", "\u0915\u093e\u0932\u093e\u0932\u093f\u0938\u0941\u091f" },
            { "km", metaValue_km },
            { "kn", "\u0915\u0928\u094d\u0928\u093e\u0921\u093e" },
            { "ko", "\u0915\u094b\u0930\u093f\u092f\u093e\u0932\u0940" },
            { "kr", "\u0915\u093e\u0928\u0941\u0930\u0940" },
            { "ks", "\u0915\u093e\u0938\u094d\u092e\u093f\u0930\u0940" },
            { "Cirt", "\u0915\u093f\u0930\u094d\u0925" },
            { "Lepc", "\u0932\u0947\u092a\u094d\u091a\u093e" },
            { "Avst", "\u0906\u092d\u0947\u0938\u094d\u091f\u093e\u0928" },
            { "ku", "\u0915\u0941\u0930\u094d\u0926\u0940" },
            { "kv", "\u0915\u094b\u092e\u0940" },
            { "kw", "\u0915\u094b\u0930\u094d\u0928\u093f\u0938" },
            { "ky", "\u0915\u093f\u0930\u094d\u0917\u093f\u091c" },
            { "snk", "\u0938\u094b\u0928\u093f\u0928\u094d\u0915\u0947" },
            { "la", metaValue_la },
            { "lb", "\u0932\u0915\u094d\u091c\u0947\u092e\u094d\u092c\u0930\u094d\u0917\u0940" },
            { "type.nu.mlym", "\u092e\u0932\u093e\u092f\u0932\u092e \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "lg", "\u0917\u093e\u0928\u094d\u0921\u093e" },
            { "Roro", "\u0930\u094b\u0919\u094d\u0917\u094b\u0930\u094b\u0919\u094d\u0917\u094b" },
            { "li", "\u0932\u093f\u092e\u094d\u092c\u0941\u0930\u094d\u0917\u0940" },
            { "Tibt", metaValue_bo },
            { "ln", "\u0932\u093f\u0919\u094d\u0917\u093e\u0932\u093e" },
            { "fur", "\u092b\u094d\u0930\u093f\u0909\u0932\u093f\u092f\u093e\u0932\u0940" },
            { "lo", metaValue_lo },
            { "type.ms.uksystem", "\u0907\u092e\u094d\u092a\u0947\u0930\u093f\u092f\u0932 \u092e\u093e\u092a\u0928 \u092a\u094d\u0930\u0923\u093e\u0932\u0940" },
            { "lt", "\u0932\u093f\u0925\u0941\u0906\u0928\u093f\u092f\u093e\u0932\u0940" },
            { "lu", "\u0932\u0941\u092c\u093e-\u0915\u093e\u0924\u093e\u0919\u094d\u0917\u093e" },
            { "lv", "\u0932\u093e\u0924\u094d\u092d\u093f\u092f\u093e\u0932\u0940" },
            { "mg", "\u092e\u0932\u093e\u0917\u093e\u0938\u0940" },
            { "mh", "\u092e\u093e\u0930\u094d\u0938\u093e\u0932\u0940" },
            { "type.co.ducet", "\u092a\u0942\u0930\u094d\u0935\u0928\u093f\u0930\u094d\u0927\u093e\u0930\u093f\u0924 \u092f\u0941\u0928\u093f\u0915\u094b\u0921\u0915\u094b \u0915\u094d\u0930\u092e\u092c\u0926\u094d\u0927\u0924\u093e \u0938\u0942\u091a\u0940" },
            { "mi", "\u092e\u093e\u0913\u0930\u0940" },
            { "mk", "\u092e\u094d\u092f\u093e\u0938\u0947\u0921\u094b\u0928\u093f\u092f\u0928" },
            { "ml", "\u092e\u0932\u092f\u093e\u0932\u092e" },
            { "mn", "\u092e\u0919\u094d\u0917\u094b\u0932\u093f\u092f\u093e\u0932\u0940" },
            { "mr", "\u092e\u0930\u093e\u0920\u0940" },
            { "ms", "\u092e\u0932\u093e\u092f" },
            { "mt", "\u092e\u093e\u0932\u094d\u091f\u093f\u091c" },
            { "my", "\u092c\u0930\u094d\u092e\u0947\u0932\u0940" },
            { "Saur", "\u0938\u094c\u0930\u093e\u0937\u094d\u091f\u094d\u0930" },
            { "Armn", metaValue_hy },
            { "mdf", "\u092e\u094b\u0915\u094d\u0937" },
            { "mde", "\u092e\u093e\u092c\u093e" },
            { "dsb", "\u0924\u0932\u094d\u0932\u094b \u0938\u094b\u0930\u094d\u092c\u093f\u092f\u0928" },
            { "Armi", "\u0906\u0930\u094d\u092e\u0940" },
            { "na", metaValue_NR },
            { "type.co.search", "\u0938\u093e\u092e\u093e\u0928\u094d\u092f \u0909\u0926\u094d\u0926\u0947\u0936\u0940\u092f \u0916\u094b\u091c\u0940" },
            { "nb", "\u0928\u0930\u094d\u0935\u0947\u0932\u0940 \u092c\u094b\u0915\u092e\u093e\u0932" },
            { "nd", "\u0909\u0924\u094d\u0924\u0930\u0940 \u0928\u094d\u0921\u0947\u092c\u0947\u0932\u0947" },
            { "ne", "\u0928\u0947\u092a\u093e\u0932\u0940" },
            { "ng", "\u0928\u094d\u0926\u094b\u0928\u094d\u0917\u093e" },
            { "mdr", "\u092e\u0928\u094d\u0926\u0930" },
            { "nl", "\u0921\u091a" },
            { "nn", "\u0928\u0930\u094d\u0935\u0947\u0932\u0940 \u0928\u093e\u0907\u0928\u094b\u0930\u094d\u0938\u094d\u0915" },
            { "no", "\u0928\u0930\u094d\u0935\u0947\u0932\u0940" },
            { "nr", "\u0926\u0915\u094d\u0937\u093f\u0923 \u0928\u094d\u0926\u0947\u092c\u0947\u0932\u0947" },
            { "nv", "\u0928\u093e\u092d\u093e\u091c\u094b" },
            { "kaa", "\u0915\u093e\u0930\u093e-\u0915\u093e\u0932\u094d\u092a\u093e\u0915" },
            { "ny", "\u0928\u094d\u092f\u093e\u0928\u094d\u091c\u093e" },
            { "kac", "\u0915\u093e\u091a\u093f\u0928" },
            { "kab", "\u0915\u093e\u092c\u093f\u0932" },
            { "oc", "\u0905\u0915\u094d\u0938\u093f\u091f\u0928" },
            { "kaj", "\u091c\u094d\u091c\u0941" },
            { "kam", "\u0915\u093e\u092e\u094d\u092c\u093e" },
            { "men", "\u092e\u0947\u0928\u094d\u0921\u0947" },
            { "oj", "\u0913\u091c\u093f\u092c\u094d\u0935\u093e" },
            { "mer", "\u092e\u0947\u0930\u0942" },
            { "type.nu.armn", "\u0906\u0930\u094d\u092e\u0947\u0928\u093f\u092f\u093e\u0932\u0940 \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "om", "\u0913\u0930\u094b\u092e\u094b" },
            { "kaw", "\u0915\u093e\u0935\u0940" },
            { "dtp", "\u0915\u0947\u0928\u094d\u0926\u094d\u0930\u0940\u092f \u0926\u0941\u0938\u0941\u0928" },
            { "or", "\u0909\u0921\u093f\u092f\u093e" },
            { "os", "\u0905\u094b\u0938\u094d\u0938\u0947\u091f\u093f\u0915" },
            { "bpy", "\u0935\u093f\u0937\u094d\u0923\u0941\u092a\u094d\u0930\u093f\u092f\u093e" },
            { "kbd", "\u0915\u093e\u092c\u093e\u0930\u094d\u0926\u093f\u092f\u093e\u0932\u0940" },
            { "mfe", "\u092e\u094b\u0930\u093f\u0938\u0947\u0928" },
            { "srn", "\u0938\u094d\u0930\u093e\u0928\u093e\u0928 \u091f\u094b\u0919\u094d\u0917\u094b" },
            { "pa", "\u092a\u0902\u091c\u093e\u092c\u0940" },
            { "dua", "\u0926\u0941\u0935\u093e\u0932\u093e" },
            { "kbl", "\u0915\u093e\u0928\u0947\u092e\u094d\u092c\u0941" },
            { "pi", "\u092a\u093e\u0932\u0940" },
            { "bqi", "\u092c\u093e\u0916\u094d\u0924\u093f\u0906\u0930\u0940" },
            { "pl", "\u092a\u094b\u0932\u093f\u0938" },
            { "dum", "\u092e\u0927\u094d\u092f \u0921\u091a" },
            { "type.ca.dangi", "\u0921\u093e\u0919\u094d\u0917\u0940 \u092a\u093e\u0924\u094d\u0930\u094b" },
            { "ps", "\u092a\u093e\u0938\u094d\u0924\u094b" },
            { "pt", "\u092a\u094b\u0930\u094d\u0924\u0941\u0917\u0940" },
            { "mga", "\u092e\u0927\u094d\u092f \u0906\u092f\u0930\u093f\u0938" },
            { "key.co", "\u0915\u094d\u0930\u092e\u092c\u0926\u094d\u0927 \u0938\u0941\u091a\u0940" },
            { "pt_BR", "\u092c\u094d\u0930\u093e\u091c\u093f\u0932\u0940 \u092a\u094b\u0930\u094d\u0924\u0941\u0917\u0940" },
            { "kcg", "\u091f\u0941\u0906\u092a" },
            { "mgh", "\u092e\u093e\u0916\u0941\u0935\u093e-\u092e\u093f\u091f\u094d\u091f\u094b" },
            { "key.cf", "cf" },
            { "bra", "\u092c\u094d\u0930\u091c" },
            { "key.ca", "\u092a\u093e\u0924\u094d\u0930\u094b" },
            { "Laoo", metaValue_lo },
            { "mgo", "\u092e\u0947\u091f\u093e" },
            { "type.hc.h23", "hc-h23" },
            { "type.hc.h24", "hc-h24" },
            { "ssy", "\u0938\u093e\u0939\u094b" },
            { "brh", "\u092c\u094d\u0930\u093e\u0939\u0941\u0907" },
            { "type.nu.mymr", "\u092e\u094d\u092f\u093e\u0928\u094d\u092e\u093e\u0930\u0915\u093e \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "qu", "\u0915\u094d\u0935\u0947\u091a\u0941\u0935\u093e" },
            { "brx", "\u092c\u094b\u0921\u094b" },
            { "Lana", "\u0932\u093e\u0928\u094d\u0928\u093e" },
            { "kde", "\u092e\u093e\u0915\u094b\u0928\u094d\u0921\u0947" },
            { "Ethi", "\u0907\u0925\u093f\u092f\u094b\u092a\u093f\u0915" },
            { "type.hc.h12", "hc-h12" },
            { "type.hc.h11", "hc-h11" },
            { "rm", "\u0930\u094b\u092e\u093e\u0928\u093f\u0938" },
            { "rn", "\u0930\u0941\u0928\u094d\u0921\u0940" },
            { "key.cu", "\u092e\u0941\u0926\u094d\u0930\u093e" },
            { "ro", "\u0930\u094b\u092e\u093e\u0928\u093f\u092f\u093e\u0932\u0940" },
            { "type.nu.orya", "\u0913\u0930\u093f\u092f\u093e \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "type.nu.hanidec", "\u091a\u093f\u0928\u093f\u092f\u093e\u0901 \u0926\u0936\u092e\u0932\u0935 \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "ru", "\u0930\u0938\u093f\u092f\u093e\u0932\u0940" },
            { "bss", "\u0905\u0915\u0941\u091c" },
            { "rw", "\u0915\u093f\u0928\u094d\u092f\u093e\u0930\u0935\u093e\u0928\u094d\u0921\u093e" },
            { "zbl", "\u092c\u094d\u0932\u093f\u0938\u0938\u093f\u092e\u094d\u092c\u094b\u0932\u094d\u0938" },
            { "kea", "\u0915\u093e\u092c\u0941\u092d\u0947\u0930\u094d\u0921\u093f\u092f\u093e\u0928\u0941" },
            { "mic", "\u092e\u093f\u0915\u092e\u093e\u0915" },
            { "suk", "\u0938\u0941\u0915\u0941\u092e\u093e" },
            { "en_AU", "\u0905\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e\u0932\u0940 \u0905\u0919\u094d\u0917\u094d\u0930\u0947\u091c\u0940" },
            { "sa", "\u0938\u0902\u0938\u094d\u0915\u0943\u0924" },
            { "sc", "\u0938\u093e\u0930\u094d\u0921\u093f\u0928\u093f\u092f\u093e\u0932\u0940" },
            { "sus", "\u0938\u0941\u0938\u0942" },
            { "sd", "\u0938\u093f\u0928\u094d\u0927\u0940" },
            { "se", "\u0909\u0924\u094d\u0924\u0930\u0940 \u0938\u093e\u092e\u0940" },
            { "min", "\u092e\u093f\u0928\u093e\u0919\u0915\u093e\u092c\u093e\u0909" },
            { "sg", "\u0938\u093e\u0919\u094d\u0917\u094b" },
            { "ken", "\u0915\u0947\u0928\u092f\u093e\u0919" },
            { "si", "\u0938\u093f\u0928\u094d\u0939\u093e\u0932\u0940" },
            { "sux", "\u0938\u0941\u092e\u0947\u0930\u093f\u092f\u093e\u0932\u0940" },
            { "sk", "\u0938\u094d\u0932\u094b\u092d\u093e\u0915\u093f\u092f\u093e\u0932\u0940" },
            { "sl", "\u0938\u094d\u0932\u094b\u092d\u0947\u0928\u093f\u092f\u093e\u0932\u0940" },
            { "sm", metaValue_WS },
            { "sn", "\u0936\u094b\u0928\u093e" },
            { "so", "\u0938\u094b\u092e\u093e\u0932\u0940" },
            { "type.nu.arab", "\u0905\u0930\u092c\u0940 \u092d\u093e\u0930\u0924\u0940\u092f \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "sq", "\u0905\u0932\u094d\u092c\u093e\u0928\u093f\u092f\u093e\u0932\u0940" },
            { "sr", "\u0938\u0930\u094d\u092c\u093f\u092f\u093e\u0932\u0940" },
            { "ss", "\u0938\u094d\u0935\u093e\u0924\u0940" },
            { "type.cf.account", "cf-account" },
            { "Java", metaValue_jv },
            { "st", "\u0926\u0915\u094d\u0937\u093f\u0923\u0940 \u0938\u094b\u0925\u094b" },
            { "su", "\u0938\u0941\u0921\u093e\u0928\u0940" },
            { "sv", "\u0938\u094d\u0935\u093f\u0921\u093f\u0938" },
            { "sw", "\u0938\u094d\u0935\u093e\u0939\u093f\u0932\u0940" },
            { "type.nu.hantfin", "\u092a\u0930\u092e\u094d\u092a\u0930\u093e\u0917\u0924 \u091a\u093f\u0928\u093f\u092f\u093e\u0901 \u0935\u093f\u0924\u094d\u0924\u0940\u092f \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "ibb", "\u0907\u092c\u093f\u092c\u093f\u092f\u094b" },
            { "iba", "\u0907\u092c\u093e\u0928" },
            { "ta", metaValue_ta },
            { "142", "\u090f\u0936\u093f\u092f\u093e" },
            { "bua", "\u092c\u0941\u0930\u093f\u0906\u0924" },
            { "143", "\u0915\u0947\u0928\u094d\u0926\u094d\u0930\u0940\u092f \u090f\u0936\u093f\u092f\u093e" },
            { "te", metaValue_te },
            { "145", "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u090f\u0936\u093f\u092f\u093e" },
            { "tg", "\u0924\u093e\u091c\u093f\u0915" },
            { "th", metaValue_th },
            { "ti", "\u091f\u093f\u0917\u094d\u0930\u093f\u0928\u094d\u092f\u093e" },
            { "bug", "\u092c\u0941\u0917\u093f\u0928\u093f\u092f\u093e\u0932\u0940" },
            { "kfo", "\u0915\u094b\u0930\u094b" },
            { "en_CA", "\u0915\u094d\u092f\u093e\u0928\u093e\u0921\u0947\u0932\u0940 \u0905\u0919\u094d\u0917\u094d\u0930\u0947\u091c\u0940" },
            { "tk", "\u091f\u0930\u094d\u0915\u092e\u0947\u0928" },
            { "tn", "\u091f\u094d\u0938\u094d\u0935\u093e\u0928\u093e" },
            { "to", "\u091f\u094b\u0919\u094d\u0917\u0928" },
            { "bum", "\u092c\u0941\u0932\u0941" },
            { "dyo", "\u091c\u094b\u0932\u093e-\u092b\u094b\u0928\u093f\u0932" },
            { "type.nu.jpan", "\u091c\u093e\u092a\u093e\u0928\u0940 \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "tr", "\u091f\u0930\u094d\u0915\u093f\u0936" },
            { "ts", "\u091f\u094d\u0938\u094b\u0919\u094d\u0917\u093e" },
            { "swb", "\u0915\u094b\u092e\u094b\u0930\u0940" },
            { "Cakm", "\u0915\u093e\u0915\u094d\u092e\u094d" },
            { "tt", "\u0924\u093e\u0924\u093e\u0930" },
            { "dyu", "\u0926\u094d\u092f\u0941\u0932\u093e" },
            { "ty", "\u091f\u093e\u0939\u093f\u091f\u093f\u092f\u0928" },
            { "150", "\u092f\u0941\u0930\u094b\u092a" },
            { "151", "\u092a\u0942\u0930\u094d\u0935\u0940 \u092f\u0941\u0930\u094b\u092a" },
            { "154", "\u0909\u0924\u094d\u0924\u0930\u0940 \u092f\u0941\u0930\u094b\u092a" },
            { "dzg", "\u0926\u093e\u091c\u093e\u0917\u093e" },
            { "155", "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u092f\u0941\u0930\u094b\u092a" },
            { "ug", "\u0909\u0907\u0918\u0941\u0930" },
            { "Ital", "\u092a\u0941\u0930\u093e\u0928\u094b \u0907\u091f\u093e\u0932\u093f\u0915" },
            { "Kore", "\u0915\u094b\u0930\u093f\u092f\u0928" },
            { "kgp", "\u0915\u093e\u0907\u0928\u0917\u093e\u0919" },
            { "Zyyy", "\u0938\u093e\u091d\u093e" },
            { "uk", "\u092f\u0941\u0915\u094d\u0930\u0947\u0928\u0940" },
            { "ur", "\u0909\u0930\u094d\u0926\u0941" },
            { "xal", "\u0915\u093e\u0932\u094d\u092e\u093f\u0915" },
            { "uz", "\u0909\u091c\u094d\u092c\u0947\u0915\u0940" },
            { "kha", "\u0916\u093e\u0938\u0940" },
            { "nds_NL", "\u0924\u0932\u094d\u0932\u094b \u0938\u093e\u0915\u094d\u0938\u0928" },
            { "Sylo", "\u0938\u094d\u0932\u094d\u092f\u094b\u091f\u0940 \u0928\u093e\u0917\u094d\u0930\u0940" },
            { "ve", "\u092d\u0947\u0928\u094d\u0921\u093e" },
            { "type.ca.roc", "\u091a\u093f\u0928\u093f\u092f\u093e\u0901 \u0917\u0923\u0924\u0928\u094d\u0924\u094d\u0930\u0915\u094b \u092a\u093e\u0924\u094d\u0930\u094b" },
            { "vi", "\u092d\u093f\u092f\u0924\u0928\u093e\u092e\u0940" },
            { "kho", "\u0916\u094b\u091f\u093e\u0928\u0940" },
            { "khq", "\u0915\u094b\u092f\u0930\u093e \u091a\u093f\u0928\u0940" },
            { "key.hc", "hc" },
            { "vo", "\u092d\u094b\u0932\u093e\u092a\u093f\u0915" },
            { "khw", "\u0916\u094b\u0935\u093e\u0930" },
            { "syc", "\u092a\u0930\u092e\u094d\u092a\u0930\u093e\u0917\u0924 \u0938\u093f\u0930\u093f\u092f\u093e\u0915" },
            { "Osma", "\u0913\u0938\u094d\u092e\u093e\u0928\u094d\u092f\u093e" },
            { "quc", "\u0915\u093f\u091a\u0947" },
            { "qug", "\u091a\u093f\u092e\u094d\u092c\u094b\u0930\u093e\u091c\u094b \u0909\u091a\u094d\u091a\u0938\u094d\u0925\u093e\u0928 \u0915\u093f\u091a\u0941\u0906" },
            { "gaa", "\u0917\u093e" },
            { "wa", "\u0935\u093e\u0932\u094d\u0932\u0941\u0928" },
            { "gag", "\u0917\u0917\u093e\u0909\u091c" },
            { "syr", metaValue_syr },
            { "Grek", metaValue_el },
            { "gan", "\u0917\u093e\u0928 \u091a\u093f\u0928\u093f\u092f\u093e\u0901" },
            { "kiu", "\u0915\u093f\u0930\u094d\u092e\u093e\u0928\u094d\u091c\u0915\u0940" },
            { "Lydi", "\u0932\u093e\u0907\u0921\u093f\u092f\u0928" },
            { "wo", "\u0935\u0941\u0932\u0941\u092b" },
            { "zgh", "\u092e\u093e\u0928\u0915 \u092e\u094b\u0930\u094b\u0915\u094d\u0915\u094b\u0928 \u0924\u093e\u092e\u093e\u091c\u093f\u0918\u091f" },
            { "ar_001", "\u0906\u0927\u0941\u0928\u093f\u0915 \u092e\u093e\u0928\u0915 \u0905\u0930\u092c\u0940" },
            { "gay", "\u0917\u093e\u092f\u094b" },
            { "Mong", "\u092e\u0919\u094d\u0917\u094b\u0932" },
            { "mnc", "\u092e\u093e\u0928\u094d\u091a\u0941" },
            { "Latf", "\u092b\u094d\u0930\u093e\u0915\u094d\u091f\u0941\u0930 \u0932\u094d\u092f\u093e\u091f\u093f\u0928" },
            { "gba", "\u0917\u094d\u092c\u093e\u092f\u093e" },
            { "mni", "\u092e\u0928\u093f\u092a\u0941\u0930\u0940" },
            { "Latn", metaValue_la },
            { "Latg", "\u0917\u094d\u092f\u093e\u0932\u093f\u0915 \u0932\u094d\u092f\u093e\u091f\u093f\u0928" },
            { "type.nu.hans", "\u0938\u0930\u0932\u093f\u0915\u0943\u0924 \u091a\u093f\u0928\u093f\u092f\u093e\u0901 \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "type.nu.hant", "\u092a\u0930\u092e\u094d\u092a\u0930\u093e\u0917\u0924 \u091a\u093f\u0928\u093f\u092f\u093e\u0901 \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "xh", "\u0916\u094b\u0938\u093e" },
            { "type.nu.romanlow", "\u0930\u094b\u092e\u0928 \u0938\u093e\u0928\u093e \u0915\u0947\u0938\u0915\u093e \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "byn", "\u092c\u094d\u0932\u093f\u0928" },
            { "Lyci", "\u0932\u093e\u0907\u0938\u093f\u092f\u0928" },
            { "osa", "\u0913\u0938\u093e\u0917\u0947" },
            { "byv", "\u092e\u0947\u0921\u0941\u092e\u094d\u092c\u093e" },
            { "Moon", "\u091c\u0942\u0928" },
            { "moh", "\u092e\u094b\u0939\u0915" },
            { "kkj", "\u0915\u093e\u0915\u094b" },
            { "Syrc", metaValue_syr },
            { "yi", "\u092f\u093f\u0926\u094d\u0926\u093f\u0938" },
            { "mos", "\u092e\u094b\u0938\u094d\u0938\u0940" },
            { "Dsrt", "\u0921\u0947\u0938\u0947\u0930\u0947\u091f" },
            { "yo", "\u092f\u094b\u0930\u0942\u0935\u093e" },
            { "es_MX", "\u092e\u0947\u0915\u094d\u0938\u093f\u0915\u0928 \u0938\u094d\u092a\u0947\u0928\u0940" },
            { "Syrj", "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0938\u093f\u0930\u093f\u092f\u093e\u0915" },
            { "ota", "\u0905\u091f\u094b\u092e\u0928 \u0924\u0941\u0930\u094d\u0915\u0940" },
            { "Syre", "\u0907\u0938\u094d\u091f\u094d\u0930\u0947\u0928\u091c\u0947\u0932\u094b \u0938\u093f\u0930\u093f\u092f\u093e\u0915" },
            { "vai", metaValue_vai },
            { "Cari", "\u0915\u093e\u0930\u093f\u092f\u0928" },
            { "kln", "\u0915\u093e\u0932\u0947\u0928\u094d\u091c\u093f\u0928" },
            { "zh", "\u091a\u093f\u0928\u093f\u092f\u093e\u0901" },
            { "Bopo", "\u092c\u094b\u092a\u094b\u092e\u094b\u092b\u094b" },
            { "Perm", "\u092a\u0941\u0930\u093e\u0928\u094b \u092a\u0930\u094d\u092e\u093f\u0915" },
            { "key.lb", "lb" },
            { "zu", "\u091c\u0941\u0932\u0941" },
            { "type.co.phonebook", "\u091f\u0947\u0932\u093f\u092b\u094b\u0928 \u092a\u0941\u0938\u094d\u0924\u093f\u0915\u093e \u0915\u094d\u0930\u092e\u092c\u0926\u094d\u0927\u0924\u093e\u092a\u0926\u094d\u0926\u0924\u093f" },
            { "Geor", metaValue_ka },
            { "kmb", "\u0915\u093f\u092e\u094d\u092c\u0941\u0928\u094d\u0921\u0941" },
            { "type.nu.jpanfin", "\u091c\u093e\u092a\u093e\u0928\u0940 \u0935\u093f\u0924\u094d\u0924\u0940\u092f \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "Cham", "\u091a\u093e\u092e" },
            { "gez", "\u0917\u093f\u091c" },
            { "Syrn", "\u092a\u0942\u0930\u094d\u0935\u0940 \u0938\u093f\u0930\u093f\u092f\u093e\u0915" },
            { "Tglg", "\u091f\u093e\u0917\u093e\u0932\u094b\u0917" },
            { "Egyd", "\u0907\u091c\u093f\u092a\u094d\u091f\u093f\u092f\u0928 \u0921\u0947\u092e\u094b\u091f\u093f\u0915" },
            { "Egyh", "\u0907\u091c\u093f\u092a\u094d\u091f\u093f\u092f\u0928 \u0939\u093e\u0907\u0930\u091f\u093f\u0915" },
            { "ebu", "\u090f\u092e\u094d\u092c\u0941" },
            { "Egyp", "\u0907\u091c\u093f\u092a\u094d\u091f\u093f\u092f\u0928 \u0939\u093e\u0907\u0930\u094b\u0917\u094d\u0932\u093f\u092b\u094d\u0938" },
            { "Geok", "\u0917\u094d\u0930\u0941\u091c\u093f\u092f\u093e\u0932\u0940 \u0916\u0941\u091f\u094d\u0938\u0941\u0930\u0940" },
            { "zh_Hans", metaValue_Hans },
            { "koi", "\u0915\u094b\u092e\u0940-\u092a\u0930\u094d\u092e\u094d\u092f\u093e\u0915" },
            { "Hung", "\u092a\u0941\u0930\u093e\u0928\u094b \u0939\u0919\u094d\u0917\u0947\u0930\u093f\u092f\u093e\u0932\u0940" },
            { "kok", "\u0915\u094b\u0928\u094d\u0915\u093e\u0928\u0940" },
            { "kos", "\u0915\u094b\u0938\u094d\u0930\u093e\u0932\u0940" },
            { "zh_Hant", metaValue_Hant },
            { "kpe", "\u0915\u094d\u092a\u0947\u0932\u094d\u0932\u0947" },
            { "type.nu.khmr", "\u0916\u092e\u0947\u0930 \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "ilo", "\u0907\u092f\u094b\u0915\u094b" },
            { "Cprt", "\u0915\u092a\u094d\u0930\u093f\u092f\u091f" },
            { "mua", "\u092e\u0941\u0928\u094d\u0921\u093e\u0919" },
            { "type.nu.guru", "\u0917\u0941\u0930\u0942\u092e\u0941\u0916\u0940 \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "mul", "\u092c\u0939\u0941\u092d\u093e\u0937\u093e" },
            { "cad", "\u0915\u093e\u0921\u094d\u0921\u094b" },
            { "key.ms", "\u092e\u093e\u092a\u0928 \u092a\u094d\u0930\u0923\u093e\u0932\u0940" },
            { "mus", "\u0915\u094d\u0930\u093f\u0915" },
            { "Glag", "\u0917\u094d\u0932\u093e\u0917\u094b\u0932\u093f\u091f\u093f\u0915" },
            { "gil", "\u0917\u093f\u0932\u094d\u092c\u0930\u094d\u091f\u0940" },
            { "Cher", metaValue_chr },
            { "car", "\u0915\u094d\u092f\u093e\u0930\u093f\u092c" },
            { "cay", "\u0915\u093e\u092f\u0941\u0917\u093e" },
            { "type.nu.tamldec", "\u0924\u093e\u092e\u093f\u0932 \u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "krc", "\u0915\u093e\u0930\u093e\u091a\u093e\u092f-\u092c\u093e\u0932\u094d\u0915\u0930" },
            { "inh", "\u0907\u0928\u094d\u0917\u0938" },
            { "krj", "\u0915\u093f\u0928\u093e\u0930\u093e\u092f-\u090f" },
            { "kri", "\u0915\u094d\u0930\u093f\u0913" },
            { "krl", "\u0915\u0930\u0947\u0932\u093f\u092f\u0928" },
            { "efi", "\u090f\u092b\u093f\u0915" },
            { "key.nu", "\u0905\u0919\u094d\u0915\u0939\u0930\u0942" },
            { "kru", "\u0915\u0941\u0930\u0941\u0916" },
            { "ksb", "\u0936\u093e\u092e\u094d\u092c\u093e\u0932\u093e" },
            { "Telu", metaValue_te },
            { "ksf", "\u092c\u093e\u092b\u093f\u092f\u093e" },
        };
        return data;
    }
}
