/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNNotificationCallback;
import org.eclipse.team.svn.core.connector.SVNNotification;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.UnreportableException;
import org.eclipse.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class LockOperation
extends AbstractWorkingCopyOperation {
    protected String message;
    protected long options;

    public LockOperation(IResource[] resources, String message, boolean force) {
        this(resources, message, force ? 4L : 0L);
    }

    public LockOperation(IResourceProvider provider, String message, boolean force) {
        this(provider, message, force ? 4L : 0L);
    }

    public LockOperation(IResource[] resources, String message, long options) {
        super("Operation_Lock", SVNMessages.class, resources);
        this.message = message;
        this.options = options & 4L;
    }

    public LockOperation(IResourceProvider provider, String message, long options) {
        super("Operation_Lock", SVNMessages.class, provider);
        this.message = message;
        this.options = options & 4L;
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IResource[] resources = this.operableData();
        ArrayList problems = new ArrayList();
        Map<IProject, List<IResource>> wc2Resources = SVNUtility.splitWorkingCopies(resources);
        Iterator<Map.Entry<IProject, List<IResource>>> it = wc2Resources.entrySet().iterator();
        while (it.hasNext() && !monitor.isCanceled()) {
            Map.Entry<IProject, List<IResource>> entry = it.next();
            IRepositoryLocation location = SVNRemoteStorage.instance().getRepositoryLocation((IResource)entry.getKey());
            String[] paths = FileUtility.asPathArray(entry.getValue().toArray(new IResource[0]));
            this.complexWriteToConsole(() -> {
                this.writeToConsole(0, "svn lock" + ISVNConnector.Options.asCommandLine(this.options));
                int i = 0;
                while (i < paths.length && !monitor.isCanceled()) {
                    this.writeToConsole(0, " \"" + paths[i] + "\"");
                    ++i;
                }
                this.writeToConsole(0, " -m \"" + this.message + "\"" + FileUtility.getUsernameParam(location.getUsername()) + "\n");
            });
            ISVNConnector proxy = location.acquireSVNProxy();
            this.protectStep(monitor1 -> {
                ISVNNotificationCallback listener = info -> {
                    if (SVNNotification.PerformedAction.FAILED_LOCK == info.action) {
                        problems.add(info);
                    }
                };
                SVNUtility.addSVNNotifyListener(proxy, listener);
                try {
                    proxy.lock(paths, this.message, this.options, new SVNProgressMonitor(this, monitor1, null));
                }
                finally {
                    SVNUtility.removeSVNNotifyListener(proxy, listener);
                }
            }, monitor, wc2Resources.size());
            location.releaseSVNProxy(proxy);
        }
        if (!problems.isEmpty()) {
            StringBuilder res = new StringBuilder();
            Iterator iter = problems.iterator();
            while (iter.hasNext()) {
                SVNNotification problem = (SVNNotification)iter.next();
                res.append(problem.errMsg);
                if (!iter.hasNext()) continue;
                res.append("\n\n");
            }
            throw new UnreportableException(res.toString());
        }
    }
}

