/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.synchronize;

import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSet;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSetManager;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.internal.ui.synchronize.ChangeSetCapability;
import org.eclipse.team.internal.ui.synchronize.SyncInfoSetChangeSetCollector;
import org.eclipse.team.svn.core.SVNTeamPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.panel.local.CommitSetPanel;
import org.eclipse.team.svn.ui.synchronize.SVNChangeSetCollector;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class SVNChangeSetCapability
extends ChangeSetCapability {
    public static boolean isEnabled = false;

    public static String getProposedComment(IResource[] resourcesToCommit) {
        ChangeSet[] sets;
        String retVal = null;
        ChangeSet[] changeSetArray = sets = SVNTeamPlugin.instance().getModelChangeSetManager().getSets();
        int n = sets.length;
        int n2 = 0;
        while (n2 < n) {
            ChangeSet set = changeSetArray[n2];
            if (SVNChangeSetCapability.containsOneOf(set, resourcesToCommit)) {
                String comment = set.getComment();
                retVal = retVal == null ? comment : retVal + "\n" + comment;
            }
            ++n2;
        }
        return retVal;
    }

    public static boolean containsOneOf(ChangeSet set, IResource[] resourcesToCommit) {
        IResource[] iResourceArray = resourcesToCommit;
        int n = resourcesToCommit.length;
        int n2 = 0;
        while (n2 < n) {
            IResource element = iResourceArray[n2];
            if (set.contains(element)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean supportsCheckedInChangeSets() {
        return true;
    }

    public SyncInfoSetChangeSetCollector createSyncInfoSetChangeSetCollector(ISynchronizePageConfiguration configuration) {
        isEnabled = true;
        return new SVNChangeSetCollector(configuration);
    }

    public boolean supportsActiveChangeSets() {
        return true;
    }

    public ActiveChangeSet createChangeSet(ISynchronizePageConfiguration configuration, IDiff[] diffs) {
        ActiveChangeSet set = this.getActiveChangeSetManager().createSet(SVNUIMessages.ChangeSet_NewSet, new IDiff[0]);
        CommitSetPanel panel = new CommitSetPanel(set, this.getResources(diffs), 0);
        DefaultDialog dialog = new DefaultDialog(configuration.getSite().getShell(), panel);
        dialog.open();
        if (dialog.getReturnCode() != 0) {
            return null;
        }
        set.add(diffs);
        return set;
    }

    private IResource[] getResources(IDiff[] diffs) {
        HashSet<IResource> result = new HashSet<IResource>();
        IDiff[] iDiffArray = diffs;
        int n = diffs.length;
        int n2 = 0;
        while (n2 < n) {
            IDiff diff = iDiffArray[n2];
            IResource resource = ResourceDiffTree.getResourceFor((IDiff)diff);
            if (resource != null) {
                result.add(resource);
            }
            ++n2;
        }
        return result.toArray(new IResource[result.size()]);
    }

    public void editChangeSet(ISynchronizePageConfiguration configuration, ActiveChangeSet set) {
        CommitSetPanel panel = new CommitSetPanel(set, set.getResources(), 1);
        DefaultDialog dialog = new DefaultDialog(configuration.getSite().getShell(), panel);
        dialog.open();
    }

    public ActiveChangeSetManager getActiveChangeSetManager() {
        return SVNTeamPlugin.instance().getModelChangeSetManager();
    }

    public boolean enableActiveChangeSetsFor(ISynchronizePageConfiguration configuration) {
        return this.supportsActiveChangeSets() && configuration.getMode() != 1;
    }

    public boolean enableCheckedInChangeSetsFor(ISynchronizePageConfiguration configuration) {
        return this.supportsCheckedInChangeSets() && configuration.getMode() != 2;
    }
}

