/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.properties.bugtraq;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.team.svn.core.operation.LoggedOperation;
import org.eclipse.team.svn.ui.properties.bugtraq.BugtraqModel;
import org.eclipse.team.svn.ui.properties.bugtraq.LinkList;

public class IssueList
extends LinkList {
    public void parseMessage(String message, BugtraqModel model) {
        String prefix = "";
        String suffix = "";
        String issueRegex = ".*";
        String innerRegExp = null;
        String modelMessage = null;
        if (model.getLogregex() != null) {
            issueRegex = model.getLogregex()[0];
            if (model.isDoubleLogRegexp()) {
                innerRegExp = model.getLogregex()[1];
            }
        } else if (model.getMessage() != null) {
            modelMessage = model.getMessage();
            prefix = this.getTemplatePrefix(modelMessage);
            suffix = this.getTemplateSuffix(modelMessage);
            if (model.isNumber()) {
                issueRegex = "[0-9]+(?:,[0-9]+)*";
                innerRegExp = "[0-9]+";
            }
        } else {
            return;
        }
        prefix = Pattern.quote(prefix);
        suffix = Pattern.quote(suffix);
        String regex = prefix + "(" + issueRegex + ")" + suffix;
        Matcher matcher = Pattern.compile(regex, 8).matcher(message);
        while (matcher.find()) {
            if (innerRegExp == null) {
                int i = 2;
                while (i <= matcher.groupCount()) {
                    this.links.add(new LinkList.LinkPlacement(matcher.start(i), matcher.end(i), message));
                    ++i;
                }
                continue;
            }
            if (matcher.groupCount() <= 0) continue;
            String group = matcher.group(1);
            Matcher entryMatcher = Pattern.compile(innerRegExp).matcher(group);
            while (entryMatcher.find()) {
                String originalPrefix = modelMessage == null ? "" : this.getTemplatePrefix(modelMessage);
                int prefixLength = matcher.start() + originalPrefix.length();
                if (prefixLength + entryMatcher.end() > message.length()) {
                    LoggedOperation.reportError((String)(prefix + "~~" + suffix + "~~" + issueRegex + "~~" + (innerRegExp == null ? "null" : innerRegExp) + "~~" + originalPrefix), (Throwable)new StringIndexOutOfBoundsException(message));
                    continue;
                }
                this.links.add(new LinkList.LinkPlacement(prefixLength + entryMatcher.start(), prefixLength + entryMatcher.end(), message));
            }
        }
    }

    protected String getTemplatePrefix(String template) {
        int indexOfIssue = template.indexOf("%BUGID%");
        String prefix = "";
        if (indexOfIssue > 0) {
            prefix = template.substring(0, indexOfIssue);
        }
        return prefix;
    }

    protected String getTemplateSuffix(String template) {
        int indexOfSuffix;
        int indexOfIssue = template.indexOf("%BUGID%");
        String suffix = "";
        if (indexOfIssue != -1 && (indexOfSuffix = indexOfIssue + "%BUGID%".length()) < template.length()) {
            suffix = template.substring(indexOfSuffix);
        }
        return suffix;
    }

    public static void main(String[] args) {
        BugtraqModel model = new BugtraqModel();
        model.setAppend(true);
        model.setLabel(null);
        model.setNumber(true);
        model.setUrl("http://site.com/bugs=%BUGID%");
        model.setWarnIfNoIssue(false);
        String messagePattern = "";
        String message = "";
        IssueList issue = null;
        List<LinkList.LinkPlacement> links = null;
        messagePattern = "My bug %BUGID%.";
        message = "\nMy bug 48.\n";
        model.setMessage(messagePattern);
        issue = new IssueList();
        issue.parseMessage(message, model);
        links = issue.getLinks();
        assert (links.size() == 1);
        assert ("48".equals(links.get(0).getURL()));
        messagePattern = "My bug: %BUGID%";
        message = "\nMy bug: 48\n";
        model.setMessage(messagePattern);
        issue = new IssueList();
        issue.parseMessage(message, model);
        links = issue.getLinks();
        assert (links.size() == 1);
        assert ("48".equals(links.get(0).getURL()));
        messagePattern = "My %BUGID%,and";
        message = "\nMy 48,and\n";
        model.setMessage(messagePattern);
        issue = new IssueList();
        issue.parseMessage(message, model);
        links = issue.getLinks();
        assert (links.size() == 1);
        assert ("48".equals(links.get(0).getURL()));
        messagePattern = "My (%BUGID%)";
        message = "\nMy (48)\n";
        model.setMessage(messagePattern);
        issue = new IssueList();
        issue.parseMessage(message, model);
        links = issue.getLinks();
        assert (links.size() == 1);
        assert ("48".equals(links.get(0).getURL()));
        messagePattern = "My f%BUGID%f";
        message = "\nMy f48f\n";
        model.setMessage(messagePattern);
        issue = new IssueList();
        issue.parseMessage(message, model);
        links = issue.getLinks();
        assert (links.size() == 1);
        assert ("48".equals(links.get(0).getURL()));
        messagePattern = "My111 %BUGID%";
        message = "\nMy111 48\n";
        model.setMessage(messagePattern);
        issue = new IssueList();
        issue.parseMessage(message, model);
        links = issue.getLinks();
        assert (links.size() == 1);
        assert ("48".equals(links.get(0).getURL()));
        messagePattern = "My111 %BUGID%";
        message = "\nMy111 48,49\n";
        model.setMessage(messagePattern);
        issue = new IssueList();
        issue.parseMessage(message, model);
        links = issue.getLinks();
        assert (links.size() == 2);
        assert ("48".equals(links.get(0).getURL()) || "49".equals(links.get(0).getURL()));
        assert ("48".equals(links.get(1).getURL()) || "49".equals(links.get(1).getURL()));
        messagePattern = "My\n and \r prefix %BUGID%";
        message = "\nMy\n and \r prefix 48\n";
        model.setMessage(messagePattern);
        issue = new IssueList();
        issue.parseMessage(message, model);
        links = issue.getLinks();
        assert (links.size() == 1);
        assert ("48".equals(links.get(0).getURL()));
        String logregex = null;
        logregex = "[Ii]ssue(?:s)? #?(\\d+)";
        model.setLogregex(logregex);
        model.setMessage(null);
        message = "Issue #48";
        issue = new IssueList();
        issue.parseMessage(message, model);
        links = issue.getLinks();
        assert (links.size() == 1);
        assert ("48".equals(links.get(0).getURL()));
        logregex = "[Ii]ssues?:?(\\s*(,|and)?\\s*#\\d+)+\n\\d+";
        model.setLogregex(logregex);
        model.setMessage(null);
        message = "This change resolves issues #23, #24 and #25";
        issue = new IssueList();
        issue.parseMessage(message, model);
        links = issue.getLinks();
        assert (links.size() == 3);
        String res = links.get(0).getURL();
        assert ("23".equals(res) || "24".equals(res) || "25".equals(res));
        res = links.get(1).getURL();
        assert ("23".equals(res) || "24".equals(res) || "25".equals(res));
        res = links.get(2).getURL();
        assert ("23".equals(res) || "24".equals(res) || "25".equals(res));
    }
}

