/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.action.local;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.action.AbstractWorkingCopyAction;
import org.eclipse.team.svn.ui.action.local.CompareWithWorkingCopyAction;
import org.eclipse.team.svn.ui.composite.BranchTagSelectionComposite;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.operation.CompareResourcesOperation;
import org.eclipse.team.svn.ui.operation.ShowHistoryViewOperation;
import org.eclipse.team.svn.ui.panel.remote.CompareBranchTagPanel;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;

public class CompareWithBranchTagAction
extends AbstractWorkingCopyAction {
    protected int type;

    public CompareWithBranchTagAction(int type) {
        this.type = type;
    }

    @Override
    public boolean isEnabled() {
        if (this.getSelectedResources().length == 1 && this.checkForResourcesPresence(CompareWithWorkingCopyAction.COMPARE_FILTER)) {
            boolean recommendedLayoutUsed;
            IResource resource = this.getSelectedResources()[0];
            ILocalResource local = SVNRemoteStorage.instance().asLocalResource(resource);
            IRepositoryLocation location = SVNRemoteStorage.instance().getRepositoryLocation(resource);
            if (local.isCopied()) {
                IRepositoryResource remote = SVNUtility.getCopiedFrom((IResource)resource);
                location = remote.getRepositoryLocation();
            }
            boolean isCompareFoldersAllowed = CoreExtensionsManager.instance().getSVNConnectorFactory().getSVNAPIVersion() >= 5;
            boolean bl = recommendedLayoutUsed = SVNTeamPreferences.getRepositoryBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "tagConsideringProjectStructure") && location.isStructureEnabled();
            return (isCompareFoldersAllowed || this.getSelectedResources()[0].getType() == 1) && recommendedLayoutUsed;
        }
        return false;
    }

    @Override
    public void runImpl(IAction action) {
        IRepositoryResource[] branchTagResources;
        IResource resource = this.getSelectedResources()[0];
        ILocalResource local = SVNRemoteStorage.instance().asLocalResourceAccessible(resource);
        IRepositoryResource remote = local.isCopied() ? SVNUtility.getCopiedFrom((IResource)resource) : SVNRemoteStorage.instance().asRepositoryResource(resource);
        boolean considerStructure = BranchTagSelectionComposite.considerStructure(remote);
        IRepositoryResource[] iRepositoryResourceArray = branchTagResources = considerStructure ? BranchTagSelectionComposite.calculateBranchTagResources(remote, this.type) : new IRepositoryResource[]{};
        if (!considerStructure || branchTagResources.length != 0) {
            CompareBranchTagPanel panel = new CompareBranchTagPanel(remote, this.type, branchTagResources);
            DefaultDialog dlg = new DefaultDialog(this.getShell(), panel);
            if (dlg.open() == 0 && panel.getResourceToCompareWith() != null) {
                remote = panel.getResourceToCompareWith();
                String diffFile = panel.getDiffFile();
                CompareResourcesOperation mainOp = new CompareResourcesOperation(local, remote, false, false, panel.getDiffOptions());
                mainOp.setDiffFile(diffFile);
                CompositeOperation op = new CompositeOperation(mainOp.getId(), mainOp.getMessagesClass());
                op.add((IActionOperation)mainOp);
                if (SVNTeamPreferences.getHistoryBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "connectToCompareWith")) {
                    op.add((IActionOperation)new ShowHistoryViewOperation(resource, remote, 2, 2), new IActionOperation[]{mainOp});
                }
                this.runScheduled((IActionOperation)op);
            }
        }
    }

    @Override
    protected boolean needsToSaveDirtyEditors() {
        return true;
    }
}

