/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.util;

import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcStatement;

public class AttributeDataUtil {
    private static final String NAME_FROM_GUID = "select attr.value from osee_artifact art, osee_attribute attr where art.guid=? and  art.art_id = attr.art_id and attr.attr_type_id = 1152921504606847088";
    private static final Pattern guidPattern = Pattern.compile("(\\{)([0-9A-Za-z\\+_=]{20,22})(\\})");

    private AttributeDataUtil() {
    }

    public static String getNameByGuid(String value, JdbcClient jdbcClient) {
        if (value != null) {
            StringBuffer sb = new StringBuffer();
            Matcher matcher = guidPattern.matcher(value);
            while (matcher.find()) {
                String guid = matcher.group(2);
                sb.append(AttributeDataUtil.getName(guid, jdbcClient));
            }
            return sb.toString();
        }
        return null;
    }

    private static String getName(String guid, JdbcClient jdbcClient) {
        StringBuffer sb = new StringBuffer();
        Consumer<JdbcStatement> consumer = stmt -> sb.append(stmt.getString("value"));
        jdbcClient.runQuery(consumer, NAME_FROM_GUID, new Object[]{guid});
        return sb.toString();
    }
}

