/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.change;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.HasBranchId;
import org.eclipse.osee.framework.core.data.RelationId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.data.TupleTypeId;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.core.model.change.ChangeItemUtil;
import org.eclipse.osee.framework.jdk.core.type.DoubleKeyHashMap;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.orcs.OseeDb;
import org.eclipse.osee.orcs.db.internal.change.AddSyntheticArtifactChangeData;
import org.eclipse.osee.orcs.db.internal.change.LoadDeltasBetweenBranches;
import org.eclipse.osee.orcs.db.internal.change.MissingChangeItemFactory;
import org.eclipse.osee.orcs.db.internal.sql.join.ExportImportJoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;
import org.eclipse.osee.orcs.search.QueryFactory;

public class LoadDeltasBetweenTxsOnTheSameBranch {
    private static final String SELECT_ITEMS_BETWEEN_TRANSACTIONS = "with txsOuter as (select gamma_id, mod_type, app_id, transaction_id from %s where branch_id = ? and transaction_id > ? and transaction_id <= ?) \nSELECT 1 as table_type, attr_type_id as item_type_id, attr_id as item_id, art_id as item_first, 0 as item_second, 0 as item_third, 0 as item_fourth, value as item_value, item.gamma_id, mod_type, app_id, transaction_id \nFROM osee_attribute item, txsOuter where txsOuter.gamma_id = item.gamma_id\nUNION ALL\nSELECT 2 as table_type, art_type_id as item_type_id, art_id as item_id, 0 as item_first, 0 as item_second, 0 as item_third, 0 as item_fourth, 'na' as item_value, item.gamma_id, mod_type, app_id, transaction_id \nFROM osee_artifact item, txsOuter where txsOuter.gamma_id = item.gamma_id\nUNION ALL\nSELECT 3 as table_type, rel_link_type_id as item_type_id, rel_link_id as item_id,  a_art_id as item_first, b_art_id as item_second, 0 as item_third, 0 as item_fourth, rationale as item_value, item.gamma_id, mod_type, app_id, transaction_id \nFROM osee_relation_link item, txsOuter where txsOuter.gamma_id = item.gamma_id\nUNION ALL\nSELECT 4 as table_type, tuple_type as item_type_id, 0 as item_id, e1 as item_first, e2 as item_second, 0 as item_third, 0 as item_fourth, 'na' as item_value, item.gamma_id, mod_type, app_id, transaction_id \nfrom osee_tuple2 item, txsOuter where txsOuter.gamma_id = item.gamma_id\nUNION ALL\nSELECT 5 as table_type, tuple_type as item_type_id, 0 as item_id, e1 as item_first, e2 as item_second, e3 as item_third, 0 as item_fourth, 'na' as item_value, item.gamma_id, mod_type, app_id, transaction_id \nfrom osee_tuple3 item, txsOuter where txsOuter.gamma_id = item.gamma_id\nUNION ALL\nSELECT 6 as table_type, tuple_type as item_type_id, 0 as item_id, e1 as item_first, e2 as item_second, e3 as item_third, e4 as item_fourth, 'na' as item_value, item.gamma_id, mod_type, app_id, transaction_id \nfrom osee_tuple4 item, txsOuter where txsOuter.gamma_id = item.gamma_id";
    private final OrcsTokenService tokenService;
    private final TransactionToken sourceTx;
    private final TransactionToken destinationTx;
    private final MissingChangeItemFactory missingChangeItemFactory;
    private final QueryFactory queryFactory;
    private final SqlJoinFactory joinFactory;
    private final HashMap<Long, ApplicabilityToken> applicTokens;
    private final JdbcClient jdbcClient;
    private final BranchId mergeBranch;
    private final boolean isArchived;

    public LoadDeltasBetweenTxsOnTheSameBranch(JdbcClient jdbcClient, SqlJoinFactory joinFactory, OrcsTokenService tokenService, TransactionToken sourceTx, TransactionToken destinationTx, BranchId mergeBranch, QueryFactory queryFactory, MissingChangeItemFactory missingChangeItemFactory) {
        this.jdbcClient = jdbcClient;
        this.joinFactory = joinFactory;
        this.tokenService = tokenService;
        this.sourceTx = sourceTx;
        this.destinationTx = destinationTx;
        this.applicTokens = queryFactory.applicabilityQuery().getApplicabilityTokens(sourceTx.getBranch());
        this.missingChangeItemFactory = missingChangeItemFactory;
        this.queryFactory = queryFactory;
        this.mergeBranch = mergeBranch;
        this.isArchived = queryFactory.branchQuery().isArchived(destinationTx.getBranch());
    }

    private ApplicabilityToken getApplicabilityToken(ApplicabilityId appId) {
        ApplicabilityToken toReturn = this.applicTokens.get(appId.getId());
        if (toReturn != null) {
            return toReturn;
        }
        throw new OseeCoreException("Applicability Token with app id %s not available", new Object[]{appId});
    }

    public List<ChangeItem> loadDeltasBetweenTxsOnTheSameBranch() {
        Conditions.checkExpressionFailOnTrue((!this.sourceTx.isOnSameBranch((HasBranchId)this.destinationTx) ? 1 : 0) != 0, (String)"Unable to compute deltas between transactions on different branches", (Object[])new Object[0]);
        DoubleKeyHashMap<Integer, Long, ChangeItem> hashChangeData = this.loadChangesAtEndTx();
        return this.loadItemsByItemId(hashChangeData);
    }

    private DoubleKeyHashMap<Integer, Long, ChangeItem> loadChangesAtEndTx() {
        DoubleKeyHashMap hashChangeData = new DoubleKeyHashMap();
        Consumer<JdbcStatement> consumer = stmt -> {
            GammaId gammaId = GammaId.valueOf((Long)stmt.getLong("gamma_id"));
            ModificationType modType = ModificationType.valueOf((long)stmt.getInt("mod_type"));
            ApplicabilityId appId = ApplicabilityId.valueOf((Long)stmt.getLong("app_id"));
            TransactionToken txToken = TransactionToken.valueOf((long)stmt.getLong("transaction_id"), (BranchId)this.destinationTx.getBranch());
            int tableType = stmt.getInt("table_type");
            Long itemId = stmt.getLong("item_id");
            Long itemTypeId = stmt.getLong("item_type_id");
            switch (tableType) {
                case 1: {
                    ArtifactId artId = ArtifactId.valueOf((Long)stmt.getLong("item_first"));
                    String value = stmt.getString("item_value");
                    hashChangeData.put((Object)1, (Object)itemId, (Object)ChangeItemUtil.newAttributeChange((AttributeId)AttributeId.valueOf((Long)itemId), (AttributeTypeId)this.tokenService.getAttributeType(itemTypeId), (ArtifactId)artId, (GammaId)gammaId, (ModificationType)modType, (String)value, (ApplicabilityToken)this.getApplicabilityToken(appId), (TransactionToken)txToken));
                    break;
                }
                case 2: {
                    hashChangeData.put((Object)2, (Object)itemId, (Object)ChangeItemUtil.newArtifactChange((ArtifactId)ArtifactId.valueOf((Long)itemId), (ArtifactTypeId)this.tokenService.getArtifactType(itemTypeId), (GammaId)gammaId, (ModificationType)modType, (ApplicabilityToken)this.getApplicabilityToken(appId), (TransactionToken)txToken));
                    break;
                }
                case 3: {
                    ArtifactId aArtId = ArtifactId.valueOf((Long)stmt.getLong("item_first"));
                    ArtifactId bArtId = ArtifactId.valueOf((Long)stmt.getLong("item_second"));
                    String rationale = stmt.getString("item_value");
                    hashChangeData.put((Object)3, (Object)itemId, (Object)ChangeItemUtil.newRelationChange((RelationId)RelationId.valueOf((Long)itemId), (RelationTypeToken)this.tokenService.getRelationType(itemTypeId), (GammaId)gammaId, (ModificationType)modType, (ArtifactId)aArtId, (ArtifactId)bArtId, (String)rationale, (ApplicabilityToken)this.getApplicabilityToken(appId), (TransactionToken)txToken));
                    break;
                }
                case 4: {
                    long e1 = stmt.getLong("item_first");
                    long e2 = stmt.getLong("item_second");
                    hashChangeData.put((Object)4, (Object)gammaId.getId(), (Object)ChangeItemUtil.newTupleChange((TupleTypeId)TupleTypeId.valueOf((Long)itemTypeId), (GammaId)gammaId, (ApplicabilityToken)this.getApplicabilityToken(appId), (ModificationType)modType, (TransactionToken)txToken, (Long[])new Long[]{e1, e2}));
                    break;
                }
                case 5: {
                    long e1 = stmt.getLong("item_first");
                    long e2 = stmt.getLong("item_second");
                    long e3 = stmt.getLong("item_third");
                    hashChangeData.put((Object)5, (Object)gammaId.getId(), (Object)ChangeItemUtil.newTupleChange((TupleTypeId)TupleTypeId.valueOf((Long)itemTypeId), (GammaId)gammaId, (ApplicabilityToken)this.getApplicabilityToken(appId), (ModificationType)modType, (TransactionToken)txToken, (Long[])new Long[]{e1, e2, e3}));
                    break;
                }
                case 6: {
                    long e1 = stmt.getLong("item_first");
                    long e2 = stmt.getLong("item_second");
                    long e3 = stmt.getLong("item_third");
                    long e4 = stmt.getLong("item_fourth");
                    hashChangeData.put((Object)6, (Object)gammaId.getId(), (Object)ChangeItemUtil.newTupleChange((TupleTypeId)TupleTypeId.valueOf((Long)itemTypeId), (GammaId)gammaId, (ApplicabilityToken)this.getApplicabilityToken(appId), (ModificationType)modType, (TransactionToken)txToken, (Long[])new Long[]{e1, e2, e3, e4}));
                }
            }
        };
        String query = String.format(SELECT_ITEMS_BETWEEN_TRANSACTIONS, OseeDb.getTxsTable((boolean)this.isArchived));
        this.jdbcClient.runQueryWithMaxFetchSize(consumer, query, new Object[]{this.destinationTx.getBranch(), this.sourceTx, this.destinationTx});
        return hashChangeData;
    }

    private List<ChangeItem> loadItemsByItemId(DoubleKeyHashMap<Integer, Long, ChangeItem> changeData) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ExportImportJoinQuery idJoin = this.joinFactory.createExportImportJoinQuery();){
            for (Integer i : changeData.getKeySetOne()) {
                for (ChangeItem item : changeData.get((Object)i)) {
                    idJoin.add(i, item.getItemId());
                }
            }
            idJoin.store();
            this.loadCurrentVersionData(idJoin.getQueryId(), changeData, this.sourceTx);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        LinkedList<ChangeItem> list = new LinkedList<ChangeItem>(changeData.allValues());
        return list;
    }

    private void loadCurrentVersionData(Long queryId, DoubleKeyHashMap<Integer, Long, ChangeItem> changesByItemId, TransactionToken transactionLimit) {
        Consumer<JdbcStatement> consumer = stmt -> {
            Long itemId = stmt.getLong("item_id");
            Integer tableType = stmt.getInt("table_type");
            GammaId gammaId = GammaId.valueOf((Long)stmt.getLong("gamma_id"));
            ApplicabilityId appId = ApplicabilityId.valueOf((Long)stmt.getLong("app_id"));
            ModificationType modType = ModificationType.valueOf((long)stmt.getInt("mod_type"));
            TransactionToken txToken = TransactionToken.valueOf((long)stmt.getLong("transaction_id"), (BranchId)transactionLimit.getBranch());
            ChangeItem change = (ChangeItem)changesByItemId.get((Object)tableType, (Object)itemId);
            change.getDestinationVersion().setModType(modType);
            change.getDestinationVersion().setGammaId(gammaId);
            change.getDestinationVersion().setApplicabilityToken(this.getApplicabilityToken(appId));
            change.getDestinationVersion().setTransactionToken(txToken);
            change.getBaselineVersion().copy(change.getDestinationVersion());
        };
        String archiveTable = this.isArchived ? "osee_txs_archived" : "osee_txs";
        String query = String.format("select txs.gamma_id, txs.mod_type, txs.app_id, item.art_id as item_id, 2 as table_type, transaction_id from osee_join_export_import idj, osee_artifact item, %s txs where idj.query_id = ? and idj.id2 = item.art_id and idj.id1 = 2 and item.gamma_id = txs.gamma_id and txs.branch_id = ? and txs.transaction_id <= ? union all select txs.gamma_id, txs.mod_type, txs.app_id, item.attr_id as item_id, 1 as table_type, transaction_id from osee_join_export_import idj, osee_attribute item, %s txs where idj.query_id = ? and idj.id2 = item.attr_id and idj.id1 = 1 and item.gamma_id = txs.gamma_id and txs.branch_id = ? and txs.transaction_id <= ? union all select txs.gamma_id, txs.mod_type, txs.app_id, item.rel_link_id as item_id, 3 as table_type, transaction_id from osee_join_export_import idj, osee_relation_link item, %s txs where idj.query_id = ? and idj.id2 = item.rel_link_id and idj.id1 = 3 and item.gamma_id = txs.gamma_id and txs.branch_id = ? and txs.transaction_id <= ? union all select txs.gamma_id, txs.mod_type, txs.app_id, item.gamma_id as item_id, 4 as table_type, transaction_id from osee_join_export_import idj, osee_tuple2 item, %s txs where idj.query_id = ? and idj.id2 = item.gamma_id and idj.id1 = 4 and item.gamma_id = txs.gamma_id and txs.branch_id = ? and txs.transaction_id <= ? union all select txs.gamma_id, txs.mod_type, txs.app_id, item.gamma_id as item_id, 5 as table_type, transaction_id from osee_join_export_import idj, osee_tuple3 item, %s txs where idj.query_id = ? and idj.id2 = item.gamma_id and idj.id1 = 5 and item.gamma_id = txs.gamma_id and txs.branch_id = ? and txs.transaction_id <= ? union all select txs.gamma_id, txs.mod_type, txs.app_id, item.gamma_id as item_id, 6 as table_type, transaction_id from osee_join_export_import idj, osee_tuple4 item, %s txs where idj.query_id = ? and idj.id2 = item.gamma_id and idj.id1 = 6 and item.gamma_id = txs.gamma_id and txs.branch_id = ? and txs.transaction_id <= ? ORDER BY transaction_id", archiveTable, archiveTable, archiveTable, archiveTable, archiveTable, archiveTable);
        this.jdbcClient.runQueryWithMaxFetchSize(consumer, query, new Object[]{queryId, transactionLimit.getBranch(), transactionLimit, queryId, transactionLimit.getBranch(), transactionLimit, queryId, transactionLimit.getBranch(), transactionLimit, queryId, transactionLimit.getBranch(), transactionLimit, queryId, transactionLimit.getBranch(), transactionLimit, queryId, transactionLimit.getBranch(), transactionLimit});
    }

    public List<ChangeItem> compareTransactions() {
        List<ChangeItem> changes;
        if (this.sourceTx.isOnSameBranch((HasBranchId)this.destinationTx)) {
            changes = this.loadDeltasBetweenTxsOnTheSameBranch();
            changes.addAll(this.missingChangeItemFactory.createMissingChanges(changes, this.sourceTx, this.destinationTx, this.queryFactory.applicabilityQuery()));
        } else {
            changes = new LoadDeltasBetweenBranches(this.jdbcClient, this.joinFactory, this.tokenService, this.sourceTx.getBranch(), this.destinationTx.getBranch(), this.sourceTx, this.destinationTx, this.mergeBranch, this.queryFactory, this.missingChangeItemFactory).call();
        }
        ChangeItemUtil.computeNetChanges(changes);
        AddSyntheticArtifactChangeData addArtifactData = new AddSyntheticArtifactChangeData(changes, this.jdbcClient, this.sourceTx.getBranch(), this.tokenService);
        changes = addArtifactData.doWork();
        return changes;
    }
}

