/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal;

import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.resource.management.IResourceManager;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.core.ds.BranchDataStore;
import org.eclipse.osee.orcs.core.ds.DataFactory;
import org.eclipse.osee.orcs.core.ds.DataLoaderFactory;
import org.eclipse.osee.orcs.core.ds.DataModule;
import org.eclipse.osee.orcs.core.ds.DataStoreAdmin;
import org.eclipse.osee.orcs.core.ds.KeyValueStore;
import org.eclipse.osee.orcs.core.ds.QueryEngine;
import org.eclipse.osee.orcs.core.ds.QueryEngineIndexer;
import org.eclipse.osee.orcs.core.ds.TxDataStore;
import org.eclipse.osee.orcs.db.internal.branch.BranchModule;
import org.eclipse.osee.orcs.db.internal.branch.KeyValueModule;
import org.eclipse.osee.orcs.db.internal.loader.LoaderModule;
import org.eclipse.osee.orcs.db.internal.loader.SqlObjectLoader;
import org.eclipse.osee.orcs.db.internal.loader.data.OrcsObjectFactoryImpl;
import org.eclipse.osee.orcs.db.internal.loader.processor.DynamicLoadProcessor;
import org.eclipse.osee.orcs.db.internal.proxy.AttributeDataProxyFactory;
import org.eclipse.osee.orcs.db.internal.search.QueryModule;
import org.eclipse.osee.orcs.db.internal.transaction.TxModule;

public class DataModuleFactory {
    private final Log logger;
    private final LoaderModule loaderModule;
    private final QueryModule queryModule;
    private final BranchModule branchModule;
    private final KeyValueModule keyValueModule;
    private final TxModule txModule;
    private final DataStoreAdmin dataStoreAdmin;
    private final IResourceManager resourceManager;

    public DataModuleFactory(Log logger, LoaderModule loaderModule, QueryModule queryModule, BranchModule branchModule, KeyValueModule keyValueModule, TxModule txModule, DataStoreAdmin dataStoreAdmin, IResourceManager resourceManager) {
        this.logger = logger;
        this.loaderModule = loaderModule;
        this.queryModule = queryModule;
        this.branchModule = branchModule;
        this.keyValueModule = keyValueModule;
        this.txModule = txModule;
        this.dataStoreAdmin = dataStoreAdmin;
        this.resourceManager = resourceManager;
    }

    public DataModule createDataModule(OrcsTokenService tokenService) {
        this.logger.debug("Creating DataModule", new Object[0]);
        QueryEngineIndexer indexer = this.queryModule.getQueryIndexer();
        AttributeDataProxyFactory proxyFactory = this.loaderModule.createProxyDataFactory();
        OrcsObjectFactoryImpl objectFactory = new OrcsObjectFactoryImpl(proxyFactory, tokenService);
        final DataFactory dataFactory = this.loaderModule.createDataFactory(objectFactory);
        DynamicLoadProcessor loadProcessor = this.loaderModule.createDynamicLoadProcessor(tokenService, proxyFactory);
        SqlObjectLoader sqlObjectLoader = this.loaderModule.createSqlObjectLoader(objectFactory, loadProcessor, tokenService);
        final DataLoaderFactory dataLoaderFactory = this.loaderModule.createDataLoaderFactory(sqlObjectLoader);
        final KeyValueStore keyValueStore = this.keyValueModule.createKeyValueStore();
        final QueryEngine queryEngine = this.queryModule.createQueryEngine(dataLoaderFactory, tokenService, sqlObjectLoader, keyValueStore, this.resourceManager);
        final BranchDataStore branchDataStore = this.branchModule.createBranchDataStore(dataLoaderFactory);
        final TxDataStore txDataStore = this.txModule.createTransactionStore(dataLoaderFactory, indexer, tokenService);
        return new DataModule(){

            public DataFactory getDataFactory() {
                return dataFactory;
            }

            public DataLoaderFactory getDataLoaderFactory() {
                return dataLoaderFactory;
            }

            public QueryEngine getQueryEngine() {
                return queryEngine;
            }

            public BranchDataStore getBranchDataStore() {
                return branchDataStore;
            }

            public KeyValueStore getKeyValueStore() {
                return keyValueStore;
            }

            public TxDataStore getTxDataStore() {
                return txDataStore;
            }

            public DataStoreAdmin getDataStoreAdmin() {
                return DataModuleFactory.this.dataStoreAdmin;
            }
        };
    }
}

