/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.workitem.sync.jira;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.agile.IAgileBacklog;
import org.eclipse.osee.ats.api.agile.IAgileItem;
import org.eclipse.osee.ats.api.agile.IAgileSprint;
import org.eclipse.osee.ats.api.agile.IAgileTeam;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.rest.internal.workitem.sync.jira.JiraTask;
import org.eclipse.osee.ats.rest.internal.workitem.sync.jira.SyncSprint;
import org.eclipse.osee.ats.rest.internal.workitem.sync.jira.SyncTeam;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.AXml;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.ElapsedTime;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class SyncJiraOperation {
    private final AtsApi atsApi;
    private XResultData results;
    private List<JiraTask> jTasks;
    private final Set<String> atsIds = new HashSet<String>();
    private final SyncTeam syncTeam;
    private final boolean fixSprint = false;
    private final boolean debugJiraTextCleanup = false;
    private final String SKIP_JIRA_SYNC = "skipJiraSync";
    private static final Pattern ITEM_CHECKED_PATTERN = Pattern.compile("<item checked.*?</item>", 40);
    private static final Pattern ITEM_PATTERN = Pattern.compile("<item(.*?)</item>", 40);
    private static Pattern sprintPattern = Pattern.compile("AMS [0-9\\.]{3,4}");
    private static Pattern statusPattern = Pattern.compile(">(.*?)</status>");
    private static Pattern atsTwIdPattern = Pattern.compile("TW[0-9]{5}");
    private static Pattern atsIdPattern = Pattern.compile("ATS[0-9]{6}");

    public SyncJiraOperation(AtsApi atsApi, SyncTeam syncTeam, boolean reportOnly) {
        this.atsApi = atsApi;
        this.syncTeam = syncTeam;
        this.results = syncTeam.getResults();
    }

    public XResultData run() {
        ElapsedTime allTime = new ElapsedTime(this.getClass().getSimpleName(), true);
        ElapsedTime time = new ElapsedTime("loadTeamDefsAndSprints", true);
        this.loadTeamDefsAndSprints();
        time.end();
        if (this.results.isErrors()) {
            return this.results;
        }
        time.start("loadJiraTasks");
        this.loadJiraTasks();
        time.end();
        if (this.results.isErrors()) {
            return this.results;
        }
        time.start("loadWfs");
        this.loadWfs();
        time.end();
        if (this.results.isErrors()) {
            return this.results;
        }
        time.start("checkJiraClosedToOseeOpen");
        this.checkJiraClosedToOseeOpen();
        time.end();
        time.start("checkJiraOpenToOseeClosed");
        this.checkJiraOpenToOseeClosed();
        time.end();
        time.start("validateWorkflowsNotInJira");
        this.validateWorkflowsNotInJira();
        time.end();
        time.start("validateSprints");
        this.validateSprints();
        time.end();
        time.start("printSprints");
        this.printSprints();
        time.end();
        allTime.end(ElapsedTime.Units.MIN);
        return this.results;
    }

    private void printSprints() {
        this.results.logf("", new Object[0]);
        this.results.logf("", new Object[0]);
        this.results.logf("================================================================", new Object[0]);
        this.results.logf("Sprints", new Object[0]);
        this.results.logf("", new Object[0]);
        for (SyncSprint sSprint : this.syncTeam.getSyncSprints()) {
            if (sSprint.sprint == null) {
                this.results.errorf("Sprint [%s] has null sprint", new Object[]{sSprint.getJiraSprintName()});
                continue;
            }
            if (this.atsApi.getAttributeResolver().getAttributesToStringList((ArtifactId)sSprint.sprint.getStoreObject(), (AttributeTypeToken)AtsAttributeTypes.Category1).contains("skipJiraSync")) continue;
            this.results.logf("", new Object[0]);
            this.results.logf("Sprint [%s]", new Object[]{sSprint.getJiraSprintName()});
            HashSet<String> ids = new HashSet<String>();
            for (JiraTask jTask : sSprint.getJiraTasksInSprint()) {
                this.results.logf("[%s] - %s-[%s]", new Object[]{jTask.getjSprint(), jTask.getAtsIds(), jTask.getSummary()});
                ids.addAll(jTask.getAtsIds());
            }
            this.results.logf("Ids: %s", new Object[]{Collections.toString((String)",", ids)});
        }
        this.results.logf("================================================================", new Object[0]);
    }

    private void validateWorkflowsNotInJira() {
        this.results.logf("", new Object[0]);
        this.results.logf("", new Object[0]);
        this.results.logf("================================================================", new Object[0]);
        this.results.logf("Validate Workflows Not in JIRA don't belong to Sprint", new Object[0]);
        this.results.logf("", new Object[0]);
        List teamWfsNotInJira = Collections.setComplement(this.syncTeam.getBacklogTeamWfs(), this.syncTeam.getJiraTeamWfs());
        StringBuilder ids = new StringBuilder();
        for (IAtsTeamWorkflow teamWf : teamWfsNotInJira) {
            IAgileSprint sprint;
            if (this.skipJiraSync(teamWf) || (sprint = this.atsApi.getAgileService().getSprint(teamWf)) == null) continue;
            this.results.logf("   ERROR: Workflow shouldn't belong to sprint [%s] - %s", new Object[]{sprint.getName(), teamWf.toStringWithId()});
            ids.append(String.valueOf(teamWf.getAtsId()) + ",");
        }
        this.results.logf("Ids: %s", new Object[]{ids.toString().replaceFirst(",$", "")});
        this.results.logf("================================================================", new Object[0]);
    }

    private void loadTeamDefsAndSprints() {
        IAgileTeam aTeam = this.atsApi.getAgileService().getAgileTeam(this.syncTeam.getAgileTeamId().longValue());
        this.syncTeam.setAgileTeam(aTeam);
        for (IAgileSprint sprint : this.atsApi.getAgileService().getAgileSprints(aTeam)) {
            if (!sprint.getName().contains("AMS")) continue;
            this.syncTeam.getOrCreateSyncSprint(sprint);
        }
        for (IAtsTeamDefinition teamDef : this.atsApi.getAgileService().getAtsTeams(aTeam)) {
            this.syncTeam.addTeamDef(teamDef);
        }
    }

    public XResultData loadWfs() {
        IAtsTeamWorkflow teamWf;
        IAgileBacklog backlog = this.atsApi.getAgileService().getAgileBacklog(this.syncTeam.getAgileTeam());
        for (IAgileItem aItem : this.atsApi.getAgileService().getItems(backlog)) {
            ArtifactToken art = aItem.getArtifactToken();
            teamWf = this.atsApi.getWorkItemService().getTeamWf(art);
            if (teamWf == null) continue;
            this.syncTeam.addBacklogTeamWf(teamWf);
        }
        StringBuilder ids = new StringBuilder();
        this.results.logf("", new Object[0]);
        this.results.logf("", new Object[0]);
        this.results.logf("================================================================", new Object[0]);
        this.results.log("Ignoring non OSEE Workflows (spot check): ");
        this.results.logf("", new Object[0]);
        for (ArtifactToken teamWfArt : this.atsApi.getQueryService().getArtifactListFromAttributeValues((AttributeTypeToken)AtsAttributeTypes.AtsId, this.atsIds, 500)) {
            teamWf = this.atsApi.getWorkItemService().getTeamWf(teamWfArt);
            if (teamWf == null || this.skipJiraSync(teamWf)) continue;
            this.syncTeam.addJiraTeamWf(teamWf);
            if (this.syncTeam.getTeamDefs().contains(teamWf.getTeamDefinition())) {
                JiraTask jTask = this.getJiraTask(teamWf.getAtsId());
                jTask.setTeamWf(teamWf);
                continue;
            }
            this.results.logf("   INFO: Ignoring non OSEE wf %s", new Object[]{teamWf.toStringWithId()});
            ids.append(String.valueOf(teamWf.getAtsId()) + ",");
        }
        this.results.logf("Ids: %s", new Object[]{ids.toString().replaceFirst(",$", "")});
        this.results.logf("================================================================", new Object[0]);
        return this.results;
    }

    private JiraTask getJiraTask(String atsId) {
        return this.syncTeam.getAtsIdToTask().get(atsId);
    }

    private void validateSprints() {
        this.results.logf("", new Object[0]);
        this.results.logf("", new Object[0]);
        this.results.logf("================================================================", new Object[0]);
        this.results.logf("Sprints Do Not Match, update ATS", new Object[0]);
        this.results.logf("", new Object[0]);
        IAtsChangeSet changes = this.atsApi.createChangeSet("Sync OSEE with JIRA Sprints");
        HashSet<IAtsTeamWorkflow> teamWfs = new HashSet<IAtsTeamWorkflow>();
        for (JiraTask jTask : this.syncTeam.atsIdToTask.values()) {
            if (jTask.getAtsIds().isEmpty()) {
                this.results.logf("   ERROR: ATS Id not set for JIRA Task %s", new Object[]{jTask.getSummary()});
                continue;
            }
            IAtsTeamWorkflow teamWf = jTask.getTeamWf();
            if (teamWf == null || teamWfs.contains(teamWf)) continue;
            teamWfs.add(teamWf);
            IAgileSprint atsSprint = this.atsApi.getAgileService().getSprint(teamWf);
            jTask.setaSprint(atsSprint);
            SyncSprint sSprint = null;
            if (Strings.isValid((String)jTask.getjSprint())) {
                sSprint = this.syncTeam.getSyncSprint(jTask.getjSprint());
            }
            if (atsSprint == null && sSprint != null) {
                this.results.logf("   ERROR: Workflow Sprint [%s] doesn't match JIRA sprint [%s] for workflow %s", new Object[]{atsSprint, jTask.getjSprint(), teamWf.toStringWithId()});
                this.results.logf("      FIX: SET ATS Sprint to %s", new Object[]{jTask.getjSprint()});
                continue;
            }
            if (sSprint == null && atsSprint != null) {
                this.results.logf("   ERROR: Workflow Sprint [%s] doesn't match JIRA sprint [%s] for workflow %s", new Object[]{atsSprint, jTask.getjSprint(), teamWf.toStringWithId()});
                this.results.logf("      FIX: REMOVE ATS workflow from sprint %s", new Object[]{atsSprint});
                continue;
            }
            if (sSprint == null || atsSprint == null) continue;
            if (sSprint.getSprint() == null) {
                this.results.errorf("   ERROR: sSprint != null but getSprint() == null for %s", new Object[]{sSprint});
                continue;
            }
            if (sSprint.getSprint().equals(atsSprint)) continue;
            this.results.logf("   ERROR: Workflow Sprint [%s] doesn't match JIRA sprint [%s] for workflow %s", new Object[]{atsSprint, jTask.getjSprint(), teamWf.toStringWithId()});
            this.results.logf("      FIX: MOVE ATS workflow to sprint %s", new Object[]{sSprint.getSprint()});
        }
        if (this.results.isErrors()) {
            return;
        }
        this.results.logf("================================================================", new Object[0]);
    }

    private void checkJiraOpenToOseeClosed() {
        this.results.logf("", new Object[0]);
        this.results.logf("", new Object[0]);
        this.results.logf("================================================================", new Object[0]);
        this.results.logf("JIRA Open and OSEE Closed (close in JIRA)", new Object[]{this.syncTeam.getJiraTeamWfs().size()});
        this.results.logf("", new Object[0]);
        StringBuilder ids = new StringBuilder();
        for (JiraTask jTask : this.jTasks) {
            IAtsTeamWorkflow teamWf = jTask.getTeamWf();
            if (teamWf == null || this.skipJiraSync(teamWf) || !teamWf.isCompletedOrCancelled() || jTask.getStatus().equals("Closed")) continue;
            this.results.logf("   ERROR: JIRA Task Open, Team Wf Closed [%s] %s", new Object[]{teamWf.getStateDefinition().getName(), teamWf.toStringWithId()});
            for (String atsId : jTask.getAtsIds()) {
                ids.append(String.valueOf(atsId) + ",");
            }
        }
        this.results.logf("Ids: %s", new Object[]{ids.toString().replaceFirst(",$", "")});
        this.results.logf("================================================================", new Object[0]);
    }

    private void checkJiraClosedToOseeOpen() {
        this.results.logf("", new Object[0]);
        this.results.logf("", new Object[0]);
        this.results.logf("================================================================", new Object[0]);
        this.results.logf("JIRA Closed and OSEE Open (spot check; close in OSEE)", new Object[]{this.syncTeam.getJiraTeamWfs().size()});
        this.results.logf("", new Object[0]);
        StringBuilder ids = new StringBuilder();
        for (JiraTask jTask : this.jTasks) {
            IAtsTeamWorkflow teamWf = jTask.getTeamWf();
            if (teamWf == null || this.skipJiraSync(teamWf) || !jTask.getStatus().equals("Closed") || !teamWf.isInWork()) continue;
            this.results.logf("   ERROR: JIRA Task Closed, OSEE is Open [%s] %s", new Object[]{teamWf.getStateDefinition().getName(), teamWf.toStringWithId()});
            for (String atsId : jTask.getAtsIds()) {
                ids.append(String.valueOf(atsId) + ",");
            }
        }
        this.results.logf("Ids: %s", new Object[]{ids.toString().replaceFirst(",$", "")});
        this.results.logf("================================================================", new Object[0]);
    }

    private boolean skipJiraSync(IAtsTeamWorkflow teamWf) {
        return this.atsApi.getAttributeResolver().getAttributesToStringList((IAtsObject)teamWf, (AttributeTypeToken)AtsAttributeTypes.Category1).contains("skipJiraSync");
    }

    public XResultData loadJiraTasks() {
        this.results = this.syncTeam.getResults();
        try {
            Matcher m;
            int postSize;
            String home = System.getenv("HOMEPATH");
            File file2 = new File(String.valueOf(home) + "\\Desktop\\jira.xml");
            if (!file2.exists()) {
                this.results.errorf("File [%s] does not exist", new Object[]{file2.getAbsolutePath()});
                return this.results;
            }
            String fileXml = Lib.fileToString((File)file2);
            int preSize = fileXml.length();
            if (preSize == (postSize = (fileXml = (m = ITEM_CHECKED_PATTERN.matcher(fileXml)).replaceAll("")).length())) {
                this.results.errorf("Does not look like checked items were removed", new Object[0]);
                return this.results;
            }
            this.jTasks = new ArrayList<JiraTask>();
            m = ITEM_PATTERN.matcher(fileXml);
            int lineNum = 1;
            while (m.find()) {
                try {
                    String xmlStr = m.group();
                    String title = AXml.getTagData((String)xmlStr, (String)"title");
                    System.out.println(String.format("line %s : %s", lineNum, title));
                    JiraTask task = new JiraTask();
                    task.setSummary(title);
                    this.findStatus(task, xmlStr);
                    this.findAtsId(task, xmlStr);
                    this.findSprint(task, xmlStr);
                    this.jTasks.add(task);
                }
                catch (Exception ex) {
                    this.results.errorf("Error on line %s: Exception %s", new Object[]{lineNum, ex.getLocalizedMessage()});
                }
                ++lineNum;
            }
        }
        catch (IOException ex) {
            this.results.errorf("Exception %s", new Object[]{Lib.exceptionToString((Exception)ex)});
        }
        if (this.jTasks.isEmpty()) {
            this.results.error("No tasks found");
        }
        return this.results;
    }

    private void findSprint(JiraTask jTask, String line) {
        Matcher m = sprintPattern.matcher(line);
        if (m.find()) {
            String jiraSprint = m.group();
            jTask.setjSprint(jiraSprint);
            SyncSprint syncSprint = this.syncTeam.getOrCreateSyncSprint(jiraSprint);
            syncSprint.addJiraTask(jTask);
        }
    }

    private void findStatus(JiraTask task, String line) {
        Matcher m = statusPattern.matcher(line);
        if (m.find()) {
            String status = m.group(1);
            if (Strings.isValid((String)status)) {
                task.setStatus(status);
            } else {
                this.results.errorf("Can't retrive status for task [%s]", new Object[]{line});
            }
        }
    }

    private void findAtsId(JiraTask task, String line) {
        Matcher m = atsIdPattern.matcher(line);
        String atsId = null;
        while (m.find()) {
            atsId = m.group();
            task.addAtsId(atsId);
            this.atsIds.add(atsId);
            this.syncTeam.addAtsIdToTask(atsId, task);
        }
        m = atsTwIdPattern.matcher(line);
        while (m.find()) {
            atsId = m.group();
            task.addAtsId(atsId);
            this.atsIds.add(atsId);
            this.syncTeam.addAtsIdToTask(atsId, task);
        }
    }

    public static String getAtsId(String str) {
        Matcher m = atsIdPattern.matcher(str);
        String atsId = null;
        while (m.find()) {
            atsId = m.group();
        }
        m = atsTwIdPattern.matcher(str);
        while (m.find()) {
            atsId = m.group();
        }
        return atsId;
    }
}

